/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import java.util.Objects;

public class LatencyRecordKey
extends AuthKey {
    private final String app;
    private final String cluster;

    @JsonCreator
    public LatencyRecordKey(@JsonProperty(value="app") String app, @JsonProperty(value="cluster") String cluster) {
        this.app = app;
        this.cluster = cluster;
    }

    @JsonProperty
    public String app() {
        return this.app;
    }

    @JsonProperty
    public String cluster() {
        return this.cluster;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.LATENCY_RECORD;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatencyRecordKey)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LatencyRecordKey that = (LatencyRecordKey)o;
        return Objects.equals(this.app, that.app) && Objects.equals(this.cluster, that.cluster);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.app, this.cluster);
    }

    public String toString() {
        return "LatencyRecordKey{app=" + this.app + ", cluster='" + this.cluster + '\'' + '}';
    }
}

