/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import java.util.Objects;

public class CaCertificatesKey
extends AuthKey {
    private final String providerId;
    private final String organizationId;

    public CaCertificatesKey(@JsonProperty(value="providerId") String providerId, @JsonProperty(value="organizationId") String organizationId) {
        this.providerId = Objects.requireNonNull(providerId, "Argument `providerId` must not be null");
        this.organizationId = Objects.requireNonNull(organizationId, "Argument `organizationId` must not be null");
    }

    @JsonProperty
    public String providerId() {
        return this.providerId;
    }

    @JsonProperty
    public String organizationId() {
        return this.organizationId;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.CA_CERTIFICATES;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CaCertificatesKey that = (CaCertificatesKey)o;
        return this.providerId.equals(that.providerId) && Objects.equals(this.organizationId, that.organizationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entryType().name(), this.providerId, this.organizationId);
    }

    public String toString() {
        return String.format("CaCertificatesKey{\n\tproviderId=%s,\n\torganizationId=%s\n}", this.providerId, this.organizationId);
    }
}

