/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.trustservice.store.data.IdentityProvider;
import java.util.Objects;

@JsonTypeName(value="IdentityProviderValue")
public class IdentityProviderValue
extends AuthValue {
    private final String subjectClaim;
    private final String issuer;
    private final String jwksEndpoint;

    public IdentityProviderValue(@JsonProperty(value="subjectClaim") String subjectClaim, @JsonProperty(value="issuer") String issuer, @JsonProperty(value="jwksEndpoint") String jwksEndpoint) {
        this.subjectClaim = Objects.requireNonNull(subjectClaim, "Argument `subjectClaim` must not be null");
        this.issuer = Objects.requireNonNull(issuer, "Argument `issuer` must not be null");
        this.jwksEndpoint = Objects.requireNonNull(jwksEndpoint, "Argument `jwksEndpoint` must not be null");
    }

    public IdentityProviderValue(IdentityProvider identityProvider) {
        this(identityProvider.subjectClaim(), identityProvider.issuer(), identityProvider.jwksEndpoint());
    }

    @JsonProperty(value="subjectClaim")
    public String subjectClaim() {
        return this.subjectClaim;
    }

    @JsonProperty(value="issuer")
    public String issuer() {
        return this.issuer;
    }

    @JsonProperty(value="jwksEndpoint")
    public String jwksEndpoint() {
        return this.jwksEndpoint;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.IDENTITY_PROVIDER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdentityProviderValue that = (IdentityProviderValue)o;
        return Objects.equals(this.subjectClaim, that.subjectClaim) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.jwksEndpoint, that.jwksEndpoint);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.subjectClaim, this.issuer, this.jwksEndpoint);
    }

    public String toString() {
        return String.format("IdentityProviderValue{\n\tsubjectClaim=%s\n\tissuer=%s\n\tjwksEndpoint=%s\n}", this.subjectClaim, this.issuer, this.jwksEndpoint);
    }
}

