/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import java.util.Objects;

@JsonTypeName(value="JwtIssuer")
public class JwtIssuerKey
extends AuthKey {
    private final String issuer;
    private final String providerId;
    private final String jwksEndpoint;

    public JwtIssuerKey(@JsonProperty(value="issuer") String issuer, @JsonProperty(value="providerId") String providerId, @JsonProperty(value="jwksEndpoint") String jwksEndpoint) {
        this.issuer = Objects.requireNonNull(issuer, "Argument `issuer` must not be null");
        this.providerId = providerId;
        this.jwksEndpoint = jwksEndpoint;
    }

    public JwtIssuerKey(String issuer) {
        this(issuer, null, null);
    }

    @JsonProperty
    public String issuer() {
        return this.issuer;
    }

    @JsonProperty
    public String providerId() {
        return this.providerId;
    }

    @JsonProperty
    public String jwksEndpoint() {
        return this.jwksEndpoint;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.JWT_ISSUER;
    }

    public String cacheKey(Version version) {
        switch (version.ordinal()) {
            case 0: {
                return JwtIssuerKey.cacheKeyV1(this.providerId, this.issuer);
            }
            case 1: {
                return JwtIssuerKey.cacheKeyV2(this.issuer, this.jwksEndpoint);
            }
        }
        throw new IllegalArgumentException("Unsupported cache key version.");
    }

    public static String cacheKeyV1(String providerId, String issuer) {
        if (providerId == null || providerId.trim().equals("")) {
            return issuer;
        }
        return providerId;
    }

    public static String cacheKeyV2(String issuer, String jwksEndpoint) {
        String separator = ":";
        return issuer + separator + jwksEndpoint;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JwtIssuerKey that = (JwtIssuerKey)o;
        return this.issuer.equals(that.issuer) && Objects.equals(this.providerId, that.providerId) && Objects.equals(this.jwksEndpoint, that.jwksEndpoint);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entryType().name(), this.issuer, this.providerId, this.jwksEndpoint);
    }

    public String toString() {
        return String.format("JwtIssuerKey{\n\tissuer=%s,\n\tproviderId=%s\n\tjwksEndpoint=%s\n}", this.issuer, this.providerId, this.jwksEndpoint);
    }

    public static enum Version {
        V1,
        V2;

    }
}

