/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.authentication.oidc.RefreshTokenInfo;
import java.util.Objects;

public class RefreshTokenInfoValue
extends AuthValue {
    private final String issuer;
    private final String encryptedRefreshToken;
    private final long issuedAt;
    private final String subClaim;
    private final String sessionId;

    @JsonCreator
    public RefreshTokenInfoValue(RefreshTokenInfo refreshTokenInfo) {
        this.issuer = refreshTokenInfo.issuer();
        this.encryptedRefreshToken = refreshTokenInfo.encryptedRefreshToken();
        this.issuedAt = refreshTokenInfo.issuedAt();
        this.subClaim = refreshTokenInfo.subClaim();
        this.sessionId = refreshTokenInfo.sessionId();
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.REFRESH_TOKEN_INFO;
    }

    @JsonProperty
    public String issuer() {
        return this.issuer;
    }

    @JsonProperty
    public String encryptedRefreshToken() {
        return this.encryptedRefreshToken;
    }

    @JsonProperty
    public long issuedAt() {
        return this.issuedAt;
    }

    @JsonProperty
    public String subClaim() {
        return this.subClaim;
    }

    @JsonProperty
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RefreshTokenInfoValue)) {
            return false;
        }
        RefreshTokenInfoValue that = (RefreshTokenInfoValue)o;
        return Objects.equals(this.issuer, that.issuer) && Objects.equals(this.encryptedRefreshToken, that.encryptedRefreshToken) && Objects.equals(this.issuedAt, that.issuedAt) && Objects.equals(this.subClaim, that.subClaim) && Objects.equals(this.sessionId, that.sessionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.issuer, this.encryptedRefreshToken, this.issuedAt, this.subClaim, this.sessionId);
    }

    public String toString() {
        return "RefreshTokenInfoValue{issuer='" + this.issuer + "', encryptedRefreshToken='<sensitive>', issuedAt=" + this.issuedAt + ", subClaim='" + this.subClaim + "', sessionId='" + this.sessionId + "'}";
    }
}

