/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.Objects;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.PatternType;

public class Action {
    private final Scope scope;
    private final ResourcePattern resourcePattern;
    private final Operation operation;
    private final int resourceReferenceCount;
    private final boolean logIfAllowed;
    private final boolean logIfDenied;

    public Action(@JsonProperty(value="scope") Scope scope, @JsonProperty(value="resourceType") ResourceType resourceType, @JsonProperty(value="resourceName") String resourceName, @JsonProperty(value="operation") Operation operation) {
        this(scope, new ResourcePattern(resourceType, resourceName, PatternType.LITERAL), operation);
    }

    public Action(Scope scope, ResourcePattern resourcePattern, Operation operation) {
        this(scope, resourcePattern, operation, 1, true, true);
    }

    public Action(Scope scope, ResourcePattern resourcePattern, Operation operation, int resourceReferenceCount, boolean logIfAllowed, boolean logIfDenied) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.resourcePattern = resourcePattern;
        this.operation = operation == null ? Operation.ALL : operation;
        this.resourceReferenceCount = resourceReferenceCount;
        this.logIfAllowed = logIfAllowed;
        this.logIfDenied = logIfDenied;
    }

    @JsonProperty
    public Scope scope() {
        return this.scope;
    }

    @JsonProperty
    public ResourceType resourceType() {
        return this.resourcePattern.resourceType();
    }

    @JsonProperty
    public String resourceName() {
        return this.resourcePattern.name();
    }

    @JsonProperty
    public Operation operation() {
        return this.operation;
    }

    public ResourcePattern resourcePattern() {
        return this.resourcePattern;
    }

    public int resourceReferenceCount() {
        return this.resourceReferenceCount;
    }

    public boolean logIfAllowed() {
        return this.logIfAllowed;
    }

    public boolean logIfDenied() {
        return this.logIfDenied;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action that = (Action)o;
        return Objects.equals(this.scope, that.scope) && Objects.equals(this.resourcePattern, that.resourcePattern) && Objects.equals(this.operation, that.operation) && this.resourceReferenceCount == that.resourceReferenceCount && this.logIfAllowed == that.logIfAllowed && this.logIfDenied == that.logIfDenied;
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.resourcePattern, this.operation);
    }

    public String toString() {
        return "Action(scope='" + String.valueOf(this.scope) + "', resourcePattern='" + String.valueOf(this.resourcePattern) + "', operation='" + String.valueOf(this.operation) + "', resourceReferenceCount='" + this.resourceReferenceCount + "', logIfAllowed='" + this.logIfAllowed + "', logIfDenied='" + this.logIfDenied + "')";
    }

    public org.apache.kafka.server.authorizer.Action toKafkaAction() {
        return new org.apache.kafka.server.authorizer.Action(AclOperation.fromString((String)this.operation.name()), new org.apache.kafka.common.resource.ResourcePattern(org.apache.kafka.common.resource.ResourceType.fromString((String)this.resourcePattern.resourceType().name()), this.resourcePattern.name(), PatternType.fromString((String)this.resourcePattern.patternType().name())), this.resourceReferenceCount, this.logIfAllowed, this.logIfDenied);
    }
}

