/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.RequestContext;
import io.confluent.security.authorizer.utils.AuthorizerUtils;
import java.io.Closeable;
import java.util.List;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public interface Authorizer
extends Configurable,
Closeable {
    default public List<AuthorizeResult> authorize(KafkaPrincipal sessionPrincipal, String host, List<Action> actions) {
        return this.authorize(AuthorizerUtils.newRequestContext("mds", sessionPrincipal, host), actions);
    }

    default public List<AuthorizeResult> authorize(KafkaPrincipal sessionPrincipal, String host, String requestId, List<Action> actions, boolean omitClientAddress) {
        return this.authorize(AuthorizerUtils.newRequestContext("mds", sessionPrincipal, host, requestId, omitClientAddress), actions);
    }

    default public List<AuthorizeResult> authorize(KafkaPrincipal sessionPrincipal, String host, String requestId, List<Action> actions) {
        return this.authorize(AuthorizerUtils.newRequestContext("mds", sessionPrincipal, host, requestId, true), actions);
    }

    public List<AuthorizeResult> authorize(RequestContext var1, List<Action> var2);
}

