/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import java.util.HashMap;
import java.util.Map;
import kafka.server.KafkaConfig;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenantInterceptorConfigTest {
    @Test
    public void constructorCorrectlyParsedTheConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>(){
            {
                this.put(KafkaConfig.BrokerIdProp(), 1);
                this.put(KafkaConfig.DefaultReplicationFactorProp(), (short)1);
                this.put(KafkaConfig.NumPartitionsProp(), 1);
                this.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", false);
                this.put("confluent.schema.validator.multitenant.enable", true);
                this.put("confluent.multitenant.max.partitions.per.request", Integer.MAX_VALUE);
            }
        };
        MultiTenantInterceptorConfig config = new MultiTenantInterceptorConfig((Map)configMap);
        Assert.assertEquals((long)1L, (long)config.defaultNumPartitions());
        Assert.assertEquals((long)1L, (long)config.defaultReplicationFactor());
        Assert.assertNull((Object)config.partitionAssignor());
        Assert.assertFalse((boolean)config.isClusterPrefixForHostnameEnabled());
        Assert.assertTrue((boolean)config.isSchemaValidationEnabled());
    }
}

