/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.link.ClusterLinkInterceptor;
import io.confluent.kafka.multitenant.MultiTenantConfigRestrictions;
import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantRequestContext;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.quota.TenantPartitionAssignor;
import io.confluent.kafka.multitenant.quota.TestCluster;
import io.confluent.kafka.server.plugins.policy.AlterConfigPolicy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkManager;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.message.ControlledShutdownRequestData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreateClusterLinksResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteClusterLinksRequestData;
import org.apache.kafka.common.message.DeleteClusterLinksResponseData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeMirrorsRequestData;
import org.apache.kafka.common.message.DescribeMirrorsResponseData;
import org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.message.InitiateReverseConnectionsResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.ListClusterLinksRequestData;
import org.apache.kafka.common.message.ListClusterLinksResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListMirrorsRequestData;
import org.apache.kafka.common.message.ListMirrorsResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.ReplicaStatusRequestData;
import org.apache.kafka.common.message.ReplicaStatusResponseData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.message.ReverseConnectionResponseData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteClusterLinksRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.DescribeMirrorsRequest;
import org.apache.kafka.common.requests.DescribeMirrorsResponse;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.InitiateReverseConnectionsResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.ListClusterLinksRequest;
import org.apache.kafka.common.requests.ListClusterLinksResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListMirrorsRequest;
import org.apache.kafka.common.requests.ListMirrorsResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.ReplicaStatusRequest;
import org.apache.kafka.common.requests.ReplicaStatusResponse;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.ReverseConnectionRequest;
import org.apache.kafka.common.requests.ReverseConnectionResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.ApiSensorBuilder;
import org.apache.kafka.server.metrics.ApiSensors;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MultiTenantRequestContextTest {
    private static final Locale LOCALE = Locale.ENGLISH;
    private static final short DEFAULT_REPLICATION_FACTOR = 2;
    private static final int DEFAULT_NUM_PARTITIONS = 3;
    private static final int DEFAULT_MAX_PARTITIONS_PER_REQUEST = 1000;
    public static final String USERNAME = "user";
    public static final String TENANT_CLUSTER_ID = "tenant_cluster_id";
    public static final String TENANT_NAME = "tenant";
    public static final String CLUSTER_ID = "231412341";
    public static final int KAFKA_PORT = 9092;
    public static final String LOCALHOST = "localhost";
    private final MultiTenantPrincipal principal = new MultiTenantPrincipal("user", new TenantMetadata("tenant", "tenant_cluster_id"));
    private final ListenerName listenerName = new ListenerName("listener");
    private final SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
    private final Time time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), this.time, true);
    private final TenantMetrics tenantMetrics = new TenantMetrics();
    private TenantPartitionAssignor partitionAssignor;
    private TestCluster testCluster;
    private ClusterLinkClient clusterLinkClient;
    private boolean isSchemaValidationEnabled;

    @Before
    public void setUp() {
        this.testCluster = new TestCluster();
        for (int i = 0; i < 3; ++i) {
            this.testCluster.addNode(i, null);
        }
        this.partitionAssignor = new TenantPartitionAssignor();
        this.partitionAssignor.updateClusterMetadata(this.testCluster.cluster());
        this.clusterLinkClient = new ClusterLinkClient("link-name", this.principal, this.metrics, this.time);
        this.isSchemaValidationEnabled = false;
    }

    @After
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testProduceRequest() {
        for (short ver = ApiKeys.PRODUCE.oldestVersion(); ver <= ApiKeys.PRODUCE.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.PRODUCE, ver, false);
            String transactionalId = null;
            if (ver >= 3) {
                transactionalId = "tr";
            }
            HashMap<TopicPartition, Records> recordsMap = new HashMap<TopicPartition, Records>();
            recordsMap.put(new TopicPartition("foo", 0), (Records)MemoryRecords.withRecords((long)2L, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes())}));
            recordsMap.put(new TopicPartition("bar", 0), (Records)MemoryRecords.withRecords((long)2L, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("bar".getBytes())}));
            ProduceRequest inbound = this.buildProduceRequest(RecordVersion.V2, transactionalId, recordsMap, ver);
            ProduceRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((long)2L, (long)intercepted.data().topicData().size());
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"tenant_foo", "tenant_bar"}), intercepted.data().topicData().stream().map(ProduceRequestData.TopicProduceData::name).collect(Collectors.toSet()));
            if (ver >= 3) {
                Assert.assertEquals((Object)"tenant_tr", (Object)intercepted.transactionalId());
            } else {
                Assert.assertNull((Object)intercepted.transactionalId());
            }
            this.verifyRequestMetrics(ApiKeys.PRODUCE);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    private ProduceRequest buildProduceRequest(RecordVersion recordVersion, String transactionalId, Map<TopicPartition, Records> recordsMap, short version) {
        ProduceRequestData requestData = new ProduceRequestData().setAcks((short)-1).setTimeoutMs(30000).setTransactionalId(transactionalId);
        recordsMap.forEach((topicPartition, records) -> {
            String topic = topicPartition.topic();
            ProduceRequestData.TopicProduceData topicData = requestData.topicData().find(topic);
            if (topicData == null) {
                topicData = new ProduceRequestData.TopicProduceData().setName(topic);
                requestData.topicData().add((ImplicitLinkedHashCollection.Element)topicData);
            }
            ProduceRequestData.PartitionProduceData partitionData = new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records);
            topicData.partitionData().add(partitionData);
        });
        return ProduceRequest.forMagic((byte)recordVersion.value, (ProduceRequestData)requestData).build(version);
    }

    @Test
    public void testRequestSizeMetrics() {
        MultiTenantRequestContext context = this.newRequestContext(ApiKeys.PRODUCE, ApiKeys.PRODUCE.latestVersion(), false);
        ArrayList<Integer> requestSizes = new ArrayList<Integer>();
        HashMap<TopicPartition, Integer> partitionCounts = new HashMap<TopicPartition, Integer>();
        for (int recordCount : Arrays.asList(1, 5, 10)) {
            HashMap<TopicPartition, Records> partitionRecords = new HashMap<TopicPartition, Records>();
            TopicPartition tp = new TopicPartition("foo", 0);
            partitionRecords.put(tp, (Records)MemoryRecords.withRecords((long)2L, (CompressionType)CompressionType.NONE, (SimpleRecord[])this.simpleRecords(recordCount).toArray(new SimpleRecord[recordCount])));
            ProduceRequest inbound = this.buildProduceRequest(RecordVersion.V2, null, partitionRecords, ApiKeys.PRODUCE.latestVersion());
            this.parseRequest(context, inbound);
            requestSizes.add(ApiSensors.calculateRequestSize((RequestHeader)context.header, (ByteBuffer)this.toByteBuffer((AbstractRequest)inbound)));
            int count = partitionCounts.getOrDefault(tp, 0) + recordCount;
            partitionCounts.put(tp, count);
        }
        double expectedAverage = requestSizes.stream().mapToInt(v -> v).average().orElseThrow(NoSuchElementException::new);
        double expectedMin = requestSizes.stream().mapToInt(v -> v).min().orElseThrow(NoSuchElementException::new);
        double expectedMax = requestSizes.stream().mapToInt(v -> v).max().orElseThrow(NoSuchElementException::new);
        int expectedTotal = requestSizes.stream().mapToInt(v -> v).sum();
        Map<String, KafkaMetric> metrics = this.verifyRequestMetrics(ApiKeys.PRODUCE);
        Assert.assertEquals((double)expectedMin, (double)((Double)metrics.get("request-byte-min").metricValue()), (double)0.1);
        Assert.assertEquals((double)expectedMax, (double)((Double)metrics.get("request-byte-max").metricValue()), (double)0.1);
        Assert.assertEquals((double)expectedAverage, (double)((Double)metrics.get("request-byte-avg").metricValue()), (double)0.1);
        Assert.assertEquals((long)expectedTotal, (long)((int)((Double)metrics.get("request-byte-total").metricValue()).doubleValue()));
        this.metrics.metrics().forEach((name, metric) -> {
            if (name.name().equals("partition-records-in-total")) {
                String topic = (String)name.tags().get("topic");
                int partition = Integer.parseInt((String)name.tags().get("partition"));
                TopicPartition tp = new TopicPartition(topic, partition);
                Assert.assertEquals((long)((Integer)partitionCounts.get(context.tenantContext.removeTenantPrefix(tp))).intValue(), (long)((int)((Double)metric.metricValue()).doubleValue()));
            }
        });
    }

    private List<SimpleRecord> simpleRecords(int recordCount) {
        return Stream.generate(() -> new SimpleRecord("foo".getBytes())).limit(recordCount).collect(Collectors.toList());
    }

    @Test
    public void testProduceResponse() {
        for (short ver = ApiKeys.PRODUCE.oldestVersion(); ver <= ApiKeys.PRODUCE.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.PRODUCE, ver, false);
            ProduceResponseData outboundData = new ProduceResponseData();
            outboundData.responses().add((ImplicitLinkedHashCollection.Element)new ProduceResponseData.TopicProduceResponse().setName("tenant_foo").setPartitionResponses(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setIndex(0).setErrorCode(Errors.NONE.code()).setBaseOffset(5L).setLogAppendTimeMs(10L).setLogStartOffset(1L))));
            outboundData.responses().add((ImplicitLinkedHashCollection.Element)new ProduceResponseData.TopicProduceResponse().setName("tenant_bar").setPartitionResponses(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setIndex(5).setErrorCode(Errors.INVALID_RECORD.code()).setErrorMessage("Errors found in topic tenant_bar: invalid record").setBaseOffset(5L).setLogAppendTimeMs(10L).setLogStartOffset(1L).setRecordErrors(Collections.singletonList(new ProduceResponseData.BatchIndexAndErrorMessage().setBatchIndex(6).setBatchIndexErrorMessage("Compacted topic cannot accept message without key in topic partition tenant_bar-0."))))));
            ProduceResponse outbound = new ProduceResponse(outboundData);
            ProduceResponse intercepted = (ProduceResponse)this.parseResponse(ApiKeys.PRODUCE, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals(Arrays.asList("foo", "bar"), intercepted.data().responses().stream().map(ProduceResponseData.TopicProduceResponse::name).collect(Collectors.toList()));
            ProduceResponseData.TopicProduceResponse fooResponseData = intercepted.data().responses().find("foo");
            Assert.assertEquals(Collections.singletonList(0), fooResponseData.partitionResponses().stream().map(ProduceResponseData.PartitionProduceResponse::index).collect(Collectors.toList()));
            ProduceResponseData.TopicProduceResponse barResponseData = intercepted.data().responses().find("bar");
            Assert.assertEquals(Collections.singletonList(5), barResponseData.partitionResponses().stream().map(ProduceResponseData.PartitionProduceResponse::index).collect(Collectors.toList()));
            ProduceResponseData.PartitionProduceResponse barPartitionResponse = (ProduceResponseData.PartitionProduceResponse)barResponseData.partitionResponses().get(0);
            if (ver >= 8) {
                Assert.assertEquals((Object)"Errors found in topic bar: invalid record", (Object)barPartitionResponse.errorMessage());
                Assert.assertEquals((Object)"Compacted topic cannot accept message without key in topic partition bar-0.", (Object)((ProduceResponseData.BatchIndexAndErrorMessage)barPartitionResponse.recordErrors().get(0)).batchIndexErrorMessage());
            } else {
                Assert.assertNull((Object)barPartitionResponse.errorMessage());
                Assert.assertEquals(Collections.emptyList(), (Object)barPartitionResponse.recordErrors());
            }
            this.verifyResponseMetrics(ApiKeys.PRODUCE, Utils.mkSet((Object[])new Errors[]{Errors.NONE, Errors.INVALID_RECORD}));
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testFetchRequest() {
        for (short ver = ApiKeys.FETCH.oldestVersion(); ver <= ApiKeys.FETCH.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.FETCH, ver, false);
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitions = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            partitions.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, -1L, 1, Optional.empty()));
            partitions.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(0L, -1L, 1, Optional.empty()));
            FetchRequest inbound = FetchRequest.Builder.forConsumer((int)0, (int)0, partitions).build(ver);
            FetchRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals(Arrays.asList(new TopicPartition("tenant_foo", 0), new TopicPartition("tenant_bar", 0)), new ArrayList(intercepted.fetchData().keySet()));
            this.verifyRequestMetrics(ApiKeys.FETCH);
            FetchRequest clientIntercepted = (FetchRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals(inbound.fetchData().keySet(), clientIntercepted.fetchData().keySet());
        }
    }

    @Test
    public void testFetchResponse() {
        for (short ver = ApiKeys.FETCH.oldestVersion(); ver <= ApiKeys.FETCH.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.FETCH, ver, false);
            LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responsePartitions = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
            responsePartitions.put(new TopicPartition("tenant_foo", 0), new FetchResponse.PartitionData(Errors.NONE, 1330L, 1324L, 0L, Collections.emptyList(), (BaseRecords)MemoryRecords.EMPTY));
            responsePartitions.put(new TopicPartition("tenant_bar", 0), new FetchResponse.PartitionData(Errors.NONE, 1330L, 1324L, 0L, Collections.emptyList(), (BaseRecords)MemoryRecords.EMPTY));
            FetchResponse outbound = ver >= 7 ? new FetchResponse(Errors.INVALID_FETCH_SESSION_EPOCH, responsePartitions, 0, 1234) : new FetchResponse(Errors.NONE, responsePartitions, 0, 0);
            FetchResponse intercepted = (FetchResponse)this.parseResponse(ApiKeys.FETCH, ver, context.buildResponseSend((AbstractResponse)outbound));
            this.verifyFetchResponse((FetchResponse<MemoryRecords>)intercepted, ver, Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 0)));
            if (ver >= 7) {
                this.verifyResponseMetrics(ApiKeys.FETCH, Utils.mkSet((Object[])new Errors[]{Errors.INVALID_FETCH_SESSION_EPOCH, Errors.NONE}));
            } else {
                this.verifyResponseMetrics(ApiKeys.FETCH, Errors.NONE);
            }
            FetchResponse clientIntercepted = (FetchResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            this.verifyFetchResponse((FetchResponse<MemoryRecords>)clientIntercepted, ver, new ArrayList<TopicPartition>(outbound.responseData().keySet()));
        }
    }

    private void verifyFetchResponse(FetchResponse<MemoryRecords> intercepted, short ver, List<TopicPartition> expectedPartitions) {
        Assert.assertEquals(expectedPartitions, new ArrayList(intercepted.responseData().keySet()));
        if (ver >= 7) {
            Assert.assertEquals((long)1234L, (long)intercepted.sessionId());
            Assert.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)intercepted.error());
        } else {
            Assert.assertEquals((long)0L, (long)intercepted.sessionId());
            Assert.assertEquals((Object)Errors.NONE, (Object)intercepted.error());
        }
    }

    @Test
    public void testListOffsetsRequest() {
        for (short ver = ApiKeys.LIST_OFFSETS.oldestVersion(); ver <= ApiKeys.LIST_OFFSETS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LIST_OFFSETS, ver, false);
            ListOffsetsRequest.Builder bldr = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED);
            ArrayList<ListOffsetsRequestData.ListOffsetsTopic> offsetData = new ArrayList<ListOffsetsRequestData.ListOffsetsTopic>();
            if (ver == 0) {
                offsetData.add(new ListOffsetsRequestData.ListOffsetsTopic().setName("foo").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(0L).setMaxNumOffsets(1))));
                offsetData.add(new ListOffsetsRequestData.ListOffsetsTopic().setName("bar").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(0L).setMaxNumOffsets(1))));
            } else {
                offsetData.add(new ListOffsetsRequestData.ListOffsetsTopic().setName("foo").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(0L))));
                offsetData.add(new ListOffsetsRequestData.ListOffsetsTopic().setName("bar").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(0L))));
            }
            bldr.setTargetTimes(offsetData);
            ListOffsetsRequest inbound = bldr.build(ver);
            Set inboundTopicNames = inbound.data().topics().stream().map(ListOffsetsRequestData.ListOffsetsTopic::name).collect(Collectors.toSet());
            ListOffsetsRequest intercepted = this.parseRequest(context, inbound);
            Set interceptedTopicNames = intercepted.data().topics().stream().map(ListOffsetsRequestData.ListOffsetsTopic::name).collect(Collectors.toSet());
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"tenant_foo", "tenant_bar"}), interceptedTopicNames);
            this.verifyRequestMetrics(ApiKeys.LIST_OFFSETS);
            ListOffsetsRequest clientIntercepted = (ListOffsetsRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Set clientInterceptedTopicNames = clientIntercepted.data().topics().stream().map(ListOffsetsRequestData.ListOffsetsTopic::name).collect(Collectors.toSet());
            Assert.assertEquals(inboundTopicNames, clientInterceptedTopicNames);
        }
    }

    @Test
    public void testListOffsetsResponse() {
        for (short ver = ApiKeys.LIST_OFFSETS.oldestVersion(); ver <= ApiKeys.LIST_OFFSETS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LIST_OFFSETS, ver, false);
            ArrayList<ListOffsetsResponseData.ListOffsetsTopicResponse> offsetResponseData = new ArrayList<ListOffsetsResponseData.ListOffsetsTopicResponse>();
            if (ver == 0) {
                offsetResponseData.add(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("tenant_foo").setPartitions(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setOldStyleOffsets(Arrays.asList(0L, 10L)))));
                offsetResponseData.add(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("tenant_bar").setPartitions(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setOldStyleOffsets(Arrays.asList(0L, 10L)))));
            } else {
                offsetResponseData.add(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("tenant_foo").setPartitions(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setTimestamp(0L).setOffset(0L))));
                offsetResponseData.add(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("tenant_bar").setPartitions(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setTimestamp(0L).setOffset(0L))));
            }
            ListOffsetsResponseData data = new ListOffsetsResponseData().setTopics(offsetResponseData);
            ListOffsetsResponse outbound = new ListOffsetsResponse(data);
            Set outboundTopicNames = outbound.data().topics().stream().map(ListOffsetsResponseData.ListOffsetsTopicResponse::name).collect(Collectors.toSet());
            ListOffsetsResponse intercepted = (ListOffsetsResponse)this.parseResponse(ApiKeys.LIST_OFFSETS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Set interceptedTopicNames = intercepted.data().topics().stream().map(ListOffsetsResponseData.ListOffsetsTopicResponse::name).collect(Collectors.toSet());
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo", "bar"}), interceptedTopicNames);
            this.verifyResponseMetrics(ApiKeys.LIST_OFFSETS, Errors.NONE);
            ListOffsetsResponse clientIntercepted = (ListOffsetsResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Set clientInterceptedTopicNames = clientIntercepted.data().topics().stream().map(ListOffsetsResponseData.ListOffsetsTopicResponse::name).collect(Collectors.toSet());
            Assert.assertEquals(outboundTopicNames, clientInterceptedTopicNames);
        }
    }

    @Test
    public void testMetadataRequest() {
        for (short ver = 0; ver <= ApiKeys.METADATA.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.METADATA, ver, false);
            MetadataRequestData data = new MetadataRequestData();
            data.setAllowAutoTopicCreation(true);
            data.setTopics(Stream.of("foo", "bar").map(t -> new MetadataRequestData.MetadataRequestTopic().setName(t)).collect(Collectors.toList()));
            MetadataRequest inbound = new MetadataRequest(data, ver);
            MetadataRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals(Arrays.asList("tenant_foo", "tenant_bar"), (Object)intercepted.topics());
            this.verifyRequestMetrics(ApiKeys.METADATA);
            MetadataRequest clientIntercepted = (MetadataRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals((Object)inbound.topics(), (Object)clientIntercepted.topics());
        }
    }

    @Test
    public void testMetadataResponseNoController() {
        for (short ver = ApiKeys.METADATA.oldestVersion(); ver <= ApiKeys.METADATA.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.METADATA, ver, false);
            Node node = new Node(1, LOCALHOST, 9092);
            MetadataRequestData data = new MetadataRequestData().setAllowAutoTopicCreation(true).setTopics(ver == 0 ? Collections.emptyList() : null);
            MetadataRequest inbound = new MetadataRequest(data, ver);
            MetadataRequest interceptedInbound = this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)interceptedInbound.isAllTopics());
            Assert.assertTrue((boolean)((MetadataRequest)this.clusterLinkClient.intercept((AbstractRequest)interceptedInbound, context.header)).isAllTopics());
            MetadataResponse outbound = MetadataResponse.prepareResponse((short)ver, (int)0, Collections.singletonList(node), (String)CLUSTER_ID, (int)-1, new ArrayList(), (int)Integer.MIN_VALUE);
            Assert.assertNull((Object)outbound.controller());
            MetadataResponse intercepted = (MetadataResponse)this.parseResponse(ApiKeys.METADATA, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertNull((Object)intercepted.controller());
            Assert.assertNull((Object)((MetadataResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header)).controller());
        }
    }

    @Test
    public void testTenantSpecificMetadataResponse() {
        for (short ver = 0; ver <= ApiKeys.METADATA.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.METADATA, ver, true);
            int brokerId = 1;
            Node node = new Node(brokerId, "-localhost", 9092);
            ArrayList<MetadataResponseData.MetadataResponseTopic> topicMetadata = new ArrayList<MetadataResponseData.MetadataResponseTopic>();
            topicMetadata.add(this.singletonMetadataResponseTopic(new TopicPartition("tenant_foo", 0), brokerId));
            topicMetadata.add(this.singletonMetadataResponseTopic(new TopicPartition("tenant_bar", 0), brokerId));
            MetadataResponse outbound = MetadataResponse.prepareResponse((short)ver, (int)0, Collections.singletonList(node), (String)CLUSTER_ID, (int)1, topicMetadata, (int)Integer.MIN_VALUE);
            MetadataResponse intercepted = (MetadataResponse)this.parseResponse(ApiKeys.METADATA, ver, context.buildResponseSend((AbstractResponse)outbound));
            Collection brokers = intercepted.brokers();
            Assert.assertEquals((long)1L, (long)brokers.size());
            Node broker = (Node)brokers.iterator().next();
            String tenantSpecificBrokerHost = "tenant_cluster_id-localhost";
            Assert.assertEquals((Object)"tenant_cluster_id-localhost", (Object)broker.host());
            this.verifyMetadataResponse(intercepted, ver, "foo", "bar");
            this.verifyResponseMetrics(ApiKeys.METADATA, Errors.NONE);
        }
    }

    @Test
    public void testMetadataResponse() {
        for (short ver = ApiKeys.METADATA.oldestVersion(); ver <= ApiKeys.METADATA.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.METADATA, ver, false);
            int brokerId = 1;
            Node node = new Node(1, LOCALHOST, 9092);
            ArrayList<MetadataResponseData.MetadataResponseTopic> topicMetadata = new ArrayList<MetadataResponseData.MetadataResponseTopic>();
            topicMetadata.add(this.singletonMetadataResponseTopic(new TopicPartition("tenant_foo", 0), brokerId));
            topicMetadata.add(this.singletonMetadataResponseTopic(new TopicPartition("tenant_bar", 0), brokerId));
            MetadataResponse outbound = MetadataResponse.prepareResponse((short)ver, (int)0, Collections.singletonList(node), (String)CLUSTER_ID, (int)1, topicMetadata, (int)Integer.MIN_VALUE);
            MetadataResponse intercepted = (MetadataResponse)this.parseResponse(ApiKeys.METADATA, ver, context.buildResponseSend((AbstractResponse)outbound));
            this.verifyMetadataResponse(intercepted, ver, "foo", "bar");
            this.verifyResponseMetrics(ApiKeys.METADATA, Errors.NONE);
            MetadataResponse clientIntercepted = (MetadataResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            this.verifyMetadataResponse(clientIntercepted, ver, "tenant_foo", "tenant_bar");
        }
    }

    private void verifyMetadataResponse(MetadataResponse intercepted, short ver, String ... expectedTopics) {
        if (ver < 2) {
            Assert.assertNull((Object)intercepted.clusterId());
        } else {
            Assert.assertEquals((Object)TENANT_CLUSTER_ID, (Object)intercepted.clusterId());
        }
        Iterator iterator = intercepted.topicMetadata().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)expectedTopics[0], (Object)((MetadataResponse.TopicMetadata)iterator.next()).topic());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)expectedTopics[1], (Object)((MetadataResponse.TopicMetadata)iterator.next()).topic());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private MetadataResponseData.MetadataResponseTopic singletonMetadataResponseTopic(TopicPartition topicPartition, int brokerId) {
        return new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicPartition.topic()).setIsInternal(false).setPartitions(Collections.singletonList(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(topicPartition.partition()).setLeaderId(brokerId).setReplicaNodes(Collections.singletonList(brokerId)).setIsrNodes(Collections.singletonList(brokerId)).setOfflineReplicas(Collections.emptyList())));
    }

    @Test
    public void testMetadataFetchAllTopics() {
        for (short ver = 0; ver <= ApiKeys.METADATA.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.METADATA, ver, false);
            MetadataRequestData data = new MetadataRequestData().setAllowAutoTopicCreation(true).setTopics(ver == 0 ? Collections.emptyList() : null);
            MetadataRequest inbound = new MetadataRequest(data, ver);
            MetadataRequest interceptedInbound = this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)interceptedInbound.isAllTopics());
            int brokerId = 1;
            Node node = new Node(brokerId, LOCALHOST, 9092);
            ArrayList<MetadataResponseData.MetadataResponseTopic> topicMetadata = new ArrayList<MetadataResponseData.MetadataResponseTopic>();
            topicMetadata.add(this.singletonMetadataResponseTopic(new TopicPartition("tenant_foo", 0), brokerId));
            topicMetadata.add(this.singletonMetadataResponseTopic(new TopicPartition("othertenant_foo", 0), brokerId));
            topicMetadata.add(this.singletonMetadataResponseTopic(new TopicPartition("tenant_bar", 0), brokerId));
            topicMetadata.add(this.singletonMetadataResponseTopic(new TopicPartition("othertenant_bar", 0), brokerId));
            MetadataResponse outbound = MetadataResponse.prepareResponse((short)ver, (int)0, Collections.singletonList(node), (String)"clusterId", (int)1, topicMetadata, (int)Integer.MIN_VALUE);
            MetadataResponse interceptedOutbound = (MetadataResponse)this.parseResponse(ApiKeys.METADATA, ver, context.buildResponseSend((AbstractResponse)outbound));
            this.verifyMetadataResponse(interceptedOutbound, ver, "foo", "bar");
            MetadataResponse clientIntercepted = (MetadataResponse)this.clusterLinkClient.intercept((AbstractResponse)interceptedOutbound, context.header);
            this.verifyMetadataResponse(clientIntercepted, ver, "tenant_foo", "tenant_bar");
        }
    }

    @Test
    public void testDescribeClusterRequest() {
        for (short ver = 0; ver <= ApiKeys.DESCRIBE_CLUSTER.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_CLUSTER, ver, false);
            DescribeClusterRequestData data = new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(true);
            DescribeClusterRequest inbound = new DescribeClusterRequest(data, ver);
            DescribeClusterRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)intercepted.data().includeClusterAuthorizedOperations());
        }
    }

    @Test
    public void testDescribeClusterResponse() {
        for (short ver = 0; ver <= ApiKeys.DESCRIBE_CLUSTER.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_CLUSTER, ver, false);
            DescribeClusterResponseData data = new DescribeClusterResponseData().setClusterId("cluster-id").setControllerId(0).setBrokers(new DescribeClusterResponseData.DescribeClusterBrokerCollection(Collections.singletonList(new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(0).setHost(LOCALHOST).setPort(9092)).iterator()));
            DescribeClusterResponse outbound = new DescribeClusterResponse(data);
            DescribeClusterResponse intercepted = (DescribeClusterResponse)this.parseResponse(ApiKeys.DESCRIBE_CLUSTER, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)TENANT_CLUSTER_ID, (Object)intercepted.data().clusterId());
            Assert.assertEquals((long)0L, (long)intercepted.data().controllerId());
            Assert.assertEquals((long)1L, (long)intercepted.data().brokers().size());
            DescribeClusterResponseData.DescribeClusterBroker broker = intercepted.data().brokers().find(0);
            Assert.assertEquals((long)0L, (long)broker.brokerId());
            Assert.assertEquals((Object)LOCALHOST, (Object)broker.host());
            Assert.assertEquals((long)9092L, (long)broker.port());
            DescribeClusterResponse clientIntercepted = (DescribeClusterResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Assert.assertEquals((Object)TENANT_CLUSTER_ID, (Object)clientIntercepted.data().clusterId());
        }
    }

    @Test
    public void testOffsetCommitRequest() {
        for (short ver = ApiKeys.OFFSET_COMMIT.oldestVersion(); ver <= ApiKeys.OFFSET_COMMIT.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.OFFSET_COMMIT, ver, false);
            String groupId = "group";
            OffsetCommitRequest inbound = new OffsetCommitRequest.Builder(new OffsetCommitRequestData().setGroupId(groupId).setTopics(Arrays.asList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName("foo").setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(0L).setCommittedLeaderEpoch(-1).setCommittedMetadata(""))), new OffsetCommitRequestData.OffsetCommitRequestTopic().setName("bar").setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(0L).setCommittedLeaderEpoch(-1).setCommittedMetadata("")))))).build(ver);
            OffsetCommitRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_group", (Object)intercepted.data().groupId());
            Assert.assertEquals(Arrays.asList(new TopicPartition("tenant_foo", 0), new TopicPartition("tenant_bar", 0)), intercepted.data().topics().stream().flatMap(t -> t.partitions().stream().map(p -> new TopicPartition(t.name(), p.partitionIndex()))).collect(Collectors.toList()));
            this.verifyRequestMetrics(ApiKeys.OFFSET_COMMIT);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testOffsetCommitResponse() {
        for (short ver = ApiKeys.OFFSET_COMMIT.oldestVersion(); ver <= ApiKeys.OFFSET_COMMIT.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.OFFSET_COMMIT, ver, false);
            HashMap<TopicPartition, Errors> partitionErrors = new HashMap<TopicPartition, Errors>();
            partitionErrors.put(new TopicPartition("tenant_foo", 0), Errors.NONE);
            partitionErrors.put(new TopicPartition("tenant_bar", 0), Errors.NONE);
            OffsetCommitResponse outbound = new OffsetCommitResponse(0, partitionErrors);
            OffsetCommitResponse intercepted = (OffsetCommitResponse)this.parseResponse(ApiKeys.OFFSET_COMMIT, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 0))), intercepted.data().topics().stream().flatMap(t -> t.partitions().stream().map(p -> new TopicPartition(t.name(), p.partitionIndex()))).collect(Collectors.toSet()));
            this.verifyResponseMetrics(ApiKeys.OFFSET_COMMIT, Errors.NONE);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testOffsetFetchRequest() {
        for (short ver = ApiKeys.OFFSET_FETCH.oldestVersion(); ver <= ApiKeys.OFFSET_FETCH.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.OFFSET_FETCH, ver, false);
            String groupId = "group";
            OffsetFetchRequest inbound = new OffsetFetchRequest.Builder(groupId, true, Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 0)), false).build(ver);
            OffsetFetchRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_group", (Object)intercepted.groupId());
            Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("tenant_foo", 0), new TopicPartition("tenant_bar", 0)}), new HashSet(intercepted.partitions()));
            this.verifyRequestMetrics(ApiKeys.OFFSET_FETCH);
            OffsetFetchRequest clientIntercepted = (OffsetFetchRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals((Object)inbound.groupId(), (Object)clientIntercepted.groupId());
            Assert.assertEquals(new HashSet(inbound.partitions()), new HashSet(clientIntercepted.partitions()));
        }
    }

    @Test
    public void testOffsetFetchResponse() {
        for (short ver = ApiKeys.OFFSET_FETCH.oldestVersion(); ver <= ApiKeys.OFFSET_FETCH.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.OFFSET_FETCH, ver, false);
            HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responsePartitions = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
            responsePartitions.put(new TopicPartition("tenant_foo", 0), new OffsetFetchResponse.PartitionData(0L, Optional.empty(), "", Errors.NONE));
            responsePartitions.put(new TopicPartition("tenant_bar", 0), new OffsetFetchResponse.PartitionData(0L, Optional.empty(), "", Errors.NONE));
            OffsetFetchResponse outbound = new OffsetFetchResponse(0, Errors.NONE, responsePartitions);
            OffsetFetchResponse intercepted = (OffsetFetchResponse)this.parseResponse(ApiKeys.OFFSET_FETCH, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0)}), intercepted.responseData().keySet());
            this.verifyResponseMetrics(ApiKeys.OFFSET_FETCH, Errors.NONE);
            OffsetFetchResponse clientIntercepted = (OffsetFetchResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Assert.assertEquals(outbound.responseData().keySet(), clientIntercepted.responseData().keySet());
        }
    }

    @Test
    public void testFindGroupCoordinatorRequest() {
        for (short ver = ApiKeys.FIND_COORDINATOR.oldestVersion(); ver <= ApiKeys.FIND_COORDINATOR.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.FIND_COORDINATOR, ver, false);
            FindCoordinatorRequest inbound = new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey("group")).build(ver);
            FindCoordinatorRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_group", (Object)intercepted.data().key());
            this.verifyRequestMetrics(ApiKeys.FIND_COORDINATOR);
            FindCoordinatorRequest clientIntercepted = (FindCoordinatorRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals((Object)inbound.data().key(), (Object)clientIntercepted.data().key());
            this.verifyRequestMetrics(ApiKeys.FIND_COORDINATOR);
        }
    }

    @Test
    public void testFindTxnCoordinatorRequest() {
        for (short ver = 1; ver <= ApiKeys.FIND_COORDINATOR.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.FIND_COORDINATOR, ver, false);
            FindCoordinatorRequest inbound = new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.TRANSACTION.id()).setKey("tr")).build(ver);
            FindCoordinatorRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_tr", (Object)intercepted.data().key());
            this.verifyRequestMetrics(ApiKeys.FIND_COORDINATOR);
            FindCoordinatorRequest clientIntercepted = (FindCoordinatorRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals((Object)inbound.data().key(), (Object)clientIntercepted.data().key());
            this.verifyRequestMetrics(ApiKeys.FIND_COORDINATOR);
        }
    }

    @Test
    public void testFindCoordinatorResponse() {
        for (short ver = ApiKeys.FIND_COORDINATOR.oldestVersion(); ver <= ApiKeys.FIND_COORDINATOR.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.FIND_COORDINATOR, ver, false);
            FindCoordinatorResponse outbound = new FindCoordinatorResponse(new FindCoordinatorResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to lookup group coordinator for groupId 'tenant_group'"));
            FindCoordinatorResponse intercepted = (FindCoordinatorResponse)this.parseResponse(ApiKeys.FIND_COORDINATOR, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)intercepted.error());
            if (ver >= 1) {
                Assert.assertEquals((Object)"Failed to lookup group coordinator for groupId 'group'", (Object)intercepted.data().errorMessage());
            } else {
                Assert.assertEquals((Object)"", (Object)intercepted.data().errorMessage());
            }
            this.verifyResponseMetrics(ApiKeys.FIND_COORDINATOR, Errors.UNKNOWN_SERVER_ERROR);
        }
    }

    @Test
    public void testJoinGroupRequest() {
        String group = "group";
        String protocolName = "protocol";
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic"), ByteBuffer.allocate(10), Collections.singletonList(new TopicPartition("topic", 0)));
        byte[] protocolMetadata = new byte[20];
        new Random().nextBytes(protocolMetadata);
        this.testJoinGroupRequest(group, "non-consumer", protocolName, protocolMetadata, metadata -> Assert.assertArrayEquals((byte[])protocolMetadata, (byte[])metadata));
        byte[] protocolMetadataV0 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)0).array();
        this.testJoinGroupRequest(group, "consumer", protocolName, protocolMetadataV0, metadata -> {
            ConsumerPartitionAssignor.Subscription interceptedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)ByteBuffer.wrap(metadata));
            Assert.assertArrayEquals((Object[])Collections.singletonList("tenant_topic").toArray(), (Object[])interceptedSubscription.topics().toArray());
            Assert.assertEquals((Object)subscription.userData(), (Object)interceptedSubscription.userData());
        });
        byte[] protocolMetadataV1 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)1).array();
        this.testJoinGroupRequest(group, "consumer", protocolName, protocolMetadataV1, metadata -> {
            ConsumerPartitionAssignor.Subscription interceptedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)ByteBuffer.wrap(metadata));
            Assert.assertArrayEquals((Object[])Collections.singletonList("tenant_topic").toArray(), (Object[])interceptedSubscription.topics().toArray());
            Assert.assertEquals((Object)subscription.userData(), (Object)interceptedSubscription.userData());
            Assert.assertArrayEquals((Object[])subscription.ownedPartitions().toArray(), (Object[])interceptedSubscription.ownedPartitions().toArray());
        });
    }

    private void testJoinGroupRequest(String group, String protocolType, String protocolName, byte[] protocolMetadata, Consumer<byte[]> verifySubscription) {
        for (short ver = ApiKeys.JOIN_GROUP.oldestVersion(); ver <= ApiKeys.JOIN_GROUP.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.JOIN_GROUP, ver, false);
            JoinGroupRequest inbound = this.buildJoinGroupRequest(group, protocolType, protocolName, protocolMetadata, ver);
            JoinGroupRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_group", (Object)intercepted.data().groupId());
            Assert.assertEquals((long)1L, (long)intercepted.data().protocols().size());
            verifySubscription.accept(intercepted.data().protocols().find("protocol").metadata());
            this.verifyRequestMetrics(ApiKeys.JOIN_GROUP);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testJoinGroupResponse() {
        String group = "group";
        String protocolName = "protocol";
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic"), ByteBuffer.allocate(10), Collections.singletonList(new TopicPartition("topic", 0)));
        byte[] protocolMetadata = new byte[20];
        new Random().nextBytes(protocolMetadata);
        this.testJoinGroupResponse(group, "non-consumer", protocolName, protocolMetadata, true);
        this.testJoinGroupResponse(group, "non-consumer", protocolName, protocolMetadata, false);
        byte[] protocolMetadataV0 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)0).array();
        this.testJoinGroupResponse(group, "consumer", protocolName, protocolMetadataV0, true);
        this.testJoinGroupResponse(group, "consumer", protocolName, protocolMetadataV0, false);
        byte[] protocolMetadataV1 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)1).array();
        this.testJoinGroupResponse(group, "consumer", protocolName, protocolMetadataV1, true);
        this.testJoinGroupResponse(group, "consumer", protocolName, protocolMetadataV1, false);
    }

    private void testJoinGroupResponse(String group, String protocolType, String protocolName, byte[] protocolMetadata, boolean leader) {
        for (short ver = ApiKeys.JOIN_GROUP.oldestVersion(); ver <= ApiKeys.JOIN_GROUP.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.JOIN_GROUP, ver, false);
            JoinGroupRequest inbound = this.buildJoinGroupRequest(group, protocolType, protocolName, protocolMetadata, ver);
            JoinGroupRequest inboundIntercepted = this.parseRequest(context, inbound);
            JoinGroupResponse outbound = this.buildJoinGroupResponse(leader, protocolName, inboundIntercepted.data().protocols().find(protocolName).metadata());
            JoinGroupResponse intercepted = (JoinGroupResponse)this.parseResponse(ApiKeys.JOIN_GROUP, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)outbound.isLeader(), (Object)intercepted.isLeader());
            Assert.assertEquals((long)outbound.data().generationId(), (long)intercepted.data().generationId());
            Assert.assertEquals((Object)outbound.data().protocolName(), (Object)intercepted.data().protocolName());
            Assert.assertEquals((Object)outbound.data().memberId(), (Object)intercepted.data().memberId());
            Assert.assertEquals((long)outbound.data().members().size(), (long)intercepted.data().members().size());
            for (int i = 0; i < outbound.data().members().size(); ++i) {
                JoinGroupResponseData.JoinGroupResponseMember member = (JoinGroupResponseData.JoinGroupResponseMember)intercepted.data().members().get(i);
                Assert.assertEquals((Object)(i == 0 ? "leader" : "follower"), (Object)member.memberId());
                Assert.assertArrayEquals((byte[])protocolMetadata, (byte[])member.metadata());
            }
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    private JoinGroupRequest buildJoinGroupRequest(String group, String protocolType, String protocolName, byte[] protocolMetadata, short version) {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(Collections.singleton(new JoinGroupRequestData.JoinGroupRequestProtocol().setName(protocolName).setMetadata(protocolMetadata)).iterator());
        JoinGroupRequestData data = new JoinGroupRequestData().setGroupId(group).setSessionTimeoutMs(30000).setMemberId("").setProtocolType(protocolType).setProtocols(protocols);
        return new JoinGroupRequest.Builder(data).build(version);
    }

    private JoinGroupResponse buildJoinGroupResponse(boolean leader, String protocolName, byte[] protocolMetadata) {
        JoinGroupResponseData data = new JoinGroupResponseData().setLeader("leader").setMemberId(leader ? "leader" : "follower").setGenerationId(10).setProtocolName(protocolName);
        if (leader) {
            List<JoinGroupResponseData.JoinGroupResponseMember> members = Arrays.asList(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("leader").setMetadata(protocolMetadata), new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("follower").setMetadata(protocolMetadata));
            data.setMembers(members);
        }
        return new JoinGroupResponse(data);
    }

    @Test
    public void testSyncGroupRequest() {
        for (short ver = ApiKeys.SYNC_GROUP.oldestVersion(); ver <= ApiKeys.SYNC_GROUP.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.SYNC_GROUP, ver, false);
            SyncGroupRequest inbound = new SyncGroupRequest.Builder(new SyncGroupRequestData().setGroupId("group").setGenerationId(1).setMemberId("memberId")).build(ver);
            SyncGroupRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_group", (Object)intercepted.data().groupId());
            this.verifyRequestMetrics(ApiKeys.SYNC_GROUP);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testHeartbeatRequest() {
        for (short ver = ApiKeys.HEARTBEAT.oldestVersion(); ver <= ApiKeys.HEARTBEAT.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.HEARTBEAT, ver, false);
            HeartbeatRequest inbound = new HeartbeatRequest.Builder(new HeartbeatRequestData().setGroupId("group").setGenerationId(1).setMemberId("memberId")).build(ver);
            HeartbeatRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_group", (Object)intercepted.data().groupId());
            this.verifyRequestMetrics(ApiKeys.HEARTBEAT);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testLeaveGroupRequest() {
        for (short ver = ApiKeys.LEAVE_GROUP.oldestVersion(); ver <= ApiKeys.LEAVE_GROUP.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LEAVE_GROUP, ver, false);
            LeaveGroupRequest inbound = new LeaveGroupRequest.Builder("group", Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId("memberId"))).build(ver);
            LeaveGroupRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_group", (Object)intercepted.data().groupId());
            this.verifyRequestMetrics(ApiKeys.LEAVE_GROUP);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testDescribeGroupsRequest() {
        for (short ver = ApiKeys.DESCRIBE_GROUPS.oldestVersion(); ver <= ApiKeys.DESCRIBE_GROUPS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_GROUPS, ver, false);
            DescribeGroupsRequestData describeGroupsRequestData = new DescribeGroupsRequestData();
            describeGroupsRequestData.setGroups(Arrays.asList("foo", "bar"));
            DescribeGroupsRequest inbound = new DescribeGroupsRequest.Builder(describeGroupsRequestData).build(ver);
            DescribeGroupsRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals(Arrays.asList("tenant_foo", "tenant_bar"), (Object)intercepted.data().groups());
            this.verifyRequestMetrics(ApiKeys.DESCRIBE_GROUPS);
            DescribeGroupsRequest clientIntercepted = (DescribeGroupsRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals((Object)inbound.data().groups(), (Object)clientIntercepted.data().groups());
        }
    }

    @Test
    public void testDescribeGroupsResponse() throws IOException {
        List<String> outboundGroups = Arrays.asList("tenant_foo", "tenant_bar");
        ConsumerPartitionAssignor.Subscription outboundSubscriptionWithPrefix = new ConsumerPartitionAssignor.Subscription(Collections.singletonList("tenant_topic"), ByteBuffer.allocate(10), Collections.singletonList(new TopicPartition("topic", 0)));
        ConsumerPartitionAssignor.Subscription outboundSubscriptionWithoutPrefix = new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic"), ByteBuffer.allocate(10), Collections.singletonList(new TopicPartition("topic", 0)));
        ConsumerPartitionAssignor.Subscription interceptedSubscription = new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic"), ByteBuffer.allocate(10), Collections.singletonList(new TopicPartition("topic", 0)));
        byte[] protocolMetadata = new byte[20];
        new Random().nextBytes(protocolMetadata);
        this.testDescribeGroupsResponse(outboundGroups, "non-consumer", protocolMetadata, protocolMetadata);
        byte[] outboundProtocolMetadataV0 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)outboundSubscriptionWithPrefix, (short)0).array();
        byte[] interceptedProtocolMetadataV0 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)interceptedSubscription, (short)0).array();
        this.testDescribeGroupsResponse(outboundGroups, "consumer", outboundProtocolMetadataV0, interceptedProtocolMetadataV0);
        outboundProtocolMetadataV0 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)outboundSubscriptionWithoutPrefix, (short)0).array();
        interceptedProtocolMetadataV0 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)interceptedSubscription, (short)0).array();
        this.testDescribeGroupsResponse(outboundGroups, "consumer", outboundProtocolMetadataV0, interceptedProtocolMetadataV0);
        byte[] outboundProtocolMetadataV1 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)outboundSubscriptionWithPrefix, (short)1).array();
        byte[] interceptedProtocolMetadataV1 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)interceptedSubscription, (short)1).array();
        this.testDescribeGroupsResponse(outboundGroups, "consumer", outboundProtocolMetadataV1, interceptedProtocolMetadataV1);
        outboundProtocolMetadataV1 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)outboundSubscriptionWithoutPrefix, (short)1).array();
        interceptedProtocolMetadataV1 = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)interceptedSubscription, (short)1).array();
        this.testDescribeGroupsResponse(outboundGroups, "consumer", outboundProtocolMetadataV1, interceptedProtocolMetadataV1);
        byte[] emptyMetadata = new byte[]{};
        this.testDescribeGroupsResponse(outboundGroups, "consumer", emptyMetadata, emptyMetadata);
    }

    private void testDescribeGroupsResponse(List<String> outboundGroups, String protocolType, byte[] outboundProtocolMetadata, byte[] interceptedProtocolMetadata) throws IOException {
        for (short ver = ApiKeys.DESCRIBE_GROUPS.oldestVersion(); ver <= ApiKeys.DESCRIBE_GROUPS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_GROUPS, ver, false);
            DescribeGroupsResponse outbound = this.buildDescribeGroupsResponse(outboundGroups, protocolType, "range", outboundProtocolMetadata);
            DescribeGroupsResponse intercepted = (DescribeGroupsResponse)this.parseResponse(ApiKeys.DESCRIBE_GROUPS, ver, context.buildResponseSend((AbstractResponse)outbound));
            DescribeGroupsResponse clientIntercepted = (DescribeGroupsResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            for (int i = 0; i < intercepted.data().groups().size(); ++i) {
                DescribeGroupsResponseData.DescribedGroup interceptedGroup = (DescribeGroupsResponseData.DescribedGroup)intercepted.data().groups().get(i);
                DescribeGroupsResponseData.DescribedGroup outboundGroup = (DescribeGroupsResponseData.DescribedGroup)outbound.data().groups().get(i);
                this.verifyDescribedGroup(interceptedGroup, outboundGroup, context.tenantContext.removeTenantPrefix(outboundGroup.groupId()), interceptedProtocolMetadata);
                DescribeGroupsResponseData.DescribedGroup clientInterceptedGroup = (DescribeGroupsResponseData.DescribedGroup)clientIntercepted.data().groups().get(i);
                this.verifyDescribedGroup(clientInterceptedGroup, outboundGroup, outboundGroup.groupId(), interceptedProtocolMetadata);
            }
            this.verifyResponseMetrics(ApiKeys.DESCRIBE_GROUPS, Errors.NONE);
        }
    }

    private DescribeGroupsResponse buildDescribeGroupsResponse(List<String> groups, String protocolType, String protocolName, byte[] protocolMetadata) {
        DescribeGroupsResponseData describeGroupsResponseData = new DescribeGroupsResponseData();
        for (String group : groups) {
            DescribeGroupsResponseData.DescribedGroupMember member1 = DescribeGroupsResponse.groupMember((String)"member1", null, (String)"clientid", (String)"clienthost", (byte[])new byte[0], (byte[])protocolMetadata);
            DescribeGroupsResponseData.DescribedGroupMember member2 = DescribeGroupsResponse.groupMember((String)"member2", null, (String)"clientid", (String)"clienthost", (byte[])new byte[0], (byte[])protocolMetadata);
            describeGroupsResponseData.groups().add(DescribeGroupsResponse.groupMetadata((String)group, (Errors)Errors.NONE, (String)"STABLE", (String)protocolType, (String)protocolName, Arrays.asList(member1, member2), (int)Integer.MIN_VALUE));
        }
        return new DescribeGroupsResponse(describeGroupsResponseData);
    }

    private void verifyDescribedGroup(DescribeGroupsResponseData.DescribedGroup interceptedGroup, DescribeGroupsResponseData.DescribedGroup outboundGroup, String expectedGroupId, byte[] interceptedProtocolMetadata) {
        Assert.assertEquals((Object)expectedGroupId, (Object)interceptedGroup.groupId());
        Assert.assertEquals((Object)outboundGroup.groupState(), (Object)interceptedGroup.groupState());
        Assert.assertEquals((Object)outboundGroup.protocolType(), (Object)interceptedGroup.protocolType());
        Assert.assertEquals((Object)outboundGroup.protocolData(), (Object)interceptedGroup.protocolData());
        for (int j = 0; j < interceptedGroup.members().size(); ++j) {
            DescribeGroupsResponseData.DescribedGroupMember interceptedMember = (DescribeGroupsResponseData.DescribedGroupMember)interceptedGroup.members().get(j);
            DescribeGroupsResponseData.DescribedGroupMember outboundMember = (DescribeGroupsResponseData.DescribedGroupMember)outboundGroup.members().get(j);
            Assert.assertEquals((Object)outboundMember.memberId(), (Object)interceptedMember.memberId());
            Assert.assertArrayEquals((byte[])outboundMember.memberAssignment(), (byte[])interceptedMember.memberAssignment());
            Assert.assertArrayEquals((byte[])interceptedProtocolMetadata, (byte[])interceptedMember.memberMetadata());
        }
    }

    @Test
    public void testListGroupsResponse() {
        for (short ver = ApiKeys.LIST_GROUPS.oldestVersion(); ver <= ApiKeys.LIST_GROUPS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LIST_GROUPS, ver, false);
            ListGroupsResponseData.ListedGroup fooTenant = new ListGroupsResponseData.ListedGroup();
            fooTenant.setGroupId("tenant_foo");
            fooTenant.setProtocolType("consumer");
            ListGroupsResponseData.ListedGroup otherFooTenant = new ListGroupsResponseData.ListedGroup();
            otherFooTenant.setGroupId("othertenant_foo");
            otherFooTenant.setProtocolType("consumer");
            ListGroupsResponseData.ListedGroup barTenant = new ListGroupsResponseData.ListedGroup();
            barTenant.setGroupId("tenant_bar");
            barTenant.setProtocolType("consumer");
            ListGroupsResponseData.ListedGroup bazTenant = new ListGroupsResponseData.ListedGroup();
            bazTenant.setGroupId("othertenant_baz");
            bazTenant.setProtocolType("consumer");
            ListGroupsResponseData data = new ListGroupsResponseData();
            data.setThrottleTimeMs(0);
            data.setErrorCode(Errors.NONE.code());
            data.setGroups(Arrays.asList(fooTenant, otherFooTenant, barTenant, bazTenant));
            ListGroupsResponse outbound = new ListGroupsResponse(data);
            ListGroupsResponse intercepted = (ListGroupsResponse)this.parseResponse(ApiKeys.LIST_GROUPS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((long)2L, (long)intercepted.data().groups().size());
            Assert.assertEquals((Object)"foo", (Object)((ListGroupsResponseData.ListedGroup)intercepted.data().groups().get(0)).groupId());
            Assert.assertEquals((Object)"bar", (Object)((ListGroupsResponseData.ListedGroup)intercepted.data().groups().get(1)).groupId());
            this.verifyResponseMetrics(ApiKeys.LIST_GROUPS, Errors.NONE);
            ListGroupsResponse clientIntercepted = (ListGroupsResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"tenant_foo", "tenant_bar"}), clientIntercepted.data().groups().stream().map(ListGroupsResponseData.ListedGroup::groupId).collect(Collectors.toSet()));
        }
    }

    @Test
    public void testDeleteGroupsRequest() {
        for (short ver = ApiKeys.DELETE_GROUPS.oldestVersion(); ver <= ApiKeys.DELETE_GROUPS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_GROUPS, ver, false);
            DeleteGroupsRequestData requestData = new DeleteGroupsRequestData().setGroupsNames(Arrays.asList("foo", "bar"));
            DeleteGroupsRequest inbound = new DeleteGroupsRequest.Builder(requestData).build(ver);
            DeleteGroupsRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals(Arrays.asList("tenant_foo", "tenant_bar"), (Object)intercepted.data().groupsNames());
            this.verifyRequestMetrics(ApiKeys.DELETE_GROUPS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testDeleteGroupsResponse() {
        for (short ver = ApiKeys.DELETE_GROUPS.oldestVersion(); ver <= ApiKeys.DELETE_GROUPS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_GROUPS, ver, false);
            DeleteGroupsResponseData responseData = new DeleteGroupsResponseData().setResults(new DeleteGroupsResponseData.DeletableGroupResultCollection(Arrays.asList(new DeleteGroupsResponseData.DeletableGroupResult().setErrorCode(Errors.NONE.code()).setGroupId("tenant_foo"), new DeleteGroupsResponseData.DeletableGroupResult().setErrorCode(Errors.NONE.code()).setGroupId("tenant_bar")).iterator()));
            DeleteGroupsResponse outbound = new DeleteGroupsResponse(responseData);
            DeleteGroupsResponse intercepted = (DeleteGroupsResponse)this.parseResponse(ApiKeys.DELETE_GROUPS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo", "bar"}), intercepted.errors().keySet());
            this.verifyResponseMetrics(ApiKeys.DELETE_GROUPS, Errors.NONE);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testOffsetDeleteRequest() {
        String tenantPrefix = this.principal.tenantMetadata().tenantPrefix();
        for (short ver = ApiKeys.OFFSET_DELETE.oldestVersion(); ver <= ApiKeys.OFFSET_DELETE.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.OFFSET_DELETE, ver, false);
            OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection topics = new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection();
            topics.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("foo").setPartitions(Arrays.asList(new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1))));
            topics.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("bar").setPartitions(Arrays.asList(new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(2), new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(3))));
            OffsetDeleteRequestData data = new OffsetDeleteRequestData().setGroupId("group").setTopics(topics);
            OffsetDeleteRequest inbound = new OffsetDeleteRequest.Builder(data).build(ver);
            OffsetDeleteRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)intercepted.data().groupId().startsWith(tenantPrefix));
            Assert.assertEquals((long)inbound.data().topics().size(), (long)intercepted.data().topics().size());
            for (OffsetDeleteRequestData.OffsetDeleteRequestTopic topic : intercepted.data().topics()) {
                Assert.assertTrue((boolean)topic.name().startsWith(tenantPrefix));
                Assert.assertArrayEquals((Object[])inbound.data().topics().find(topic.name().substring(tenantPrefix.length())).partitions().toArray(), (Object[])topic.partitions().toArray());
            }
            this.verifyRequestMetrics(ApiKeys.OFFSET_DELETE);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testOffsetDeleteResponse() {
        String tenantPrefix = this.principal.tenantMetadata().tenantPrefix();
        for (short ver = ApiKeys.OFFSET_DELETE.oldestVersion(); ver <= ApiKeys.OFFSET_DELETE.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.OFFSET_DELETE, ver, false);
            OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection topics = new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection();
            topics.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("tenant_foo").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Arrays.asList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0), new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(1)).iterator())));
            topics.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("tenant_bar").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Arrays.asList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(2), new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(3)).iterator())));
            OffsetDeleteResponseData data = new OffsetDeleteResponseData().setTopics(topics);
            OffsetDeleteResponse outbound = new OffsetDeleteResponse(data);
            OffsetDeleteResponse intercepted = (OffsetDeleteResponse)this.parseResponse(ApiKeys.OFFSET_DELETE, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((long)outbound.data().topics().size(), (long)intercepted.data().topics().size());
            for (OffsetDeleteResponseData.OffsetDeleteResponseTopic interceptedTopic : intercepted.data().topics()) {
                Assert.assertFalse((boolean)interceptedTopic.name().startsWith(tenantPrefix));
                OffsetDeleteResponseData.OffsetDeleteResponseTopic outboundOriginal = outbound.data().topics().find(context.tenantContext.addTenantPrefix(interceptedTopic.name()));
                Assert.assertEquals((Object)context.tenantContext.removeTenantPrefix(outboundOriginal.name()), (Object)interceptedTopic.name());
                Assert.assertEquals((long)outboundOriginal.partitions().size(), (long)interceptedTopic.partitions().size());
            }
            this.verifyResponseMetrics(ApiKeys.OFFSET_DELETE, Errors.NONE);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    CreateTopicsRequestData.CreatableTopic creatableTopic(String topicName, int numPartitions, short replicationFactor, CreateTopicsRequestData.CreateableTopicConfigCollection configs) {
        return new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(numPartitions).setReplicationFactor(replicationFactor).setConfigs(configs);
    }

    CreateTopicsRequestData.CreatableTopic creatableTopic(String topicName, int numPartitions, short replicationFactor) {
        return new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(numPartitions).setReplicationFactor(replicationFactor);
    }

    @Test
    public void testCreateTopicRequestWithNoZones() {
        this.testCluster = new TestCluster();
        for (int i = 0; i < 3; ++i) {
            this.testCluster.addNode(i, null);
        }
        this.partitionAssignor = new TenantPartitionAssignor();
        this.partitionAssignor.updateClusterMetadata(this.testCluster.cluster());
        this.testCreateTopicsRequest();
    }

    @Test
    public void testCreateTopicRequestWithOneZone() {
        this.testCluster = new TestCluster();
        for (int i = 0; i < 3; ++i) {
            this.testCluster.addNode(i, "0");
        }
        this.partitionAssignor = new TenantPartitionAssignor();
        this.partitionAssignor.updateClusterMetadata(this.testCluster.cluster());
        this.testCreateTopicsRequest();
    }

    @Test
    public void testCreateTopicRequestWithThreeZone() {
        this.testCluster = new TestCluster();
        for (int i = 0; i < 3; ++i) {
            this.testCluster.addNode(i, "" + i);
        }
        this.partitionAssignor = new TenantPartitionAssignor();
        this.partitionAssignor.updateClusterMetadata(this.testCluster.cluster());
        this.testCreateTopicsRequest();
    }

    @Test
    public void testCreateTopicsRequestRespectsMaxNumPartitions() {
        for (short ver = ApiKeys.CREATE_TOPICS.oldestVersion(); ver <= ApiKeys.CREATE_TOPICS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_TOPICS, ver, false);
            CreateTopicsRequestData.CreatableTopicCollection requestTopics = new CreateTopicsRequestData.CreatableTopicCollection();
            requestTopics.add((ImplicitLinkedHashCollection.Element)this.creatableTopic("foo", 600, (short)3));
            requestTopics.add((ImplicitLinkedHashCollection.Element)this.creatableTopic("bar", 600, (short)3));
            CreateTopicsRequest inbound = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(requestTopics).setTimeoutMs(30000).setValidateOnly(false)).build(ver);
            this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)context.shouldIntercept());
            Assert.assertEquals(InvalidRequestException.class, context.tenantApiException().getClass());
            Assert.assertEquals((Object)String.format("You may not create more than %d new partitions in a single request.", 1000), (Object)context.tenantApiException().getMessage());
        }
    }

    @Test
    public void testCreateTopicRequestWithSchemaValidationEnabled() {
        this.isSchemaValidationEnabled = true;
        this.testCreateTopicsRequest();
    }

    @Test
    public void testCreateTopicsRequest() {
        for (short ver = ApiKeys.CREATE_TOPICS.oldestVersion(); ver <= ApiKeys.CREATE_TOPICS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_TOPICS, ver, false);
            CreateTopicsRequestData.CreatableTopicCollection requestTopics = new CreateTopicsRequestData.CreatableTopicCollection();
            requestTopics.add((ImplicitLinkedHashCollection.Element)this.creatableTopic("foo", 4, (short)1, this.testConfigs()));
            CreateTopicsRequestData.CreatableReplicaAssignmentCollection unbalancedAssignments = new CreateTopicsRequestData.CreatableReplicaAssignmentCollection();
            unbalancedAssignments.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex(0).setBrokerIds(Arrays.asList(0, 1)));
            unbalancedAssignments.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex(1).setBrokerIds(Arrays.asList(0, 1)));
            requestTopics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(3).setAssignments(unbalancedAssignments).setReplicationFactor((short)5));
            requestTopics.add((ImplicitLinkedHashCollection.Element)this.creatableTopic("invalid", 3, (short)5));
            if (ver >= 4) {
                requestTopics.add((ImplicitLinkedHashCollection.Element)this.creatableTopic("default", -1, (short)-1));
            }
            if (ver >= 5) {
                requestTopics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("mirror").setNumPartitions(-1).setReplicationFactor((short)4).setLinkName("link-name").setMirrorTopic("mirror-topic"));
            }
            CreateTopicsRequest inbound = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(requestTopics).setTimeoutMs(30000).setValidateOnly(false)).build(ver);
            CreateTopicsRequest intercepted = this.parseRequest(context, inbound);
            Set expectedTopics = Utils.mkSet((Object[])new String[]{"tenant_foo", "tenant_bar", "tenant_invalid"});
            if (ver >= 4) {
                expectedTopics.add("tenant_default");
            }
            if (ver >= 5) {
                expectedTopics.add("tenant_mirror");
            }
            Assert.assertEquals((Object)expectedTopics, intercepted.data().topics().stream().map(CreateTopicsRequestData.CreatableTopic::name).collect(Collectors.toSet()));
            Assert.assertEquals((long)4L, (long)intercepted.data().topics().find("tenant_foo").assignments().size());
            Assert.assertEquals((Object)this.transformedTestConfigs(), (Object)intercepted.data().topics().find("tenant_foo").configs());
            Assert.assertEquals((long)-1L, (long)intercepted.data().topics().find("tenant_foo").numPartitions());
            Assert.assertEquals((long)-1L, (long)intercepted.data().topics().find("tenant_foo").replicationFactor());
            Assert.assertEquals((long)2L, (long)intercepted.data().topics().find("tenant_bar").assignments().size());
            Assert.assertNotEquals((Object)unbalancedAssignments, (Object)intercepted.data().topics().find("tenant_invalid").assignments());
            Assert.assertTrue((boolean)intercepted.data().topics().find("tenant_invalid").assignments().isEmpty());
            Assert.assertEquals((long)3L, (long)intercepted.data().topics().find("tenant_invalid").numPartitions());
            Assert.assertEquals((long)5L, (long)intercepted.data().topics().find("tenant_invalid").replicationFactor());
            if (ver >= 4) {
                Assert.assertEquals((long)3L, (long)intercepted.data().topics().find("tenant_default").assignments().size());
                Assert.assertEquals((long)2L, (long)intercepted.data().topics().find("tenant_default").assignments().find(0).brokerIds().size());
            }
            if (ver >= 5) {
                Assert.assertEquals((long)-1L, (long)intercepted.data().topics().find("tenant_mirror").numPartitions());
                Assert.assertEquals((long)4L, (long)intercepted.data().topics().find("tenant_mirror").replicationFactor());
                Assert.assertEquals((Object)"tenant_link-name", (Object)intercepted.data().topics().find("tenant_mirror").linkName());
                Assert.assertEquals((Object)"tenant_mirror-topic", (Object)intercepted.data().topics().find("tenant_mirror").mirrorTopic());
            }
            this.verifyRequestMetrics(ApiKeys.CREATE_TOPICS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testCreateTopicsRequestWithoutPartitionAssignor() {
        this.partitionAssignor = null;
        for (short ver = ApiKeys.CREATE_TOPICS.oldestVersion(); ver <= ApiKeys.CREATE_TOPICS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_TOPICS, ver, false);
            CreateTopicsRequestData.CreatableTopicCollection requestTopics = new CreateTopicsRequestData.CreatableTopicCollection();
            requestTopics.add((ImplicitLinkedHashCollection.Element)this.creatableTopic("foo", 4, (short)1, this.testConfigs()));
            CreateTopicsRequestData.CreatableReplicaAssignmentCollection unbalancedAssignments = new CreateTopicsRequestData.CreatableReplicaAssignmentCollection();
            unbalancedAssignments.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex(0).setBrokerIds(Arrays.asList(0, 1)));
            unbalancedAssignments.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex(1).setBrokerIds(Arrays.asList(0, 1)));
            requestTopics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(3).setAssignments(unbalancedAssignments).setReplicationFactor((short)5));
            requestTopics.add((ImplicitLinkedHashCollection.Element)this.creatableTopic("foo", 3, (short)5, this.testConfigs()));
            requestTopics.add((ImplicitLinkedHashCollection.Element)this.creatableTopic("invalid", 3, (short)5));
            if (ver >= 4) {
                requestTopics.add((ImplicitLinkedHashCollection.Element)this.creatableTopic("default", -1, (short)-1));
            }
            if (ver >= 5) {
                requestTopics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("mirror").setNumPartitions(-1).setReplicationFactor((short)4).setLinkName("link-name").setMirrorTopic("mirror-topic"));
            }
            CreateTopicsRequest inbound = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(requestTopics).setTimeoutMs(30000).setValidateOnly(false)).build(ver);
            CreateTopicsRequest intercepted = this.parseRequest(context, inbound);
            Set expectedTopics = Utils.mkSet((Object[])new String[]{"tenant_foo", "tenant_bar", "tenant_invalid"});
            if (ver >= 4) {
                expectedTopics.add("tenant_default");
            }
            if (ver >= 5) {
                expectedTopics.add("tenant_mirror");
            }
            Assert.assertEquals((Object)expectedTopics, intercepted.data().topics().stream().map(CreateTopicsRequestData.CreatableTopic::name).collect(Collectors.toSet()));
            Assert.assertEquals((long)4L, (long)intercepted.data().topics().find("tenant_foo").numPartitions());
            Assert.assertEquals((long)1L, (long)intercepted.data().topics().find("tenant_foo").replicationFactor());
            Assert.assertTrue((boolean)intercepted.data().topics().find("tenant_foo").assignments().isEmpty());
            Assert.assertEquals((Object)this.transformedTestConfigs(), (Object)intercepted.data().topics().find("tenant_foo").configs());
            Assert.assertEquals((long)2L, (long)intercepted.data().topics().find("tenant_bar").assignments().size());
            Assert.assertNotEquals((Object)unbalancedAssignments, (Object)intercepted.data().topics().find("tenant_invalid").assignments());
            Assert.assertTrue((boolean)intercepted.data().topics().find("tenant_invalid").assignments().isEmpty());
            Assert.assertEquals((long)3L, (long)intercepted.data().topics().find("tenant_invalid").numPartitions());
            Assert.assertEquals((long)5L, (long)intercepted.data().topics().find("tenant_invalid").replicationFactor());
            if (ver >= 4) {
                Assert.assertTrue((boolean)intercepted.data().topics().find("tenant_default").assignments().isEmpty());
                Assert.assertEquals((long)-1L, (long)intercepted.data().topics().find("tenant_default").numPartitions());
                Assert.assertEquals((long)-1L, (long)intercepted.data().topics().find("tenant_default").replicationFactor());
            }
            if (ver >= 5) {
                Assert.assertEquals((long)-1L, (long)intercepted.data().topics().find("tenant_mirror").numPartitions());
                Assert.assertEquals((long)4L, (long)intercepted.data().topics().find("tenant_mirror").replicationFactor());
                Assert.assertEquals((Object)"tenant_link-name", (Object)intercepted.data().topics().find("tenant_mirror").linkName());
                Assert.assertEquals((Object)"tenant_mirror-topic", (Object)intercepted.data().topics().find("tenant_mirror").mirrorTopic());
            }
            this.verifyRequestMetrics(ApiKeys.CREATE_TOPICS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testCreateTopicsResponse() {
        for (short ver = ApiKeys.CREATE_TOPICS.oldestVersion(); ver <= ApiKeys.CREATE_TOPICS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_TOPICS, ver, false);
            List<CreateTopicsResponseData.CreatableTopicConfigs> configs = Arrays.asList(new CreateTopicsResponseData.CreatableTopicConfigs().setConfigName("confluent.tier.enable").setValue("true"), new CreateTopicsResponseData.CreatableTopicConfigs().setConfigName("confluent.placement.constraints").setValue("{}"), new CreateTopicsResponseData.CreatableTopicConfigs().setConfigName("max.message.bytes").setValue("100000"), new CreateTopicsResponseData.CreatableTopicConfigs().setConfigName("tenant_config").setValue("somevalue"));
            CreateTopicsResponseData.CreatableTopicResult firstResult = new CreateTopicsResponseData.CreatableTopicResult().setErrorCode(Errors.NONE.code()).setErrorMessage("").setName("tenant_foo").setTopicConfigErrorCode(Errors.NONE.code());
            if (ver >= 5) {
                firstResult = firstResult.setConfigs(configs).setNumPartitions(2).setReplicationFactor((short)3);
            }
            List<CreateTopicsResponseData.CreatableTopicResult> results = Arrays.asList(firstResult, new CreateTopicsResponseData.CreatableTopicResult().setErrorCode(Errors.NONE.code()).setErrorMessage("").setName("tenant_bar"));
            CreateTopicsResponse outbound = new CreateTopicsResponse(new CreateTopicsResponseData().setTopics(new CreateTopicsResponseData.CreatableTopicResultCollection(results.iterator())));
            CreateTopicsResponse intercepted = (CreateTopicsResponse)this.parseResponse(ApiKeys.CREATE_TOPICS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals(new HashSet<String>(Arrays.asList("foo", "bar")), intercepted.data().topics().stream().map(CreateTopicsResponseData.CreatableTopicResult::name).collect(Collectors.toSet()));
            if (ver >= 5) {
                Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"max.message.bytes", "tenant_config"}), intercepted.data().topics().find("foo").configs().stream().map(CreateTopicsResponseData.CreatableTopicConfigs::configName).collect(Collectors.toSet()));
            } else {
                Assert.assertTrue((boolean)intercepted.data().topics().find("foo").configs().isEmpty());
            }
            this.verifyResponseMetrics(ApiKeys.CREATE_TOPICS, Errors.NONE);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testCreateTopicsResponsePolicyFailure() {
        for (short ver = ApiKeys.CREATE_TOPICS.oldestVersion(); ver <= ApiKeys.CREATE_TOPICS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_TOPICS, ver, false);
            List<CreateTopicsResponseData.CreatableTopicResult> results = Arrays.asList(new CreateTopicsResponseData.CreatableTopicResult().setErrorCode(Errors.POLICY_VIOLATION.code()).setErrorMessage("Topic tenant_foo is not permitted").setName("tenant_foo"), new CreateTopicsResponseData.CreatableTopicResult().setErrorCode(Errors.NONE.code()).setErrorMessage("").setName("tenant_bar"));
            CreateTopicsResponse outbound = new CreateTopicsResponse(new CreateTopicsResponseData().setTopics(new CreateTopicsResponseData.CreatableTopicResultCollection(results.iterator())));
            CreateTopicsResponse intercepted = (CreateTopicsResponse)this.parseResponse(ApiKeys.CREATE_TOPICS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals(new HashSet<String>(Arrays.asList("foo", "bar")), intercepted.data().topics().stream().map(CreateTopicsResponseData.CreatableTopicResult::name).collect(Collectors.toSet()));
            Assert.assertEquals((long)Errors.NONE.code(), (long)intercepted.data().topics().find("bar").errorCode());
            Assert.assertEquals((long)Errors.POLICY_VIOLATION.code(), (long)intercepted.data().topics().find("foo").errorCode());
            if (ver >= 1) {
                Assert.assertEquals((Object)"Topic foo is not permitted", (Object)intercepted.data().topics().find("foo").errorMessage());
            }
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testDeleteTopicsRequest() {
        for (short ver = ApiKeys.DELETE_TOPICS.oldestVersion(); ver <= ApiKeys.DELETE_TOPICS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_TOPICS, ver, false);
            DeleteTopicsRequest inbound = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("foo", "bar"))).build(ver);
            DeleteTopicsRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"tenant_foo", "tenant_bar"}), new HashSet(intercepted.topicNames()));
            this.verifyRequestMetrics(ApiKeys.DELETE_TOPICS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testDeleteTopicsResponse() {
        for (short ver = ApiKeys.DELETE_TOPICS.oldestVersion(); ver <= ApiKeys.DELETE_TOPICS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_TOPICS, ver, false);
            DeleteTopicsResponseData.DeletableTopicResultCollection deleted = new DeleteTopicsResponseData.DeletableTopicResultCollection();
            deleted.add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setName("tenant_foo").setErrorCode(Errors.NONE.code()));
            deleted.add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setName("tenant_bar").setErrorMessage("Failed to delete 'tenant_bar'").setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()));
            DeleteTopicsResponse outbound = new DeleteTopicsResponse(new DeleteTopicsResponseData().setResponses(deleted));
            DeleteTopicsResponse intercepted = (DeleteTopicsResponse)this.parseResponse(ApiKeys.DELETE_TOPICS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo", "bar"}), intercepted.data().responses().stream().map(DeleteTopicsResponseData.DeletableTopicResult::name).collect(Collectors.toSet()));
            if (ver >= 5) {
                Assert.assertEquals((Object)"Failed to delete 'bar'", (Object)intercepted.data().responses().find("bar").errorMessage());
            }
            this.verifyResponseMetrics(ApiKeys.DELETE_TOPICS, Utils.mkSet((Object[])new Errors[]{Errors.NONE, Errors.UNKNOWN_SERVER_ERROR}));
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testInitProducerIdRequest() {
        for (short ver = ApiKeys.INIT_PRODUCER_ID.oldestVersion(); ver <= ApiKeys.INIT_PRODUCER_ID.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.INIT_PRODUCER_ID, ver, false);
            InitProducerIdRequest inbound = new InitProducerIdRequest.Builder(new InitProducerIdRequestData().setTransactionalId("tr").setTransactionTimeoutMs(30000)).build(ver);
            InitProducerIdRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_tr", (Object)intercepted.data().transactionalId());
            this.verifyRequestMetrics(ApiKeys.INIT_PRODUCER_ID);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testInitProducerIdRequestNullTransactionalId() {
        for (short ver = ApiKeys.INIT_PRODUCER_ID.oldestVersion(); ver <= ApiKeys.INIT_PRODUCER_ID.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.INIT_PRODUCER_ID, ver, false);
            InitProducerIdRequest inbound = new InitProducerIdRequest.Builder(new InitProducerIdRequestData().setTransactionalId(null).setTransactionTimeoutMs(1000)).build(ver);
            InitProducerIdRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertNull((Object)intercepted.data().transactionalId());
            this.verifyRequestMetrics(ApiKeys.INIT_PRODUCER_ID);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testControlledShutdownNotAllowed() {
        for (short ver = ApiKeys.CONTROLLED_SHUTDOWN.oldestVersion(); ver <= ApiKeys.CONTROLLED_SHUTDOWN.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CONTROLLED_SHUTDOWN, ver, false);
            ControlledShutdownRequest inbound = new ControlledShutdownRequest.Builder(new ControlledShutdownRequestData().setBrokerId(1).setBrokerEpoch(0L), ver).build(ver);
            ControlledShutdownRequest request = this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)context.shouldIntercept());
            ControlledShutdownResponse response = (ControlledShutdownResponse)context.intercept((AbstractRequest)request, 0);
            ControlledShutdownResponse outbound = (ControlledShutdownResponse)this.parseResponse(ApiKeys.CONTROLLED_SHUTDOWN, ver, context.buildResponseSend((AbstractResponse)response));
            Assert.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)outbound.error());
            this.verifyRequestAndResponseMetrics(ApiKeys.CONTROLLED_SHUTDOWN, Errors.CLUSTER_AUTHORIZATION_FAILED);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)request, context.header);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)response, context.header);
        }
    }

    @Test
    public void testStopReplicaNotAllowed() {
        for (short ver = ApiKeys.STOP_REPLICA.oldestVersion(); ver <= ApiKeys.STOP_REPLICA.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.STOP_REPLICA, ver, false);
            TopicPartition partition = new TopicPartition("foo", 0);
            StopReplicaRequestData.StopReplicaTopicState topicState = new StopReplicaRequestData.StopReplicaTopicState().setTopicName("foo").setPartitionStates(Collections.singletonList(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(0).setDeletePartition(false)));
            StopReplicaRequest inbound = new StopReplicaRequest.Builder(1, 0, 0, 0L, false, Collections.singletonList(topicState)).build(ver);
            StopReplicaRequest request = this.parseRequest(context, inbound);
            Assert.assertEquals(Collections.singletonList(new TopicPartition("tenant_foo", 0)), StreamSupport.stream(request.partitionStates().keySet().spliterator(), false).map(p -> new TopicPartition(p.topic(), p.partition())).collect(Collectors.toList()));
            Assert.assertTrue((boolean)context.shouldIntercept());
            StopReplicaResponse response = (StopReplicaResponse)context.intercept((AbstractRequest)request, 0);
            StopReplicaResponse outbound = (StopReplicaResponse)this.parseResponse(ApiKeys.STOP_REPLICA, ver, context.buildResponseSend((AbstractResponse)response));
            Assert.assertEquals(Optional.of(Errors.CLUSTER_AUTHORIZATION_FAILED.code()), outbound.partitions().stream().filter(pe -> pe.topicName().equals(partition.topic()) && pe.partitionIndex() == partition.partition()).findFirst().map(pe -> pe.errorCode()));
            this.verifyRequestAndResponseMetrics(ApiKeys.STOP_REPLICA, Errors.CLUSTER_AUTHORIZATION_FAILED);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)request, context.header);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)response, context.header);
        }
    }

    @Test
    public void testLeaderAndIsrNotAllowed() {
        for (short ver = ApiKeys.LEADER_AND_ISR.oldestVersion(); ver <= ApiKeys.LEADER_AND_ISR.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LEADER_AND_ISR, ver, false);
            String topic = "foo";
            HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
            topicIds.put("foo", Uuid.randomUuid());
            Map<Uuid, String> topicNames = topicIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            int partition = 0;
            LeaderAndIsrRequest inbound = new LeaderAndIsrRequest.Builder(ver, 1, 1, 0L, Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topic).setPartitionIndex(partition).setControllerEpoch(15).setLeader(1).setLeaderEpoch(20).setIsr(Collections.emptyList()).setZkVersion(15).setReplicas(Collections.emptyList()).setIsNew(false)), topicIds, Collections.emptySet(), false).build(ver);
            LeaderAndIsrRequest request = this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)context.shouldIntercept());
            LeaderAndIsrResponse response = (LeaderAndIsrResponse)context.intercept((AbstractRequest)request, 0);
            LeaderAndIsrResponse outbound = (LeaderAndIsrResponse)this.parseResponse(ApiKeys.LEADER_AND_ISR, ver, context.buildResponseSend((AbstractResponse)response));
            Assert.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, outbound.partitionErrors(topicNames).get(new TopicPartition(topic, partition)));
            this.verifyRequestAndResponseMetrics(ApiKeys.LEADER_AND_ISR, Errors.CLUSTER_AUTHORIZATION_FAILED);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)request, context.header);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)response, context.header);
        }
    }

    @Test
    public void testUpdateMetadataNotAllowed() {
        for (short ver = ApiKeys.UPDATE_METADATA.oldestVersion(); ver <= ApiKeys.UPDATE_METADATA.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.UPDATE_METADATA, ver, false);
            String topic = "foo";
            int partition = 0;
            HashMap topicIds = new HashMap();
            UpdateMetadataRequest inbound = new UpdateMetadataRequest.Builder(ver, 1, 1, 0L, Collections.singletonList(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(partition).setControllerEpoch(15).setLeader(1).setLeaderEpoch(20).setIsr(Collections.emptyList()).setZkVersion(15).setReplicas(Collections.emptyList())), Collections.emptyList(), topicIds).build(ver);
            UpdateMetadataRequest request = this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)context.shouldIntercept());
            UpdateMetadataResponse response = (UpdateMetadataResponse)context.intercept((AbstractRequest)request, 0);
            UpdateMetadataResponse outbound = (UpdateMetadataResponse)this.parseResponse(ApiKeys.UPDATE_METADATA, ver, context.buildResponseSend((AbstractResponse)response));
            Assert.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)outbound.error());
            this.verifyRequestAndResponseMetrics(ApiKeys.UPDATE_METADATA, Errors.CLUSTER_AUTHORIZATION_FAILED);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)request, context.header);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)response, context.header);
        }
    }

    private Set<TopicPartition> requestTopicPartitions(OffsetsForLeaderEpochRequest request) {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
        request.data().topics().forEach(topicData -> topicData.partitions().forEach(partitionData -> {
            TopicPartition topicPartition = new TopicPartition(topicData.topic(), partitionData.partition());
            topicPartitions.add(topicPartition);
        }));
        return topicPartitions;
    }

    private Set<TopicPartition> responseTopicPartitions(OffsetsForLeaderEpochResponse response) {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
        response.data().topics().forEach(topicData -> topicData.partitions().forEach(partitionData -> {
            TopicPartition topicPartition = new TopicPartition(topicData.topic(), partitionData.partition());
            topicPartitions.add(topicPartition);
        }));
        return topicPartitions;
    }

    @Test
    public void testOffsetForLeaderEpochRequest() {
        for (short ver = ApiKeys.OFFSET_FOR_LEADER_EPOCH.oldestVersion(); ver <= ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.OFFSET_FOR_LEADER_EPOCH, ver, false);
            TopicPartition partition = new TopicPartition("foo", 0);
            OffsetsForLeaderEpochRequest inbound = OffsetsForLeaderEpochRequest.Builder.forFollower((short)ver, (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(Collections.singletonList(new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(partition.topic()).setPartitions(Collections.singletonList(new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(partition.partition()).setLeaderEpoch(0).setCurrentLeaderEpoch(0)))).iterator()), (int)1).build(ver);
            OffsetsForLeaderEpochRequest request = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("tenant_foo", 0)}), this.requestTopicPartitions(request));
            Assert.assertFalse((boolean)context.shouldIntercept());
            this.verifyRequestMetrics(ApiKeys.OFFSET_FOR_LEADER_EPOCH);
            OffsetsForLeaderEpochRequest clientIntercepted = (OffsetsForLeaderEpochRequest)this.clusterLinkClient.intercept((AbstractRequest)request, context.header);
            Assert.assertEquals(this.requestTopicPartitions(inbound), this.requestTopicPartitions(clientIntercepted));
        }
    }

    @Test
    public void testOffsetForLeaderEpochResponse() {
        for (short ver = ApiKeys.OFFSET_FOR_LEADER_EPOCH.oldestVersion(); ver <= ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.OFFSET_FOR_LEADER_EPOCH, ver, false);
            OffsetForLeaderEpochResponseData outboundData = new OffsetForLeaderEpochResponseData();
            outboundData.topics().add((ImplicitLinkedHashCollection.Element)new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic("tenant_foo").setPartitions(Collections.singletonList(new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(0).setEndOffset(37L).setLeaderEpoch(5))));
            OffsetsForLeaderEpochResponse outbound = new OffsetsForLeaderEpochResponse(outboundData);
            OffsetsForLeaderEpochResponse intercepted = (OffsetsForLeaderEpochResponse)this.parseResponse(ApiKeys.OFFSET_FOR_LEADER_EPOCH, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((long)1L, (long)intercepted.data().topics().size());
            OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult interceptedTopicResponse = intercepted.data().topics().find("foo");
            Assert.assertEquals((long)1L, (long)interceptedTopicResponse.partitions().size());
            Assert.assertEquals((long)0L, (long)((OffsetForLeaderEpochResponseData.EpochEndOffset)interceptedTopicResponse.partitions().get(0)).partition());
            Assert.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)((OffsetForLeaderEpochResponseData.EpochEndOffset)interceptedTopicResponse.partitions().get(0)).errorCode()));
            this.verifyResponseMetrics(ApiKeys.OFFSET_FOR_LEADER_EPOCH, Errors.NONE);
            OffsetsForLeaderEpochResponse clientIntercepted = (OffsetsForLeaderEpochResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Assert.assertEquals(this.responseTopicPartitions(outbound), this.responseTopicPartitions(clientIntercepted));
            OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult clientInterceptedTopicResponse = clientIntercepted.data().topics().find("tenant_foo");
            Assert.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)((OffsetForLeaderEpochResponseData.EpochEndOffset)clientInterceptedTopicResponse.partitions().get(0)).errorCode()));
        }
    }

    @Test
    public void testWriteTxnMarkersNotAllowed() {
        for (short ver = ApiKeys.WRITE_TXN_MARKERS.oldestVersion(); ver <= ApiKeys.WRITE_TXN_MARKERS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.WRITE_TXN_MARKERS, ver, false);
            TopicPartition partition = new TopicPartition("foo", 0);
            WriteTxnMarkersRequest inbound = new WriteTxnMarkersRequest.Builder(ver, Collections.singletonList(new WriteTxnMarkersRequest.TxnMarkerEntry(233L, 5, 37, TransactionResult.ABORT, Collections.singletonList(partition)))).build(ver);
            WriteTxnMarkersRequest request = this.parseRequest(context, inbound);
            Assert.assertEquals((long)1L, (long)request.markers().size());
            Assert.assertEquals(Collections.singletonList(new TopicPartition("tenant_foo", 0)), (Object)((WriteTxnMarkersRequest.TxnMarkerEntry)request.markers().get(0)).partitions());
            Assert.assertTrue((boolean)context.shouldIntercept());
            WriteTxnMarkersResponse response = (WriteTxnMarkersResponse)context.intercept((AbstractRequest)request, 0);
            WriteTxnMarkersResponse outbound = (WriteTxnMarkersResponse)this.parseResponse(ApiKeys.WRITE_TXN_MARKERS, ver, context.buildResponseSend((AbstractResponse)response));
            Assert.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)outbound.errorCounts());
            this.verifyRequestAndResponseMetrics(ApiKeys.WRITE_TXN_MARKERS, Errors.CLUSTER_AUTHORIZATION_FAILED);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)request, context.header);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)response, context.header);
        }
    }

    @Test
    public void testCreateAclsRequest() {
        for (short ver = ApiKeys.CREATE_ACLS.oldestVersion(); ver <= ApiKeys.CREATE_ACLS.latestVersion(); ver = (short)(ver + 1)) {
            short version = ver;
            AclTestParams.aclTestParams(ver).forEach(params -> {
                try {
                    this.verifyCreateAclsRequest((AclTestParams)params, version);
                }
                catch (Throwable e) {
                    throw new RuntimeException("CreateAclsRequest test failed with " + params, e);
                }
            });
            AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.DELEGATION_TOKEN, "123", PatternType.LITERAL), new AccessControlEntry("User:1", "*", AclOperation.WRITE, AclPermissionType.ALLOW));
            this.verifyInvalidCreateAclsRequest(acl, version);
            List<String> invalidPrincipals = Arrays.asList("", "userWithoutPrincipalType");
            invalidPrincipals.forEach(principal -> {
                AclBinding invalidAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic1", PatternType.LITERAL), new AccessControlEntry(principal, "*", AclOperation.WRITE, AclPermissionType.ALLOW));
                this.verifyInvalidCreateAclsRequest(invalidAcl, version);
            });
        }
    }

    private void verifyCreateAclsRequest(AclTestParams params, short version) {
        MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_ACLS, version, false);
        List aclCreations = AclTestParams.RESOURCE_TYPES.stream().map(resourceType -> new CreateAclsRequestData.AclCreation().setHost("*").setOperation(AclOperation.CREATE.code()).setPermissionType(AclPermissionType.ALLOW.code()).setPrincipal(params.principal()).setResourceName(params.resourceName(resourceType)).setResourceType(resourceType.code()).setResourcePatternType(params.patternType.code())).collect(Collectors.toList());
        CreateAclsRequest inbound = new CreateAclsRequest.Builder(new CreateAclsRequestData().setCreations(aclCreations)).build(version);
        CreateAclsRequest request = this.parseRequest(context, inbound);
        Assert.assertEquals((long)aclCreations.size(), (long)request.aclCreations().size());
        request.aclCreations().forEach(creation -> {
            Assert.assertEquals((Object)params.tenantPrincipal(), (Object)creation.principal());
            ResourceType resourceType = ResourceType.fromCode((byte)creation.resourceType());
            Assert.assertEquals((long)params.tenantPatternType(resourceType).code(), (long)creation.resourcePatternType());
            Assert.assertEquals((Object)params.tenantResourceName(resourceType), (Object)creation.resourceName());
        });
        Assert.assertEquals(AclTestParams.RESOURCE_TYPES, request.aclCreations().stream().map(c -> ResourceType.fromCode((byte)c.resourceType())).collect(Collectors.toList()));
        Assert.assertFalse((boolean)context.shouldIntercept());
        this.verifyRequestMetrics(ApiKeys.CREATE_ACLS);
        this.clusterLinkClient.verifyNotAllowed((AbstractRequest)request, context.header);
    }

    private void verifyInvalidCreateAclsRequest(AclBinding acl, short version) {
        CreateAclsRequestData.AclCreation aclCreation = CreateAclsRequest.aclCreation((AclBinding)acl);
        CreateAclsRequest inbound = new CreateAclsRequest.Builder(new CreateAclsRequestData().setCreations(Collections.singletonList(aclCreation))).build(version);
        MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_ACLS, version, false);
        this.parseRequest(context, inbound);
        Assert.assertTrue((boolean)context.shouldIntercept());
        Assert.assertEquals(Collections.singleton(Errors.INVALID_REQUEST), context.intercept((AbstractRequest)inbound, 0).errorCounts().keySet());
        this.clusterLinkClient.verifyNotAllowed((AbstractRequest)inbound, context.header);
    }

    @Test
    public void testCreateAclsResponse() {
        for (short ver = ApiKeys.CREATE_ACLS.oldestVersion(); ver <= ApiKeys.CREATE_ACLS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_ACLS, ver, false);
            List<CreateAclsResponseData.AclCreationResult> aclCreationResults = Collections.singletonList(new CreateAclsResponseData.AclCreationResult().setErrorCode(ApiError.NONE.error().code()));
            CreateAclsResponse outbound = new CreateAclsResponse(new CreateAclsResponseData().setResults(aclCreationResults).setThrottleTimeMs(23));
            CreateAclsResponse intercepted = (CreateAclsResponse)this.parseResponse(ApiKeys.CREATE_ACLS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((long)ApiError.NONE.error().code(), (long)((CreateAclsResponseData.AclCreationResult)intercepted.results().get(0)).errorCode());
            this.verifyResponseMetrics(ApiKeys.CREATE_ACLS, Errors.NONE);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testDeleteAclsRequest() throws Exception {
        for (short ver = ApiKeys.DELETE_ACLS.oldestVersion(); ver <= ApiKeys.DELETE_ACLS.latestVersion(); ver = (short)(ver + 1)) {
            short version = ver;
            AclTestParams.filterTestParams(ver).forEach(params -> {
                try {
                    this.verifyDeleteAclsRequest((AclTestParams)params, version);
                }
                catch (Throwable e) {
                    throw new RuntimeException("DeleteAclsRequest test failed with " + params, e);
                }
            });
        }
    }

    private void verifyDeleteAclsRequest(AclTestParams params, short version) {
        MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_ACLS, version, false);
        AccessControlEntryFilter ace = new AccessControlEntryFilter(params.principal(), "*", AclOperation.CREATE, AclPermissionType.ALLOW);
        List aclBindingFilters = AclTestParams.RESOURCE_TYPES.stream().map(resourceType -> new AclBindingFilter(new ResourcePatternFilter(resourceType, params.resourceName(resourceType), params.patternType), ace)).collect(Collectors.toList());
        DeleteAclsRequestData reqData = new DeleteAclsRequestData().setFilters(aclBindingFilters.stream().map(DeleteAclsRequest::deleteAclsFilter).collect(Collectors.toList()));
        DeleteAclsRequest inbound = new DeleteAclsRequest.Builder(reqData).build(version);
        DeleteAclsRequest request = this.parseRequest(context, inbound);
        Assert.assertEquals((long)aclBindingFilters.size(), (long)request.filters().size());
        request.filters().forEach(acl -> {
            Assert.assertEquals((Object)params.tenantPrincipal(), (Object)acl.entryFilter().principal());
            ResourcePatternFilter pattern = acl.patternFilter();
            Assert.assertEquals((Object)params.tenantPatternType(pattern.resourceType()), (Object)pattern.patternType());
            Assert.assertEquals((Object)params.tenantResourceName(pattern.resourceType()), (Object)pattern.name());
        });
        Assert.assertEquals(AclTestParams.RESOURCE_TYPES, request.filters().stream().map(acl -> acl.patternFilter().resourceType()).collect(Collectors.toList()));
        this.clusterLinkClient.verifyNotAllowed((AbstractRequest)request, context.header);
    }

    @Test
    public void testDeleteAclsResponse() {
        for (short ver = 1; ver <= ApiKeys.DELETE_ACLS.latestVersion(); ver = (short)(ver + 1)) {
            short version = ver;
            AclTestParams.aclTestParams(ver).forEach(params -> {
                try {
                    this.verifyDeleteAclsResponse((AclTestParams)params, version);
                }
                catch (Throwable e) {
                    throw new RuntimeException("DeleteAclsResponse test failed with " + params, e);
                }
            });
        }
    }

    private void verifyDeleteAclsResponse(AclTestParams params, short version) {
        MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_ACLS, version, false);
        List<DeleteAclsResponseData.DeleteAclsMatchingAcl> deletionMatchingAcls0 = Arrays.asList(new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(ApiError.NONE.error().code()).setHost("*").setPermissionType(AclPermissionType.DENY.code()).setPrincipal(params.tenantPrincipal()).setOperation(AclOperation.ALTER.code()).setPatternType(params.tenantPatternType(ResourceType.TOPIC).code()).setResourceName(params.tenantResourceName(ResourceType.TOPIC)).setResourceType(ResourceType.TOPIC.code()), new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(ApiError.NONE.error().code()).setHost("*").setPermissionType(AclPermissionType.DENY.code()).setPrincipal(params.tenantPrincipal()).setOperation(AclOperation.ALTER.code()).setPatternType(params.tenantPatternType(ResourceType.GROUP).code()).setResourceName(params.tenantResourceName(ResourceType.GROUP)).setResourceType(ResourceType.GROUP.code()));
        List<DeleteAclsResponseData.DeleteAclsMatchingAcl> deletionMatchingAcls1 = Arrays.asList(new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(ApiError.NONE.error().code()).setHost("*").setPermissionType(AclPermissionType.DENY.code()).setPrincipal(params.tenantPrincipal()).setOperation(AclOperation.ALTER.code()).setPatternType(params.tenantPatternType(ResourceType.TRANSACTIONAL_ID).code()).setResourceName(params.tenantResourceName(ResourceType.TRANSACTIONAL_ID)).setResourceType(ResourceType.TRANSACTIONAL_ID.code()), new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(ApiError.NONE.error().code()).setHost("*").setPermissionType(AclPermissionType.DENY.code()).setPrincipal(params.tenantPrincipal()).setOperation(AclOperation.ALTER.code()).setPatternType(params.tenantPatternType(ResourceType.CLUSTER).code()).setResourceName(params.tenantResourceName(ResourceType.CLUSTER)).setResourceType(ResourceType.CLUSTER.code()));
        List<DeleteAclsResponseData.DeleteAclsFilterResult> aclFilterResults = Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(ApiError.NONE.error().code()).setMatchingAcls(deletionMatchingAcls0), new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(ApiError.NONE.error().code()).setMatchingAcls(deletionMatchingAcls1));
        DeleteAclsResponse outbound = new DeleteAclsResponse(new DeleteAclsResponseData().setFilterResults(aclFilterResults), version);
        DeleteAclsResponse intercepted = (DeleteAclsResponse)this.parseResponse(ApiKeys.DELETE_ACLS, version, context.buildResponseSend((AbstractResponse)outbound));
        List interceptedFilterResults = intercepted.filterResults();
        Assert.assertEquals((long)aclFilterResults.size(), (long)interceptedFilterResults.size());
        interceptedFilterResults.forEach(filterResult -> {
            Assert.assertEquals((long)ApiError.NONE.error().code(), (long)filterResult.errorCode());
            filterResult.matchingAcls().forEach(matchingAcl -> {
                Assert.assertEquals((Object)params.principal(), (Object)matchingAcl.principal());
                Assert.assertEquals((long)params.patternType.code(), (long)matchingAcl.patternType());
                Assert.assertEquals((Object)params.resourceName(ResourceType.fromCode((byte)matchingAcl.resourceType())), (Object)matchingAcl.resourceName());
            });
        });
        Iterator it = ((DeleteAclsResponseData.DeleteAclsFilterResult)interceptedFilterResults.get(0)).matchingAcls().iterator();
        Assert.assertEquals((long)ResourceType.TOPIC.code(), (long)((DeleteAclsResponseData.DeleteAclsMatchingAcl)it.next()).resourceType());
        Assert.assertEquals((long)ResourceType.GROUP.code(), (long)((DeleteAclsResponseData.DeleteAclsMatchingAcl)it.next()).resourceType());
        Assert.assertFalse((boolean)it.hasNext());
        it = ((DeleteAclsResponseData.DeleteAclsFilterResult)interceptedFilterResults.get(1)).matchingAcls().iterator();
        Assert.assertEquals((long)ResourceType.TRANSACTIONAL_ID.code(), (long)((DeleteAclsResponseData.DeleteAclsMatchingAcl)it.next()).resourceType());
        Assert.assertEquals((long)ResourceType.CLUSTER.code(), (long)((DeleteAclsResponseData.DeleteAclsMatchingAcl)it.next()).resourceType());
        Assert.assertFalse((boolean)it.hasNext());
        this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
    }

    @Test
    public void testDescribeAclsRequest() {
        for (short ver = ApiKeys.DESCRIBE_ACLS.oldestVersion(); ver <= ApiKeys.DESCRIBE_ACLS.latestVersion(); ver = (short)(ver + 1)) {
            short version = ver;
            AclTestParams.filterTestParams(ver).forEach(params -> AclTestParams.RESOURCE_TYPES.forEach(resourceType -> {
                try {
                    this.verifyDescribeAclsRequest((ResourceType)resourceType, (AclTestParams)params, version);
                }
                catch (Throwable e) {
                    throw new RuntimeException("DescribeAclsRequest test failed with " + params, e);
                }
            }));
        }
    }

    private void verifyDescribeAclsRequest(ResourceType resourceType, AclTestParams params, short version) throws Exception {
        MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_ACLS, version, false);
        DescribeAclsRequest inbound = new DescribeAclsRequest.Builder(new AclBindingFilter(new ResourcePatternFilter(resourceType, params.resourceName(resourceType), params.patternType), new AccessControlEntryFilter(params.principal(), "*", AclOperation.CREATE, AclPermissionType.ALLOW))).build(version);
        DescribeAclsRequest request = this.parseRequest(context, inbound);
        Assert.assertEquals((Object)resourceType, (Object)request.filter().patternFilter().resourceType());
        Assert.assertEquals((Object)params.tenantPrincipal(), (Object)request.filter().entryFilter().principal());
        Assert.assertEquals((Object)params.tenantResourceName(resourceType), (Object)request.filter().patternFilter().name());
        DescribeAclsRequest clientIntercepted = (DescribeAclsRequest)this.clusterLinkClient.intercept((AbstractRequest)inbound, context.header);
        Assert.assertEquals((Object)inbound.data(), (Object)clientIntercepted.data());
    }

    @Test
    public void testDescribeAclsResponse() {
        for (short ver = ApiKeys.DESCRIBE_ACLS.oldestVersion(); ver <= ApiKeys.DESCRIBE_ACLS.latestVersion(); ver = (short)(ver + 1)) {
            short version = ver;
            AclTestParams.aclTestParams(ver).forEach(params -> {
                try {
                    this.verifyDescribeAclsResponse((AclTestParams)params, version);
                }
                catch (Throwable e) {
                    throw new RuntimeException("DescribeAclsResponse test failed with " + params, e);
                }
            });
        }
    }

    private void verifyDescribeAclsResponse(AclTestParams params, short version) {
        MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_ACLS, version, false);
        DescribeAclsResponse outbound = new DescribeAclsResponse(new DescribeAclsResponseData().setThrottleTimeMs(12).setErrorCode(ApiError.NONE.error().code()).setErrorMessage(ApiError.NONE.message()).setResources(AclTestParams.RESOURCE_TYPES.stream().map(resourceType -> new DescribeAclsResponseData.DescribeAclsResource().setResourceType(resourceType.code()).setResourceName(params.tenantResourceName((ResourceType)resourceType)).setPatternType(params.tenantPatternType((ResourceType)resourceType).code()).setAcls(Collections.singletonList(new DescribeAclsResponseData.AclDescription().setHost("*").setOperation(AclOperation.CREATE.code()).setPermissionType(AclPermissionType.ALLOW.code()).setPrincipal(params.tenantPrincipal())))).collect(Collectors.toList())));
        DescribeAclsResponse intercepted = (DescribeAclsResponse)this.parseResponse(ApiKeys.DESCRIBE_ACLS, version, context.buildResponseSend((AbstractResponse)outbound));
        Assert.assertEquals((long)4L, (long)intercepted.acls().size());
        intercepted.acls().forEach(acl -> {
            ResourcePattern pattern = new ResourcePattern(ResourceType.fromCode((byte)acl.resourceType()), acl.resourceName(), PatternType.fromCode((byte)acl.patternType()));
            Assert.assertEquals((Object)params.resourceName(pattern.resourceType()), (Object)pattern.name());
            Assert.assertEquals((Object)params.patternType, (Object)pattern.patternType());
            acl.acls().forEach(aclDescription -> Assert.assertEquals((Object)params.principal(), (Object)aclDescription.principal()));
        });
        this.verifyResponseMetrics(ApiKeys.DESCRIBE_ACLS, Errors.NONE);
        if (version >= 1 || params.patternType == PatternType.LITERAL && !params.wildcard) {
            DescribeAclsResponse clientIntercepted = (DescribeAclsResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Assert.assertEquals((Object)outbound.acls(), (Object)clientIntercepted.acls());
        } else {
            Assert.assertThrows(UnsupportedVersionException.class, () -> {
                DescribeAclsResponse cfr_ignored_0 = (DescribeAclsResponse)this.clusterLinkClient.intercept((AbstractResponse)outbound, context.header);
            });
        }
    }

    @Test
    public void testAddPartitionsToTxnRequest() {
        for (short ver = ApiKeys.ADD_PARTITIONS_TO_TXN.oldestVersion(); ver <= ApiKeys.ADD_PARTITIONS_TO_TXN.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.ADD_PARTITIONS_TO_TXN, ver, false);
            AddPartitionsToTxnRequest inbound = new AddPartitionsToTxnRequest.Builder("tr", 23L, 15, Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 0))).build(ver);
            AddPartitionsToTxnRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("tenant_foo", 0), new TopicPartition("tenant_bar", 0)}), new HashSet(intercepted.partitions()));
            Assert.assertEquals((Object)"tenant_tr", (Object)intercepted.data().transactionalId());
            this.verifyRequestMetrics(ApiKeys.ADD_PARTITIONS_TO_TXN);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testAddPartitionsToTxnResponse() {
        for (short ver = ApiKeys.ADD_PARTITIONS_TO_TXN.oldestVersion(); ver <= ApiKeys.ADD_PARTITIONS_TO_TXN.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.ADD_PARTITIONS_TO_TXN, ver, false);
            HashMap<TopicPartition, Errors> partitionErrors = new HashMap<TopicPartition, Errors>();
            partitionErrors.put(new TopicPartition("tenant_foo", 0), Errors.NONE);
            partitionErrors.put(new TopicPartition("tenant_bar", 0), Errors.NONE);
            AddPartitionsToTxnResponse outbound = new AddPartitionsToTxnResponse(0, partitionErrors);
            AddPartitionsToTxnResponse intercepted = (AddPartitionsToTxnResponse)this.parseResponse(ApiKeys.ADD_PARTITIONS_TO_TXN, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0)}), intercepted.errors().keySet());
            this.verifyResponseMetrics(ApiKeys.ADD_PARTITIONS_TO_TXN, Errors.NONE);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testAddOffsetsToTxnRequest() {
        for (short ver = ApiKeys.ADD_OFFSETS_TO_TXN.oldestVersion(); ver <= ApiKeys.ADD_OFFSETS_TO_TXN.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.ADD_OFFSETS_TO_TXN, ver, false);
            AddOffsetsToTxnRequestData data = new AddOffsetsToTxnRequestData().setTransactionalId("tr").setProducerId(23L).setProducerEpoch((short)15).setGroupId("group");
            AddOffsetsToTxnRequest inbound = new AddOffsetsToTxnRequest.Builder(data).build(ver);
            AddOffsetsToTxnRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_tr", (Object)intercepted.data().transactionalId());
            Assert.assertEquals((Object)"tenant_group", (Object)intercepted.data().groupId());
            this.verifyRequestMetrics(ApiKeys.ADD_OFFSETS_TO_TXN);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testEndTxnRequest() {
        for (short ver = ApiKeys.END_TXN.oldestVersion(); ver <= ApiKeys.END_TXN.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.END_TXN, ver, false);
            EndTxnRequest inbound = new EndTxnRequest.Builder(new EndTxnRequestData().setTransactionalId("tr").setProducerId(23L).setProducerEpoch((short)15).setCommitted(true)).build(ver);
            EndTxnRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_tr", (Object)intercepted.data().transactionalId());
            this.verifyRequestMetrics(ApiKeys.END_TXN);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testTxnOffsetCommitRequest() {
        for (short ver = ApiKeys.TXN_OFFSET_COMMIT.oldestVersion(); ver <= ApiKeys.TXN_OFFSET_COMMIT.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.TXN_OFFSET_COMMIT, ver, false);
            HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> offsets = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
            offsets.put(new TopicPartition("foo", 0), new TxnOffsetCommitRequest.CommittedOffset(0L, "", Optional.of(-1)));
            offsets.put(new TopicPartition("bar", 0), new TxnOffsetCommitRequest.CommittedOffset(0L, "", Optional.of(-1)));
            TxnOffsetCommitRequest inbound = new TxnOffsetCommitRequest.Builder("tr", "group", 23L, 15, offsets, false).build(ver);
            TxnOffsetCommitRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_tr", (Object)intercepted.data().transactionalId());
            Assert.assertEquals((Object)"tenant_group", (Object)intercepted.data().groupId());
            Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("tenant_foo", 0), new TopicPartition("tenant_bar", 0)}), intercepted.offsets().keySet());
            this.verifyRequestMetrics(ApiKeys.TXN_OFFSET_COMMIT);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testTxnOffsetCommitResponse() {
        for (short ver = ApiKeys.TXN_OFFSET_COMMIT.oldestVersion(); ver <= ApiKeys.TXN_OFFSET_COMMIT.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.TXN_OFFSET_COMMIT, ver, false);
            HashMap<TopicPartition, Errors> partitionErrors = new HashMap<TopicPartition, Errors>();
            partitionErrors.put(new TopicPartition("tenant_foo", 0), Errors.NONE);
            partitionErrors.put(new TopicPartition("tenant_bar", 0), Errors.NONE);
            TxnOffsetCommitResponse outbound = new TxnOffsetCommitResponse(0, partitionErrors);
            TxnOffsetCommitResponse intercepted = (TxnOffsetCommitResponse)this.parseResponse(ApiKeys.TXN_OFFSET_COMMIT, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0)}), intercepted.errors().keySet());
            this.verifyResponseMetrics(ApiKeys.TXN_OFFSET_COMMIT, Errors.NONE);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testDeleteRecordsRequest() {
        for (short ver = ApiKeys.DELETE_RECORDS.oldestVersion(); ver <= ApiKeys.DELETE_RECORDS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_RECORDS, ver, false);
            DeleteRecordsRequestData.DeleteRecordsTopic foo = new DeleteRecordsRequestData.DeleteRecordsTopic().setName("foo").setPartitions(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsPartition().setPartitionIndex(0).setOffset(0L)));
            DeleteRecordsRequestData.DeleteRecordsTopic bar = new DeleteRecordsRequestData.DeleteRecordsTopic().setName("bar").setPartitions(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsPartition().setPartitionIndex(0).setOffset(0L)));
            DeleteRecordsRequestData requestData = new DeleteRecordsRequestData().setTimeoutMs(30000).setTopics(Arrays.asList(foo, bar));
            DeleteRecordsRequest inbound = new DeleteRecordsRequest.Builder(requestData).build(ver);
            DeleteRecordsRequest intercepted = this.parseRequest(context, inbound);
            Set interceptedPartitions = intercepted.data().topics().stream().flatMap(topic -> topic.partitions().stream().map(p -> new TopicPartition(topic.name(), p.partitionIndex()))).collect(Collectors.toSet());
            Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("tenant_foo", 0), new TopicPartition("tenant_bar", 0)}), interceptedPartitions);
            this.verifyRequestMetrics(ApiKeys.DELETE_RECORDS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testDeleteRecordsResponse() {
        for (short ver = ApiKeys.DELETE_RECORDS.oldestVersion(); ver <= ApiKeys.DELETE_RECORDS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_RECORDS, ver, false);
            DeleteRecordsResponseData.DeleteRecordsTopicResultCollection topics = new DeleteRecordsResponseData.DeleteRecordsTopicResultCollection();
            for (String topic2 : Arrays.asList("tenant_foo", "tenant_bar")) {
                DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection partitions = new DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection();
                partitions.add((ImplicitLinkedHashCollection.Element)new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(0).setErrorCode(Errors.NONE.code()));
                topics.add((ImplicitLinkedHashCollection.Element)new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(topic2).setPartitions(partitions));
            }
            DeleteRecordsResponseData responseData = new DeleteRecordsResponseData().setThrottleTimeMs(0).setTopics(topics);
            DeleteRecordsResponse outbound = new DeleteRecordsResponse(responseData);
            DeleteRecordsResponse intercepted = (DeleteRecordsResponse)this.parseResponse(ApiKeys.DELETE_RECORDS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Set interceptedPartitions = intercepted.data().topics().stream().flatMap(topic -> topic.partitions().stream().map(p -> new TopicPartition(topic.name(), p.partitionIndex()))).collect(Collectors.toSet());
            Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0)}), interceptedPartitions);
            this.verifyResponseMetrics(ApiKeys.DELETE_RECORDS, Errors.NONE);
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testCreatePartitionsRequestRespectsMaxNumPartitions() throws Exception {
        this.testCluster.setPartitionLeaders("tenant_foo", 0, 200, 1);
        this.testCluster.setPartitionLeaders("tenant_bar", 0, 200, 1);
        this.partitionAssignor.updateClusterMetadata(this.testCluster.cluster());
        for (short ver = ApiKeys.CREATE_PARTITIONS.oldestVersion(); ver <= ApiKeys.CREATE_PARTITIONS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_PARTITIONS, ver, false);
            ArrayList<CreatePartitionsRequestData.CreatePartitionsTopic> requestTopics = new ArrayList<CreatePartitionsRequestData.CreatePartitionsTopic>();
            requestTopics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setCount(800));
            requestTopics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setCount(800));
            CreatePartitionsRequest inbound = new CreatePartitionsRequest.Builder(new CreatePartitionsRequestData().setTopics(new CreatePartitionsRequestData.CreatePartitionsTopicCollection(requestTopics.iterator())).setTimeoutMs(30000).setValidateOnly(false)).build(ver);
            this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)context.shouldIntercept());
            Assert.assertEquals(InvalidRequestException.class, context.tenantApiException().getClass());
            Assert.assertEquals((Object)String.format("You may not create more than %d new partitions in a single request.", 1000), (Object)context.tenantApiException().getMessage());
        }
    }

    @Test
    public void testCreatePartitionsRequest() throws Exception {
        this.testCluster.setPartitionLeaders("tenant_foo", 0, 2, 1);
        this.testCluster.setPartitionLeaders("tenant_bar", 0, 2, 1);
        this.partitionAssignor.updateClusterMetadata(this.testCluster.cluster());
        for (short ver = ApiKeys.CREATE_PARTITIONS.oldestVersion(); ver <= ApiKeys.CREATE_PARTITIONS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_PARTITIONS, ver, false);
            ArrayList<CreatePartitionsRequestData.CreatePartitionsTopic> requestTopics = new ArrayList<CreatePartitionsRequestData.CreatePartitionsTopic>();
            requestTopics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setCount(4));
            List<CreatePartitionsRequestData.CreatePartitionsAssignment> unbalancedAssignment = Arrays.asList(new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Collections.singletonList(1)), new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Collections.singletonList(1)));
            requestTopics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setCount(4).setAssignments(unbalancedAssignment));
            requestTopics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("invalid").setCount(4));
            CreatePartitionsRequest inbound = new CreatePartitionsRequest.Builder(new CreatePartitionsRequestData().setTopics(new CreatePartitionsRequestData.CreatePartitionsTopicCollection(requestTopics.iterator())).setTimeoutMs(30000).setValidateOnly(false)).build(ver);
            CreatePartitionsRequest request = this.parseRequest(context, inbound);
            Map<String, List> assignments = request.data().topics().stream().collect(Collectors.toMap(CreatePartitionsRequestData.CreatePartitionsTopic::name, CreatePartitionsRequestData.CreatePartitionsTopic::assignments));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"tenant_foo", "tenant_bar", "tenant_invalid"}), assignments.keySet());
            Assert.assertEquals((long)2L, (long)assignments.get("tenant_foo").size());
            Assert.assertEquals((long)2L, (long)assignments.get("tenant_bar").size());
            Assert.assertNotEquals(unbalancedAssignment, (Object)assignments.get("tenant_bar"));
            Assert.assertTrue((boolean)assignments.get("tenant_invalid").isEmpty());
            this.verifyRequestMetrics(ApiKeys.CREATE_PARTITIONS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)request, context.header);
        }
    }

    @Test
    public void testCreatePartitionsRequestWithoutPartitionAssignor() throws Exception {
        this.partitionAssignor = null;
        for (short ver = ApiKeys.CREATE_PARTITIONS.oldestVersion(); ver <= ApiKeys.CREATE_PARTITIONS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_PARTITIONS, ver, false);
            ArrayList<CreatePartitionsRequestData.CreatePartitionsTopic> requestTopics = new ArrayList<CreatePartitionsRequestData.CreatePartitionsTopic>();
            requestTopics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setCount(4));
            List<CreatePartitionsRequestData.CreatePartitionsAssignment> unbalancedAssignment = Arrays.asList(new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Collections.singletonList(1)), new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Collections.singletonList(1)));
            requestTopics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setCount(4).setAssignments(unbalancedAssignment));
            requestTopics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("invalid").setCount(4));
            CreatePartitionsRequest inbound = new CreatePartitionsRequest.Builder(new CreatePartitionsRequestData().setTopics(new CreatePartitionsRequestData.CreatePartitionsTopicCollection(requestTopics.iterator())).setTimeoutMs(30000).setValidateOnly(false)).build(ver);
            CreatePartitionsRequest request = this.parseRequest(context, inbound);
            Map<String, List> assignments = request.data().topics().stream().collect(Collectors.toMap(CreatePartitionsRequestData.CreatePartitionsTopic::name, CreatePartitionsRequestData.CreatePartitionsTopic::assignments));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"tenant_foo", "tenant_bar", "tenant_invalid"}), assignments.keySet());
            Assert.assertTrue((boolean)assignments.get("tenant_foo").isEmpty());
            Assert.assertEquals((long)2L, (long)assignments.get("tenant_bar").size());
            Assert.assertEquals(unbalancedAssignment, (Object)assignments.get("tenant_bar"));
            Assert.assertTrue((boolean)assignments.get("tenant_invalid").isEmpty());
            this.verifyRequestMetrics(ApiKeys.CREATE_PARTITIONS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)request, context.header);
        }
    }

    @Test
    public void testCreatePartitionsPolicyFailure() throws Exception {
        for (short ver = ApiKeys.CREATE_PARTITIONS.oldestVersion(); ver <= ApiKeys.CREATE_PARTITIONS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_PARTITIONS, ver, false);
            CreatePartitionsResponseData responseData = new CreatePartitionsResponseData().setResults(Arrays.asList(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("tenant_foo").setErrorCode(Errors.POLICY_VIOLATION.code()).setErrorMessage("Topic tenant_foo is not permitted"), new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("tenant_bar").setErrorCode(Errors.NONE.code())));
            CreatePartitionsResponse outbound = new CreatePartitionsResponse(responseData);
            CreatePartitionsResponse intercepted = (CreatePartitionsResponse)this.parseResponse(ApiKeys.CREATE_PARTITIONS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Map results = intercepted.data().results().stream().collect(Collectors.toMap(CreatePartitionsResponseData.CreatePartitionsTopicResult::name, Function.identity()));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo", "bar"}), results.keySet());
            Assert.assertEquals((long)Errors.NONE.code(), (long)((CreatePartitionsResponseData.CreatePartitionsTopicResult)results.get("bar")).errorCode());
            Assert.assertEquals((long)Errors.POLICY_VIOLATION.code(), (long)((CreatePartitionsResponseData.CreatePartitionsTopicResult)results.get("foo")).errorCode());
            String errorMessage = ((CreatePartitionsResponseData.CreatePartitionsTopicResult)results.get("foo")).errorMessage();
            Assert.assertTrue((errorMessage != null ? 1 : 0) != 0);
            Assert.assertFalse((boolean)errorMessage.contains("tenant_"));
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testDescribeConfigsRequest() {
        for (short ver = ApiKeys.DESCRIBE_CONFIGS.oldestVersion(); ver <= ApiKeys.DESCRIBE_CONFIGS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_CONFIGS, ver, false);
            ArrayList<DescribeConfigsRequestData.DescribeConfigsResource> resources = new ArrayList<DescribeConfigsRequestData.DescribeConfigsResource>(5);
            resources.add(new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("foo").setConfigurationKeys(Collections.emptyList()));
            DescribeConfigsRequestData.DescribeConfigsResource blahResource = new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("blah").setConfigurationKeys(Collections.emptyList());
            resources.add(blahResource);
            DescribeConfigsRequestData.DescribeConfigsResource clusterResource = new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setConfigurationKeys(Collections.singletonList("ssl.cipher.suites"));
            resources.add(clusterResource);
            resources.add(new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("bar").setConfigurationKeys(Collections.emptyList()));
            resources.add(new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setResourceName("baz").setConfigurationKeys(Collections.emptyList()));
            DescribeConfigsRequestData requestData = new DescribeConfigsRequestData().setResources(resources);
            DescribeConfigsRequest inbound = new DescribeConfigsRequest.Builder(requestData).build(ver);
            DescribeConfigsRequest intercepted = this.parseRequest(context, inbound);
            DescribeConfigsRequestData.DescribeConfigsResource fooResource = new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("tenant_foo").setConfigurationKeys(Collections.emptyList());
            DescribeConfigsRequestData.DescribeConfigsResource barResource = new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("tenant_bar").setConfigurationKeys(Collections.emptyList());
            DescribeConfigsRequestData.DescribeConfigsResource bazResource = new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setResourceName("tenant_baz").setConfigurationKeys(Collections.emptyList());
            List<String> sslCipherSuitesConfigWithExternalListenerPrefix = Collections.singletonList(this.sslCipherSuitesConfigWithExternalListenerPrefix());
            DescribeConfigsRequestData.DescribeConfigsResource expectedClusterResource = clusterResource.duplicate().setConfigurationKeys(sslCipherSuitesConfigWithExternalListenerPrefix);
            Assert.assertEquals((Object)Utils.mkSet((Object[])new DescribeConfigsRequestData.DescribeConfigsResource[]{fooResource, blahResource, expectedClusterResource, barResource, bazResource}), new HashSet(intercepted.data().resources()));
            Assert.assertEquals(sslCipherSuitesConfigWithExternalListenerPrefix, intercepted.data().resources().stream().filter(resource -> resource.resourceName().isEmpty()).flatMap(resource -> resource.configurationKeys().stream()).collect(Collectors.toList()));
            this.verifyRequestMetrics(ApiKeys.DESCRIBE_CONFIGS);
            DescribeConfigsRequest clientIntercepted = (DescribeConfigsRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals(inbound.data().resources().stream().map(resource -> resource.resourceName().isEmpty() ? expectedClusterResource : resource).collect(Collectors.toList()), (Object)clientIntercepted.data().resources());
        }
    }

    @Test
    public void testDescribeConfigsResponse() {
        DescribeConfigsResponse.ConfigSource brokerSource = DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG;
        DescribeConfigsResponse.ConfigSource topicSource = DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG;
        DescribeConfigsResponse.ConfigSource clusterLinkSource = DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG;
        List emptySynonyms = Collections.emptyList();
        List<DescribeConfigsResponseData.DescribeConfigsResourceResult> brokerConfigEntries = Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(KafkaConfig.MessageMaxBytesProp()).setValue("10000").setConfigSource(brokerSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(KafkaConfig.NumNetworkThreadsProp()).setValue("5").setConfigSource(brokerSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(KafkaConfig.BrokerInterceptorClassProp()).setValue("bar").setConfigSource(brokerSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(KafkaConfig.AppendRecordInterceptorClassesProp()).setValue("foo,bar").setConfigSource(brokerSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(KafkaConfig.PreferTierFetchMsProp()).setValue("true").setConfigSource(brokerSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(this.sslCipherSuitesConfigWithExternalListenerPrefix()).setValue("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256").setConfigSource(brokerSource.id()).setSynonyms(emptySynonyms));
        List<DescribeConfigsResponseData.DescribeConfigsResourceResult> topicConfigEntries = Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("retention.bytes").setValue("10000000").setConfigSource(topicSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("min.insync.replicas").setValue("2").setConfigSource(topicSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("min.cleanable.dirty.ratio").setValue("0.5").setConfigSource(topicSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("confluent.tier.enable").setValue("true").setConfigSource(topicSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("confluent.key.schema.validation").setValue("true").setConfigSource(topicSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("confluent.key.subject.name.strategy").setValue("io.confluent.kafka.serializers.subject.TopicNameStrategy").setConfigSource(topicSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("confluent.prefer.tier.fetch.ms").setValue("true").setConfigSource(topicSource.id()).setSynonyms(emptySynonyms));
        List<DescribeConfigsResponseData.DescribeConfigsResourceResult> clusterLinkConfigEntries = Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("bootstrap.servers").setValue("remote:9091").setConfigSource(clusterLinkSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("metadata.max.age.ms").setValue("300000").setConfigSource(clusterLinkSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(ClusterLinkConfig.AclSyncEnableProp()).setValue("true").setConfigSource(clusterLinkSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(ClusterLinkConfig.AclSyncMsProp()).setValue("10000").setConfigSource(clusterLinkSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(KafkaConfig.ReplicaFetchBackoffMsProp()).setValue("1000").setConfigSource(clusterLinkSource.id()).setSynonyms(emptySynonyms), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("ssl.provider").setValue("value").setConfigSource(clusterLinkSource.id()).setSynonyms(emptySynonyms));
        DescribeConfigsResponseData.DescribeConfigsResult blahConfig = new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName("blah").setResourceType(ConfigResource.Type.BROKER.id()).setErrorMessage("").setConfigs(brokerConfigEntries);
        for (short ver = ApiKeys.DESCRIBE_CONFIGS.oldestVersion(); ver <= ApiKeys.DESCRIBE_CONFIGS.latestVersion(); ver = (short)(ver + 1)) {
            this.isSchemaValidationEnabled = true;
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_CONFIGS, ver, false);
            DescribeConfigsResponseData outboundData = new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setResourceName("tenant_foo").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(topicConfigEntries), blahConfig, new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to describe 'tenant_bar'").setResourceName("tenant_bar").setResourceType(ConfigResource.Type.TOPIC.id()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName("tenant_baz").setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setConfigs(clusterLinkConfigEntries)));
            DescribeConfigsResponse outbound = new DescribeConfigsResponse(outboundData);
            DescribeConfigsResponse intercepted = (DescribeConfigsResponse)this.parseResponse(ApiKeys.DESCRIBE_CONFIGS, ver, context.buildResponseSend((AbstractResponse)outbound));
            DescribeConfigsResponseData interceptedData = intercepted.data();
            Assert.assertEquals((Object)Utils.mkSet((Object[])new ConfigResource[]{new ConfigResource(ConfigResource.Type.TOPIC, "foo"), new ConfigResource(ConfigResource.Type.BROKER, "blah"), new ConfigResource(ConfigResource.Type.TOPIC, "bar"), new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "baz")}), intercepted.data().results().stream().map(resource -> new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName())).collect(Collectors.toSet()));
            List interceptedFooTopicConfigs = interceptedData.results().stream().filter(dsr -> dsr.resourceType() == ConfigResource.Type.TOPIC.id() && dsr.resourceName().equals("foo")).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)interceptedFooTopicConfigs.size());
            DescribeConfigsResponseData.DescribeConfigsResult fooConfigResult = (DescribeConfigsResponseData.DescribeConfigsResult)interceptedFooTopicConfigs.get(0);
            Map<String, Boolean> interceptedFooConfigReadOnlyMap = fooConfigResult.configs().stream().collect(Collectors.toMap(DescribeConfigsResponseData.DescribeConfigsResourceResult::name, DescribeConfigsResponseData.DescribeConfigsResourceResult::readOnly));
            Assert.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"retention.bytes", (Object)Boolean.FALSE), Utils.mkEntry((Object)"min.insync.replicas", (Object)Boolean.FALSE), Utils.mkEntry((Object)"min.cleanable.dirty.ratio", (Object)Boolean.TRUE), Utils.mkEntry((Object)"confluent.key.schema.validation", (Object)Boolean.FALSE), Utils.mkEntry((Object)"confluent.key.subject.name.strategy", (Object)Boolean.FALSE)}), interceptedFooConfigReadOnlyMap);
            List interceptedBarTopicConfigs = interceptedData.results().stream().filter(dsr -> dsr.resourceType() == ConfigResource.Type.TOPIC.id() && dsr.resourceName().equals("bar")).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)interceptedBarTopicConfigs.size());
            DescribeConfigsResponseData.DescribeConfigsResult barConfigResult = (DescribeConfigsResponseData.DescribeConfigsResult)interceptedBarTopicConfigs.get(0);
            Assert.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)Errors.forCode((short)barConfigResult.errorCode()));
            Assert.assertEquals((Object)"Failed to describe 'bar'", (Object)barConfigResult.errorMessage());
            Assert.assertTrue((String)("Bar configs are not empty " + interceptedBarTopicConfigs), (boolean)barConfigResult.configs().isEmpty());
            Collection interceptedBrokerConfigs = interceptedData.results().stream().filter(dsr -> dsr.resourceType() == ConfigResource.Type.BROKER.id() && dsr.resourceName().equals("blah")).collect(Collectors.toSet());
            Set interceptedEntries = interceptedBrokerConfigs.stream().flatMap(dcr -> dcr.configs().stream()).map(DescribeConfigsResponseData.DescribeConfigsResourceResult::name).collect(Collectors.toSet());
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"message.max.bytes", "ssl.cipher.suites"}), interceptedEntries);
            this.verifyResponseMetrics(ApiKeys.DESCRIBE_CONFIGS, Utils.mkSet((Object[])new Errors[]{Errors.NONE, Errors.UNKNOWN_SERVER_ERROR}));
            Collection interceptedBazClusterLinkConfigs = interceptedData.results().stream().filter(dsr -> dsr.resourceType() == ConfigResource.Type.CLUSTER_LINK.id() && dsr.resourceName().equals("baz")).collect(Collectors.toSet());
            Map<String, Boolean> clusterLinkReadOnlyMap = interceptedBazClusterLinkConfigs.stream().flatMap(dcr -> dcr.configs().stream()).collect(Collectors.toMap(DescribeConfigsResponseData.DescribeConfigsResourceResult::name, DescribeConfigsResponseData.DescribeConfigsResourceResult::readOnly));
            Assert.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bootstrap.servers", (Object)Boolean.FALSE), Utils.mkEntry((Object)"metadata.max.age.ms", (Object)Boolean.TRUE), Utils.mkEntry((Object)ClusterLinkConfig.AclSyncEnableProp(), (Object)Boolean.FALSE), Utils.mkEntry((Object)ClusterLinkConfig.AclSyncMsProp(), (Object)Boolean.FALSE), Utils.mkEntry((Object)KafkaConfig.ReplicaFetchBackoffMsProp(), (Object)Boolean.TRUE)}), clusterLinkReadOnlyMap);
            DescribeConfigsResponse clientIntercepted = (DescribeConfigsResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Set clusterLinkClientEntries = clientIntercepted.data().results().stream().map(resource -> new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName())).collect(Collectors.toSet());
            Set outboundEntries = outboundData.results().stream().map(resource -> new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName())).collect(Collectors.toSet());
            Assert.assertEquals(outboundEntries, clusterLinkClientEntries);
        }
    }

    private String sslCipherSuitesConfigWithExternalListenerPrefix() {
        return MultiTenantConfigRestrictions.EXTERNAL_LISTENER_PREFIX + KafkaConfig.SslCipherSuitesProp();
    }

    @Test
    public void testAlterConfigsRequestWithSchemaValidationEnabled() {
        this.isSchemaValidationEnabled = true;
        this.testAlterConfigsRequest();
    }

    @Test
    public void testAlterConfigsRequest() {
        for (short ver = ApiKeys.ALTER_CONFIGS.oldestVersion(); ver <= ApiKeys.ALTER_CONFIGS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.ALTER_CONFIGS, ver, false);
            HashMap<ConfigResource, AlterConfigsRequest.Config> resourceConfigs = new HashMap<ConfigResource, AlterConfigsRequest.Config>();
            HashSet configEntries = new HashSet();
            this.testConfigs().forEach(c -> configEntries.add(new AlterConfigsRequest.ConfigEntry(c.name(), c.value())));
            AlterConfigsRequest.ConfigEntry sslCipherSuitesConfig = new AlterConfigsRequest.ConfigEntry("ssl.cipher.suites", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
            resourceConfigs.put(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), new AlterConfigsRequest.Config(configEntries));
            resourceConfigs.put(new ConfigResource(ConfigResource.Type.BROKER, "blah"), new AlterConfigsRequest.Config(Collections.emptyList()));
            resourceConfigs.put(new ConfigResource(ConfigResource.Type.BROKER, ""), new AlterConfigsRequest.Config(Arrays.asList(sslCipherSuitesConfig)));
            resourceConfigs.put(new ConfigResource(ConfigResource.Type.TOPIC, "bar"), new AlterConfigsRequest.Config(Collections.emptyList()));
            AlterConfigsRequest inbound = new AlterConfigsRequest.Builder(resourceConfigs, false).build(ver);
            AlterConfigsRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)Utils.mkSet((Object[])new ConfigResource[]{new ConfigResource(ConfigResource.Type.TOPIC, "tenant_foo"), new ConfigResource(ConfigResource.Type.BROKER, "blah"), new ConfigResource(ConfigResource.Type.BROKER, ""), new ConfigResource(ConfigResource.Type.TOPIC, "tenant_bar")}), intercepted.configs().keySet());
            HashMap expectedTenantFooTopicConfigs = new HashMap();
            this.transformedTestConfigs().forEach(c -> expectedTenantFooTopicConfigs.put(c.name(), c.value()));
            HashMap actualTenantFooTopicConfigs = new HashMap();
            ((AlterConfigsRequest.Config)intercepted.configs().get(new ConfigResource(ConfigResource.Type.TOPIC, "tenant_foo"))).entries().forEach(c -> actualTenantFooTopicConfigs.put(c.name(), c.value()));
            Assert.assertEquals(expectedTenantFooTopicConfigs, actualTenantFooTopicConfigs);
            AlterConfigsRequest.Config clusterConfig = (AlterConfigsRequest.Config)intercepted.configs().get(new ConfigResource(ConfigResource.Type.BROKER, ""));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.sslCipherSuitesConfigWithExternalListenerPrefix()}), clusterConfig.entries().stream().map(e -> e.name()).collect(Collectors.toSet()));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{sslCipherSuitesConfig.value()}), clusterConfig.entries().stream().map(e -> e.value()).collect(Collectors.toSet()));
            this.verifyRequestMetrics(ApiKeys.ALTER_CONFIGS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testAlterConfigsResponse() {
        for (short ver = ApiKeys.ALTER_CONFIGS.oldestVersion(); ver <= ApiKeys.ALTER_CONFIGS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.ALTER_CONFIGS, ver, false);
            ArrayList<AlterConfigsResponseData.AlterConfigsResourceResponse> resourceErrors = new ArrayList<AlterConfigsResponseData.AlterConfigsResourceResponse>();
            resourceErrors.add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.NONE.code()).setErrorMessage("").setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("tenant_foo"));
            resourceErrors.add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.NONE.code()).setErrorMessage("").setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("blah"));
            resourceErrors.add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.NONE.code()).setErrorMessage(AlterConfigPolicy.ClusterPolicyConfig.invalidCipherSuiteMessage((Collection)AlterConfigPolicy.ClusterPolicyConfig.DEFAULT_SSL_CIPHER_SUITES_ALLOWED, (String)"TLS_ABC_RSA_WITH_AES_128_GCM_SHA256")).setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(""));
            resourceErrors.add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.NONE.code()).setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("tenant_bar"));
            resourceErrors.add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to alter config of 'tenant_baz'").setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("tenant_baz"));
            AlterConfigsResponseData outboundData = new AlterConfigsResponseData();
            outboundData.setResponses(resourceErrors);
            AlterConfigsResponse outbound = new AlterConfigsResponse(outboundData);
            AlterConfigsResponse intercepted = (AlterConfigsResponse)this.parseResponse(ApiKeys.ALTER_CONFIGS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new ConfigResource[]{new ConfigResource(ConfigResource.Type.TOPIC, "foo"), new ConfigResource(ConfigResource.Type.BROKER, "blah"), new ConfigResource(ConfigResource.Type.BROKER, ""), new ConfigResource(ConfigResource.Type.TOPIC, "bar"), new ConfigResource(ConfigResource.Type.TOPIC, "baz")}), intercepted.errors().keySet());
            Assert.assertEquals((Object)"", (Object)((ApiError)intercepted.errors().get(new ConfigResource(ConfigResource.Type.BROKER, "blah"))).message());
            String clusterConfigErrorMessage = ((ApiError)intercepted.errors().get(new ConfigResource(ConfigResource.Type.BROKER, ""))).message();
            Assert.assertFalse((String)("Unexpected cluster config error message: " + clusterConfigErrorMessage), (boolean)clusterConfigErrorMessage.contains(this.sslCipherSuitesConfigWithExternalListenerPrefix()));
            Assert.assertTrue((String)("Unexpected cluster config error message: " + clusterConfigErrorMessage), (boolean)clusterConfigErrorMessage.contains("ssl.cipher.suites"));
            ApiError topicError = (ApiError)intercepted.errors().get(new ConfigResource(ConfigResource.Type.TOPIC, "baz"));
            Assert.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)topicError.error());
            Assert.assertEquals((Object)"Failed to alter config of 'baz'", (Object)topicError.message());
            this.verifyResponseMetrics(ApiKeys.ALTER_CONFIGS, Utils.mkSet((Object[])new Errors[]{Errors.NONE, Errors.UNKNOWN_SERVER_ERROR}));
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testRequestResponseMetrics() {
        int minSleepTimeMs = 1;
        int maxSleepTimeMs = 3;
        for (int i = 0; i < 2; ++i) {
            short ver = ApiKeys.FETCH.latestVersion();
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.FETCH, ver, false);
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitions = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            partitions.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, -1L, 1, Optional.empty()));
            FetchRequest inbound = FetchRequest.Builder.forConsumer((int)0, (int)0, partitions).build(ver);
            FetchRequest intercepted = this.parseRequest(context, inbound);
            AbstractResponse outbound = intercepted.getErrorResponse((Throwable)new NotLeaderOrFollowerException());
            this.time.sleep(i == 0 ? (long)minSleepTimeMs : (long)maxSleepTimeMs);
            this.parseResponse(ApiKeys.FETCH, ver, context.buildResponseSend(outbound));
        }
        Map<String, KafkaMetric> metrics = this.verifyRequestAndResponseMetrics(ApiKeys.FETCH, Errors.NOT_LEADER_OR_FOLLOWER);
        Assert.assertEquals((double)minSleepTimeMs, (double)((Double)metrics.get("response-time-ns-min").metricValue() / 1000000.0), (double)0.001);
        Assert.assertEquals((double)maxSleepTimeMs, (double)((Double)metrics.get("response-time-ns-max").metricValue() / 1000000.0), (double)0.001);
        Set<Sensor> sensors = this.verifySensors(ApiKeys.FETCH, Errors.NOT_LEADER_OR_FOLLOWER, new String[0]);
        this.time.sleep(ApiSensorBuilder.EXPIRY_SECONDS * 1000L + 1L);
        for (Sensor sensor : sensors) {
            Assert.assertTrue((String)"Sensor should have expired", (boolean)sensor.hasExpired());
        }
    }

    @Test
    public void testAlterIsrNotAllowed() {
        for (short ver = ApiKeys.ALTER_ISR.oldestVersion(); ver <= ApiKeys.ALTER_ISR.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.ALTER_ISR, ver, false);
            AlterIsrRequestData.PartitionData inboundPartitionData = new AlterIsrRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(5).setNewIsr(Arrays.asList(1, 2, 3));
            AlterIsrRequestData.TopicData inboundTopicData = new AlterIsrRequestData.TopicData().setName("foo");
            inboundTopicData.partitions().add(inboundPartitionData);
            AlterIsrRequestData inboundData = new AlterIsrRequestData();
            inboundData.topics().add(inboundTopicData);
            AlterIsrRequest inbound = new AlterIsrRequest(inboundData, ver);
            this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)context.shouldIntercept());
            AlterIsrResponse response = (AlterIsrResponse)context.intercept((AbstractRequest)inbound, 0);
            AlterIsrResponse outbound = (AlterIsrResponse)this.parseResponse(ApiKeys.ALTER_ISR, ver, context.buildResponseSend((AbstractResponse)response));
            Assert.assertEquals((long)0L, (long)outbound.data().topics().size());
            Assert.assertEquals((long)Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (long)outbound.data().errorCode());
        }
    }

    @Test
    public void testUpdateFeaturesNotAllowed() {
        for (short ver = ApiKeys.UPDATE_FEATURES.oldestVersion(); ver <= ApiKeys.UPDATE_FEATURES.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.UPDATE_FEATURES, ver, false);
            UpdateFeaturesRequestData inboundData = new UpdateFeaturesRequestData();
            inboundData.featureUpdates().add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("foo").setMaxVersionLevel((short)1));
            UpdateFeaturesRequest inbound = new UpdateFeaturesRequest(inboundData, ver);
            this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)context.shouldIntercept());
            UpdateFeaturesResponse response = (UpdateFeaturesResponse)context.intercept((AbstractRequest)inbound, 0);
            UpdateFeaturesResponse outbound = (UpdateFeaturesResponse)this.parseResponse(ApiKeys.UPDATE_FEATURES, ver, context.buildResponseSend((AbstractResponse)response));
            Assert.assertEquals((long)Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (long)outbound.data().errorCode());
            Assert.assertEquals((long)0L, (long)outbound.data().results().size());
        }
    }

    @Test
    public void testIncrementalAlterConfigsRequestWithSchemaValidationEnabled() {
        this.isSchemaValidationEnabled = true;
        this.testIncrementalAlterConfigsRequest();
    }

    @Test
    public void testIncrementalAlterConfigsRequest() {
        for (short ver = ApiKeys.INCREMENTAL_ALTER_CONFIGS.oldestVersion(); ver <= ApiKeys.INCREMENTAL_ALTER_CONFIGS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.INCREMENTAL_ALTER_CONFIGS, ver, false);
            IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection resourceConfigs = new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection();
            IncrementalAlterConfigsRequestData.AlterableConfigCollection configEntries = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
            this.testConfigs().forEach(c -> configEntries.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(c.name()).setValue(c.value()).setConfigOperation((byte)0)));
            HashMap<String, String> updatableClusterLinkConfigs = new HashMap<String, String>();
            updatableClusterLinkConfigs.put("bootstrap.servers", "remote:9091");
            updatableClusterLinkConfigs.put(ClusterLinkConfig.AclSyncEnableProp(), "true");
            updatableClusterLinkConfigs.put(ClusterLinkConfig.AclSyncMsProp(), "10000");
            HashMap<String, String> clusterLinkConfigs = new HashMap<String, String>();
            clusterLinkConfigs.putAll(updatableClusterLinkConfigs);
            clusterLinkConfigs.put("metadata.max.age.ms", "300000");
            clusterLinkConfigs.put("ssl.provider", "value");
            clusterLinkConfigs.put(KafkaConfig.ReplicaFetchBackoffMsProp(), "1000");
            IncrementalAlterConfigsRequestData.AlterableConfigCollection clusterLinkConfigEntries = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
            clusterLinkConfigs.forEach((k, v) -> clusterLinkConfigEntries.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(k).setValue(v).setConfigOperation((byte)0)));
            IncrementalAlterConfigsRequestData.AlterableConfigCollection sslCipherSuites = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
            sslCipherSuites.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName("ssl.cipher.suites").setValue("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"));
            resourceConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("foo").setConfigs(configEntries));
            resourceConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("blah").setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection()));
            resourceConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setConfigs(sslCipherSuites));
            resourceConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("bar").setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection()));
            resourceConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setResourceName("baz").setConfigs(clusterLinkConfigEntries));
            IncrementalAlterConfigsRequest inbound = new IncrementalAlterConfigsRequest.Builder(new IncrementalAlterConfigsRequestData().setResources(resourceConfigs).setValidateOnly(false)).build(ver);
            IncrementalAlterConfigsRequest actual = this.parseRequest(context, inbound);
            IncrementalAlterConfigsRequestData.AlterableConfigCollection expectedConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
            this.transformedTestConfigs().forEach(c -> expectedConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(c.name()).setValue(c.value()).setConfigOperation((byte)0)));
            IncrementalAlterConfigsRequestData.AlterableConfigCollection expectedClusterLinkConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
            updatableClusterLinkConfigs.forEach((k, v) -> expectedClusterLinkConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(k).setValue(v).setConfigOperation((byte)0)));
            IncrementalAlterConfigsRequestData.AlterableConfigCollection sslCipherSuitesWithExternalListenerPrefix = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
            sslCipherSuitesWithExternalListenerPrefix.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.sslCipherSuitesConfigWithExternalListenerPrefix()).setValue("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"));
            IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection expectedResources = new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection();
            expectedResources.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("tenant_foo").setConfigs(expectedConfigs));
            expectedResources.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("blah").setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection()));
            expectedResources.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setConfigs(sslCipherSuitesWithExternalListenerPrefix));
            expectedResources.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("tenant_bar").setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection()));
            expectedResources.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setResourceName("tenant_baz").setConfigs(expectedClusterLinkConfigs));
            IncrementalAlterConfigsRequest expected = new IncrementalAlterConfigsRequest.Builder(new IncrementalAlterConfigsRequestData().setResources(expectedResources).setValidateOnly(false)).build(ver);
            Assert.assertEquals((Object)expected.data().resources().valuesSet(), (Object)actual.data().resources().valuesSet());
            Assert.assertEquals(new HashSet(expected.data().resources().find(ConfigResource.Type.TOPIC.id(), "tenant_foo").configs()), new HashSet(actual.data().resources().find(ConfigResource.Type.TOPIC.id(), "tenant_foo").configs()));
            Assert.assertEquals(new HashSet(expected.data().resources().find(ConfigResource.Type.BROKER.id(), "").configs()), new HashSet(actual.data().resources().find(ConfigResource.Type.BROKER.id(), "").configs()));
            Assert.assertEquals(new HashSet(expected.data().resources().find(ConfigResource.Type.CLUSTER_LINK.id(), "tenant_baz").configs()), new HashSet(actual.data().resources().find(ConfigResource.Type.CLUSTER_LINK.id(), "tenant_baz").configs()));
            this.verifyRequestMetrics(ApiKeys.INCREMENTAL_ALTER_CONFIGS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)actual, context.header);
        }
    }

    @Test
    public void testIncrementalAlterConfigsResponse() {
        for (short ver = ApiKeys.INCREMENTAL_ALTER_CONFIGS.oldestVersion(); ver <= ApiKeys.INCREMENTAL_ALTER_CONFIGS.latestVersion(); ver = (short)(ver + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.INCREMENTAL_ALTER_CONFIGS, ver, false);
            ArrayList<IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse> responses = new ArrayList<IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse>();
            responses.add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("tenant_foo").setErrorCode(Errors.NONE.code()).setErrorMessage(""));
            responses.add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("blah").setErrorCode(Errors.NONE.code()).setErrorMessage(""));
            responses.add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setErrorCode(Errors.NONE.code()).setErrorMessage(AlterConfigPolicy.ClusterPolicyConfig.invalidCipherSuiteMessage((Collection)AlterConfigPolicy.ClusterPolicyConfig.DEFAULT_SSL_CIPHER_SUITES_ALLOWED, (String)"TLS_ABC_RSA_WITH_AES_128_GCM_SHA256")));
            responses.add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("tenant_bar").setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to alter 'tenant_bar'"));
            responses.add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setResourceName("tenant_baz").setErrorCode(Errors.NONE.code()));
            IncrementalAlterConfigsResponse outbound = new IncrementalAlterConfigsResponse(new IncrementalAlterConfigsResponseData().setResponses(responses));
            IncrementalAlterConfigsResponse intercepted = (IncrementalAlterConfigsResponse)this.parseResponse(ApiKeys.INCREMENTAL_ALTER_CONFIGS, ver, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo", "blah", "bar", "baz", ""}), intercepted.data().responses().stream().map(IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse::resourceName).collect(Collectors.toSet()));
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{""}), intercepted.data().responses().stream().filter(r -> r.resourceType() == ConfigResource.Type.BROKER.id() && r.resourceName().equals("blah")).map(r -> r.errorMessage()).collect(Collectors.toSet()));
            String clusterConfigErrorMessage = intercepted.data().responses().stream().filter(r -> r.resourceType() == ConfigResource.Type.BROKER.id() && r.resourceName().equals("")).map(r -> r.errorMessage()).findFirst().get();
            Assert.assertFalse((String)("Unexpected cluster config error message: " + clusterConfigErrorMessage), (boolean)clusterConfigErrorMessage.contains(this.sslCipherSuitesConfigWithExternalListenerPrefix()));
            Assert.assertTrue((String)("Unexpected cluster config error message: " + clusterConfigErrorMessage), (boolean)clusterConfigErrorMessage.contains("ssl.cipher.suites"));
            Assert.assertEquals(Optional.of("Failed to alter 'bar'"), intercepted.data().responses().stream().filter(r -> r.resourceType() == ConfigResource.Type.TOPIC.id() && r.resourceName().equals("bar")).map(r -> r.errorMessage()).findFirst());
            this.verifyResponseMetrics(ApiKeys.INCREMENTAL_ALTER_CONFIGS, Utils.mkSet((Object[])new Errors[]{Errors.NONE, Errors.UNKNOWN_SERVER_ERROR}));
            this.clusterLinkClient.verifyNotAllowed((AbstractResponse)intercepted, context.header);
        }
    }

    @Test
    public void testListClusterLinksRequest() {
        for (short version = ApiKeys.LIST_CLUSTER_LINKS.oldestVersion(); version <= ApiKeys.LIST_CLUSTER_LINKS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LIST_CLUSTER_LINKS, version, false);
            ListClusterLinksRequest inbound = new ListClusterLinksRequest(new ListClusterLinksRequestData().setIncludeTopics(true).setLinkNames(Arrays.asList("foo", "bar")), version);
            ListClusterLinksRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)intercepted.linkNames().isPresent());
            Assert.assertEquals(Arrays.asList("tenant_foo", "tenant_bar"), intercepted.linkNames().get());
            Assert.assertTrue((boolean)intercepted.includeTopics());
            this.verifyRequestMetrics(ApiKeys.LIST_CLUSTER_LINKS);
            ListClusterLinksRequest clientIntercepted = (ListClusterLinksRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals((Object)inbound.data(), (Object)clientIntercepted.data());
        }
    }

    @Test
    public void testListClusterLinksResponse() {
        for (short version = ApiKeys.LIST_CLUSTER_LINKS.oldestVersion(); version <= ApiKeys.LIST_CLUSTER_LINKS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LIST_CLUSTER_LINKS, version, false);
            ArrayList<ListClusterLinksResponseData.EntryData> linkEntries = new ArrayList<ListClusterLinksResponseData.EntryData>();
            linkEntries.add(new ListClusterLinksResponseData.EntryData().setLinkName("tenant_link1").setTopics(Arrays.asList("tenant_foo", "tenant_bar")).setRemoteClusterId("source_cluster1"));
            linkEntries.add(new ListClusterLinksResponseData.EntryData().setLinkName("othertenant_link").setTopics(Arrays.asList("othertenant_foo", "othertenant_bar")).setRemoteClusterId("source_cluster2"));
            linkEntries.add(new ListClusterLinksResponseData.EntryData().setLinkName("tenant_link2").setTopics(Collections.singletonList("tenant_baz")));
            if (version >= 1) {
                linkEntries.forEach(e -> e.setLocalClusterId("dest_cluster"));
            }
            ListClusterLinksResponse outbound = new ListClusterLinksResponse(new ListClusterLinksResponseData().setEntries(linkEntries));
            ListClusterLinksResponse intercepted = (ListClusterLinksResponse)this.parseResponse(ApiKeys.LIST_CLUSTER_LINKS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals(Arrays.asList("link1", "link2"), intercepted.data().entries().stream().map(ListClusterLinksResponseData.EntryData::linkName).collect(Collectors.toList()));
            Assert.assertEquals(Arrays.asList("source_cluster1", ""), intercepted.data().entries().stream().map(ListClusterLinksResponseData.EntryData::remoteClusterId).collect(Collectors.toList()));
            if (version >= 1) {
                Assert.assertEquals(Arrays.asList(TENANT_CLUSTER_ID, TENANT_CLUSTER_ID), intercepted.data().entries().stream().map(ListClusterLinksResponseData.EntryData::localClusterId).collect(Collectors.toList()));
            }
            ListClusterLinksResponseData.EntryData link1Data = (ListClusterLinksResponseData.EntryData)intercepted.data().entries().get(0);
            Assert.assertEquals(Arrays.asList("foo", "bar"), (Object)link1Data.topics());
            ListClusterLinksResponseData.EntryData link2Data = (ListClusterLinksResponseData.EntryData)intercepted.data().entries().get(1);
            Assert.assertEquals(Collections.singletonList("baz"), (Object)link2Data.topics());
            this.verifyResponseMetrics(ApiKeys.LIST_CLUSTER_LINKS, Errors.NONE);
            ListClusterLinksResponse clientIntercepted = (ListClusterLinksResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Assert.assertEquals(Arrays.asList("tenant_link1", "tenant_link2"), clientIntercepted.data().entries().stream().map(ListClusterLinksResponseData.EntryData::linkName).collect(Collectors.toList()));
            Assert.assertEquals(Arrays.asList("source_cluster1", ""), clientIntercepted.data().entries().stream().map(ListClusterLinksResponseData.EntryData::remoteClusterId).collect(Collectors.toList()));
            if (version < 1) continue;
            Assert.assertEquals(Arrays.asList(TENANT_CLUSTER_ID, TENANT_CLUSTER_ID), clientIntercepted.data().entries().stream().map(ListClusterLinksResponseData.EntryData::localClusterId).collect(Collectors.toList()));
        }
    }

    @Test
    public void testListClusterLinksErrorMessage() {
        for (short version = ApiKeys.LIST_CLUSTER_LINKS.oldestVersion(); version <= ApiKeys.LIST_CLUSTER_LINKS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LIST_CLUSTER_LINKS, version, false);
            ListClusterLinksResponse outbound = new ListClusterLinksResponse(new ListClusterLinksResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Error accessing 'tenant_foo' and 'tenant_bar'"));
            ListClusterLinksResponse intercepted = (ListClusterLinksResponse)this.parseResponse(ApiKeys.LIST_CLUSTER_LINKS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((long)Errors.UNKNOWN_SERVER_ERROR.code(), (long)intercepted.data().errorCode());
            Assert.assertEquals((Object)"Error accessing 'foo' and 'bar'", (Object)intercepted.data().errorMessage());
        }
    }

    @Test
    public void testCreateClusterLinksRequest() {
        for (short version = ApiKeys.CREATE_CLUSTER_LINKS.oldestVersion(); version <= ApiKeys.CREATE_CLUSTER_LINKS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_CLUSTER_LINKS, version, false);
            ArrayList<NewClusterLink> newLinks = new ArrayList<NewClusterLink>(4);
            newLinks.add(new NewClusterLink("link-empty-configs", "cid-0", Collections.emptyMap()));
            newLinks.add(new NewClusterLink("link-valid-config", "cid-1", Collections.singletonMap("bootstrap.servers", "value-0")));
            newLinks.add(new NewClusterLink("link-read-only-config", "cid-2", Collections.singletonMap("metadata.max.age.ms", "value-1")));
            newLinks.add(new NewClusterLink("link-invisible-config", "cid-3", Collections.singletonMap("ssl.provider", "value-2")));
            newLinks.add(new NewClusterLink("link-unknown-config", "cid-4", Collections.singletonMap("unknown-config", "value-3")));
            newLinks.add(new NewClusterLink("link-empty-config", "cid-5", Collections.singletonMap("", "value-4")));
            newLinks.add(new NewClusterLink("link-mixture-configs", "cid-6", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bootstrap.servers", (Object)"value-5"), Utils.mkEntry((Object)ClusterLinkConfig.NumClusterLinkFetchersProp(), (Object)"value-6"), Utils.mkEntry((Object)"bad-config", (Object)"value-7"), Utils.mkEntry((Object)ClusterLinkConfig.AclSyncEnableProp(), (Object)"value-8")})));
            CreateClusterLinksRequest inbound = new CreateClusterLinksRequest.Builder(newLinks, true, true, 10000).build(version);
            CreateClusterLinksRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertTrue((boolean)intercepted.validateOnly());
            Assert.assertTrue((boolean)intercepted.validateLink());
            Assert.assertEquals((long)10000L, (long)intercepted.timeoutMs());
            HashMap<String, NewClusterLink> transformed = new HashMap<String, NewClusterLink>(newLinks.size());
            for (NewClusterLink link : intercepted.newClusterLinks()) {
                transformed.put(link.linkName(), link);
            }
            HashSet<String> expectedLinkNames = new HashSet<String>(newLinks.size());
            for (NewClusterLink link : newLinks) {
                expectedLinkNames.add("tenant_" + link.linkName());
            }
            Assert.assertEquals(expectedLinkNames, transformed.keySet());
            Assert.assertEquals((Object)this.expectedNewClusterLink(context, (NewClusterLink)newLinks.get(0), ((NewClusterLink)newLinks.get(0)).configs()), transformed.get("tenant_link-empty-configs"));
            Assert.assertEquals((Object)this.expectedNewClusterLink(context, (NewClusterLink)newLinks.get(1), ((NewClusterLink)newLinks.get(1)).configs()), transformed.get("tenant_link-valid-config"));
            Assert.assertEquals((Object)this.expectedNewClusterLink(context, (NewClusterLink)newLinks.get(2), Collections.emptyMap()), transformed.get("tenant_link-read-only-config"));
            Assert.assertEquals((Object)this.expectedNewClusterLink(context, (NewClusterLink)newLinks.get(3), Collections.emptyMap()), transformed.get("tenant_link-invisible-config"));
            Assert.assertEquals((Object)this.expectedNewClusterLink(context, (NewClusterLink)newLinks.get(4), Collections.emptyMap()), transformed.get("tenant_link-unknown-config"));
            Assert.assertEquals((Object)this.expectedNewClusterLink(context, (NewClusterLink)newLinks.get(5), Collections.emptyMap()), transformed.get("tenant_link-empty-config"));
            Assert.assertEquals((Object)this.expectedNewClusterLink(context, (NewClusterLink)newLinks.get(6), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bootstrap.servers", (Object)"value-5"), Utils.mkEntry((Object)ClusterLinkConfig.AclSyncEnableProp(), (Object)"value-8")})), transformed.get("tenant_link-mixture-configs"));
            this.verifyRequestMetrics(ApiKeys.CREATE_CLUSTER_LINKS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testCreateClusterLinksResponse() {
        for (short version = ApiKeys.CREATE_CLUSTER_LINKS.oldestVersion(); version <= ApiKeys.CREATE_CLUSTER_LINKS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.CREATE_CLUSTER_LINKS, version, false);
            ArrayList<CreateClusterLinksResponseData.EntryData> entries = new ArrayList<CreateClusterLinksResponseData.EntryData>();
            entries.add(new CreateClusterLinksResponseData.EntryData().setErrorCode(Errors.NONE.code()).setLinkName("tenant_link1"));
            entries.add(new CreateClusterLinksResponseData.EntryData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to create 'tenant_link2'").setLinkName("tenant_link2"));
            CreateClusterLinksResponse outbound = new CreateClusterLinksResponse(new CreateClusterLinksResponseData().setEntries(entries));
            CreateClusterLinksResponse intercepted = (CreateClusterLinksResponse)this.parseResponse(ApiKeys.CREATE_CLUSTER_LINKS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals(Arrays.asList("link1", "link2"), intercepted.data().entries().stream().map(CreateClusterLinksResponseData.EntryData::linkName).collect(Collectors.toList()));
            Assert.assertEquals((Object)"Failed to create 'link2'", (Object)((CreateClusterLinksResponseData.EntryData)intercepted.data().entries().get(1)).errorMessage());
            this.verifyResponseMetrics(ApiKeys.CREATE_CLUSTER_LINKS, Utils.mkSet((Object[])new Errors[]{Errors.NONE, Errors.UNKNOWN_SERVER_ERROR}));
        }
    }

    @Test
    public void testDeleteClusterLinksRequest() {
        for (short version = ApiKeys.DELETE_CLUSTER_LINKS.oldestVersion(); version <= ApiKeys.DELETE_CLUSTER_LINKS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_CLUSTER_LINKS, version, false);
            DeleteClusterLinksRequest inbound = new DeleteClusterLinksRequest(new DeleteClusterLinksRequestData().setLinkNames(Arrays.asList("foo", "bar")), version);
            DeleteClusterLinksRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals(Arrays.asList("tenant_foo", "tenant_bar"), (Object)intercepted.data().linkNames());
            this.verifyRequestMetrics(ApiKeys.DELETE_CLUSTER_LINKS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testDeleteClusterLinksResponse() {
        for (short version = ApiKeys.DELETE_CLUSTER_LINKS.oldestVersion(); version <= ApiKeys.DELETE_CLUSTER_LINKS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DELETE_CLUSTER_LINKS, version, false);
            ArrayList<DeleteClusterLinksResponseData.EntryData> entries = new ArrayList<DeleteClusterLinksResponseData.EntryData>();
            entries.add(new DeleteClusterLinksResponseData.EntryData().setErrorCode(Errors.NONE.code()).setLinkName("tenant_link1"));
            entries.add(new DeleteClusterLinksResponseData.EntryData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to delete 'tenant_link2'").setLinkName("tenant_link2"));
            DeleteClusterLinksResponse outbound = new DeleteClusterLinksResponse(new DeleteClusterLinksResponseData().setEntries(entries));
            DeleteClusterLinksResponse intercepted = (DeleteClusterLinksResponse)this.parseResponse(ApiKeys.DELETE_CLUSTER_LINKS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals(Arrays.asList("link1", "link2"), intercepted.data().entries().stream().map(DeleteClusterLinksResponseData.EntryData::linkName).collect(Collectors.toList()));
            Assert.assertEquals((Object)"Failed to delete 'link2'", (Object)((DeleteClusterLinksResponseData.EntryData)intercepted.data().entries().get(1)).errorMessage());
            this.verifyResponseMetrics(ApiKeys.DELETE_CLUSTER_LINKS, Utils.mkSet((Object[])new Errors[]{Errors.NONE, Errors.UNKNOWN_SERVER_ERROR}));
        }
    }

    @Test
    public void testReplicaStatusRequest() {
        for (short version = ApiKeys.REPLICA_STATUS.oldestVersion(); version <= ApiKeys.REPLICA_STATUS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.REPLICA_STATUS, version, false);
            ReplicaStatusRequest inbound = new ReplicaStatusRequest(new ReplicaStatusRequestData(), version);
            inbound.data().topics().add(new ReplicaStatusRequestData.ReplicaStatusTopic().setName("foo").setPartitions(Arrays.asList(0, 1)));
            inbound.data().topics().add(new ReplicaStatusRequestData.ReplicaStatusTopic().setName("bar").setPartitions(Collections.singletonList(0)));
            ReplicaStatusRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals(Arrays.asList("tenant_foo", "tenant_bar"), intercepted.data().topics().stream().map(ReplicaStatusRequestData.ReplicaStatusTopic::name).collect(Collectors.toList()));
            ReplicaStatusRequest clientIntercepted = (ReplicaStatusRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals((Object)inbound.data(), (Object)clientIntercepted.data());
            this.verifyRequestMetrics(ApiKeys.REPLICA_STATUS);
        }
    }

    @Test
    public void testReplicaStatusResponse() {
        for (short version = ApiKeys.REPLICA_STATUS.oldestVersion(); version <= ApiKeys.REPLICA_STATUS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.REPLICA_STATUS, version, false);
            ReplicaStatusResponse outbound = new ReplicaStatusResponse(new ReplicaStatusResponseData().setErrorCode(Errors.NONE.code()));
            outbound.data().topics().add(new ReplicaStatusResponseData.ReplicaStatusTopicResponse().setName("tenant_foo").setPartitions(Collections.emptyList()));
            outbound.data().topics().add(new ReplicaStatusResponseData.ReplicaStatusTopicResponse().setName("tenant_bar").setPartitions(Collections.emptyList()));
            ReplicaStatusResponse intercepted = (ReplicaStatusResponse)this.parseResponse(ApiKeys.REPLICA_STATUS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals(Arrays.asList("foo", "bar"), intercepted.data().topics().stream().map(ReplicaStatusResponseData.ReplicaStatusTopicResponse::name).collect(Collectors.toList()));
            ReplicaStatusResponse clientIntercepted = (ReplicaStatusResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Assert.assertEquals((Object)outbound.data(), (Object)clientIntercepted.data());
            this.verifyResponseMetrics(ApiKeys.REPLICA_STATUS, Errors.NONE);
        }
    }

    @Test
    public void testAlterMirrorsRequestVersions0_1() {
        for (short version = ApiKeys.ALTER_MIRRORS.oldestVersion(); version <= 1; version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.ALTER_MIRRORS, version, false);
            AlterMirrorsRequest inbound = new AlterMirrorsRequest(new AlterMirrorsRequestData(), version);
            inbound.data().ops().add(new AlterMirrorsRequestData.OpData().setClearTopicMirror(Arrays.asList(new AlterMirrorsRequestData.ClearTopicMirrorData().setTopic("a"), new AlterMirrorsRequestData.ClearTopicMirrorData().setTopic("b"))).setStopTopicMirror(Arrays.asList(new AlterMirrorsRequestData.StopTopicMirrorData().setTopic("c"), new AlterMirrorsRequestData.StopTopicMirrorData().setTopic("d"), new AlterMirrorsRequestData.StopTopicMirrorData().setTopic("e"))));
            if (version == 1) {
                inbound.data().ops().add(new AlterMirrorsRequestData.OpData().setPauseTopicMirror(Arrays.asList(new AlterMirrorsRequestData.PauseTopicMirrorData().setTopic("f"), new AlterMirrorsRequestData.PauseTopicMirrorData().setTopic("g"))));
            }
            AlterMirrorsRequest intercepted = this.parseRequest(context, inbound);
            if (version >= 1) {
                Assert.assertEquals((long)2L, (long)intercepted.data().ops().size());
            } else {
                Assert.assertEquals((long)1L, (long)intercepted.data().ops().size());
            }
            Assert.assertEquals((long)0L, (long)intercepted.data().mirrorOperations().size());
            AlterMirrorsRequestData.OpData interceptedOp1 = (AlterMirrorsRequestData.OpData)intercepted.data().ops().get(0);
            Assert.assertEquals(Arrays.asList("tenant_a", "tenant_b"), interceptedOp1.clearTopicMirror().stream().map(AlterMirrorsRequestData.ClearTopicMirrorData::topic).collect(Collectors.toList()));
            Assert.assertEquals(Arrays.asList("tenant_c", "tenant_d", "tenant_e"), interceptedOp1.stopTopicMirror().stream().map(AlterMirrorsRequestData.StopTopicMirrorData::topic).collect(Collectors.toList()));
            if (version >= 1) {
                AlterMirrorsRequestData.OpData interceptedOp2 = (AlterMirrorsRequestData.OpData)intercepted.data().ops().get(1);
                Assert.assertEquals(Arrays.asList("tenant_f", "tenant_g"), interceptedOp2.pauseTopicMirror().stream().map(AlterMirrorsRequestData.PauseTopicMirrorData::topic).collect(Collectors.toList()));
            }
            this.verifyRequestMetrics(ApiKeys.ALTER_MIRRORS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testAlterMirrorsRequest() {
        for (short version = 2; version <= ApiKeys.ALTER_MIRRORS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.ALTER_MIRRORS, version, false);
            AlterMirrorsRequest inbound = new AlterMirrorsRequest(new AlterMirrorsRequestData(), version);
            inbound.data().setMirrorOperations(Arrays.asList(new AlterMirrorsRequestData.MirrorOperation().setTopic("a").setOperationCode(AlterMirrorOp.CLEAR.id()), new AlterMirrorsRequestData.MirrorOperation().setTopic("b").setOperationCode(AlterMirrorOp.PROMOTE.id()), new AlterMirrorsRequestData.MirrorOperation().setTopic("c").setOperationCode(AlterMirrorOp.FAILOVER.id()), new AlterMirrorsRequestData.MirrorOperation().setTopic("d").setOperationCode(AlterMirrorOp.PAUSE.id()), new AlterMirrorsRequestData.MirrorOperation().setTopic("e").setOperationCode(AlterMirrorOp.RESUME.id()), new AlterMirrorsRequestData.MirrorOperation().setTopic("f").setOperationCode(AlterMirrorOp.PAUSE_LINK.id()), new AlterMirrorsRequestData.MirrorOperation().setTopic("g").setOperationCode(AlterMirrorOp.RESUME_LINK.id())));
            AlterMirrorsRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((long)inbound.data().mirrorOperations().size(), (long)intercepted.data().mirrorOperations().size());
            Assert.assertEquals((long)0L, (long)intercepted.data().ops().size());
            Assert.assertEquals(Arrays.asList("tenant_a", "tenant_b", "tenant_c", "tenant_d", "tenant_e", "tenant_f", "tenant_g"), intercepted.data().mirrorOperations().stream().map(AlterMirrorsRequestData.MirrorOperation::topic).collect(Collectors.toList()));
            this.verifyRequestMetrics(ApiKeys.ALTER_MIRRORS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testAlterMirrorsResponse() {
        for (short version = ApiKeys.ALTER_MIRRORS.oldestVersion(); version <= ApiKeys.ALTER_MIRRORS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.ALTER_MIRRORS, version, false);
            AlterMirrorsResponse outbound = new AlterMirrorsResponse(new AlterMirrorsResponseData());
            AlterMirrorsResponseData.AlterMirrorResult result = new AlterMirrorsResponseData.AlterMirrorResult().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to update 'tenant_foo'");
            if (version >= 2) {
                result.setTopic("tenant_topic");
            }
            outbound.data().results().add(result);
            AlterMirrorsResponse intercepted = (AlterMirrorsResponse)this.parseResponse(ApiKeys.ALTER_MIRRORS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((long)1L, (long)intercepted.data().results().size());
            Assert.assertEquals((Object)"Failed to update 'foo'", (Object)((AlterMirrorsResponseData.AlterMirrorResult)intercepted.data().results().get(0)).errorMessage());
            if (version >= 2) {
                Assert.assertEquals((Object)"topic", (Object)((AlterMirrorsResponseData.AlterMirrorResult)intercepted.data().results().get(0)).topic());
            }
            this.verifyResponseMetrics(ApiKeys.ALTER_MIRRORS, Errors.UNKNOWN_SERVER_ERROR);
        }
    }

    @Test
    public void testDescribeMirrorsRequest() {
        for (short version = ApiKeys.DESCRIBE_MIRRORS.oldestVersion(); version <= ApiKeys.DESCRIBE_MIRRORS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_MIRRORS, version, false);
            DescribeMirrorsRequest inbound = new DescribeMirrorsRequest(new DescribeMirrorsRequestData().setTopics(Arrays.asList("foo", "bar")), version);
            DescribeMirrorsRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals(Arrays.asList("tenant_foo", "tenant_bar"), (Object)intercepted.topics());
            this.verifyRequestMetrics(ApiKeys.DESCRIBE_MIRRORS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testDescribeMirrorsResponse() {
        for (short version = ApiKeys.DESCRIBE_MIRRORS.oldestVersion(); version <= ApiKeys.DESCRIBE_MIRRORS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_MIRRORS, version, false);
            DescribeMirrorsResponse outbound = new DescribeMirrorsResponse(new DescribeMirrorsResponseData().setErrorCode(Errors.NONE.code()));
            outbound.data().topics().add(new DescribeMirrorsResponseData.TopicData().setErrorCode(Errors.NONE.code()).setTopic("tenant_foo").setLinkName("tenant_link").setMirrorTopic("tenant_foo_mirror"));
            outbound.data().topics().add(new DescribeMirrorsResponseData.TopicData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to describe 'tenant_bar'").setTopic("tenant_bar"));
            DescribeMirrorsResponse intercepted = (DescribeMirrorsResponse)this.parseResponse(ApiKeys.DESCRIBE_MIRRORS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((long)2L, (long)intercepted.data().topics().size());
            DescribeMirrorsResponseData.TopicData topicResponse1 = (DescribeMirrorsResponseData.TopicData)intercepted.data().topics().get(0);
            Assert.assertEquals((Object)"foo", (Object)topicResponse1.topic());
            Assert.assertEquals((Object)"link", (Object)topicResponse1.linkName());
            Assert.assertEquals((Object)"foo_mirror", (Object)topicResponse1.mirrorTopic());
            DescribeMirrorsResponseData.TopicData topicResponse2 = (DescribeMirrorsResponseData.TopicData)intercepted.data().topics().get(1);
            Assert.assertEquals((Object)"bar", (Object)topicResponse2.topic());
            Assert.assertEquals((Object)"Failed to describe 'bar'", (Object)topicResponse2.errorMessage());
            Assert.assertEquals((Object)"", (Object)topicResponse2.mirrorTopic());
            Assert.assertEquals((Object)"", (Object)topicResponse2.linkName());
            this.verifyResponseMetrics(ApiKeys.DESCRIBE_MIRRORS, Utils.mkSet((Object[])new Errors[]{Errors.NONE, Errors.UNKNOWN_SERVER_ERROR}));
        }
    }

    @Test
    public void testDescribeMirrorsResponseTopLevelErrorMessage() {
        for (short version = ApiKeys.DESCRIBE_MIRRORS.oldestVersion(); version <= ApiKeys.DESCRIBE_MIRRORS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.DESCRIBE_MIRRORS, version, false);
            DescribeMirrorsResponse outbound = new DescribeMirrorsResponse(new DescribeMirrorsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to describe 'tenant_foo'"));
            DescribeMirrorsResponse intercepted = (DescribeMirrorsResponse)this.parseResponse(ApiKeys.DESCRIBE_MIRRORS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)"Failed to describe 'foo'", (Object)intercepted.data().errorMessage());
            this.verifyResponseMetrics(ApiKeys.DESCRIBE_MIRRORS, Errors.UNKNOWN_SERVER_ERROR);
        }
    }

    @Test
    public void testListMirrorsRequest() {
        for (short version = ApiKeys.LIST_MIRRORS.oldestVersion(); version <= ApiKeys.LIST_MIRRORS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LIST_MIRRORS, version, false);
            ListMirrorsRequest inbound = new ListMirrorsRequest(new ListMirrorsRequestData().setLinkName("link"), version);
            ListMirrorsRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)"tenant_link", (Object)intercepted.data().linkName());
            this.verifyRequestMetrics(ApiKeys.LIST_MIRRORS);
            this.clusterLinkClient.verifyNotAllowed((AbstractRequest)intercepted, context.header);
        }
    }

    @Test
    public void testListMirrorsResponse() {
        for (short version = ApiKeys.LIST_MIRRORS.oldestVersion(); version <= ApiKeys.LIST_MIRRORS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LIST_MIRRORS, version, false);
            ListMirrorsResponse outbound = new ListMirrorsResponse(new ListMirrorsResponseData().setErrorCode(Errors.NONE.code()).setTopics(new ArrayList<String>(Arrays.asList("tenant_foo", "othertenant_baz", "tenant_bar", "othertenant_foo"))));
            ListMirrorsResponse intercepted = (ListMirrorsResponse)this.parseResponse(ApiKeys.LIST_MIRRORS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals(Arrays.asList("foo", "bar"), (Object)intercepted.data().topics());
            this.verifyResponseMetrics(ApiKeys.LIST_MIRRORS, Errors.NONE);
        }
    }

    @Test
    public void testListMirrorsResponseTopLevelErrorMessage() {
        for (short version = ApiKeys.LIST_MIRRORS.oldestVersion(); version <= ApiKeys.LIST_MIRRORS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.LIST_MIRRORS, version, false);
            ListMirrorsResponse outbound = new ListMirrorsResponse(new ListMirrorsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setErrorMessage("Failed to list mirrors for 'tenant_link'"));
            ListMirrorsResponse intercepted = (ListMirrorsResponse)this.parseResponse(ApiKeys.LIST_MIRRORS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((Object)"Failed to list mirrors for 'link'", (Object)intercepted.data().errorMessage());
            this.verifyResponseMetrics(ApiKeys.LIST_MIRRORS, Errors.UNKNOWN_SERVER_ERROR);
        }
    }

    @Test
    public void testInitiateReverseConnectionsRequest() {
        for (short version = ApiKeys.INITIATE_REVERSE_CONNECTIONS.oldestVersion(); version <= ApiKeys.INITIATE_REVERSE_CONNECTIONS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.INITIATE_REVERSE_CONNECTIONS, version, false);
            InitiateReverseConnectionsRequestData.EntryData entry = new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(1).setSourceBrokerId(2).setTargetBrokerId(3);
            Uuid linkId = Uuid.randomUuid();
            InitiateReverseConnectionsRequest inbound = new InitiateReverseConnectionsRequest(new InitiateReverseConnectionsRequestData().setClusterLinkId(linkId).setForwardToBroker(true).setSourceClusterId("source_cluster").setTargetClusterId("target_cluster").setEntries(Collections.singletonList(entry)), version);
            InitiateReverseConnectionsRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)linkId, (Object)intercepted.data().clusterLinkId());
            Assert.assertTrue((boolean)intercepted.data().forwardToBroker());
            Assert.assertEquals((Object)"source_cluster", (Object)intercepted.data().sourceClusterId());
            Assert.assertEquals((Object)"target_cluster", (Object)intercepted.data().targetClusterId());
            Assert.assertEquals(Collections.singletonList(entry), (Object)intercepted.data().entries());
            this.verifyRequestMetrics(ApiKeys.INITIATE_REVERSE_CONNECTIONS);
            InitiateReverseConnectionsRequest clientIntercepted = (InitiateReverseConnectionsRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals((Object)"source_cluster", (Object)clientIntercepted.data().sourceClusterId());
            Assert.assertEquals((Object)"target_cluster", (Object)clientIntercepted.data().targetClusterId());
        }
    }

    @Test
    public void testInitiateReverseConnectionsResponse() {
        for (short version = ApiKeys.INITIATE_REVERSE_CONNECTIONS.oldestVersion(); version <= ApiKeys.INITIATE_REVERSE_CONNECTIONS.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.INITIATE_REVERSE_CONNECTIONS, version, false);
            InitiateReverseConnectionsResponseData.EntryData entry = new InitiateReverseConnectionsResponseData.EntryData().setErrorCode(Errors.NONE.code()).setErrorMessage("Failed to reverse connection for 'tenant_link'").setInitiateRequestId(1);
            InitiateReverseConnectionsResponse outbound = new InitiateReverseConnectionsResponse(new InitiateReverseConnectionsResponseData().setThrottleTimeMs(10).setEntries(Collections.singletonList(entry)));
            InitiateReverseConnectionsResponse intercepted = (InitiateReverseConnectionsResponse)this.parseResponse(ApiKeys.INITIATE_REVERSE_CONNECTIONS, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((long)10L, (long)intercepted.data().throttleTimeMs());
            Assert.assertEquals((long)1L, (long)intercepted.data().entries().size());
            Assert.assertEquals((long)1L, (long)((InitiateReverseConnectionsResponseData.EntryData)intercepted.data().entries().get(0)).initiateRequestId());
            Assert.assertEquals((long)Errors.NONE.code(), (long)((InitiateReverseConnectionsResponseData.EntryData)intercepted.data().entries().get(0)).errorCode());
            Assert.assertEquals((Object)"Failed to reverse connection for 'link'", (Object)((InitiateReverseConnectionsResponseData.EntryData)intercepted.data().entries().get(0)).errorMessage());
            this.verifyResponseMetrics(ApiKeys.INITIATE_REVERSE_CONNECTIONS, Errors.NONE);
            InitiateReverseConnectionsResponse clientIntercepted = (InitiateReverseConnectionsResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Assert.assertEquals((Object)intercepted, (Object)clientIntercepted);
        }
    }

    @Test
    public void testReverseConnectionRequest() {
        for (short version = ApiKeys.REVERSE_CONNECTION.oldestVersion(); version <= ApiKeys.REVERSE_CONNECTION.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.REVERSE_CONNECTION, version, false);
            Uuid linkId = Uuid.randomUuid();
            ReverseConnectionRequest inbound = new ReverseConnectionRequest(new ReverseConnectionRequestData().setClusterLinkId(linkId).setSourceClusterId("source_cluster").setTargetClusterId("target_cluster").setSourceHost("host").setSourcePort(9092).setInitiateRequestId(1).setSourceBrokerId(2), version);
            ReverseConnectionRequest intercepted = this.parseRequest(context, inbound);
            Assert.assertEquals((Object)linkId, (Object)intercepted.data().clusterLinkId());
            Assert.assertEquals((Object)"source_cluster", (Object)intercepted.data().sourceClusterId());
            Assert.assertEquals((Object)"target_cluster", (Object)intercepted.data().targetClusterId());
            this.verifyRequestMetrics(ApiKeys.REVERSE_CONNECTION);
            ReverseConnectionRequest clientIntercepted = (ReverseConnectionRequest)this.clusterLinkClient.intercept((AbstractRequest)intercepted, context.header);
            Assert.assertEquals((Object)linkId, (Object)clientIntercepted.data().clusterLinkId());
            Assert.assertEquals((Object)"source_cluster", (Object)clientIntercepted.data().sourceClusterId());
            Assert.assertEquals((Object)"target_cluster", (Object)intercepted.data().targetClusterId());
        }
    }

    @Test
    public void testReverseConnectionResponse() {
        for (short version = ApiKeys.REVERSE_CONNECTION.oldestVersion(); version <= ApiKeys.REVERSE_CONNECTION.latestVersion(); version = (short)(version + 1)) {
            MultiTenantRequestContext context = this.newRequestContext(ApiKeys.REVERSE_CONNECTION, version, false);
            ReverseConnectionResponse outbound = new ReverseConnectionResponse(new ReverseConnectionResponseData().setThrottleTimeMs(10).setErrorCode(Errors.NONE.code()).setErrorMessage("Failed to reverse connection for 'tenant_link'"));
            ReverseConnectionResponse intercepted = (ReverseConnectionResponse)this.parseResponse(ApiKeys.REVERSE_CONNECTION, version, context.buildResponseSend((AbstractResponse)outbound));
            Assert.assertEquals((long)10L, (long)intercepted.data().throttleTimeMs());
            Assert.assertEquals((long)Errors.NONE.code(), (long)intercepted.data().errorCode());
            Assert.assertEquals((Object)"Failed to reverse connection for 'link'", (Object)intercepted.data().errorMessage());
            this.verifyResponseMetrics(ApiKeys.REVERSE_CONNECTION, Errors.NONE);
            ReverseConnectionResponse clientIntercepted = (ReverseConnectionResponse)this.clusterLinkClient.intercept((AbstractResponse)intercepted, context.header);
            Assert.assertEquals((Object)intercepted, (Object)clientIntercepted);
        }
    }

    private NewClusterLink expectedNewClusterLink(MultiTenantRequestContext context, NewClusterLink link, Map<String, String> newConfigs) {
        return new NewClusterLink(context.tenantContext.addTenantPrefix(link.linkName()), link.clusterId(), newConfigs);
    }

    private <T extends AbstractRequest> T parseRequest(MultiTenantRequestContext context, T request) {
        ByteBuffer requestBuffer = this.toByteBuffer(request);
        AbstractRequest parsed = context.parseRequest((ByteBuffer)requestBuffer).request;
        Assert.assertFalse((boolean)requestBuffer.hasRemaining());
        return (T)parsed;
    }

    private MultiTenantRequestContext newRequestContext(ApiKeys api, short version, boolean isListenerPrefixEnabled) {
        RequestHeader header = new RequestHeader(api, version, "clientId", 23);
        MultiTenantInterceptorConfig config = (MultiTenantInterceptorConfig)Mockito.mock(MultiTenantInterceptorConfig.class);
        Mockito.when((Object)config.defaultNumPartitions()).thenReturn((Object)3);
        Mockito.when((Object)config.defaultReplicationFactor()).thenReturn((Object)2);
        Mockito.when((Object)config.maxNumPartitionsPerRequest()).thenReturn((Object)1000);
        Mockito.when((Object)config.isClusterPrefixForHostnameEnabled()).thenReturn((Object)isListenerPrefixEnabled);
        Mockito.when((Object)config.partitionAssignor()).thenReturn((Object)this.partitionAssignor);
        Mockito.when((Object)config.isSchemaValidationEnabled()).thenReturn((Object)this.isSchemaValidationEnabled);
        return new MultiTenantRequestContext(header, "1", null, this.principal, this.listenerName, this.securityProtocol, ClientInformation.EMPTY, null, this.time, this.metrics, this.tenantMetrics, config, Optional.empty(), false, Optional.empty());
    }

    private ByteBuffer toByteBuffer(AbstractRequest request) {
        return request.serialize();
    }

    private <T extends AbstractResponse> T parseResponse(ApiKeys api, short version, Send send) {
        ByteBuffer buffer = TestUtils.toBuffer((Send)send);
        Assert.assertEquals((long)(send.size() - 4L), (long)buffer.getInt());
        ResponseHeader.parse((ByteBuffer)buffer, (short)api.responseHeaderVersion(version));
        AbstractResponse response = AbstractResponse.parseResponse((ApiKeys)api, (ByteBuffer)buffer, (short)version, (MessageContext)MessageContext.IDENTITY);
        return (T)response;
    }

    private Map<String, KafkaMetric> verifyRequestMetrics(ApiKeys apiKey) {
        return this.verifyTenantMetrics(apiKey, Collections.emptySet(), true, false, "request-byte-min", "request-byte-avg", "request-byte-max", "request-rate", "request-total", "request-byte-rate", "request-byte-total");
    }

    private void verifyResponseMetrics(ApiKeys apiKey, Errors error) {
        this.verifyResponseMetrics(apiKey, Collections.singleton(error));
    }

    private void verifyResponseMetrics(ApiKeys apiKey, Set<Errors> errors) {
        this.verifyTenantMetrics(apiKey, errors, false, true, "response-time-ns-min", "response-time-ns-avg", "response-time-ns-max", "response-byte-min", "response-byte-avg", "response-byte-max", "response-byte-rate", "response-byte-total", "error-rate", "error-total");
    }

    private Map<String, KafkaMetric> verifyRequestAndResponseMetrics(ApiKeys apiKey, Errors error) {
        return this.verifyTenantMetrics(apiKey, Collections.singleton(error), true, true, "request-rate", "request-total", "request-byte-rate", "request-byte-total", "response-time-ns-min", "response-time-ns-avg", "response-time-ns-max", "response-byte-min", "response-byte-avg", "response-byte-max", "response-byte-rate", "response-byte-total", "error-rate", "error-total");
    }

    private Map<String, KafkaMetric> verifyTenantMetrics(ApiKeys apiKey, Set<Errors> expectedErrors, boolean hasRequests, boolean hasResponses, String ... expectedMetrics) {
        HashSet<String> tenantMetrics = new HashSet<String>();
        HashMap<String, KafkaMetric> metricsByName = new HashMap<String, KafkaMetric>();
        List<String> expectedMetricsList = Arrays.asList(expectedMetrics);
        Set expectedErrorNames = expectedErrors.stream().map(Enum::name).collect(Collectors.toSet());
        for (Map.Entry entry : this.metrics.metrics().entrySet()) {
            boolean toIgnore;
            MetricName metricName = (MetricName)entry.getKey();
            String tenant = (String)metricName.tags().get(TENANT_NAME);
            boolean bl = toIgnore = tenant == null || !hasRequests && metricName.name().startsWith("request") || !hasResponses && metricName.name().startsWith("response") || !expectedMetricsList.contains(metricName.name());
            if (toIgnore) continue;
            KafkaMetric metric = (KafkaMetric)entry.getValue();
            metricsByName.put(metricName.name(), metric);
            tenantMetrics.add(metricName.name());
            Assert.assertEquals((Object)TENANT_NAME, (Object)tenant);
            if ("cluster-link-dest-tenant-metrics".equals(metricName.group())) {
                Assert.assertEquals((Object)"link-name", metricName.tags().get("link-name"));
            } else {
                Assert.assertEquals((Object)USERNAME, metricName.tags().get(USERNAME));
            }
            Assert.assertEquals((Object)apiKey.name, metricName.tags().get("request"));
            double value = (Double)metric.metricValue();
            if (metricName.name().contains("time-")) {
                Assert.assertTrue((String)("Invalid metric value " + value), (value >= 0.0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)String.format("Metric (%s) not recorded: %s", metricName.name(), value), (value > 0.0 ? 1 : 0) != 0);
            }
            if (!metricName.name().startsWith("error")) continue;
            Assert.assertTrue((boolean)expectedErrorNames.contains(metricName.tags().get("error")));
        }
        Assert.assertEquals((Object)Utils.mkSet((Object[])expectedMetrics), tenantMetrics);
        for (Errors expectedError : expectedErrors) {
            this.verifySensors(apiKey, expectedError, expectedMetrics);
        }
        return metricsByName;
    }

    private Set<Sensor> verifySensors(ApiKeys apiKey, Errors error, String ... expectedMetrics) {
        HashSet<Sensor> sensors = new HashSet<Sensor>();
        for (String metricName : expectedMetrics) {
            String name = metricName.substring(0, metricName.lastIndexOf(45));
            if (name.equals("error")) {
                name = name + ":error-" + error.name();
            }
            String sensorName = String.format("%s:request-%s:tenant-tenant:user-user", name, apiKey.name);
            Sensor sensor = this.metrics.getSensor(sensorName);
            Assert.assertNotNull((String)("Sensor not found " + sensorName), (Object)sensor);
            sensors.add(sensor);
        }
        return sensors;
    }

    private CreateTopicsRequestData.CreateableTopicConfigCollection transformedTestConfigs() {
        CreateTopicsRequestData.CreateableTopicConfigCollection transformedConfigs = this.testConfigs();
        transformedConfigs.remove((Object)new CreateTopicsRequestData.CreateableTopicConfig().setName("compression.type").setValue("lz4"));
        transformedConfigs.remove((Object)new CreateTopicsRequestData.CreateableTopicConfig().setName("confluent.placement.constraints"));
        if (!this.isSchemaValidationEnabled) {
            transformedConfigs.remove((Object)new CreateTopicsRequestData.CreateableTopicConfig().setName("confluent.key.schema.validation").setValue("true"));
        }
        return transformedConfigs;
    }

    private CreateTopicsRequestData.CreateableTopicConfigCollection testConfigs() {
        CreateTopicsRequestData.CreateableTopicConfigCollection configs = new CreateTopicsRequestData.CreateableTopicConfigCollection();
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("cleanup.policy").setValue("compact"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("max.message.bytes").setValue("16777216"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("message.timestamp.difference.max.ms").setValue("31536000000"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("message.timestamp.type").setValue("LogAppendTime"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("min.compaction.lag.ms").setValue("0"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("max.compaction.lag.ms").setValue("2147483647"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("retention.bytes").setValue("107374182400"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("retention.ms").setValue("86400000"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("delete.retention.ms").setValue("31536000000"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("segment.bytes").setValue("1024"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("segment.ms").setValue("100"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("min.insync.replicas").setValue("3"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("compression.type").setValue("lz4"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("confluent.placement.constraints").setValue("{}"));
        configs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("confluent.key.schema.validation").setValue("true"));
        return configs;
    }

    private static class ClusterLinkClient {
        private final ClusterLinkInterceptor interceptor = new ClusterLinkInterceptor();
        private final Time time;

        ClusterLinkClient(String linkName, MultiTenantPrincipal principal, Metrics metrics, Time time) {
            this.time = time;
            Map configs = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ClusterLinkManager.LocalTenantPrefixProp(), (Object)principal.tenantMetadata().tenantPrefix()), Utils.mkEntry((Object)ClusterLinkManager.LinkNameProp(), (Object)linkName), Utils.mkEntry((Object)ClusterLinkConfig.LinkModeProp(), (Object)"DESTINATION")});
            this.interceptor.configure(configs);
            this.interceptor.configureMetrics(metrics);
        }

        private <T extends AbstractRequest> T intercept(T request, RequestHeader header) {
            Send send = this.interceptor.toSend(header, request, this.time.milliseconds());
            ByteBufferChannel channel = new ByteBufferChannel(send.size());
            try {
                send.writeTo((TransferableChannel)channel);
                channel.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteBuffer buffer = channel.buffer();
            buffer.getInt();
            buffer = buffer.slice();
            RequestHeader interceptedHeader = RequestHeader.parse((ByteBuffer)buffer);
            Assert.assertEquals((Object)header, (Object)interceptedHeader);
            buffer = buffer.slice();
            RequestAndSize interceptedRequestAndSize = AbstractRequest.parseRequest((ApiKeys)header.apiKey(), (short)header.apiVersion(), (ByteBuffer)buffer, (MessageContext)MessageContext.IDENTITY);
            Assert.assertEquals((long)0L, (long)buffer.remaining());
            AbstractRequest response = interceptedRequestAndSize.request;
            return (T)response;
        }

        private <T extends AbstractResponse> T intercept(T response, RequestHeader header) {
            ByteBuffer buffer = RequestTestUtils.serializeResponseWithHeader(response, (short)header.apiVersion(), (int)header.correlationId());
            AbstractResponse interceptedResponse = this.interceptor.parseResponse(buffer, header, this.time.milliseconds(), this.time.milliseconds());
            return (T)interceptedResponse;
        }

        private void verifyNotAllowed(AbstractRequest request, RequestHeader header) {
            Assert.assertThrows(IllegalStateException.class, () -> this.intercept(request, header));
        }

        private void verifyNotAllowed(AbstractResponse response, RequestHeader header) {
            Assert.assertThrows(IllegalStateException.class, () -> this.intercept(response, header));
        }
    }

    private static class AclTestParams {
        static final List<ResourceType> RESOURCE_TYPES = Arrays.asList(ResourceType.TOPIC, ResourceType.GROUP, ResourceType.TRANSACTIONAL_ID, ResourceType.CLUSTER);
        final PatternType patternType;
        final boolean wildcard;
        final boolean hasResourceName;

        AclTestParams(PatternType patternType, boolean wildcard, boolean hasResourceName) {
            this.patternType = patternType;
            this.wildcard = wildcard;
            this.hasResourceName = hasResourceName;
        }

        private String resourceName(ResourceType resourceType) {
            String suffix = resourceType.name().toLowerCase(LOCALE);
            if (!this.hasResourceName) {
                return null;
            }
            if (this.wildcard) {
                return "*";
            }
            if (resourceType == ResourceType.CLUSTER) {
                return "kafka-cluster";
            }
            if (this.patternType == PatternType.PREFIXED) {
                return "prefix." + suffix;
            }
            return "test." + suffix;
        }

        String tenantResourceName(ResourceType resourceType) {
            String suffix = resourceType.name().toLowerCase(LOCALE);
            if (!this.hasResourceName) {
                return "tenant_";
            }
            if (this.wildcard) {
                return "tenant_";
            }
            if (resourceType == ResourceType.CLUSTER) {
                return "tenant_kafka-cluster";
            }
            if (this.patternType == PatternType.PREFIXED) {
                return "tenant_prefix." + suffix;
            }
            return "tenant_test." + suffix;
        }

        String principal() {
            return this.wildcard ? "User:*" : "User:principal";
        }

        String tenantPrincipal() {
            return this.wildcard ? "TenantUser*:tenant_" : "TenantUser:tenant_principal";
        }

        PatternType tenantPatternType(ResourceType resourceType) {
            if (this.hasResourceName) {
                switch (this.patternType) {
                    case LITERAL: {
                        return this.wildcard ? PatternType.PREFIXED : PatternType.LITERAL;
                    }
                    case PREFIXED: {
                        return PatternType.PREFIXED;
                    }
                    case ANY: {
                        return PatternType.ANY;
                    }
                    case MATCH: {
                        return PatternType.CONFLUENT_ONLY_TENANT_MATCH;
                    }
                }
                throw new IllegalArgumentException("Unsupported pattern type " + this.patternType);
            }
            switch (this.patternType) {
                case LITERAL: {
                    return PatternType.CONFLUENT_ALL_TENANT_LITERAL;
                }
                case PREFIXED: {
                    return PatternType.CONFLUENT_ALL_TENANT_PREFIXED;
                }
                case ANY: 
                case MATCH: {
                    return PatternType.CONFLUENT_ALL_TENANT_ANY;
                }
            }
            throw new IllegalArgumentException("Unsupported pattern type " + this.patternType);
        }

        public String toString() {
            return String.format("AclTestParams(patternType=%s, wildcard=%s, hasResourceName=%s)", this.patternType, this.wildcard, this.hasResourceName);
        }

        static List<AclTestParams> aclTestParams(short ver) {
            ArrayList<AclTestParams> tests = new ArrayList<AclTestParams>();
            tests.add(new AclTestParams(PatternType.LITERAL, false, true));
            tests.add(new AclTestParams(PatternType.LITERAL, true, true));
            if (ver > 0) {
                tests.add(new AclTestParams(PatternType.PREFIXED, false, true));
            }
            return tests;
        }

        static List<AclTestParams> filterTestParams(short ver) {
            ArrayList<AclTestParams> tests = new ArrayList<AclTestParams>();
            tests.add(new AclTestParams(PatternType.LITERAL, false, true));
            tests.add(new AclTestParams(PatternType.LITERAL, true, true));
            tests.add(new AclTestParams(PatternType.LITERAL, false, false));
            if (ver > 0) {
                tests.add(new AclTestParams(PatternType.PREFIXED, false, true));
                tests.add(new AclTestParams(PatternType.PREFIXED, false, false));
                tests.add(new AclTestParams(PatternType.ANY, false, true));
                tests.add(new AclTestParams(PatternType.ANY, false, false));
                tests.add(new AclTestParams(PatternType.MATCH, false, true));
                tests.add(new AclTestParams(PatternType.MATCH, false, false));
            }
            return tests;
        }
    }
}

