/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.SslCertificateManager;
import io.confluent.kafka.multitenant.Utils;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SslCertificateManagerTest {
    private static final String SSL_CERTS_DIR = "mnt/sslcerts/";
    private static final String DATA_DIR = "..data";
    private static final String BROKER_ID = "1";
    private static final URL TEST_SSL_CERTS_AUG = SslCertificateManagerTest.class.getResource("/cert_exp_aug");
    private static final URL TEST_ROOT = SslCertificateManagerTest.class.getResource("/");
    private AdminClient mockAdminClient;
    private SslCertificateManager sslCache;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        System.out.println("root resource: " + TEST_ROOT.getPath());
        Node node = new Node(1, "localhost", 9092);
        String sslCertsPath = this.tempFolder.getRoot().getCanonicalPath() + "/" + SSL_CERTS_DIR + "spec.json";
        this.mockAdminClient = (AdminClient)Mockito.spy((Object)new MockAdminClient(Collections.singletonList(node), node));
        this.sslCache = new SslCertificateManager((Object)BROKER_ID, (Object)sslCertsPath, this.mockAdminClient);
    }

    @After
    public void teardown() {
        this.sslCache.close();
    }

    @Test
    public void testAdminClientInvokedAfterCertificateSync() throws Exception {
        Utils.deleteFiles(this.tempFolder, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempFolder, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testAdminClientNotInvokedWithoutReadPermissionForCerts() throws Exception {
        Utils.syncCerts(this.tempFolder, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        String fullchainFilepath = this.tempFolder.getRoot().getCanonicalPath() + "/" + SSL_CERTS_DIR + "/" + DATA_DIR + "/fullchain.pem";
        String privkeyFilepath = this.tempFolder.getRoot().getCanonicalPath() + "/" + SSL_CERTS_DIR + "/" + DATA_DIR + "/privkey.pem";
        Files.setPosixFilePermissions(Paths.get(fullchainFilepath, new String[0]), PosixFilePermissions.fromString("-wx-wx-wx"));
        Files.setPosixFilePermissions(Paths.get(privkeyFilepath, new String[0]), PosixFilePermissions.fromString("-wx-wx-wx"));
        this.sslCache.loadSslCertFiles();
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testAdminClientNotInvokedWithoutSpecFile() throws Exception {
        String specfile = "spec.json";
        Utils.moveFile(specfile, TEST_SSL_CERTS_AUG, TEST_ROOT);
        Utils.deleteFiles(this.tempFolder, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempFolder, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.moveFile(specfile, TEST_ROOT, TEST_SSL_CERTS_AUG);
    }

    @Test
    public void testAdminClientNotInvokedWithoutPKCSCertificate() throws Exception {
        String pkcsfile = "pkcs.p12";
        Utils.moveFile(pkcsfile, TEST_SSL_CERTS_AUG, TEST_ROOT);
        Utils.deleteFiles(this.tempFolder, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempFolder, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.moveFile(pkcsfile, TEST_ROOT, TEST_SSL_CERTS_AUG);
    }

    @Test
    public void testAdminClientNotInvokedWithoutPrivkeyPemFile() throws Exception {
        String privkeyfile = "privkey.pem";
        Utils.moveFile(privkeyfile, TEST_SSL_CERTS_AUG, TEST_ROOT);
        Utils.deleteFiles(this.tempFolder, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempFolder, TEST_ROOT, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.moveFile(privkeyfile, TEST_ROOT, TEST_SSL_CERTS_AUG);
    }

    @Test
    public void testAdminClientNotInvokedWithoutFullchainPemFile() throws Exception {
        String fullchainfile = "fullchain.pem";
        Utils.moveFile(fullchainfile, TEST_SSL_CERTS_AUG, TEST_ROOT);
        Utils.deleteFiles(this.tempFolder, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempFolder, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.moveFile(fullchainfile, TEST_ROOT, TEST_SSL_CERTS_AUG);
    }
}

