/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.multitenant.LogicalClusterMetadata;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.SslCertificateSpecification;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Date;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.rules.TemporaryFolder;

public class Utils {
    public static final Date CREATION_DATE_1 = new Date(System.currentTimeMillis() - 124356L);
    public static final Date CREATION_DATE_2 = new Date(System.currentTimeMillis() - 654321L);
    public static final LogicalClusterMetadata LC_META_XYZ = new LogicalClusterMetadata("lkc-xyz", "pkc-xyz", "xyz", "my-account", "k8s-abc", "kafka", Long.valueOf(0x6400000L), Long.valueOf(10240000L), Long.valueOf(2048L), null, null, Long.valueOf(LogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER.longValue()), LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new LogicalClusterMetadata.LifecycleMetadata("xyz", "pkc-xyz", CREATION_DATE_2, null), Integer.valueOf(6000));
    public static final LogicalClusterMetadata LC_META_ABC = new LogicalClusterMetadata("lkc-abc", "pkc-abc", "abc", "my-account", "k8s-abc", "kafka", Long.valueOf(0xA00000L), Long.valueOf(102000000L), Long.valueOf(204800L), null, null, Long.valueOf(LogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER.longValue()), LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new LogicalClusterMetadata.LifecycleMetadata("abc", "pkc-abc", CREATION_DATE_1, null), Integer.valueOf(12000));
    public static final LogicalClusterMetadata LC_META_DED = new LogicalClusterMetadata("lkc-ded", "pkc-ded", "ded", "my-account", "k8s-abc", "kafka", Long.valueOf(0xA00000L), Long.valueOf(10240000L), Long.valueOf(20480000L), null, null, Long.valueOf(LogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER.longValue()), LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new LogicalClusterMetadata.LifecycleMetadata("ded", "pkc-ded", null, new Date()), null);
    public static final LogicalClusterMetadata LC_META_MEH = new LogicalClusterMetadata("lkc-meh", "pkc-meh", "meh", "my-account", "k8s-abc", "kafka", Long.valueOf(0xA00000L), Long.valueOf(10240000L), Long.valueOf(204800L), null, null, Long.valueOf(LogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER.longValue()), LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new LogicalClusterMetadata.LifecycleMetadata("meh", "pkc-meh", null, new Date(System.currentTimeMillis() - ConfluentConfigs.MULTITENANT_TENANT_DELETE_DELAY_MS_DEFAULT)), null);
    public static final LogicalClusterMetadata LC_META_HEALTHCHECK = new LogicalClusterMetadata("lkc-htc", "pkc-xyz", "external-healthcheck-pkc-xyz", "my-account", "k8s-abc", "healthcheck", null, null, null, null, null, null, null, null, null);
    public static final LogicalClusterMetadata LC_META_LINK_HEALTHCHECK = new LogicalClusterMetadata("lkc-lhtc", "pkc-xyz", "external-link-healthcheck-pkc-xyz", "my-account", "k8s-abc", "link-healthcheck", null, null, null, null, null, null, null, null, null);
    static final SslCertificateSpecification SSL_CERT_SPEC_NO_TYPE = new SslCertificateSpecification(null, "mystorepassword", "pkcs.p12", Integer.valueOf(1), "fullchain.pem", "privkey.pem");
    static final SslCertificateSpecification SSL_CERT_SPEC_NO_PKCSFILE = new SslCertificateSpecification("PKCS12", "mystorepassword", null, Integer.valueOf(1), "fullchain.pem", "privkey.pem");
    static final SslCertificateSpecification SSL_CERT_SPEC_NO_PEMFILES = new SslCertificateSpecification("PKCS12", "mystorepassword", "pkcs.p12", Integer.valueOf(1), null, null);

    public static PhysicalClusterMetadata initiatePhysicalClusterMetadata(Map<String, Object> configs) throws IOException {
        return Utils.initiatePhysicalClusterMetadata(configs, ConfluentConfigs.MULTITENANT_METADATA_RELOAD_DELAY_MS_DEFAULT);
    }

    public static PhysicalClusterMetadata initiatePhysicalClusterMetadata(Map<String, Object> configs, long reloadDelay) throws IOException {
        configs.put("multitenant.metadata.reload.delay.ms", reloadDelay);
        PhysicalClusterMetadata metadata = new PhysicalClusterMetadata(new Metrics(), Time.SYSTEM);
        metadata.configure(configs);
        return metadata;
    }

    public static void createLogicalClusterFile(LogicalClusterMetadata lcMeta, TemporaryFolder tempFolder) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, true, tempFolder, null);
    }

    public static void createInvalidLogicalClusterFile(LogicalClusterMetadata lcMeta, TemporaryFolder tempFolder) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, false, tempFolder, null);
    }

    public static void updateLogicalClusterFile(LogicalClusterMetadata lcMeta, TemporaryFolder tempFolder) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, true, tempFolder, null);
    }

    public static void updateInvalidLogicalClusterFile(LogicalClusterMetadata lcMeta, TemporaryFolder tempFolder) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, false, tempFolder, null);
    }

    public static void deleteLogicalClusterFile(LogicalClusterMetadata lcMeta, TemporaryFolder tempFolder) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, true, true, tempFolder, null);
    }

    public static void setPosixFilePermissions(LogicalClusterMetadata lcMeta, String posixFilePermissionsStr, TemporaryFolder tempFolder) throws IOException {
        String lcFilename = lcMeta.logicalClusterId() + ".json";
        Path metaPath = Paths.get(tempFolder.getRoot().toString(), "..data", lcFilename);
        Files.setPosixFilePermissions(metaPath, PosixFilePermissions.fromString(posixFilePermissionsStr));
    }

    public static LogicalClusterMetadata updateQuotas(LogicalClusterMetadata lcMeta, Long producerByteRate, Long consumerByteRate, Long brokerRequestPercentage) {
        return new LogicalClusterMetadata(lcMeta.logicalClusterId(), lcMeta.physicalClusterId(), lcMeta.logicalClusterName(), lcMeta.accountId(), lcMeta.k8sClusterId(), "kafka", lcMeta.storageBytes(), producerByteRate, consumerByteRate, null, null, brokerRequestPercentage, lcMeta.networkQuotaOverhead(), lcMeta.lifecycleMetadata(), lcMeta.maxPartitions());
    }

    public static void createOrUpdateLogicalClusterFile(LogicalClusterMetadata lcMeta, TemporaryFolder tempFolder, long lastModified) throws IOException {
        String lcFilename = lcMeta.logicalClusterId() + ".json";
        Utils.updateJsonFile(lcFilename, Utils.logicalClusterJsonString(lcMeta, true), false, tempFolder, lastModified);
    }

    private static void updateLogicalClusterFile(LogicalClusterMetadata lcMeta, boolean remove, boolean valid, TemporaryFolder tempFolder, Long lastModified) throws IOException {
        String lcFilename = lcMeta.logicalClusterId() + ".json";
        Utils.updateJsonFile(lcFilename, Utils.logicalClusterJsonString(lcMeta, valid), remove, tempFolder, lastModified);
    }

    public static Path updateJsonFile(String jsonFilename, String jsonString, boolean remove, TemporaryFolder tempFolder) throws IOException {
        return Utils.updateJsonFile(jsonFilename, jsonString, remove, tempFolder, null);
    }

    public static Path updateJsonFile(String jsonFilename, String jsonString, boolean remove, TemporaryFolder tempFolder, Long lastModified) throws IOException {
        Path dataDir;
        Path newDir = tempFolder.newFolder().toPath();
        Path lcFile = null;
        if (!remove) {
            lcFile = Paths.get(newDir.toString(), jsonFilename);
            Files.write(lcFile, jsonString.getBytes(), new OpenOption[0]);
            if (lastModified != null) {
                lcFile.toFile().setLastModified(lastModified);
            }
        }
        if (Files.exists(dataDir = Paths.get(tempFolder.getRoot().toString(), "..data"), new LinkOption[0])) {
            Path oldDir = Files.readSymbolicLink(dataDir);
            try (Stream<Path> fileStream = Files.list(oldDir);){
                fileStream.forEach(filePath -> {
                    try {
                        if (!filePath.getFileName().toString().equals(jsonFilename)) {
                            Files.move(filePath, Paths.get(newDir.toString(), filePath.getFileName().toString()), new CopyOption[0]);
                        } else {
                            Files.delete(filePath);
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("Test failed to simulate logical cluster file creation.", ioe);
                    }
                });
            }
            Files.delete(dataDir);
            Files.delete(oldDir);
        }
        Files.createSymbolicLink(dataDir, newDir, new FileAttribute[0]);
        return lcFile;
    }

    static String logicalClusterJsonString(LogicalClusterMetadata lcMeta) {
        String json = Utils.baseLogicalClusterJsonString(lcMeta);
        json = json + ", \"network_quota_overhead\": " + lcMeta.networkQuotaOverhead();
        json = json + "}";
        return json;
    }

    static String logicalClusterJsonString(LogicalClusterMetadata lcMeta, boolean valid) {
        String json = Utils.baseLogicalClusterJsonString(lcMeta);
        if (valid) {
            json = json + "}";
        }
        return json;
    }

    private static String baseLogicalClusterJsonString(LogicalClusterMetadata lcMeta) {
        String json = "{\"logical_cluster_id\": \"" + lcMeta.logicalClusterId() + "\",\"physical_cluster_id\": \"" + lcMeta.physicalClusterId() + "\",\"logical_cluster_name\": \"" + lcMeta.logicalClusterName() + "\",\"account_id\": \"" + lcMeta.accountId() + "\",\"k8s_cluster_id\": \"" + lcMeta.k8sClusterId() + "\",\"logical_cluster_type\": \"" + lcMeta.logicalClusterType() + "\",\"max_partitions\": " + lcMeta.maxPartitions();
        try {
            json = json + ", \"metadata\": " + Utils.lifecycleJsonString(lcMeta);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        if (lcMeta.storageBytes() != null) {
            json = json + ", \"storage_bytes\": " + lcMeta.storageBytes();
        }
        if (lcMeta.producerByteRate() != null) {
            json = json + ", \"network_ingress_byte_rate\": " + lcMeta.producerByteRate();
        }
        if (lcMeta.consumerByteRate() != null) {
            json = json + ", \"network_egress_byte_rate\": " + lcMeta.consumerByteRate();
        }
        if (lcMeta.brokerRequestPercentage() != null) {
            json = json + ", \"broker_request_percentage\": " + lcMeta.brokerRequestPercentage();
        }
        return json;
    }

    private static String lifecycleJsonString(LogicalClusterMetadata lcMeta) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)lcMeta.lifecycleMetadata());
    }

    static String sslCertSpecJsonString(SslCertificateSpecification sslSpec) {
        String json = "{\"ssl_certificate_encoding\": \"" + sslSpec.sslKeystoreType() + "\",\"ssl_keystore_filename\": \"" + sslSpec.pkcsCertFilename() + "\",\"ssl_pem_fullchain_filename\": \"" + sslSpec.sslPemFullchainFilename() + "\",\"ssl_pem_privkey_filename\": \"" + sslSpec.sslPemPrivkeyFilename() + "\"}";
        return json;
    }

    public static Path createSpecFile(TemporaryFolder tempFolder, SslCertificateSpecification sslSpec) throws IOException {
        Path newDir = tempFolder.newFolder().toPath();
        Path sslSpecPath = Paths.get(newDir.toString(), "spec.json");
        String jsonString = Utils.sslCertSpecJsonString(sslSpec);
        Files.write(sslSpecPath, jsonString.getBytes(), new OpenOption[0]);
        return sslSpecPath;
    }

    public static void syncCerts(TemporaryFolder tempFolder, URL url, String dirPath) throws IOException {
        String[] certFiles;
        String certs = url.getPath();
        tempFolder.newFolder(dirPath + "..data");
        String symlinkPath = tempFolder.getRoot().getCanonicalPath() + "/" + dirPath;
        String certDirPath = symlinkPath + "..data";
        File syncCertFile = new File(certs);
        for (String certFile : certFiles = syncCertFile.list()) {
            Files.copy(Paths.get(syncCertFile.getCanonicalPath(), certFile), Paths.get(certDirPath, certFile), StandardCopyOption.REPLACE_EXISTING);
            Files.createSymbolicLink(Paths.get(symlinkPath, certFile), Paths.get(certDirPath, certFile), new FileAttribute[0]);
        }
    }

    public static void deleteFiles(TemporaryFolder tempFolder, String dirPath) throws Exception {
        String certDirPath = tempFolder.getRoot().getCanonicalPath() + "/" + dirPath;
        String certDataDirPath = certDirPath + "..data";
        File certDataDir = new File(certDataDirPath);
        String[] files = certDataDir.list();
        if (files == null) {
            return;
        }
        for (String file : files) {
            Files.delete(Paths.get(certDataDirPath, file));
            Files.delete(Paths.get(certDirPath, file));
        }
        Files.delete(Paths.get(certDataDirPath, new String[0]));
    }

    static void moveFile(String filename, URL sourceUrl, URL destUrl) throws IOException {
        Path sourceDir = Paths.get(sourceUrl.getPath(), new String[0]);
        Path source = Paths.get(sourceDir.toString(), filename);
        Path destDir = Paths.get(destUrl.getPath(), new String[0]);
        Files.move(source, destDir.resolve(source.getFileName()), StandardCopyOption.REPLACE_EXISTING);
    }
}

