/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithCorrectSni;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithCorrectSniWithPathPrefix;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithSniStartWithPKC;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithWrongSni;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import kafka.admin.AclCommand;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={IntegrationTest.class})
public class FileBasedPlainSaslAuthHostNameValidationIntegrationTest {
    public static final String LOCAL_HOST_IP = "127.0.0.1";
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final String serviceUserAPIkey = "APIKEY1";
    private final String serviceUserAPIkeyPassword = "pwd1";
    private IntegrationTestHarness testHarness;
    private String brokerUUID;
    private PhysicalClusterMetadata metadata;
    private final String testTopic = "abcd";
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
    private final String path = FileBasedPlainSaslAuthenticatorTest.class.getResource("/file_auth_test_apikeys.json").getFile();
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private Map<String, Object> testCert;

    public void setUpCluster(String mode) throws Exception {
        MockAuditLogProvider.reset();
        this.testHarness = new IntegrationTestHarness();
        Properties brokerOverrideProps = this.setUpMetadata(this.brokerProps(mode));
        PhysicalCluster physicalCluster = this.testHarness.start(brokerOverrideProps);
        int serviceUserId = 1;
        LogicalCluster logicalCluster = physicalCluster.createLogicalCluster(this.logicalClusterId, 100, serviceUserId);
        LogicalClusterUser testUser = logicalCluster.user(serviceUserId);
        AclCommand.main((String[])SecurityTestUtils.addTopicAclArgs(this.testHarness.zkConnect(), testUser.prefixedKafkaPrincipal(), testUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL));
    }

    @After
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        this.metadata.close(this.brokerUUID);
    }

    private Properties setUpMetadata(Properties brokerProps) throws IOException, InterruptedException {
        this.brokerUUID = "uuid";
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        brokerProps.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        configs.put("multitenant.metadata.dir", this.tempFolder.getRoot().getCanonicalPath());
        this.metadata = Utils.initiatePhysicalClusterMetadata(configs);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempFolder);
        TestUtils.waitForCondition(() -> this.metadata.metadata(Utils.LC_META_ABC.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
        return brokerProps;
    }

    private Properties brokerProps(String mode) throws Exception {
        Properties props = new Properties();
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", (Object)true);
        props.put(KafkaConfig.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", (Object)true);
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.FileBasedLoginModule required config_path=\"" + this.path + "\"refresh_ms=\"1000\"sni_host_name_validation_mode=\"" + mode + "\";");
        props.put("confluent.multitenant.parse.sni.host.name.enable", (Object)true);
        props.put("listener.security.protocol.map", "REPLICATION:PLAINTEXT,EXTERNAL:SASL_SSL");
        CertStores certStores = new CertStores(true, LOCAL_HOST_IP, InetAddress.getByName(LOCAL_HOST_IP));
        this.testCert = certStores.keyStoreProps();
        this.testCert.putAll(certStores.trustStoreProps());
        props.put(KafkaConfig.ListenersProp(), "REPLICATION://127.0.0.1:0,EXTERNAL://127.0.0.1:0");
        props.put(KafkaConfig.InterBrokerListenerNameProp(), "REPLICATION");
        this.testCert.values().removeIf(Objects::isNull);
        props.putAll(this.testCert);
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        return props;
    }

    @Test
    public void testSuccessfulAuthenticationNoModeSpecified() throws Exception {
        this.setUpCluster("");
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @Test
    public void testSuccessfulAuthenticationOptionalMode() throws Exception {
        this.setUpCluster(SniValidationMode.OPTIONAL_VALIDATION.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @Test
    public void testFailedAuthenticationOptionalMode() throws Exception {
        this.setUpCluster(SniValidationMode.OPTIONAL_VALIDATION.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithWrongSni.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @Test
    public void testSuccessfulAuthenticationInLegacyModeWhenSniStartWithPKC() throws Exception {
        this.setUpCluster(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithSniStartWithPKC.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @Test
    public void testFailedAuthenticationInLegacyModeDueToSniNotSetByDefaultOnLocalHost() throws Exception {
        this.setUpCluster(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @Test
    public void testFailedAuthenticationInLegacyModeSniIncorrect() throws Exception {
        this.setUpCluster(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithWrongSni.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @Test
    public void testSuccessfulAuthenticationInStrictModeSni() throws Exception {
        this.setUpCluster(SniValidationMode.STRICT.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithCorrectSni.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @Test
    public void testFailedAuthenticationInStrictModeSniNotProvided() throws Exception {
        this.setUpCluster(SniValidationMode.STRICT.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @Test
    public void testFailedAuthenticationInStrictModeSniIncorrect() throws Exception {
        this.setUpCluster(SniValidationMode.STRICT.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithWrongSni.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @Test
    public void testFailedAuthenticationInStrictModeSniStartsWithPkc() throws Exception {
        this.setUpCluster(SniValidationMode.STRICT.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithSniStartWithPKC.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @Test
    public void testSuccessfulAuthenticationInStrictModeWithPathPrefix() throws Exception {
        this.testSuccessfulAuthenticationWithPathPrefix(SniValidationMode.STRICT);
    }

    @Test
    public void testSuccessfulAuthenticationInOptionalModeWithPathPrefix() throws Exception {
        this.testSuccessfulAuthenticationWithPathPrefix(SniValidationMode.OPTIONAL_VALIDATION);
    }

    @Test
    public void testSuccessfulAuthenticationInLegacyModeWithPathPrefix() throws Exception {
        this.testSuccessfulAuthenticationWithPathPrefix(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
    }

    private void testSuccessfulAuthenticationWithPathPrefix(SniValidationMode sniValidationMode) throws Exception {
        this.setUpCluster(sniValidationMode.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithCorrectSniWithPathPrefix.class.getCanonicalName(), CaptureAndStripHostResolver.class);
        DescribeClusterResult describeClusterResult = client.describeCluster(new DescribeClusterOptions());
        Collection nodes = (Collection)describeClusterResult.nodes().get();
        Assert.assertEquals((long)1L, (long)nodes.size());
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifySuccessfulAuthenticationEvent(authenticationEvent);
        CaptureAndStripHostResolver dnsResolver = CaptureAndStripHostResolver.getInstance();
        int resolveAttempts = dnsResolver.resolveAttempts.size();
        TestCase.assertTrue((resolveAttempts > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((boolean)((String)dnsResolver.resolveAttempts.get(resolveAttempts - 1)).startsWith("pb-"));
    }

    private void verifySuccessfulAuthentication(AdminClient client, KafkaFuture<Void> future) throws InterruptedException, ExecutionException {
        future.get();
        this.verifyExpectedTopicsPresent(client);
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifySuccessfulAuthenticationEvent(authenticationEvent);
    }

    private void verifyFailedAuthentication(KafkaFuture<Void> future) throws InterruptedException {
        TestUtils.assertFutureError(future, SaslAuthenticationException.class);
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifyUnauthenticatedEvent(authenticationEvent);
    }

    private void verifyExpectedTopicsPresent(AdminClient client) throws InterruptedException, ExecutionException {
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestCase.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics));
    }

    private void verifySuccessfulAuthenticationEvent(ConfluentAuthenticationEvent authenticationEvent) {
        Assert.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assert.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assert.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        TestCase.assertTrue((String)"Authentication event should contain principal", (boolean)authenticationEvent.principal().isPresent());
        TestCase.assertTrue((String)"Authentication event should contain logical cluster", (boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        Assert.assertFalse((String)"Authentication event shouldn't contain tenant metadata", (boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"));
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assert.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    private ConfluentAuthenticationEvent getLastAuthenticationEvent() {
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        return (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
    }

    private void verifyUnauthenticatedEvent(ConfluentAuthenticationEvent authenticationEvent) {
        Assert.assertFalse((String)"Authentication event shouldn't have principal", (boolean)authenticationEvent.principal().isPresent());
        Assert.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        TestCase.assertTrue((String)"Authentication event should have lkc", (boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        TestCase.assertTrue((String)"Authentication event should have exception", (boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        TestCase.assertTrue((String)"Error Info should contains SNI cluster Id doesn't match", (errorInfo.errorMessage().contains("SNI cluster ID") && errorInfo.errorMessage().contains("does not match") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"APIKEY1", (Object)errorInfo.identifier());
        Assert.assertEquals((Object)"lkc-abc", (Object)errorInfo.clusterId());
    }

    public static class CaptureAndStripHostResolver
    implements HostResolver {
        private static CaptureAndStripHostResolver instance;
        private final List<String> resolveAttempts = new ArrayList<String>();

        public static synchronized CaptureAndStripHostResolver getInstance() {
            return instance;
        }

        public CaptureAndStripHostResolver() {
            instance = this;
        }

        public synchronized List<String> resolveAttempts() {
            return new ArrayList<String>(this.resolveAttempts);
        }

        public synchronized InetAddress[] resolve(String host) throws UnknownHostException {
            this.resolveAttempts.add(host);
            if (host.startsWith("pb-")) {
                host = host.substring(3);
            }
            return InetAddress.getAllByName(host);
        }
    }
}

