/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.ApiSensorBuilder;
import org.apache.kafka.server.metrics.ApiSensors;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TenantMetricsTest {
    private static final String REQUEST_TAG = "request";
    private static final String REQUEST_RATE = "request-rate";
    private static final String REQUEST_TOTAL = "request-total";
    private static final String REQUEST_BYTE_TOTAL = "request-byte-total";
    private static final String REQUEST_BYTE_RATE = "request-byte-rate";
    private static final String REQUEST_BYTE_AVG = "request-byte-avg";
    private static final String REQUEST_BYTE_MIN = "request-byte-min";
    private static final String REQUEST_BYTE_MAX = "request-byte-max";
    private static final String RESPONSE_TIME_NS_MAX = "response-time-ns-max";
    private static final String RESPONSE_TIME_NS_MIN = "response-time-ns-min";
    private static final String RESPONSE_TIME_NS_AVG = "response-time-ns-avg";
    private static final String RESPONSE_BYTE_RATE = "response-byte-rate";
    private static final String RESPONSE_BYTE_TOTAL = "response-byte-total";
    private static final String RESPONSE_BYTE_AVG = "response-byte-avg";
    private static final String RESPONSE_BYTE_MIN = "response-byte-min";
    private static final String RESPONSE_BYTE_MAX = "response-byte-max";
    private Metrics metrics;
    private TenantMetrics tenantMetrics;
    private Time time;

    @Before
    public void setUp() {
        this.metrics = new Metrics();
        this.tenantMetrics = new TenantMetrics();
        this.time = new MockTime();
    }

    @After
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testApiSensorsReinitialized() {
        MultiTenantPrincipal principal = new MultiTenantPrincipal("user", new TenantMetadata("tenant", "cluster-1"));
        String clientId = "client";
        ApiKeys apiKey = ApiKeys.API_VERSIONS;
        TenantMetrics.MetricsRequestContext ctx = new TenantMetrics.MetricsRequestContext(principal, clientId, apiKey);
        this.tenantMetrics.recordResponse(this.metrics, ctx, 100L, this.time.nanoseconds(), Collections.emptyMap(), this.time.milliseconds());
        Map<Errors, Integer> errors = Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1);
        this.tenantMetrics.recordResponse(this.metrics, ctx, 100L, this.time.nanoseconds(), errors, this.time.milliseconds());
        ApiSensors apiSensors = (ApiSensors)this.tenantMetrics.apiSensors.get(apiKey);
        Assert.assertEquals(Collections.emptySet(), (Object)apiSensors.errorsWithoutSensors(this.metrics, errors.keySet()));
        Map responseSensors = new ApiSensorBuilder(this.metrics, (MetricsBuilderContext)ctx, apiKey).getOrCreateSuffixedSensors();
        Map errorSensors = new ApiSensorBuilder(this.metrics, (MetricsBuilderContext)ctx, apiKey).getOrCreateErrorSensors(errors.keySet());
        Assert.assertFalse((boolean)apiSensors.requestSensorsExpired(this.metrics));
        errorSensors.values().forEach(sensor -> this.metrics.removeSensor(sensor.name()));
        Assert.assertEquals(errors.keySet(), (Object)((ApiSensors)this.tenantMetrics.apiSensors.get(apiKey)).errorsWithoutSensors(this.metrics, errors.keySet()));
        responseSensors.values().forEach(sensor -> this.metrics.removeSensor(sensor.name()));
        Assert.assertTrue((boolean)apiSensors.requestSensorsExpired(this.metrics));
        Assert.assertTrue((boolean)apiSensors.responseSensorsExpired(this.metrics));
        this.tenantMetrics.recordResponse(this.metrics, ctx, 100L, this.time.nanoseconds(), Collections.emptyMap(), this.time.milliseconds());
        ApiSensors newSensors = (ApiSensors)this.tenantMetrics.apiSensors.get(apiKey);
        Assert.assertNotEquals((Object)apiSensors, (Object)newSensors);
        Assert.assertFalse((boolean)newSensors.requestSensorsExpired(this.metrics));
        Assert.assertFalse((boolean)newSensors.responseSensorsExpired(this.metrics));
    }

    private Map<String, KafkaMetric> requestMetrics(String group, ApiKeys apiKey) {
        HashMap<String, KafkaMetric> requestMetrics = new HashMap<String, KafkaMetric>();
        for (Map.Entry entry : this.metrics.metrics().entrySet()) {
            if (!((MetricName)entry.getKey()).group().equals(group) || !((String)((MetricName)entry.getKey()).tags().get(REQUEST_TAG)).equals(apiKey.name)) continue;
            switch (((MetricName)entry.getKey()).name()) {
                case "request-rate": {
                    requestMetrics.put(REQUEST_RATE, (KafkaMetric)entry.getValue());
                    break;
                }
                case "request-total": {
                    requestMetrics.put(REQUEST_TOTAL, (KafkaMetric)entry.getValue());
                    break;
                }
                case "request-byte-total": {
                    requestMetrics.put(REQUEST_BYTE_TOTAL, (KafkaMetric)entry.getValue());
                    break;
                }
                case "request-byte-rate": {
                    requestMetrics.put(REQUEST_BYTE_RATE, (KafkaMetric)entry.getValue());
                    break;
                }
                case "request-byte-avg": {
                    requestMetrics.put(REQUEST_BYTE_AVG, (KafkaMetric)entry.getValue());
                    break;
                }
                case "request-byte-min": {
                    requestMetrics.put(REQUEST_BYTE_MIN, (KafkaMetric)entry.getValue());
                    break;
                }
                case "request-byte-max": {
                    requestMetrics.put(REQUEST_BYTE_MAX, (KafkaMetric)entry.getValue());
                }
            }
        }
        return requestMetrics;
    }

    private Map<String, KafkaMetric> responseMetrics(String group, ApiKeys apiKey) {
        HashMap<String, KafkaMetric> requestMetrics = new HashMap<String, KafkaMetric>();
        for (Map.Entry entry : this.metrics.metrics().entrySet()) {
            if (!((MetricName)entry.getKey()).group().equals(group) || !((String)((MetricName)entry.getKey()).tags().get(REQUEST_TAG)).equals(apiKey.name)) continue;
            switch (((MetricName)entry.getKey()).name()) {
                case "response-time-ns-max": {
                    requestMetrics.put(RESPONSE_TIME_NS_MAX, (KafkaMetric)entry.getValue());
                    break;
                }
                case "response-time-ns-min": {
                    requestMetrics.put(RESPONSE_TIME_NS_MIN, (KafkaMetric)entry.getValue());
                    break;
                }
                case "response-time-ns-avg": {
                    requestMetrics.put(RESPONSE_TIME_NS_AVG, (KafkaMetric)entry.getValue());
                    break;
                }
                case "response-byte-rate": {
                    requestMetrics.put(RESPONSE_BYTE_RATE, (KafkaMetric)entry.getValue());
                    break;
                }
                case "response-byte-total": {
                    requestMetrics.put(RESPONSE_BYTE_TOTAL, (KafkaMetric)entry.getValue());
                    break;
                }
                case "response-byte-avg": {
                    requestMetrics.put(RESPONSE_BYTE_AVG, (KafkaMetric)entry.getValue());
                    break;
                }
                case "response-byte-min": {
                    requestMetrics.put(RESPONSE_BYTE_MIN, (KafkaMetric)entry.getValue());
                    break;
                }
                case "response-byte-max": {
                    requestMetrics.put(RESPONSE_BYTE_MAX, (KafkaMetric)entry.getValue());
                }
            }
        }
        return requestMetrics;
    }

    @Test
    public void testAggregatedApiRequestSensors() {
        ImmutableList tenantRequests = ImmutableList.of((Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user", new TenantMetadata("tenant-1", "cluster-1")), 50L, ApiKeys.PRODUCE), (Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user", new TenantMetadata("tenant-2", "cluster-1")), 100L, ApiKeys.PRODUCE), (Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user-1", new TenantMetadata("tenant-3", "cluster-2")), 75L, ApiKeys.PRODUCE), (Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user-1", new TenantMetadata("tenant-1", "cluster-1")), 25L, ApiKeys.PRODUCE));
        String clientId = "client";
        double requestSizeAvgExpected = 0.0;
        double requestSizeMinExpected = Double.MAX_VALUE;
        double requestSizeMaxExpected = Double.MIN_VALUE;
        for (TenantRequestConfiguration tenantRequest : tenantRequests) {
            TenantMetrics.MetricsRequestContext context = new TenantMetrics.MetricsRequestContext(tenantRequest.tenantPrincipal, clientId, tenantRequest.apikey);
            this.tenantMetrics.recordRequest(this.metrics, context, tenantRequest.requestSize, this.time.milliseconds());
            requestSizeAvgExpected += (double)tenantRequest.requestSize;
            if ((double)tenantRequest.requestSize < requestSizeMinExpected) {
                requestSizeMinExpected = tenantRequest.requestSize;
            }
            if (!((double)tenantRequest.requestSize > requestSizeMaxExpected)) continue;
            requestSizeMaxExpected = tenantRequest.requestSize;
        }
        requestSizeAvgExpected /= (double)tenantRequests.size();
        for (TenantRequestConfiguration tenantRequest : tenantRequests) {
            ApiSensors apiSensors = (ApiSensors)this.tenantMetrics.aggregateApiSensors.get(tenantRequest.apikey);
            Assert.assertNotNull((Object)apiSensors);
        }
        String aggregatedMetricsTag = String.format("%s-%s", "aggregate", "tenant-metrics");
        Map<String, KafkaMetric> requestMetrics = this.requestMetrics(aggregatedMetricsTag, ApiKeys.PRODUCE);
        Assert.assertEquals((long)7L, (long)requestMetrics.size());
        Assert.assertTrue(((Double)requestMetrics.get(REQUEST_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)tenantRequests.size(), (double)((Double)requestMetrics.get(REQUEST_TOTAL).metricValue()), (double)0.0);
        Assert.assertEquals((double)(requestSizeAvgExpected * (double)tenantRequests.size()), (double)((Double)requestMetrics.get(REQUEST_BYTE_TOTAL).metricValue()), (double)0.0);
        Assert.assertTrue(((Double)requestMetrics.get(REQUEST_BYTE_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)requestSizeAvgExpected, (double)((Double)requestMetrics.get(REQUEST_BYTE_AVG).metricValue()), (double)0.0);
        Assert.assertEquals((double)requestSizeMinExpected, (double)((Double)requestMetrics.get(REQUEST_BYTE_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)requestSizeMaxExpected, (double)((Double)requestMetrics.get(REQUEST_BYTE_MAX).metricValue()), (double)0.0);
    }

    @Test
    public void testAggregatedApiRequestSensorsMultipleRequestTypes() {
        ImmutableList tenantRequests = ImmutableList.of((Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user", new TenantMetadata("tenant-1", "cluster-1")), 50L, ApiKeys.PRODUCE), (Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user", new TenantMetadata("tenant-2", "cluster-1")), 100L, ApiKeys.PRODUCE), (Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user-1", new TenantMetadata("tenant-3", "cluster-2")), 75L, ApiKeys.FETCH), (Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user-1", new TenantMetadata("tenant-1", "cluster-1")), 25L, ApiKeys.DELETE_TOPICS));
        String clientId = "client";
        for (TenantRequestConfiguration tenantRequest : tenantRequests) {
            TenantMetrics.MetricsRequestContext context = new TenantMetrics.MetricsRequestContext(tenantRequest.tenantPrincipal, clientId, tenantRequest.apikey);
            this.tenantMetrics.recordRequest(this.metrics, context, tenantRequest.requestSize, this.time.milliseconds());
        }
        for (TenantRequestConfiguration tenantRequest : tenantRequests) {
            ApiSensors apiSensors = (ApiSensors)this.tenantMetrics.aggregateApiSensors.get(tenantRequest.apikey);
            Assert.assertNotNull((Object)apiSensors);
        }
        String aggregatedMetricsTag = String.format("%s-%s", "aggregate", "tenant-metrics");
        Map<String, KafkaMetric> requestMetrics = this.requestMetrics(aggregatedMetricsTag, ApiKeys.PRODUCE);
        Assert.assertEquals((long)7L, (long)requestMetrics.size());
        Assert.assertTrue(((Double)requestMetrics.get(REQUEST_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)2.0, (double)((Double)requestMetrics.get(REQUEST_TOTAL).metricValue()), (double)0.0);
        Assert.assertEquals((double)150.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_TOTAL).metricValue()), (double)0.0);
        Assert.assertTrue(((Double)requestMetrics.get(REQUEST_BYTE_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)75.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_AVG).metricValue()), (double)0.0);
        Assert.assertEquals((double)50.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)100.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_MAX).metricValue()), (double)0.0);
        requestMetrics = this.requestMetrics(aggregatedMetricsTag, ApiKeys.FETCH);
        Assert.assertEquals((long)7L, (long)requestMetrics.size());
        Assert.assertTrue(((Double)requestMetrics.get(REQUEST_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)1.0, (double)((Double)requestMetrics.get(REQUEST_TOTAL).metricValue()), (double)0.0);
        Assert.assertEquals((double)75.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_TOTAL).metricValue()), (double)0.0);
        Assert.assertTrue(((Double)requestMetrics.get(REQUEST_BYTE_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)75.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_AVG).metricValue()), (double)0.0);
        Assert.assertEquals((double)75.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)75.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_MAX).metricValue()), (double)0.0);
        requestMetrics = this.requestMetrics(aggregatedMetricsTag, ApiKeys.DELETE_TOPICS);
        Assert.assertEquals((long)7L, (long)requestMetrics.size());
        Assert.assertTrue(((Double)requestMetrics.get(REQUEST_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)1.0, (double)((Double)requestMetrics.get(REQUEST_TOTAL).metricValue()), (double)0.0);
        Assert.assertEquals((double)25.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_TOTAL).metricValue()), (double)0.0);
        Assert.assertTrue(((Double)requestMetrics.get(REQUEST_BYTE_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)25.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_AVG).metricValue()), (double)0.0);
        Assert.assertEquals((double)25.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)25.0, (double)((Double)requestMetrics.get(REQUEST_BYTE_MAX).metricValue()), (double)0.0);
    }

    @Test
    public void testAggregatedApiResponseSensors() {
        ImmutableList tenantRequests = ImmutableList.of((Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user", new TenantMetadata("tenant-1", "cluster-1")), 50L, ApiKeys.PRODUCE), (Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user", new TenantMetadata("tenant-2", "cluster-1")), 100L, ApiKeys.PRODUCE), (Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user-1", new TenantMetadata("tenant-3", "cluster-2")), 75L, ApiKeys.FETCH), (Object)new TenantRequestConfiguration(new MultiTenantPrincipal("user-1", new TenantMetadata("tenant-1", "cluster-1")), 25L, ApiKeys.DELETE_TOPICS));
        String clientId = "client";
        long responseTimeNs = this.time.nanoseconds();
        for (TenantRequestConfiguration tenantRequest : tenantRequests) {
            TenantMetrics.MetricsRequestContext context = new TenantMetrics.MetricsRequestContext(tenantRequest.tenantPrincipal, clientId, tenantRequest.apikey);
            this.tenantMetrics.recordResponse(this.metrics, context, tenantRequest.requestSize, responseTimeNs, Collections.emptyMap(), this.time.milliseconds());
        }
        for (TenantRequestConfiguration tenantRequest : tenantRequests) {
            ApiSensors apiSensors = (ApiSensors)this.tenantMetrics.aggregateApiSensors.get(tenantRequest.apikey);
            Assert.assertNotNull((Object)apiSensors);
        }
        String aggregatedMetricsTag = String.format("%s-%s", "aggregate", "tenant-metrics");
        Map<String, KafkaMetric> responseMetrics = this.responseMetrics(aggregatedMetricsTag, ApiKeys.PRODUCE);
        Assert.assertEquals((long)8L, (long)responseMetrics.size());
        Assert.assertEquals((double)responseTimeNs, (double)((Double)responseMetrics.get(RESPONSE_TIME_NS_MAX).metricValue()), (double)0.0);
        Assert.assertEquals((double)responseTimeNs, (double)((Double)responseMetrics.get(RESPONSE_TIME_NS_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)responseTimeNs, (double)((Double)responseMetrics.get(RESPONSE_TIME_NS_AVG).metricValue()), (double)0.0);
        Assert.assertTrue(((Double)responseMetrics.get(RESPONSE_BYTE_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)150.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_TOTAL).metricValue()), (double)0.0);
        Assert.assertEquals((double)75.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_AVG).metricValue()), (double)0.0);
        Assert.assertEquals((double)50.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)100.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_MAX).metricValue()), (double)0.0);
        responseMetrics = this.responseMetrics(aggregatedMetricsTag, ApiKeys.FETCH);
        Assert.assertEquals((long)8L, (long)responseMetrics.size());
        Assert.assertEquals((double)responseTimeNs, (double)((Double)responseMetrics.get(RESPONSE_TIME_NS_MAX).metricValue()), (double)0.0);
        Assert.assertEquals((double)responseTimeNs, (double)((Double)responseMetrics.get(RESPONSE_TIME_NS_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)responseTimeNs, (double)((Double)responseMetrics.get(RESPONSE_TIME_NS_AVG).metricValue()), (double)0.0);
        Assert.assertTrue(((Double)responseMetrics.get(RESPONSE_BYTE_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)75.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_TOTAL).metricValue()), (double)0.0);
        Assert.assertEquals((double)75.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_AVG).metricValue()), (double)0.0);
        Assert.assertEquals((double)75.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)75.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_MAX).metricValue()), (double)0.0);
        responseMetrics = this.responseMetrics(aggregatedMetricsTag, ApiKeys.DELETE_TOPICS);
        Assert.assertEquals((long)8L, (long)responseMetrics.size());
        Assert.assertEquals((double)responseTimeNs, (double)((Double)responseMetrics.get(RESPONSE_TIME_NS_MAX).metricValue()), (double)0.0);
        Assert.assertEquals((double)responseTimeNs, (double)((Double)responseMetrics.get(RESPONSE_TIME_NS_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)responseTimeNs, (double)((Double)responseMetrics.get(RESPONSE_TIME_NS_AVG).metricValue()), (double)0.0);
        Assert.assertTrue(((Double)responseMetrics.get(RESPONSE_BYTE_RATE).metricValue() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)25.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_TOTAL).metricValue()), (double)0.0);
        Assert.assertEquals((double)25.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_AVG).metricValue()), (double)0.0);
        Assert.assertEquals((double)25.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_MIN).metricValue()), (double)0.0);
        Assert.assertEquals((double)25.0, (double)((Double)responseMetrics.get(RESPONSE_BYTE_MAX).metricValue()), (double)0.0);
    }

    private static class TenantRequestConfiguration {
        private final MultiTenantPrincipal tenantPrincipal;
        private final long requestSize;
        private final ApiKeys apikey;

        public TenantRequestConfiguration(MultiTenantPrincipal tenantPrincipal, long requestSize, ApiKeys apikey) {
            this.tenantPrincipal = tenantPrincipal;
            this.requestSize = requestSize;
            this.apikey = apikey;
        }
    }
}

