/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.multitenant.quota.ClusterMetadata;
import io.confluent.kafka.multitenant.quota.TestCluster;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClusterMetadataTest {
    private TestCluster testCluster;

    @Before
    public void setUp() {
        this.testCluster = new TestCluster();
    }

    @Test
    public void testRackAwareNoRacks() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        Assert.assertFalse((boolean)clusterMetadata.rackAware());
    }

    @Test
    public void testRackAwareOneBrokerHasRack() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, "rack1");
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        Assert.assertFalse((boolean)clusterMetadata.rackAware());
    }

    @Test
    public void testRackAwareAllBrokersHasRack() {
        this.testCluster.addNode(0, "rack1");
        this.testCluster.addNode(1, "rack2");
        this.testCluster.addNode(2, "rack3");
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        Assert.assertTrue((boolean)clusterMetadata.rackAware());
    }

    @Test
    public void testNodeReplicaCountsNoTopics() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        Map leaderCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList(), true);
        ClusterMetadata.ReplicaCounts zeroReplicaCounts = new ClusterMetadata.ReplicaCounts(0, 0);
        Assert.assertEquals((Object)zeroReplicaCounts, leaderCounts.get(0));
        Assert.assertEquals((Object)zeroReplicaCounts, leaderCounts.get(1));
        Assert.assertEquals((Object)zeroReplicaCounts, leaderCounts.get(2));
        Map followerCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList(), false);
        Assert.assertEquals((Object)zeroReplicaCounts, followerCounts.get(0));
        Assert.assertEquals((Object)zeroReplicaCounts, followerCounts.get(1));
        Assert.assertEquals((Object)zeroReplicaCounts, followerCounts.get(2));
    }

    @Test
    public void testNodeReplicaCountsOneTenantTopic() {
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ImmutableList assignment = ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2, (Object)0), (Object)ImmutableList.of((Object)2, (Object)0, (Object)1));
        this.testCluster.createPartitions("tenant1_topicA", 0, (List<List<Integer>>)assignment);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.ReplicaCounts nodeLeaderCounts = new ClusterMetadata.ReplicaCounts(1, 1);
        Map leaderCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList(), true);
        Assert.assertEquals((Object)nodeLeaderCounts, leaderCounts.get(0));
        Assert.assertEquals((Object)nodeLeaderCounts, leaderCounts.get(1));
        Assert.assertEquals((Object)nodeLeaderCounts, leaderCounts.get(2));
        ClusterMetadata.ReplicaCounts nodeFollowerCounts = new ClusterMetadata.ReplicaCounts(2, 2);
        Map followerCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList(), false);
        Assert.assertEquals((Object)nodeFollowerCounts, followerCounts.get(0));
        Assert.assertEquals((Object)nodeFollowerCounts, followerCounts.get(1));
        Assert.assertEquals((Object)nodeFollowerCounts, followerCounts.get(2));
    }

    @Test
    public void testNodeReplicaCountsMultipleTenants() {
        String tenant1 = "tenant1";
        String topic1 = "tenant1_topicA";
        String topic2 = "tenant2_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ImmutableList assignment = ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2, (Object)0), (Object)ImmutableList.of((Object)2, (Object)0, (Object)1));
        this.testCluster.createPartitions("tenant1_topicA", 0, (List<List<Integer>>)assignment);
        this.testCluster.createPartitions("tenant2_topicA", 0, (List<List<Integer>>)assignment);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.ReplicaCounts nodeLeaderCounts = new ClusterMetadata.ReplicaCounts(1, 2);
        Map leaderCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList(), true);
        Assert.assertEquals((Object)nodeLeaderCounts, leaderCounts.get(0));
        Assert.assertEquals((Object)nodeLeaderCounts, leaderCounts.get(1));
        Assert.assertEquals((Object)nodeLeaderCounts, leaderCounts.get(2));
        ClusterMetadata.ReplicaCounts nodeFollowerCounts = new ClusterMetadata.ReplicaCounts(2, 4);
        Map followerCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList(), false);
        Assert.assertEquals((Object)nodeFollowerCounts, followerCounts.get(0));
        Assert.assertEquals((Object)nodeFollowerCounts, followerCounts.get(1));
        Assert.assertEquals((Object)nodeFollowerCounts, followerCounts.get(2));
    }

    @Test
    public void testNodeReplicaCountsForOneExistingTenantTopic() {
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ImmutableList assignment = ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2, (Object)0), (Object)ImmutableList.of((Object)2, (Object)0, (Object)1), (Object)ImmutableList.of((Object)0, (Object)1, (Object)2));
        this.testCluster.createPartitions("tenant1_topicA", 0, (List<List<Integer>>)assignment);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        Map leaderCounts = clusterMetadata.nodeReplicaCounts(this.testCluster.cluster().partitionsForTopic("tenant1_topicA"), true);
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2, 2), leaderCounts.get(0));
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1, 1), leaderCounts.get(1));
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1, 1), leaderCounts.get(2));
        Map followerCounts = clusterMetadata.nodeReplicaCounts(this.testCluster.cluster().partitionsForTopic("tenant1_topicA"), false);
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2, 2), followerCounts.get(0));
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(3, 3, 3), followerCounts.get(1));
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(3, 3, 3), followerCounts.get(2));
    }

    @Test(expected=IllegalStateException.class)
    public void testNodeReplicaCountsForExistingTenantTopicWithInvalidAssignment() {
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        ImmutableList assignment = ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2, (Object)0), (Object)ImmutableList.of((Object)2, (Object)0, (Object)1));
        this.testCluster.createPartitions("tenant1_topicA", 0, (List<List<Integer>>)assignment);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        try {
            clusterMetadata.nodeReplicaCounts(this.testCluster.cluster().partitionsForTopic("tenant1_topicA"), true);
            Assert.fail((String)"Expected nodeReplicaCounts() to throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            clusterMetadata.nodeReplicaCounts(this.testCluster.cluster().partitionsForTopic("tenant1_topicA"), false);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testUpdateNodeMetadataWithInvalidAssignment() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        clusterMetadata.updateNodeMetadata((List)ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1, (Object)2)));
    }

    @Test
    public void testUpdateNodeMetadata() {
        String tenant = "tenant1";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ImmutableList assignment = ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2, (Object)0));
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster());
        clusterMetadata.updateNodeMetadata((List)assignment);
        Map leaderCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList(), true);
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), leaderCounts.get(0));
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), leaderCounts.get(1));
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(0, 0), leaderCounts.get(2));
        Map followerCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList(), false);
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), followerCounts.get(0));
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), followerCounts.get(1));
        Assert.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2), followerCounts.get(2));
    }

    @Test
    public void testReplicaCountsComparison() {
        ClusterMetadata.ReplicaCounts counts0 = new ClusterMetadata.ReplicaCounts(1, 2, 4);
        ClusterMetadata.ReplicaCounts counts1 = new ClusterMetadata.ReplicaCounts(1, 2, 3);
        ClusterMetadata.ReplicaCounts counts2 = new ClusterMetadata.ReplicaCounts(1, 4, 3);
        ClusterMetadata.ReplicaCounts counts3 = new ClusterMetadata.ReplicaCounts(3, 2, 3);
        ClusterMetadata.ReplicaCounts counts4 = new ClusterMetadata.ReplicaCounts(4, 5, 3);
        ClusterMetadata.ReplicaCounts counts5 = new ClusterMetadata.ReplicaCounts(4, 5, 3);
        Assert.assertTrue((counts0.compareTo(counts1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((counts0.compareTo(counts2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((counts4.compareTo(counts3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((counts3.compareTo(counts2) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)counts5.compareTo(counts4));
        Assert.assertTrue((counts5.compareTo(counts0) < 0 ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testReplicaCountsCompareToThrowsExceptionForNullParameter() {
        ClusterMetadata.ReplicaCounts counts = new ClusterMetadata.ReplicaCounts(1, 2, 4);
        counts.compareTo(null);
    }
}

