/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.quota.QuotaConfig;
import io.confluent.kafka.multitenant.quota.TenantQuotaCallback;
import io.confluent.kafka.multitenant.quota.TestCluster;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TenantQuotaCallbackTest {
    private static final double EPS = 1.0E-4;
    private static final Long MIN_BROKER_CONSUME_QUOTA = 20L;
    private static final Long MIN_BROKER_PRODUCE_QUOTA = 10L;
    private static final Long MAX_BROKER_CONSUME_QUOTA = 1200L;
    private static final Long MAX_BROKER_PRODUCE_QUOTA = 600L;
    private static final Double DEFAULT_CONTROLLER_QUOTA = 20.0;
    private final int brokerId = 1;
    private TestCluster testCluster;
    private TenantQuotaCallback quotaCallback;

    @Before
    public void setUp() {
        TenantQuotaCallback.closeAll();
        this.quotaCallback = new TenantQuotaCallback();
        Map<String, Object> configs = this.quotaCallbackProps();
        this.quotaCallback.configure(configs);
        HashMap<String, QuotaConfig> tenantQuotas = new HashMap<String, QuotaConfig>();
        tenantQuotas.put("tenant1", this.quotaConfig(1000L, 2000L, 300.0));
        tenantQuotas.put("tenant2", this.quotaConfig(2000L, 3000L, 400.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
    }

    @After
    public void tearDown() {
        this.quotaCallback.close();
    }

    @Test
    public void testTenantQuotaConstructor() {
        TenantQuotaCallback callback = new TenantQuotaCallback();
        callback.configure(Collections.singletonMap("broker.id", 0));
        TenantQuotaCallback tenantQuotaCallback = callback;
        tenantQuotaCallback.getClass();
        TenantQuotaCallback.TenantQuota unlimitedQuota = new TenantQuotaCallback.TenantQuota(tenantQuotaCallback, QuotaConfig.UNLIMITED_QUOTA);
        Assert.assertFalse((boolean)unlimitedQuota.hasQuotaLimit(ClientQuotaType.PRODUCE));
        Assert.assertFalse((boolean)unlimitedQuota.hasQuotaLimit(ClientQuotaType.FETCH));
        Assert.assertFalse((boolean)unlimitedQuota.hasQuotaLimit(ClientQuotaType.REQUEST));
        Assert.assertFalse((boolean)unlimitedQuota.hasQuotaLimit(ClientQuotaType.CONTROLLER_MUTATION));
        QuotaConfig defaultQuota = this.quotaConfig(102400L, 102400L, 50.0);
        Assert.assertTrue((boolean)defaultQuota.hasQuotaLimit(ClientQuotaType.PRODUCE));
        Assert.assertEquals((String)"Unexpected PRODUCE quota", (double)102400.0, (double)defaultQuota.quota(ClientQuotaType.PRODUCE), (double)1.0E-4);
        Assert.assertTrue((boolean)defaultQuota.hasQuotaLimit(ClientQuotaType.FETCH));
        Assert.assertEquals((String)"Unexpected FETCH quota", (double)102400.0, (double)defaultQuota.quota(ClientQuotaType.FETCH), (double)1.0E-4);
        Assert.assertTrue((boolean)defaultQuota.hasQuotaLimit(ClientQuotaType.REQUEST));
        Assert.assertEquals((String)"Unexpected REQUEST quota", (double)50.0, (double)defaultQuota.quota(ClientQuotaType.REQUEST), (double)1.0E-4);
        Assert.assertFalse((boolean)defaultQuota.hasQuotaLimit(ClientQuotaType.CONTROLLER_MUTATION));
        Assert.assertEquals((String)"Unexpected CONTROLLER_MUTATION quota", (double)2.147483647E9, (double)defaultQuota.quota(ClientQuotaType.CONTROLLER_MUTATION), (double)1.0E-4);
    }

    @Test
    public void testGetOrCreateTenantQuota() {
        TenantQuotaCallback newQuotaCallback = new TenantQuotaCallback();
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("broker.id", String.valueOf(1));
        configs.put("confluent.quota.tenant.default.controller.mutation.rate", DEFAULT_CONTROLLER_QUOTA);
        newQuotaCallback.configure(configs);
        TenantQuotaCallback.TenantQuota tenantQuota = newQuotaCallback.getOrCreateTenantQuota("tenantA", this.quotaConfig(204800L, 204800L, 500.0), false);
        Assert.assertTrue((boolean)tenantQuota.hasQuotaLimit(ClientQuotaType.PRODUCE));
        Assert.assertEquals((String)"Unexpected PRODUCE quota", (double)1.048576E7, (double)tenantQuota.quotaLimit(ClientQuotaType.PRODUCE), (double)1.0E-4);
        Assert.assertTrue((boolean)tenantQuota.hasQuotaLimit(ClientQuotaType.FETCH));
        Assert.assertEquals((String)"Unexpected FETCH quota", (double)1.048576E7, (double)tenantQuota.quotaLimit(ClientQuotaType.FETCH), (double)1.0E-4);
        Assert.assertTrue((boolean)tenantQuota.hasQuotaLimit(ClientQuotaType.REQUEST));
        Assert.assertEquals((String)"Unexpected REQUEST quota", (double)500.0, (double)tenantQuota.quotaLimit(ClientQuotaType.REQUEST), (double)1.0E-4);
        Assert.assertTrue((boolean)tenantQuota.hasQuotaLimit(ClientQuotaType.CONTROLLER_MUTATION));
        Assert.assertEquals((String)"Unexpected CONTROLLER_MUTATION quota", (double)DEFAULT_CONTROLLER_QUOTA, (double)tenantQuota.quotaLimit(ClientQuotaType.CONTROLLER_MUTATION), (double)1.0E-4);
        this.createCluster(5);
        this.testCluster.setPartitionLeaders("tenantA_topic1", 0, 1, 1);
        newQuotaCallback.updateClusterMetadata(this.testCluster.cluster());
        TenantQuotaCallback.TenantQuota tenantQuota2 = newQuotaCallback.getOrCreateTenantQuota("tenantA", this.quotaConfig(404800L, 404800L, 600.0), false);
        Assert.assertEquals((String)"Unexpected PRODUCE quota", (double)204800.0, (double)tenantQuota2.quotaLimit(ClientQuotaType.PRODUCE), (double)1.0E-4);
        Assert.assertEquals((String)"Unexpected FETCH quota", (double)204800.0, (double)tenantQuota2.quotaLimit(ClientQuotaType.FETCH), (double)1.0E-4);
        Assert.assertEquals((String)"Unexpected REQUEST quota", (double)500.0, (double)tenantQuota2.quotaLimit(ClientQuotaType.REQUEST), (double)1.0E-4);
        Assert.assertEquals((String)"Unexpected CONTROLLER_MUTATION quota", (double)DEFAULT_CONTROLLER_QUOTA, (double)tenantQuota.quotaLimit(ClientQuotaType.CONTROLLER_MUTATION), (double)1.0E-4);
        TenantQuotaCallback.TenantQuota updatedQuota = newQuotaCallback.getOrCreateTenantQuota("tenantA", this.quotaConfig(404800L, 404800L, 600.0), true);
        Assert.assertEquals((String)"Unexpected PRODUCE quota", (double)404800.0, (double)updatedQuota.quotaLimit(ClientQuotaType.PRODUCE), (double)1.0E-4);
        Assert.assertEquals((String)"Unexpected FETCH quota", (double)404800.0, (double)updatedQuota.quotaLimit(ClientQuotaType.FETCH), (double)1.0E-4);
        Assert.assertEquals((String)"Unexpected REQUEST quota", (double)600.0, (double)updatedQuota.quotaLimit(ClientQuotaType.REQUEST), (double)1.0E-4);
        Assert.assertEquals((String)"Unexpected CONTROLLER_MUTATION quota", (double)DEFAULT_CONTROLLER_QUOTA, (double)tenantQuota.quotaLimit(ClientQuotaType.CONTROLLER_MUTATION), (double)1.0E-4);
    }

    @Test
    public void testTenantQuota() {
        this.createCluster(5);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("userA", new TenantMetadata("tenant1", "tenant1_cluster_id"));
        this.setPartitionLeaders("tenant1_topic1", 0, 5, 1);
        this.setPartitionLeaders("tenant1_topic2", 0, 5, 2);
        this.verifyQuotas(principal, 500.0, 1000.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant2_topic1", 0, 5, 1);
        this.setPartitionLeaders("tenant2_topic2", 0, 5, 2);
        this.verifyQuotas(principal, 500.0, 1000.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.deleteTopic("tenant1_topic2");
        this.verifyQuotas(principal, MAX_BROKER_PRODUCE_QUOTA.longValue(), MAX_BROKER_CONSUME_QUOTA.longValue(), 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant1_topic3", 0, 5, 3);
        this.verifyQuotas(principal, 500.0, 1000.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant1_topic3", 1, 1, 1);
        this.verifyQuotas(principal, 500.0, 1000.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
    }

    @Test
    public void testTenantEqualQuotaDistribution() {
        this.createCluster(5);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("userA", new TenantMetadata("tenant1", "tenant1_cluster_id"));
        MultiTenantPrincipal principal2 = new MultiTenantPrincipal("userB", new TenantMetadata("tenant2", "tenant2_cluster_id"));
        this.setPartitionLeaders("tenant1_topic1", 0, 1, 1);
        this.setPartitionLeaders("tenant1_topic2", 0, 1000, 2);
        this.verifyQuotas(principal, 500.0, 1000.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant2_topic1", 0, 1000, 1);
        this.setPartitionLeaders("tenant2_topic2", 0, 1, 2);
        this.setPartitionLeaders("tenant2_topic3", 0, 1, 3);
        this.setPartitionLeaders("tenant2_topic4", 0, 1, 4);
        this.verifyQuotas(principal, 500.0, 1000.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.verifyQuotas(principal2, 500.0, 750.0, 400.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant1_topic3", 0, 10, 3);
        this.setPartitionLeaders("tenant1_topic4", 0, 100, 4);
        this.setPartitionLeaders("tenant1_topic5", 0, 500, 5);
        this.verifyQuotas(principal, 200.0, 400.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.deleteTopic("tenant1_topic2");
        this.verifyQuotas(principal, 250.0, 500.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
    }

    @Test
    public void testTenantQuotaUpdateSetsCorrectUpdateFlags() {
        int numBrokers = 10;
        String tenantName = "tenant1";
        String topic = "tenant1_topic1";
        HashMap<String, QuotaConfig> tenantQuotas = new HashMap<String, QuotaConfig>();
        tenantQuotas.put("tenant1", this.quotaConfig(3000L, 2000L, 300.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.PRODUCE));
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.FETCH));
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.REQUEST));
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.CONTROLLER_MUTATION));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.PRODUCE));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.FETCH));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.REQUEST));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.CONTROLLER_MUTATION));
        this.createCluster(10);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("userA", new TenantMetadata("tenant1", "tenant1_cluster_id"));
        for (int i = 1; i <= 10; ++i) {
            this.setPartitionLeaders("tenant1_topic1", i - 1, 1, i);
        }
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 300.0, "tenant1", false);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 200.0, "tenant1", false);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 300.0, "tenant1", false);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant1", false);
        tenantQuotas.put("tenant1", this.quotaConfig(2000L, 4000L, 500.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 200.0, "tenant1", true);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 400.0, "tenant1", true);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 500.0, "tenant1", true);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant1", false);
        tenantQuotas.put("tenant1", this.quotaConfig(1000L, 4000L, 500.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 100.0, "tenant1", true);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 400.0, "tenant1", false);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 500.0, "tenant1", false);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant1", false);
        tenantQuotas.put("tenant1", this.quotaConfig(1000L, 2000L, 500.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 100.0, "tenant1", false);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 200.0, "tenant1", true);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 500.0, "tenant1", false);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant1", false);
        tenantQuotas.put("tenant1", this.quotaConfig(1000L, 2000L, 200.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 100.0, "tenant1", false);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 200.0, "tenant1", false);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 200.0, "tenant1", true);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant1", false);
        MultiTenantPrincipal principal2 = new MultiTenantPrincipal("userB", new TenantMetadata("tenant2", "tenant2_cluster_id"));
        tenantQuotas.put("tenant2", this.quotaConfig(500L, 500L, 500.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.PRODUCE));
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.FETCH));
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.REQUEST));
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.CONTROLLER_MUTATION));
        this.setPartitionLeaders("tenant2_topic1", 0, 1, 1);
        this.verifyQuotas(principal2, 500.0, 500.0, 500.0, DEFAULT_CONTROLLER_QUOTA);
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.PRODUCE));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.FETCH));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.REQUEST));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.CONTROLLER_MUTATION));
        tenantQuotas.put("tenant2", this.quotaConfig(400L, 500L, 500.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        this.verifyQuotas(principal2, 400.0, 500.0, 500.0, DEFAULT_CONTROLLER_QUOTA);
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.PRODUCE));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.FETCH));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.REQUEST));
        Assert.assertFalse((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.CONTROLLER_MUTATION));
    }

    @Test
    public void testSmallNumberOfPartitions() throws Exception {
        this.createCluster(5);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("userA", new TenantMetadata("tenant1", "tenant1_cluster_id"));
        this.setPartitionLeaders("tenant1_topic1", 0, 1, 1);
        this.verifyQuotas(principal, MAX_BROKER_PRODUCE_QUOTA.longValue(), MAX_BROKER_CONSUME_QUOTA.longValue(), 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant1_topic2", 0, 1, 1);
        this.verifyQuotas(principal, MAX_BROKER_PRODUCE_QUOTA.longValue(), MAX_BROKER_CONSUME_QUOTA.longValue(), 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant1_topic3", 0, 2, 2);
        this.verifyQuotas(principal, 500.0, 1000.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant1_topic4", 0, 6, 3);
        this.verifyQuotas(principal, 333.0, 666.0, 300.0, DEFAULT_CONTROLLER_QUOTA);
    }

    @Test
    public void testNoPartitions() throws Exception {
        this.createCluster(5);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("userA", new TenantMetadata("tenant1", "tenant1_cluster_id"));
        this.verifyQuotas(principal, MIN_BROKER_PRODUCE_QUOTA.longValue(), MIN_BROKER_CONSUME_QUOTA.longValue(), 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant1_topic1", 0, 2, 1);
        this.verifyQuotas(principal, MAX_BROKER_PRODUCE_QUOTA.longValue(), MAX_BROKER_CONSUME_QUOTA.longValue(), 300.0, DEFAULT_CONTROLLER_QUOTA);
        this.createCluster(5);
        this.verifyQuotas(principal, MIN_BROKER_PRODUCE_QUOTA.longValue(), MIN_BROKER_CONSUME_QUOTA.longValue(), 300.0, DEFAULT_CONTROLLER_QUOTA);
    }

    @Test
    public void testNoClusterMetadata() {
        MultiTenantPrincipal principal = new MultiTenantPrincipal("userA", new TenantMetadata("tenant1", "tenant1_cluster_id"));
        this.verifyQuotas(principal, MIN_BROKER_PRODUCE_QUOTA.longValue(), MIN_BROKER_CONSUME_QUOTA.longValue(), 300.0, DEFAULT_CONTROLLER_QUOTA);
    }

    @Test
    public void testUnlimitedTenantQuota() {
        this.createCluster(5);
        HashMap<String, QuotaConfig> tenantQuotas = new HashMap<String, QuotaConfig>();
        tenantQuotas.put("tenant1", this.quotaConfig(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("userA", new TenantMetadata("tenant1", "tenant1_cluster_id"));
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 9.223372036854776E18, null);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 9.223372036854776E18, null);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 2.147483647E9, null);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant1");
        this.setPartitionLeaders("tenant1_topic1", 0, 5, 1);
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 9.223372036854776E18, null);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 9.223372036854776E18, null);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 2.147483647E9, null);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant1");
        this.setPartitionLeaders("tenant1_topic2", 0, 5, 2);
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 9.223372036854776E18, null);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 9.223372036854776E18, null);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 2.147483647E9, null);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant1");
        tenantQuotas.put("tenant1", this.quotaConfig(1000L, 2000L, 2.147483647E9));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 500.0, "tenant1");
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 1000.0, "tenant1");
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 2.147483647E9, null);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant1");
    }

    @Test
    public void testDefaultTenantQuota() {
        this.createCluster(5);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("userA", new TenantMetadata("tenant100", "tenant100_cluster_id"));
        this.setPartitionLeaders("tenant100_topic1", 0, 1, 1);
        this.setPartitionLeaders("tenant100_topic2", 0, 10, 2);
        this.setPartitionLeaders("tenant100_topic3", 0, 1, 3);
        this.setPartitionLeaders("tenant100_topic4", 0, 100, 4);
        this.setPartitionLeaders("tenant100_topic5", 0, 5, 5);
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, 9.223372036854776E18, null);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, 9.223372036854776E18, null);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, 2.147483647E9, null);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, DEFAULT_CONTROLLER_QUOTA, "tenant100");
        QuotaConfig defaultQuota = this.quotaConfig(1000L, 2000L, 10.0);
        TenantQuotaCallback.updateQuotas(Collections.emptyMap(), (QuotaConfig)defaultQuota);
        MultiTenantPrincipal principal2 = new MultiTenantPrincipal("userA", new TenantMetadata("tenant101", "tenant101_cluster_id"));
        this.setPartitionLeaders("tenant101_topic2", 0, 1, 2);
        this.setPartitionLeaders("tenant101_topic3", 0, 1, 3);
        this.setPartitionLeaders("tenant101_topic4", 0, 1, 4);
        this.setPartitionLeaders("tenant101_topic5", 0, 1, 5);
        this.verifyQuotas(principal2, MIN_BROKER_PRODUCE_QUOTA.longValue(), MIN_BROKER_CONSUME_QUOTA.longValue(), 10.0, DEFAULT_CONTROLLER_QUOTA);
        this.setPartitionLeaders("tenant101_topic1", 0, 1, 1);
        this.verifyQuotas(principal2, 200.0, 400.0, 10.0, DEFAULT_CONTROLLER_QUOTA);
        this.verifyQuotas(principal, 200.0, 400.0, 10.0, DEFAULT_CONTROLLER_QUOTA);
        QuotaConfig newDefaultQuota = this.quotaConfig(3000L, 6000L, 30.0);
        TenantQuotaCallback.updateQuotas(Collections.emptyMap(), (QuotaConfig)newDefaultQuota);
        this.quotaCallback.updateClusterMetadata(this.testCluster.cluster());
        this.verifyQuotas(principal2, 600.0, 1200.0, 30.0, DEFAULT_CONTROLLER_QUOTA);
        this.verifyQuotas(principal, 600.0, 1200.0, 30.0, DEFAULT_CONTROLLER_QUOTA);
    }

    @Test
    public void testNonTenantPrincipal() {
        this.createCluster(5);
        KafkaPrincipal principal = KafkaPrincipal.ANONYMOUS;
        for (ClientQuotaType quotaType : ClientQuotaType.values()) {
            this.verifyQuota(quotaType, principal, QuotaConfig.UNLIMITED_QUOTA.quota(quotaType), null);
        }
    }

    @Test
    public void testUnavailableBrokers() {
        this.createCluster(2);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("userA", new TenantMetadata("tenant1", "tenant1_cluster_id"));
        this.setPartitionLeaders("tenant1_topic1", 0, 1, 1);
        this.setPartitionLeaders("tenant1_topic2", 0, 1, 30);
        Assert.assertNull((String)"Unavailable node created", (Object)this.testCluster.cluster().nodeById(30));
        Assert.assertNull((String)"Unavailable node created", (Object)((PartitionInfo)this.testCluster.cluster().partitionsForTopic("tenant1_topic2").get(0)).leader());
        this.quotaCallback.updateClusterMetadata(this.testCluster.cluster());
        this.verifyQuotas(principal, MAX_BROKER_PRODUCE_QUOTA.longValue(), MAX_BROKER_CONSUME_QUOTA.longValue(), 300.0, DEFAULT_CONTROLLER_QUOTA);
    }

    @Test
    public void testReconfigure() {
        this.createCluster(5);
        MultiTenantPrincipal tenant100 = new MultiTenantPrincipal("userA", new TenantMetadata("tenant100", "tenant100_cluster_id"));
        MultiTenantPrincipal tenant200 = new MultiTenantPrincipal("userB", new TenantMetadata("tenant200", "tenant100_cluster_id"));
        MultiTenantPrincipal tenant300 = new MultiTenantPrincipal("userC", new TenantMetadata("tenant300", "tenant100_cluster_id"));
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)tenant100, DEFAULT_CONTROLLER_QUOTA, tenant100.tenantMetadata().tenantName);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)tenant200, DEFAULT_CONTROLLER_QUOTA, tenant200.tenantMetadata().tenantName);
        this.quotaCallback.reconfigure(Collections.singletonMap("confluent.quota.tenant.default.controller.mutation.rate", "10"));
        Assert.assertTrue((boolean)this.quotaCallback.quotaResetRequired(ClientQuotaType.CONTROLLER_MUTATION));
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)tenant100, 10.0, tenant100.tenantMetadata().tenantName);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)tenant200, 10.0, tenant200.tenantMetadata().tenantName);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)tenant300, 10.0, tenant300.tenantMetadata().tenantName);
    }

    @Test
    public void testDefaultControllerMutationQuota() {
        this.createCluster(5);
        TenantQuotaCallback.updateQuotas(Collections.singletonMap("tenantA", this.quotaConfig(10L, 20L, 30.0)), (QuotaConfig)QuotaConfig.UNLIMITED_QUOTA);
        Assert.assertEquals((Object)DEFAULT_CONTROLLER_QUOTA, (Object)this.quotaCallback.quotaLimit(ClientQuotaType.CONTROLLER_MUTATION, Collections.singletonMap("tenant", "tenantA")));
        Assert.assertEquals((Object)DEFAULT_CONTROLLER_QUOTA, (Object)this.quotaCallback.quotaLimit(ClientQuotaType.CONTROLLER_MUTATION, Collections.singletonMap("tenant", "tenantB")));
        Assert.assertEquals((Object)2.147483647E9, (Object)this.quotaCallback.quotaLimit(ClientQuotaType.CONTROLLER_MUTATION, Collections.emptyMap()));
    }

    private Map<String, Object> quotaCallbackProps() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("broker.id", String.valueOf(1));
        configs.put("confluent.quota.tenant.follower.broker.min.producer.rate", MIN_BROKER_PRODUCE_QUOTA.toString());
        configs.put("confluent.quota.tenant.broker.max.producer.rate", MAX_BROKER_PRODUCE_QUOTA.toString());
        configs.put("confluent.quota.tenant.follower.broker.min.consumer.rate", MIN_BROKER_CONSUME_QUOTA.toString());
        configs.put("confluent.quota.tenant.broker.max.consumer.rate", MAX_BROKER_CONSUME_QUOTA.toString());
        configs.put("confluent.quota.tenant.default.controller.mutation.rate", DEFAULT_CONTROLLER_QUOTA.toString());
        return configs;
    }

    private void createCluster(int numNodes) {
        this.testCluster = new TestCluster();
        for (int i = 1; i <= numNodes; ++i) {
            this.testCluster.addNode(i, "rack0");
        }
        Cluster cluster = this.testCluster.cluster();
        this.quotaCallback.updateClusterMetadata(cluster);
        Assert.assertEquals((Object)cluster, (Object)this.quotaCallback.cluster());
    }

    private void verifyQuotas(MultiTenantPrincipal principal, double produceQuota, double fetchQuota, double requestQuota, double controllerQuota) {
        String tenant = principal.tenantMetadata().tenantName;
        this.verifyQuota(ClientQuotaType.PRODUCE, (KafkaPrincipal)principal, produceQuota, tenant);
        this.verifyQuota(ClientQuotaType.FETCH, (KafkaPrincipal)principal, fetchQuota, tenant);
        this.verifyQuota(ClientQuotaType.REQUEST, (KafkaPrincipal)principal, requestQuota, tenant);
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, (KafkaPrincipal)principal, controllerQuota, tenant);
    }

    private void verifyQuota(ClientQuotaType type, KafkaPrincipal principal, double expectedValue, String expectedTenantTag) {
        this.verifyQuota(type, principal, expectedValue, expectedTenantTag, null);
    }

    private void verifyQuota(ClientQuotaType type, KafkaPrincipal principal, double expectedValue, String expectedTenantTag, Boolean expectQuotaResetRequired) {
        Map metricTags = this.quotaCallback.quotaMetricTags(type, principal, "some-client");
        if (expectedTenantTag != null) {
            Assert.assertEquals(Collections.singletonMap("tenant", expectedTenantTag), (Object)metricTags);
        } else {
            Assert.assertTrue((String)("Unexpected tags " + metricTags), (boolean)metricTags.isEmpty());
        }
        Double quotaLimit = this.quotaCallback.quotaLimit(type, metricTags);
        Assert.assertEquals((String)("Unexpected quota of type " + type), (double)expectedValue, (double)quotaLimit, (double)1.0E-4);
        if (expectQuotaResetRequired != null) {
            Assert.assertEquals((Object)expectQuotaResetRequired, (Object)this.quotaCallback.quotaResetRequired(type));
        }
    }

    private void setPartitionLeaders(String topic, int firstPartition, int count, Integer leaderBrokerId) {
        this.testCluster.setPartitionLeaders(topic, firstPartition, count, leaderBrokerId);
        this.quotaCallback.updateClusterMetadata(this.testCluster.cluster());
    }

    private void deleteTopic(String topic) {
        this.testCluster.deleteTopic(topic);
        this.quotaCallback.updateClusterMetadata(this.testCluster.cluster());
    }

    private QuotaConfig quotaConfig(long producerByteRate, long consumerByteRate, double requestPercentage) {
        return new QuotaConfig(Long.valueOf(producerByteRate), Long.valueOf(consumerByteRate), Double.valueOf(requestPercentage), null, QuotaConfig.UNLIMITED_QUOTA);
    }
}

