/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.schema;

import io.confluent.kafka.multitenant.schema.MultiTenantApis;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.Utils;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class MultiTenantApisTest {
    private final Map<ApiKeys, Integer> maxVerifiedVersions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ApiKeys.PRODUCE, (Object)9), Utils.mkEntry((Object)ApiKeys.FETCH, (Object)12), Utils.mkEntry((Object)ApiKeys.LIST_OFFSETS, (Object)6), Utils.mkEntry((Object)ApiKeys.METADATA, (Object)11), Utils.mkEntry((Object)ApiKeys.OFFSET_COMMIT, (Object)8), Utils.mkEntry((Object)ApiKeys.OFFSET_FETCH, (Object)7), Utils.mkEntry((Object)ApiKeys.FIND_COORDINATOR, (Object)3), Utils.mkEntry((Object)ApiKeys.JOIN_GROUP, (Object)7), Utils.mkEntry((Object)ApiKeys.HEARTBEAT, (Object)4), Utils.mkEntry((Object)ApiKeys.LEAVE_GROUP, (Object)4), Utils.mkEntry((Object)ApiKeys.SYNC_GROUP, (Object)5), Utils.mkEntry((Object)ApiKeys.DESCRIBE_GROUPS, (Object)5), Utils.mkEntry((Object)ApiKeys.LIST_GROUPS, (Object)4), Utils.mkEntry((Object)ApiKeys.DELETE_GROUPS, (Object)2), Utils.mkEntry((Object)ApiKeys.SASL_HANDSHAKE, (Object)1), Utils.mkEntry((Object)ApiKeys.API_VERSIONS, (Object)3), Utils.mkEntry((Object)ApiKeys.CREATE_TOPICS, (Object)7), Utils.mkEntry((Object)ApiKeys.DELETE_TOPICS, (Object)6), Utils.mkEntry((Object)ApiKeys.DELETE_RECORDS, (Object)2), Utils.mkEntry((Object)ApiKeys.INIT_PRODUCER_ID, (Object)4), Utils.mkEntry((Object)ApiKeys.ADD_PARTITIONS_TO_TXN, (Object)3), Utils.mkEntry((Object)ApiKeys.ADD_OFFSETS_TO_TXN, (Object)3), Utils.mkEntry((Object)ApiKeys.END_TXN, (Object)3), Utils.mkEntry((Object)ApiKeys.TXN_OFFSET_COMMIT, (Object)3), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CONFIGS, (Object)4), Utils.mkEntry((Object)ApiKeys.ALTER_CONFIGS, (Object)2), Utils.mkEntry((Object)ApiKeys.INCREMENTAL_ALTER_CONFIGS, (Object)1), Utils.mkEntry((Object)ApiKeys.SASL_AUTHENTICATE, (Object)2), Utils.mkEntry((Object)ApiKeys.CREATE_ACLS, (Object)2), Utils.mkEntry((Object)ApiKeys.DESCRIBE_ACLS, (Object)2), Utils.mkEntry((Object)ApiKeys.DELETE_ACLS, (Object)2), Utils.mkEntry((Object)ApiKeys.CREATE_PARTITIONS, (Object)3), Utils.mkEntry((Object)ApiKeys.OFFSET_FOR_LEADER_EPOCH, (Object)4), Utils.mkEntry((Object)ApiKeys.REPLICA_STATUS, (Object)3), Utils.mkEntry((Object)ApiKeys.OFFSET_DELETE, (Object)0), Utils.mkEntry((Object)ApiKeys.CREATE_CLUSTER_LINKS, (Object)0), Utils.mkEntry((Object)ApiKeys.LIST_CLUSTER_LINKS, (Object)1), Utils.mkEntry((Object)ApiKeys.DELETE_CLUSTER_LINKS, (Object)0), Utils.mkEntry((Object)ApiKeys.ALTER_MIRRORS, (Object)2), Utils.mkEntry((Object)ApiKeys.LIST_MIRRORS, (Object)0), Utils.mkEntry((Object)ApiKeys.DESCRIBE_MIRRORS, (Object)0), Utils.mkEntry((Object)ApiKeys.INITIATE_REVERSE_CONNECTIONS, (Object)0), Utils.mkEntry((Object)ApiKeys.REVERSE_CONNECTION, (Object)0), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CLUSTER, (Object)0)});

    @Test
    public void testIsApiAllowedHandlesAllApiVersions() {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> unverifiedVersionApis = new HashSet<ApiKeys>();
        for (ApiKeys api : ApiKeys.zkBrokerApis()) {
            try {
                Optional<Integer> maxValidatedVersion;
                if (!MultiTenantApis.isApiAllowed((ApiKeys)api) || (maxValidatedVersion = Optional.ofNullable(this.maxVerifiedVersions.get(api))).isPresent() && api.latestVersion() <= maxValidatedVersion.get()) continue;
                unverifiedVersionApis.add(api);
            }
            catch (IllegalArgumentException e) {
                unhandledApis.add(api);
            }
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis, (String)("The following APIs are not handled: " + unhandledApis));
        Assertions.assertEquals(Collections.emptySet(), unverifiedVersionApis, (String)("The following exposed APIs have unverified version bumps: " + unhandledApis));
    }
}

