/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.schema;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.schema.TenantContext;
import org.junit.Assert;
import org.junit.Test;

public class TenantContextTest {
    @Test(expected=IllegalArgumentException.class)
    public void testTenantNameCannotIncludePrefixDelimeter() {
        new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("foo_bar", "cluster")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTenantNameIsValidTopicPrefix() {
        new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("foo|bar", "cluster")));
    }

    @Test
    public void shouldExtractValidPrefix() throws Exception {
        Assert.assertEquals((Object)"confluent_", (Object)TenantContext.extractTenantPrefix((String)"confluent_foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailExtractingMissingPrefix() throws Exception {
        TenantContext.extractTenantPrefix((String)"blah");
    }

    @Test
    public void shouldIdentifyPrefixedTopics() throws Exception {
        Assert.assertTrue((boolean)TenantContext.isTenantPrefixed((String)"confluent_foo"));
        Assert.assertFalse((boolean)TenantContext.isTenantPrefixed((String)"blah"));
        Assert.assertFalse((boolean)TenantContext.isTenantPrefixed(null));
        Assert.assertFalse((boolean)TenantContext.isTenantPrefixed((String)"__consumer_offsets"));
        Assert.assertFalse((boolean)TenantContext.isTenantPrefixed((String)"_confluent_metrics"));
    }

    @Test
    public void shouldIdentifyTopicsWithTenantPrefix() throws Exception {
        Assert.assertTrue((boolean)TenantContext.hasTenantPrefix((String)"confluent_", (String)"confluent_foo"));
        Assert.assertFalse((boolean)TenantContext.hasTenantPrefix((String)"xyz_", (String)"confluent_foo"));
        Assert.assertFalse((boolean)TenantContext.hasTenantPrefix((String)"blah", (String)"blah"));
        Assert.assertFalse((boolean)TenantContext.hasTenantPrefix((String)"confluent_", null));
    }

    @Test
    public void shouldRemoveAllTenantPrefixes() throws Exception {
        TenantContext context = new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("tenant", "cluster")));
        String uncleaned = "Failed to create topics tenant_foo, tenant_tenantbar, and tenant_tenant_blah";
        Assert.assertEquals((long)("tenant_".length() * 4), (long)context.sizeOfRemovedPrefixes(uncleaned));
        String cleaned = context.removeAllTenantPrefixes(uncleaned);
        Assert.assertEquals((Object)"Failed to create topics foo, tenantbar, and blah", (Object)cleaned);
    }

    @Test
    public void shouldQuoteTenantNameInPattern() throws Exception {
        TenantContext context = new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("bl.h", "cluster")));
        String uncleaned = "This matches 'bl.h_foo'. This does not: blah_foo";
        String cleaned = context.removeAllTenantPrefixes(uncleaned);
        Assert.assertEquals((Object)"This matches 'foo'. This does not: blah_foo", (Object)cleaned);
    }

    @Test
    public void shouldPermitEmptyGroupId() throws Exception {
        TenantContext context = new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("tenant", "cluster")));
        String groupId = context.addTenantPrefix("");
        Assert.assertEquals((Object)"tenant_", (Object)groupId);
        Assert.assertEquals((Object)"", (Object)context.removeTenantPrefix("tenant_"));
        String message = "This is a message referring to the empty group 'tenant_'";
        Assert.assertTrue((boolean)message.contains(context.prefix()));
        String cleanedMessage = context.removeAllTenantPrefixes(message);
        Assert.assertFalse((boolean)cleanedMessage.contains(context.prefix()));
    }
}

