/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer;

import io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizerTest;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;

public class ConfluentServerAuthorizerTest
extends AclAuthorizerTest {
    public void tearDown() {
        super.tearDown();
        KafkaTestUtils.verifyThreadCleanup();
    }

    public AclAuthorizer createAclAuthorizer() {
        return this.aclAuthorizer(this.createAuthorizer());
    }

    protected Authorizer createAuthorizer() {
        return new TestAuthorizer();
    }

    protected AclAuthorizer aclAuthorizer(final Authorizer authorizer) {
        return new AclAuthorizer(){

            public void configure(Map<String, ?> javaConfigs) {
                authorizer.configure(javaConfigs);
            }

            public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
                return authorizer.start(serverInfo);
            }

            public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
                return authorizer.authorize(requestContext, actions);
            }

            public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
                return authorizer.createAcls(requestContext, aclBindings);
            }

            public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
                return authorizer.deleteAcls(requestContext, aclBindingFilters);
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                return authorizer.acls(filter);
            }

            public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
                return authorizer.authorizeByResourceType(requestContext, op, resourceType);
            }

            public void close() {
                try {
                    authorizer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static class TestAuthorizer
    extends ConfluentServerAuthorizer {
        private final ConfluentAuthorizerServerInfo serverInfo = KafkaTestUtils.serverInfo("clusterA", SecurityProtocol.SSL);

        private TestAuthorizer() {
        }

        public void configure(Map<String, ?> configs) {
            super.configure(configs);
            this.configureServerInfo(this.serverInfo);
        }
    }
}

