/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.AuthAttemptCache;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthAttemptCacheTest {
    private AuthAttemptCache authCache;

    @Before
    public void setUp() {
        this.authCache = new AuthAttemptCache();
    }

    @Test
    public void testGetNone() {
        Assert.assertNull((Object)this.authCache.get("no_user", "no_pwd"));
    }

    @Test
    public void testGetSameUserDifferentPassword() {
        this.authCache.put("fred", "foo", "hash");
        Assert.assertNull((Object)this.authCache.get("fred", "bar"));
    }

    @Test
    public void testGetDifferentUserDifferentPassword() {
        this.authCache.put("fred", "foo", "hash");
        Assert.assertNull((Object)this.authCache.get("joe", "bar"));
    }

    @Test
    public void testGetDifferentUserSamePassword() {
        this.authCache.put("fred", "foo", "hash");
        Assert.assertNull((Object)this.authCache.get("joe", "foo"));
    }

    @Test
    public void testGet() {
        String hash = "some hash";
        this.authCache.put("fred", "foo", hash);
        Assert.assertEquals((Object)hash, (Object)this.authCache.get("fred", "foo"));
    }

    @Test
    public void testGetMultiple() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.authCache.put("fred" + i, "foo", "hash" + i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("hash" + i), (Object)this.authCache.get("fred" + i, "foo"));
        }
    }

    @Test
    public void testTtl() {
        long ttl = 100L;
        MockTime time = new MockTime();
        this.authCache = new AuthAttemptCache(ttl, 10000, (Time)time, 10);
        String hash = "some hash";
        this.authCache.put("fred", "pwd", hash);
        Assert.assertEquals((Object)hash, (Object)this.authCache.get("fred", "pwd"));
        time.sleep(ttl - 1L);
        this.authCache.get("foo", "bar");
        Assert.assertEquals((Object)hash, (Object)this.authCache.get("fred", "pwd"));
        time.sleep(ttl - 1L);
        this.authCache.get("foo", "bar");
        Assert.assertEquals((Object)hash, (Object)this.authCache.get("fred", "pwd"));
        time.sleep(ttl);
        this.authCache.get("foo", "bar");
        Assert.assertNull((Object)this.authCache.get("fred", "pwd"));
    }

    @Test
    public void testMaxEntries() {
        this.authCache = new AuthAttemptCache(60000L, 100, Time.SYSTEM, 10);
        for (int i = 0; i < 200; ++i) {
            this.authCache.put("fred" + i, "pwd", "some hash");
        }
        int cachedCount = 0;
        for (int i = 0; i < 200; ++i) {
            if (this.authCache.get("fred" + i, "pwd") == null) continue;
            ++cachedCount;
        }
        Assert.assertEquals((long)100L, (long)cachedCount);
    }
}

