/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsLoaderTest;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsStore;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MultiTenantSaslSecretsStoreTest {
    private static final String TOPIC = "confluent.cdc.api.keys.topic";
    private static final String HEADER_KEY = "_sequence_id";
    static final String JSON1 = MultiTenantSaslSecretsLoaderTest.JSON1;
    static final String JSON2 = MultiTenantSaslSecretsLoaderTest.JSON2;
    static final String MALFORMED_JSON = MultiTenantSaslSecretsLoaderTest.MALFORMED_JSON;
    static final String JSON_WITH_NULL = MultiTenantSaslSecretsLoaderTest.JSON_WITH_NULL;
    static final String JSON_WITH_MISSING_FIELDS = MultiTenantSaslSecretsLoaderTest.JSON_WITH_MISSING_FIELDS;
    private MultiTenantSaslSecretsStore store;
    @Mock
    private KafkaBasedLog<String, String> secretsLog;

    @Before
    public void setUp() throws Exception {
        this.secretsLog = (KafkaBasedLog)EasyMock.createMock(KafkaBasedLog.class);
        this.store = new MultiTenantSaslSecretsStore(new HashMap());
        this.store.configure(this.secretsLog);
    }

    @Test
    public void testRead() {
        this.store.start();
        long seqId1 = 1L;
        ConsumerRecord<String, String> record = this.createConsumerRecord(seqId1, HEADER_KEY, JSON1);
        Assert.assertNull((Object)this.store.lastSequenceId);
        this.store.read(record);
        Assert.assertEquals((long)seqId1, (long)this.store.lastSequenceId);
        long seqId2 = seqId1 + 1L;
        record = this.createConsumerRecord(seqId2, HEADER_KEY, JSON2);
        Assert.assertNotNull((Object)this.store.lastSequenceId);
        this.store.read(record);
        Assert.assertEquals((long)seqId2, (long)this.store.lastSequenceId);
    }

    @Test
    public void testReadRecordWithMissingHeader() {
        this.store.start();
        ConsumerRecord<String, String> record = new ConsumerRecord<String, String>(TOPIC, 0, 0L, (Object)"", (Object)JSON1);
        Assert.assertNull((Object)this.store.lastSequenceId);
        this.store.read((ConsumerRecord)record);
        Assert.assertNull((Object)this.store.lastSequenceId);
        record = this.createConsumerRecord(123L, "invalid-header-key", JSON1);
        Assert.assertNull((Object)this.store.lastSequenceId);
        this.store.read(record);
        Assert.assertNull((Object)this.store.lastSequenceId);
    }

    @Test
    public void testRecordMessageInvalid() {
        this.store.start();
        ConsumerRecord<String, String> record1 = this.createConsumerRecord(123L, HEADER_KEY, "invalid-msg");
        Assert.assertNull((Object)this.store.lastSequenceId);
        Assert.assertThrows(ConfigException.class, () -> this.store.read(record1));
        Assert.assertNull((Object)this.store.lastSequenceId);
        ConsumerRecord<String, String> record2 = this.createConsumerRecord(123L, HEADER_KEY, MALFORMED_JSON);
        Assert.assertNull((Object)this.store.lastSequenceId);
        Assert.assertThrows(ConfigException.class, () -> this.store.read(record2));
        Assert.assertNull((Object)this.store.lastSequenceId);
        ConsumerRecord<String, String> record3 = this.createConsumerRecord(123L, HEADER_KEY, JSON_WITH_NULL);
        Assert.assertNull((Object)this.store.lastSequenceId);
        Assert.assertThrows(ConfigException.class, () -> this.store.read(record3));
        Assert.assertNull((Object)this.store.lastSequenceId);
        ConsumerRecord<String, String> record4 = this.createConsumerRecord(123L, HEADER_KEY, JSON_WITH_MISSING_FIELDS);
        Assert.assertNull((Object)this.store.lastSequenceId);
        Assert.assertThrows(ConfigException.class, () -> this.store.read(record4));
        Assert.assertNull((Object)this.store.lastSequenceId);
    }

    @Test
    public void testLoad() {
        this.setupMockLoad();
        this.store.start();
        long seqId = 123L;
        ConsumerRecord<String, String> record = this.createConsumerRecord(seqId, HEADER_KEY, JSON1);
        Assert.assertNull((Object)this.store.lastSequenceId);
        this.store.read(record);
        Assert.assertEquals((long)seqId, (long)this.store.lastSequenceId);
        MultiTenantSaslSecrets secrets1 = this.store.load();
        MultiTenantSaslConfigEntry entry = (MultiTenantSaslConfigEntry)secrets1.entries().get("key1");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"user1", (Object)entry.userId());
        Assert.assertEquals((Object)"myCluster", (Object)entry.logicalClusterId());
        Assert.assertEquals((Object)"PLAIN", (Object)entry.saslMechanism());
        Assert.assertEquals((Object)"no hash", (Object)entry.hashedSecret());
        Assert.assertEquals((Object)"none", (Object)entry.hashFunction());
        MultiTenantSaslConfigEntry entry2 = (MultiTenantSaslConfigEntry)secrets1.entries().get("key2");
        Assert.assertNotNull((Object)entry2);
        Assert.assertEquals((Object)"user2", (Object)entry2.userId());
        Assert.assertEquals((Object)"myCluster2", (Object)entry2.logicalClusterId());
        Assert.assertEquals((Object)"SSL", (Object)entry2.saslMechanism());
        Assert.assertEquals((Object)"no hash", (Object)entry2.hashedSecret());
        Assert.assertEquals((Object)"none", (Object)entry2.hashFunction());
        EasyMock.verify((Object[])new Object[]{this.secretsLog});
    }

    @Test
    public void testReloadNewRecord() {
        this.setupMockLoad();
        this.store.start();
        long seqId1 = 123L;
        ConsumerRecord<String, String> record = this.createConsumerRecord(seqId1, HEADER_KEY, JSON1);
        Assert.assertNull((Object)this.store.lastSequenceId);
        this.store.read(record);
        Assert.assertEquals((long)seqId1, (long)this.store.lastSequenceId);
        MultiTenantSaslSecrets secrets1 = this.store.load();
        long seqId2 = seqId1 + 1L;
        record = this.createConsumerRecord(seqId2, HEADER_KEY, JSON2);
        Assert.assertEquals((long)seqId1, (long)this.store.lastSequenceId);
        this.store.read(record);
        Assert.assertEquals((long)seqId2, (long)this.store.lastSequenceId);
        MultiTenantSaslSecrets secrets2 = this.store.load();
        Assert.assertNotEquals((Object)secrets1, (Object)secrets2);
        EasyMock.verify((Object[])new Object[]{this.secretsLog});
    }

    @Test
    public void testIgnoreOldMessage() {
        this.setupMockLoad();
        this.store.start();
        long seqId1 = 123L;
        ConsumerRecord<String, String> record = this.createConsumerRecord(seqId1, HEADER_KEY, JSON1);
        Assert.assertNull((Object)this.store.lastSequenceId);
        this.store.read(record);
        Assert.assertEquals((long)seqId1, (long)this.store.lastSequenceId);
        MultiTenantSaslSecrets secrets1 = this.store.load();
        long seqId2 = seqId1 - 1L;
        record = this.createConsumerRecord(seqId2, HEADER_KEY, JSON1);
        Assert.assertEquals((long)seqId1, (long)this.store.lastSequenceId);
        this.store.read(record);
        Assert.assertEquals((long)seqId1, (long)this.store.lastSequenceId);
        MultiTenantSaslSecrets secrets2 = this.store.load();
        Assert.assertEquals((Object)secrets1, (Object)secrets2);
        EasyMock.verify((Object[])new Object[]{this.secretsLog});
    }

    private void setupMockLoad() {
        this.secretsLog.start();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.secretsLog});
    }

    private ConsumerRecord<String, String> createConsumerRecord(long seqId, String headerKey, String value) {
        RecordHeaders headers = this.createHeaders(headerKey, seqId);
        return new ConsumerRecord(TOPIC, 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, Long.valueOf(-1L), -1, -1, (Object)"key", (Object)value, (Headers)headers);
    }

    private RecordHeaders createHeaders(String key, long seqId) {
        Header[] headerArr = new Header[]{new RecordHeader(key, this.longToBytes(seqId))};
        return new RecordHeaders(headerArr);
    }

    private byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }
}

