/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import java.util.Optional;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.junit.Assert;
import org.junit.Test;

public class SniValidationModeTest {
    private static final String UNRECOGNIZED_MODE = "unrecognized_mode";
    private static final String EXPECTED_LKC = "lkc-123";
    private static final String WRONG_LKC = "lkc-wrong";
    private static final String WRONG_PKC = "pkc-wrong";
    private static final String HOST_NAME_SUFFIX = "-00aa.confluent.io";

    @Test
    public void fromStringTest() {
        Assert.assertEquals((String)"Should return optional_validation if input is null", (Object)SniValidationMode.OPTIONAL_VALIDATION, (Object)SniValidationMode.fromString(null));
        Assert.assertEquals((String)"Should return optional_validation if input is not recognized", (Object)SniValidationMode.OPTIONAL_VALIDATION, (Object)SniValidationMode.fromString((String)UNRECOGNIZED_MODE));
        Assert.assertEquals((String)"Should parse optional_validation successfully", (Object)SniValidationMode.OPTIONAL_VALIDATION, (Object)SniValidationMode.fromString((String)SniValidationMode.OPTIONAL_VALIDATION.getText()));
        Assert.assertEquals((String)"Should parse allow_legacy_bootstrap successfully", (Object)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP, (Object)SniValidationMode.fromString((String)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText()));
        Assert.assertEquals((String)"Should parse strict successfully", (Object)SniValidationMode.STRICT, (Object)SniValidationMode.fromString((String)SniValidationMode.STRICT.getText()));
    }

    @Test
    public void isSniHostNameMatchedOptionalTest() {
        Assert.assertTrue((String)"SNI hostname should match if the supplied cluster name is the same as expected in optional mode", (boolean)SniValidationMode.OPTIONAL_VALIDATION.sniHostNameMatches(EXPECTED_LKC, Optional.of(EXPECTED_LKC), this.constructSNIHostNameFor(EXPECTED_LKC)));
        Assert.assertTrue((String)"SNI hostname should match regardless in optional mode", (boolean)SniValidationMode.OPTIONAL_VALIDATION.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), this.constructSNIHostNameFor(WRONG_PKC)));
        Assert.assertTrue((String)"SNI hostname should match if hostname is empty in optional mode", (boolean)SniValidationMode.OPTIONAL_VALIDATION.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), Optional.empty()));
        Assert.assertFalse((String)"SNI hostname shouldn't match in optional mode if supplied cluster name is different from expected", (boolean)SniValidationMode.OPTIONAL_VALIDATION.sniHostNameMatches(EXPECTED_LKC, Optional.of(WRONG_LKC), this.constructSNIHostNameFor(WRONG_LKC)));
    }

    @Test
    public void isSniHostNameMatchedLegacyTest() {
        Assert.assertTrue((String)"SNI hostname should match if supplied cluster name is the same as expected in legacy mode", (boolean)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.sniHostNameMatches(EXPECTED_LKC, Optional.of(EXPECTED_LKC), this.constructSNIHostNameFor(EXPECTED_LKC)));
        Assert.assertTrue((String)"SNI hostname should match in legacy mode if supplied cluster name starts with `pkc-`. We accept any SNI hostname that starts with `pkc-` since it is the bootstrap path and we don't have a mapping for the correct PKC.", (boolean)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), this.constructSNIHostNameFor(WRONG_PKC)));
        Assert.assertFalse((String)"SNI hostname shouldn't match in legacy mode if supplied cluster name is different from expected", (boolean)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.sniHostNameMatches(EXPECTED_LKC, Optional.of(WRONG_LKC), this.constructSNIHostNameFor(WRONG_LKC)));
        Assert.assertFalse((String)"SNI hostname shouldn't match in legacy mode if cluster name is not supplied", (boolean)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), Optional.empty()));
    }

    @Test
    public void isSniHostNameMatchedStrictTest() {
        Assert.assertTrue((String)"SNI hostname should match if the supplied cluster name is the same as expected in strict mode", (boolean)SniValidationMode.STRICT.sniHostNameMatches(EXPECTED_LKC, Optional.of(EXPECTED_LKC), this.constructSNIHostNameFor(EXPECTED_LKC)));
        Assert.assertFalse((String)"SNI hostname shouldn't match if the supplied cluster name is not the same as expected in strict mode", (boolean)SniValidationMode.STRICT.sniHostNameMatches(EXPECTED_LKC, Optional.of(WRONG_LKC), this.constructSNIHostNameFor(WRONG_LKC)));
        Assert.assertFalse((String)"SNI hostname shouldn't match if supplied cluster name is not the same as expected even if it starts with `pkc-` in strict mode", (boolean)SniValidationMode.STRICT.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), this.constructSNIHostNameFor(WRONG_PKC)));
        Assert.assertFalse((String)"SNI hostname shouldn't match if supplied cluster name is not supplied in strict mode", (boolean)SniValidationMode.STRICT.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), Optional.empty()));
    }

    private Optional<PathAwareSniHostName> constructSNIHostNameFor(String clusterId) {
        return Optional.of(new PathAwareSniHostName(clusterId + HOST_NAME_SUFFIX));
    }
}

