/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.kafka.test.TestUtils;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthUtils {
    private static final Logger log = LoggerFactory.getLogger(OAuthUtils.class);

    public static JwsContainer setUpJws(Integer expiration, String issuer, String subject, String[] allowedClusters) throws Exception {
        KeyPair keyPair = OAuthUtils.generateKeyPair();
        String jws = OAuthUtils.sign(keyPair.getPrivate(), expiration, issuer, subject, allowedClusters);
        File publicKeyFile = TestUtils.tempFile();
        OAuthUtils.writePemFile(publicKeyFile, keyPair.getPublic());
        return new JwsContainer(jws, publicKeyFile);
    }

    static void writePemFile(File publicKeyFile, PublicKey publicKey) throws IOException {
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new FileWriter(publicKeyFile));
        pemWriter.writeObject((Object)publicKey);
        pemWriter.close();
    }

    static KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        return keyGen.genKeyPair();
    }

    private static String sign(PrivateKey key, Integer expiration, String issuer, String subject, String[] allowedClusters) {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setIssuer(issuer);
            if (expiration != null) {
                NumericDate expirationTime = NumericDate.now();
                expirationTime.addSeconds((long)(expiration / 1000));
                claims.setExpirationTime(expirationTime);
            }
            claims.setGeneratedJwtId();
            claims.setIssuedAtToNow();
            claims.setNotBeforeMinutesInThePast(2.0f);
            claims.setStringListClaim("clusters", allowedClusters);
            if (subject != null) {
                claims.setSubject(subject);
            }
            claims.setClaim("monitoring", (Object)true);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)key);
            jws.setAlgorithmHeaderValue("RS256");
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            log.error("Error creating JWS for test");
            return null;
        }
    }

    public static class JwsContainer {
        private final String jwsToken;
        private final File publicKeyFile;

        JwsContainer(String jwsToken, File publicKeyFile) {
            this.jwsToken = jwsToken;
            this.publicKeyFile = publicKeyFile;
        }

        public File getPublicKeyFile() {
            return this.publicKeyFile;
        }

        public String getJwsToken() {
            return this.jwsToken;
        }
    }
}

