/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.server.plugins.policy.CreateTopicPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateTopicPolicyTest {
    private static final String TENANT = "xx";
    private static final String TOPIC = "xx_test-topic";
    private static final short REPLICATION_FACTOR = 3;
    private static final short MIN_IN_SYNC_REPLICAS = 1;
    private static final int MAX_PARTITIONS = 21;
    private static final int MAX_MESSAGE_BYTES = 4242;
    private CreateTopicPolicy policy;
    private Map<String, String> topicConfigs;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("confluent.plugins.topic.policy.replication.factor", String.valueOf(3));
        config.put("confluent.plugins.topic.policy.max.partitions.per.tenant", String.valueOf(21));
        this.policy = new CreateTopicPolicy();
        this.policy.configure(config);
        this.topicConfigs = new HashMap<String, String>();
        this.topicConfigs.put("max.message.bytes", String.valueOf(4242));
        this.topicConfigs.put("min.insync.replicas", String.valueOf(1));
        this.topicConfigs = Collections.unmodifiableMap(this.topicConfigs);
    }

    @Test
    public void testValidateOk() {
        int currentPartitions = 10;
        int requestedPartitions = 10;
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 10));
        this.policy.ensureValidPartitionCount(TENANT, 10);
    }

    @Test
    public void acceptsExactlyMaxPartitions() {
        int currentPartitions = 10;
        int requestedPartitions = 11;
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 10));
        this.policy.ensureValidPartitionCount(TENANT, 11);
    }

    @Test
    public void testValidateDoesNotCountOtherTopicPartitions() {
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 21));
        this.policy.ensureValidPartitionCount("badprefix_", 21);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectsRequestOverMaxNumberOfPartitions() {
        int currentPartitions = 10;
        int requestedPartitions = 12;
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 10));
        this.policy.ensureValidPartitionCount(TENANT, 12);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectsCurrentExceedMaxNumberOfPartitions() {
        int currentPartitions = 10;
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 10));
        this.policy.ensureValidPartitionCount(TENANT, 22);
    }

    @Test(expected=NotControllerException.class)
    public void rejectsWhenTopicMetadataNotSet() {
        this.policy.ensureValidPartitionCount(TENANT, 1);
    }

    @Test
    public void returnsZeroWhenTopicMetadataSetButTenantMissing() {
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 5));
        String nonExistingTenant = "axx_";
        this.policy.ensureValidPartitionCount(nonExistingTenant, 0);
    }

    @Test
    public void validateParamsSetOk() {
        this.updateTopicMetadata(Collections.emptyMap());
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)3), null, this.topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void validateNoReplicationNoTopicConfigGivenOk() {
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 5));
        Map topicConfigs = Collections.emptyMap();
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(10), null, null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void validateValidTopicConfigsOk() {
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 5));
        Map<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("cleanup.policy", "delete");
        topicConfigs.put("max.message.bytes", "100");
        topicConfigs.put("message.timestamp.difference.max.ms", "100");
        topicConfigs.put("message.timestamp.type", "CreateTime");
        topicConfigs.put("min.compaction.lag.ms", "100");
        topicConfigs.put("max.compaction.lag.ms", "604800000");
        topicConfigs.put("min.insync.replicas", Integer.toString(2));
        topicConfigs.put("retention.bytes", "100");
        topicConfigs.put("retention.ms", "135217728");
        topicConfigs.put("segment.ms", "600000");
        topicConfigs = Collections.unmodifiableMap(topicConfigs);
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(10), null, null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void rejectSchemaValidationProperties() {
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 5));
        Assert.assertThrows(PolicyViolationException.class, () -> this.policy.validate(new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(10), null, null, Collections.singletonMap("confluent.key.schema.validation", "true"))));
        Assert.assertThrows(PolicyViolationException.class, () -> this.policy.validate(new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(10), null, null, Collections.singletonMap("confluent.key.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy"))));
        Assert.assertThrows(PolicyViolationException.class, () -> this.policy.validate(new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(10), null, null, Collections.singletonMap("confluent.value.schema.validation", "true"))));
        Assert.assertThrows(PolicyViolationException.class, () -> this.policy.validate(new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(10), null, null, Collections.singletonMap("confluent.value.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy"))));
    }

    @Test
    public void acceptSchemaValidationPropertiesWhenFeatureEnabled() {
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 5));
        HashMap<String, String> policyConfigs = new HashMap<String, String>();
        policyConfigs.put("confluent.schema.validator.multitenant.enable", "true");
        policyConfigs.put("confluent.plugins.topic.policy.replication.factor", String.valueOf(3));
        this.policy.configure(policyConfigs);
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("confluent.key.schema.validation", "true");
        topicConfigs.put("confluent.key.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
        topicConfigs.put("confluent.value.schema.validation", "false");
        topicConfigs.put("confluent.value.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
        this.policy.validate(new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(10), null, null, topicConfigs));
    }

    @Test
    public void validateValidPartitionAssignmentOk() {
        this.updateTopicMetadata(Collections.singletonMap(TOPIC, 5));
        List<Integer> part0Assignment = Arrays.asList(0, 1, 2);
        List<Integer> part1Assignment = Arrays.asList(3, 4, 5);
        HashMap<Integer, List<Integer>> replicaAssignments = new HashMap<Integer, List<Integer>>();
        replicaAssignments.put(0, part0Assignment);
        replicaAssignments.put(1, part1Assignment);
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, null, null, replicaAssignments, this.topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void validatePartitionAssignmentWithInvalidNumberOfReplicasNotOk() {
        List<Integer> part0Assignment = Arrays.asList(0, 1, 2, 3, 4, 5);
        List<Integer> part1Assignment = Arrays.asList(1, 2, 3, 4, 5, 6);
        HashMap<Integer, List<Integer>> replicaAssignments = new HashMap<Integer, List<Integer>>();
        replicaAssignments.put(0, part0Assignment);
        replicaAssignments.put(1, part1Assignment);
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, null, null, replicaAssignments, this.topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void validatePartitionAssignmentWithNoReplicasNotOk() throws Exception {
        List emptyAssignment = Collections.emptyList();
        HashMap replicaAssignments = new HashMap();
        replicaAssignments.put(0, emptyAssignment);
        replicaAssignments.put(1, emptyAssignment);
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, null, null, replicaAssignments, this.topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void validateInvalidTopicConfigsNotOk() throws Exception {
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("delete.retention.ms", "100");
        topicConfigs.put("min.insync.replicas", Integer.toString(3));
        topicConfigs.put("retention.ms", "135217728");
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(10), null, null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectsNoPartitionCountGiven() throws Exception {
        Map topicConfigs = Collections.emptyMap();
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, null, null, null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectsBadRepFactor() throws Exception {
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)6), null, this.topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectsSmallMinIsrs() throws Exception {
        Map<String, String> topicConfigs = Collections.singletonMap("min.insync.replicas", Integer.toString(0));
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)3), null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectsLargeMinIsrs() throws Exception {
        Map<String, String> topicConfigs = Collections.singletonMap("min.insync.replicas", Integer.toString(3));
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)3), null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectsEmptyTopicName() {
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata("lkc123_", Integer.valueOf(3), Short.valueOf((short)3), null, Collections.emptyMap());
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectsInvalidTopicName() {
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata("lkc123_::", Integer.valueOf(3), Short.valueOf((short)3), null, Collections.emptyMap());
        this.policy.validate(requestMetadata);
    }

    @Test
    public void acceptsValidMinIsr() throws Exception {
        HashMap<String, Integer> topicPartitions = new HashMap<String, Integer>();
        topicPartitions.put("xyz_foo", 3);
        this.updateTopicMetadata(topicPartitions);
        Map<String, String> topicConfigs = Collections.singletonMap("min.insync.replicas", Integer.toString(1));
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)3), null, topicConfigs);
        this.policy.validate(requestMetadata);
        Map<String, String> topicConfigs2 = Collections.singletonMap("min.insync.replicas", Integer.toString(2));
        CreateTopicPolicy.RequestMetadata requestMetadata2 = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)3), null, topicConfigs2);
        this.policy.validate(requestMetadata2);
    }

    @Test(expected=RuntimeException.class)
    public void rejectsBadNumPartitions() throws Exception {
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(22), Short.valueOf((short)3), null, this.topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectDeleteRetentionMsTooHigh() {
        Map<String, String> topicConfigs = Collections.singletonMap("delete.retention.ms", "60566400001");
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)3), null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectSegmentBytesTooLow() {
        Map<String, String> topicConfigs = Collections.singletonMap("segment.bytes", "52428799");
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)3), null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectSegmentBytesTooHigh() {
        Map<String, String> topicConfigs = Collections.singletonMap("segment.bytes", "1073741825");
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)3), null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test(expected=PolicyViolationException.class)
    public void rejectSegmentMsTooLow() {
        Map<String, String> topicConfigs = Collections.singletonMap("segment.ms", "500000");
        CreateTopicPolicy.RequestMetadata requestMetadata = new CreateTopicPolicy.RequestMetadata(TOPIC, Integer.valueOf(21), Short.valueOf((short)3), null, topicConfigs);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void testNumPartitions() {
        HashMap<String, Integer> topicPartitions0 = new HashMap<String, Integer>();
        topicPartitions0.put("xyz_foo", 3);
        topicPartitions0.put("xyz_bar", 3);
        topicPartitions0.put("__consumer_offsets", 3);
        topicPartitions0.put("_confluent_metrics", 3);
        this.updateTopicMetadata(topicPartitions0);
        Assert.assertEquals((long)6L, (long)this.policy.numPartitions("xyz"));
        Assert.assertEquals((long)0L, (long)this.policy.numPartitions("xyz_"));
        Assert.assertEquals((long)0L, (long)this.policy.numPartitions("_"));
        Assert.assertEquals((long)0L, (long)this.policy.numPartitions(""));
        HashMap<String, Integer> topicPartitions1 = new HashMap<String, Integer>();
        topicPartitions1.put("xyz_foo", 3);
        topicPartitions1.put("__consumer_offsets", 3);
        this.updateTopicMetadata(topicPartitions1);
        Assert.assertEquals((long)3L, (long)this.policy.numPartitions("xyz"));
    }

    @Test
    public void testNumPartitionMetrics() {
        Metrics metrics = new Metrics();
        this.policy.registerMetrics(metrics);
        HashMap<String, Integer> topicPartitions0 = new HashMap<String, Integer>();
        topicPartitions0.put("abc_foo", 2);
        topicPartitions0.put("abc_bar", 2);
        topicPartitions0.put("xyz_foo", 3);
        topicPartitions0.put("xyz_bar", 3);
        this.updateTopicMetadata(topicPartitions0);
        Assert.assertEquals((long)4L, (long)this.policy.numPartitions("abc"));
        Assert.assertEquals((long)6L, (long)this.policy.numPartitions("xyz"));
        Assert.assertEquals((Object)4, (Object)this.metricValue(metrics, "abc"));
        Assert.assertEquals((Object)6, (Object)this.metricValue(metrics, "xyz"));
        HashMap<String, Integer> topicPartitions1 = new HashMap<String, Integer>();
        topicPartitions1.put("xyz_foo", 3);
        this.updateTopicMetadata(topicPartitions1);
        Assert.assertEquals((long)0L, (long)this.policy.numPartitions("abc"));
        Assert.assertEquals((long)3L, (long)this.policy.numPartitions("xyz"));
        Assert.assertEquals((Object)0, (Object)this.metricValue(metrics, "abc"));
        Assert.assertEquals((Object)3, (Object)this.metricValue(metrics, "xyz"));
        HashMap<String, Integer> topicPartitions2 = new HashMap<String, Integer>();
        topicPartitions2.put("xyz_foo", 1);
        this.updateTopicMetadata(topicPartitions2);
        Assert.assertEquals((long)0L, (long)this.policy.numPartitions("abc"));
        Assert.assertEquals((long)1L, (long)this.policy.numPartitions("xyz"));
        Assert.assertNull((Object)this.metricValue(metrics, "abc"));
        Assert.assertEquals((Object)1, (Object)this.metricValue(metrics, "xyz"));
        metrics.close();
    }

    private Integer metricValue(Metrics metrics, String tenant) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("tenant", tenant);
        MetricName name = metrics.metricName("partitions", "tenant-metrics", "", tags);
        KafkaMetric metric = metrics.metric(name);
        if (metric != null) {
            return (Integer)metric.metricValue();
        }
        return null;
    }

    private void updateTopicMetadata(Map<String, Integer> topicToNumPartitions) {
        this.policy.topicMetadataUpdated(CreateTopicPolicyTest.createTopicPartitions(topicToNumPartitions));
    }

    private static List<TopicPartition> createTopicPartitions(Map<String, Integer> topicToNumPartitions) {
        ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
        for (Map.Entry<String, Integer> entry : topicToNumPartitions.entrySet()) {
            String topic = entry.getKey();
            int numPartitions = entry.getValue();
            for (int i = 0; i < numPartitions; ++i) {
                topicPartitions.add(new TopicPartition(topic, i));
            }
        }
        return topicPartitions;
    }
}

