/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import io.confluent.kafka.link.ClusterLinkInterceptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.LinkMode;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterLinkInterceptorTest {
    private final String localTenantPrefix = "dest_tenant_";
    private final String linkName = "dest_tenant_link";
    private final Map<String, ?> configs = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ClusterLinkManager.LocalTenantPrefixProp(), (Object)"dest_tenant_"), Utils.mkEntry((Object)ClusterLinkManager.LinkNameProp(), (Object)"dest_tenant_link")});

    @Test
    public void testConfigure() {
        ClusterLinkInterceptor interceptor = new ClusterLinkInterceptor();
        Assertions.assertThrows(ConfigException.class, () -> interceptor.configure(Collections.emptyMap()));
        interceptor.configure(this.configs);
    }

    @Test
    public void testServiceLoader() {
        ClientInterceptor interceptor = ClusterLinkManager.prefixInterceptor((String)"dest_tenant_", (String)"", (String)"dest_tenant_link", (LinkMode)LinkMode.Destination$.MODULE$, null, (boolean)true, (boolean)true);
        Assertions.assertNotNull((Object)interceptor);
        Assertions.assertTrue((boolean)(interceptor instanceof ClusterLinkInterceptor));
    }

    @Test
    public void testNonServiceLoader() {
        ClientInterceptor interceptor = ClusterLinkManager.prefixInterceptor((String)"dest_tenant_", (String)"", (String)"dest_tenant_link", (LinkMode)LinkMode.Destination$.MODULE$, null, (boolean)false, (boolean)true);
        Assertions.assertNotNull((Object)interceptor);
        Assertions.assertTrue((boolean)(interceptor instanceof ClusterLinkInterceptor));
    }

    @Test
    public void testEnsureConnectionAllowed() throws IOException {
        ClientInterceptor interceptor = ClusterLinkManager.prefixInterceptor((String)"dest_tenant_", (String)"", (String)"dest_tenant_link", (LinkMode)LinkMode.Destination$.MODULE$, null, (boolean)true, (boolean)true);
        Assertions.assertNotNull((Object)interceptor);
        interceptor.ensureConnectionAllowed(new InetSocketAddress(InetAddress.getByAddress(new byte[]{11, 0, 0, 1}), 9071));
        interceptor.ensureConnectionAllowed(new InetSocketAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 9092));
        Assertions.assertThrows(IOException.class, () -> interceptor.ensureConnectionAllowed(new InetSocketAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 9071)));
        Assertions.assertThrows(IOException.class, () -> interceptor.ensureConnectionAllowed(new InetSocketAddress(InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1}), 9071)));
        Assertions.assertThrows(IOException.class, () -> interceptor.ensureConnectionAllowed(new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 0, 0, 1}), 9071)));
    }
}

