/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.multitenant.LogicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.quota.QuotaConfig;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Formatter;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LogicalClusterMetadataTest {
    private Path tempDir;

    @BeforeEach
    public void setUp() {
        this.tempDir = TestUtils.tempDirectory().toPath();
    }

    @Test
    public void testLoadMetadataFromFile() throws IOException {
        Path metaFile = Files.createFile(this.tempDir.resolve("lkc-xyz.json"), new FileAttribute[0]);
        Files.write(metaFile, Utils.logicalClusterJsonString(Utils.LC_META_XYZ).getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assertions.assertEquals((Object)Utils.LC_META_XYZ, (Object)meta);
        Assertions.assertTrue((boolean)meta.isValid());
    }

    @Test
    public void testLoadMetadataWithNonDefaultOverheadAndRequestRate() throws IOException {
        Path metaFile = Files.createFile(this.tempDir.resolve("lkc-abc.json"), new FileAttribute[0]);
        Files.write(metaFile, Utils.logicalClusterJsonString(Utils.LC_META_ABC).getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assertions.assertEquals((Object)Utils.LC_META_ABC, (Object)meta);
        Assertions.assertTrue((boolean)meta.isValid());
    }

    @Test
    public void testDefaultHeadroom() throws IOException {
        LogicalClusterMetadata legacyQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0x500000L), Long.valueOf(0x500000L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null, "new-org", "new-env");
        Assertions.assertEquals((Integer)LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, (Integer)legacyQuotaMeta.networkQuotaOverhead());
        QuotaConfig quotaConfig = legacyQuotaMeta.quotaConfig();
        Assertions.assertEquals((double)5242880.0, (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assertions.assertEquals((double)5242880.0, (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assertions.assertEquals((double)Utils.LC_META_ABC.brokerRequestPercentage(), (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
        LogicalClusterMetadata largeConsumeQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0x100000L), Long.valueOf(0x6400000L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null, "new-org", "new-env");
        Assertions.assertEquals((Integer)LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, (Integer)largeConsumeQuotaMeta.networkQuotaOverhead());
        quotaConfig = largeConsumeQuotaMeta.quotaConfig();
        Assertions.assertEquals((double)1048576.0, (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assertions.assertEquals((double)1.048576E8, (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assertions.assertEquals((double)Utils.LC_META_ABC.brokerRequestPercentage(), (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
        LogicalClusterMetadata largeQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0x6400000L), Long.valueOf(0x6400000L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null, "new-org", "new-env");
        Assertions.assertEquals((Integer)LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, (Integer)largeQuotaMeta.networkQuotaOverhead());
        quotaConfig = largeQuotaMeta.quotaConfig();
        Assertions.assertEquals((double)1.048576E8, (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assertions.assertEquals((double)1.048576E8, (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assertions.assertEquals((double)Utils.LC_META_ABC.brokerRequestPercentage(), (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
    }

    @Test
    public void testZeroQuotas() throws IOException {
        LogicalClusterMetadata zeroQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0L), Long.valueOf(0L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null, "new-org", "new-env");
        Assertions.assertEquals((Long)LogicalClusterMetadata.DEFAULT_MIN_NETWORK_BYTE_RATE, (Long)zeroQuotaMeta.producerByteRate());
        Assertions.assertEquals((Long)LogicalClusterMetadata.DEFAULT_MIN_NETWORK_BYTE_RATE, (Long)zeroQuotaMeta.consumerByteRate());
        LogicalClusterMetadata produceZeroQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0L), Long.valueOf(0x6400000L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null, "new-org", "new-env");
        Assertions.assertEquals((Long)LogicalClusterMetadata.DEFAULT_MIN_NETWORK_BYTE_RATE, (Long)produceZeroQuotaMeta.producerByteRate());
        Assertions.assertEquals((long)0x6400000L, (long)produceZeroQuotaMeta.consumerByteRate());
        QuotaConfig quotaConfig = produceZeroQuotaMeta.quotaConfig();
        Assertions.assertEquals((double)LogicalClusterMetadata.DEFAULT_MIN_NETWORK_BYTE_RATE.longValue(), (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assertions.assertEquals((double)1.048576E8, (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assertions.assertEquals((double)Utils.LC_META_ABC.brokerRequestPercentage(), (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
    }

    @Test
    public void testLifeCycleMetadataOfLiveCluster() throws IOException {
        Path metaFile = Files.createFile(this.tempDir.resolve("lkc-xyz.json"), new FileAttribute[0]);
        Files.write(metaFile, Utils.logicalClusterJsonString(Utils.LC_META_XYZ).getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assertions.assertEquals((Object)Utils.LC_META_XYZ, (Object)meta);
        Assertions.assertEquals((Object)meta.lifecycleMetadata().logicalClusterName(), (Object)"lkc-xyz");
    }

    @Test
    public void testLifeCycleMetadataOfDeadCluster() throws IOException {
        Path metaFile = Files.createFile(this.tempDir.resolve("lkc-abs.json"), new FileAttribute[0]);
        Files.write(metaFile, Utils.logicalClusterJsonString(Utils.LC_META_DED).getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assertions.assertEquals((Object)Utils.LC_META_DED, (Object)meta);
        Assertions.assertTrue((boolean)meta.lifecycleMetadata().deletionDate().before(new Date()));
    }

    @Test
    public void testMetadataWithNoByteRatesIsValid() throws IOException {
        String lcId = "lkc-fhg";
        String invalidMeta = "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"kafka\"}";
        Path metaFile = Files.createFile(this.tempDir.resolve("lkc-fhg.json"), new FileAttribute[0]);
        Files.write(metaFile, "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"kafka\"}".getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assertions.assertNotNull((Object)meta);
        Assertions.assertTrue((boolean)meta.isValid());
        Assertions.assertNull((Object)meta.producerByteRate());
        Assertions.assertNull((Object)meta.consumerByteRate());
        Assertions.assertEquals((double)LogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER, (double)meta.brokerRequestPercentage(), (double)0.001);
        QuotaConfig quotaConfig = meta.quotaConfig();
        Assertions.assertEquals((double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.PRODUCE), (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assertions.assertEquals((double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.FETCH), (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assertions.assertEquals((double)LogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER, (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
    }

    @Test
    public void testLoadMetadataWithInvalidClusterType() throws IOException {
        String lcId = "lkc-fhg";
        String invalidMeta = "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"not-kafka\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": 1024,\"network_egress_byte_rate\": 1024}";
        Path metaFile = Files.createFile(this.tempDir.resolve("lkc-fhg.json"), new FileAttribute[0]);
        Files.write(metaFile, "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"not-kafka\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": 1024,\"network_egress_byte_rate\": 1024}".getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assertions.assertNotNull((Object)meta);
        Assertions.assertFalse((boolean)meta.isValid());
        Assertions.assertEquals((Object)"lkc-fhg", (Object)meta.logicalClusterId());
        Assertions.assertEquals((Long)1024L, (Long)meta.producerByteRate());
        Assertions.assertEquals((Long)1024L, (Long)meta.consumerByteRate());
    }

    @Test
    public void testLoadMetadataWithMaxQuotas() throws IOException {
        String lcId = "lkc-fhg";
        String metadataTemplate = "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"nobody-cares\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": %d,\"network_egress_byte_rate\": %d,\"max_network_ingress_byte_rate\": %d,\"max_network_egress_byte_rate\": %d}";
        File metaFile = Files.createFile(this.tempDir.resolve("lkc-fhg.1.json"), new FileAttribute[0]).toFile();
        Formatter formatter = new Formatter(metaFile.toString());
        formatter.format("{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"nobody-cares\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": %d,\"network_egress_byte_rate\": %d,\"max_network_ingress_byte_rate\": %d,\"max_network_egress_byte_rate\": %d}", 1024L, 1024L, 2048L, 2048L);
        formatter.close();
        LogicalClusterMetadata meta = this.loadFromFile(metaFile.toPath());
        Assertions.assertNotNull((Object)meta);
        Assertions.assertFalse((boolean)meta.isValid());
        Assertions.assertEquals((Long)2048L, (Long)meta.producerByteRate());
        Assertions.assertEquals((Long)2048L, (Long)meta.consumerByteRate());
        metaFile = Files.createFile(this.tempDir.resolve("lkc-fhg.2.json"), new FileAttribute[0]).toFile();
        formatter = new Formatter(metaFile.toString());
        formatter.format("{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"nobody-cares\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": %d,\"network_egress_byte_rate\": %d,\"max_network_ingress_byte_rate\": %d,\"max_network_egress_byte_rate\": %d}", 1024L, 1024L, -1L, -1L);
        formatter.close();
        meta = this.loadFromFile(metaFile.toPath());
        Assertions.assertNotNull((Object)meta);
        Assertions.assertFalse((boolean)meta.isValid());
        Assertions.assertEquals((Long)1024L, (Long)meta.producerByteRate());
        Assertions.assertEquals((Long)1024L, (Long)meta.consumerByteRate());
    }

    @Test
    public void testEnvironmentId() throws IOException {
        String lcId = "lkc-abc1";
        String metadataJson = "{\"logical_cluster_id\": \"" + lcId + "\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account_id\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"kafka\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": 1024,\"network_egress_byte_rate\": 1024}";
        Path metaFile = Files.createFile(this.tempDir.resolve(lcId + ".json"), new FileAttribute[0]);
        Files.write(metaFile, metadataJson.getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assertions.assertNotNull((Object)meta);
        Assertions.assertEquals((Object)"account_id", (Object)meta.accountId());
        Assertions.assertEquals((Object)"account_id", (Object)meta.environmentId());
        lcId = "lkc-abc2";
        metadataJson = "{\"logical_cluster_id\": \"" + lcId + "\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"environment_id\": \"environment_id\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"kafka\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": 1024,\"network_egress_byte_rate\": 1024}";
        metaFile = Files.createFile(this.tempDir.resolve(lcId + ".json"), new FileAttribute[0]);
        Files.write(metaFile, metadataJson.getBytes(), new OpenOption[0]);
        meta = this.loadFromFile(metaFile);
        Assertions.assertNotNull((Object)meta);
        Assertions.assertNull((Object)meta.accountId());
        Assertions.assertEquals((Object)"environment_id", (Object)meta.environmentId());
    }

    @Test
    public void testLoadFromProto() {
        LogicalClusterMetadata[] tests;
        for (LogicalClusterMetadata lcm : tests = new LogicalClusterMetadata[]{Utils.LC_META_XYZ, Utils.LC_META_ABC, Utils.LC_META_DED, Utils.LC_META_HEALTHCHECK, Utils.LC_META_LINK_HEALTHCHECK}) {
            LogicalClusterMetadata protoRoundtrip = LogicalClusterMetadata.fromProtobuf((LogicalCluster)Utils.protoFromMetadata(lcm));
            Assertions.assertEquals((Object)lcm, (Object)protoRoundtrip);
            Assertions.assertTrue((boolean)protoRoundtrip.isValid());
        }
    }

    @Test
    public void testZeroDeactivationDateProto() {
        LogicalClusterMetadata protoRoundTrip = LogicalClusterMetadata.fromProtobuf((LogicalCluster)Utils.protoFromMetadata(Utils.LC_META_ZERO_DEACTIVATION_DATE));
        Assertions.assertNull((Object)protoRoundTrip.lifecycleMetadata().deletionDate());
        Assertions.assertTrue((boolean)protoRoundTrip.isValid());
    }

    private LogicalClusterMetadata loadFromFile(Path metaFile) {
        LogicalClusterMetadata retMeta = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            retMeta = (LogicalClusterMetadata)objectMapper.readValue(metaFile.toFile(), LogicalClusterMetadata.class);
        }
        catch (IOException ioe) {
            Assertions.fail((String)("Failed to read logical cluster metadata from file " + metaFile));
        }
        return retMeta;
    }
}

