/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.SslCertificateManager;
import io.confluent.kafka.multitenant.Utils;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.verification.VerificationMode;

public class SslCertificateManagerTest {
    private static final long TEST_MAX_WAIT_MS = TimeUnit.SECONDS.toMillis(60L);
    private static final String SSL_CERTS_DIR = "mnt/sslcerts/";
    private static final String DATA_DIR = "..data";
    private static final String BROKER_ID = "0";
    private static final URL TEST_SSL_CERTS_MAY = SslCertificateManagerTest.class.getResource("/cert_exp_may");
    private static final URL TEST_SSL_CERTS_AUG = SslCertificateManagerTest.class.getResource("/cert_exp_aug");
    private static final URL TEST_ROOT = SslCertificateManagerTest.class.getResource("/");
    private ConfluentAdmin mockAdminClient;
    private SslCertificateManager sslCache;
    private Path tempDir;

    @BeforeEach
    public void setUp() throws Exception {
        this.tempDir = TestUtils.tempDirectory().toPath();
        System.out.println("root resource: " + TEST_ROOT.getPath());
        Node node = new Node(0, "localhost", 9092);
        String sslCertsPath = this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "spec.json";
        this.mockAdminClient = (ConfluentAdmin)Mockito.spy((Object)new MockAdminClient(Collections.singletonList(node), node));
        this.sslCache = new SslCertificateManager((Object)BROKER_ID, (Object)sslCertsPath, this.mockAdminClient);
    }

    @AfterEach
    public void teardown() {
        this.sslCache.shutdown();
        this.sslCache.close();
    }

    @Test
    public void testAdminClientInvokedAfterCertificateSync() throws Exception {
        Utils.deleteFiles(this.tempDir, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testAdminClientNotInvokedWithoutReadPermissionForCerts() throws Exception {
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        String fullchainFilepath = this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "/" + DATA_DIR + "/fullchain.pem";
        String privkeyFilepath = this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "/" + DATA_DIR + "/privkey.pem";
        Files.setPosixFilePermissions(Paths.get(fullchainFilepath, new String[0]), PosixFilePermissions.fromString("-wx-wx-wx"));
        Files.setPosixFilePermissions(Paths.get(privkeyFilepath, new String[0]), PosixFilePermissions.fromString("-wx-wx-wx"));
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testAdminClientNotInvokedWithoutSpecFile() throws Exception {
        String specfile = "spec.json";
        Utils.moveFile(specfile, TEST_SSL_CERTS_AUG, TEST_ROOT);
        Utils.deleteFiles(this.tempDir, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.moveFile(specfile, TEST_ROOT, TEST_SSL_CERTS_AUG);
    }

    @Test
    public void testAdminClientNotInvokedWithoutPKCSCertificate() throws Exception {
        String pkcsfile = "pkcs.p12";
        Utils.moveFile(pkcsfile, TEST_SSL_CERTS_AUG, TEST_ROOT);
        Utils.deleteFiles(this.tempDir, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.moveFile(pkcsfile, TEST_ROOT, TEST_SSL_CERTS_AUG);
    }

    @Test
    public void testAdminClientNotInvokedWithoutPrivkeyPemFile() throws Exception {
        String privkeyfile = "privkey.pem";
        Utils.moveFile(privkeyfile, TEST_SSL_CERTS_AUG, TEST_ROOT);
        Utils.deleteFiles(this.tempDir, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_ROOT, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.moveFile(privkeyfile, TEST_ROOT, TEST_SSL_CERTS_AUG);
    }

    @Test
    public void testAdminClientNotInvokedWithoutFullchainPemFile() throws Exception {
        String fullchainfile = "fullchain.pem";
        Utils.moveFile(fullchainfile, TEST_SSL_CERTS_AUG, TEST_ROOT);
        Utils.deleteFiles(this.tempDir, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.moveFile(fullchainfile, TEST_ROOT, TEST_SSL_CERTS_AUG);
    }

    private boolean verifyIncerementalAlterConfigsCalls(int wantedNumberOfInvocations) {
        try {
            ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
            return true;
        }
        catch (MockitoAssertionError e) {
            return false;
        }
    }

    @Test
    public void testAdminClientInvocationOnIdenticalSslCertsSync() throws Exception {
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        this.sslCache.startWatching();
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.deleteFiles(this.tempDir, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.timeout((long)TEST_MAX_WAIT_MS).times(1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testAdminClientInvocationOnDifferentSslCertsSync() throws Exception {
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        this.sslCache.startWatching();
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.deleteFiles(this.tempDir, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        TestUtils.waitForCondition(() -> this.verifyIncerementalAlterConfigsCalls(2), (long)TEST_MAX_WAIT_MS, (String)"Should call after sync");
        Utils.deleteFiles(this.tempDir, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        TestUtils.waitForCondition(() -> this.verifyIncerementalAlterConfigsCalls(3), (long)TEST_MAX_WAIT_MS, (String)"Should call after sync");
    }

    @Test
    public void testWatchServiceDoesNotTerminateOnDirectoryDeletion() throws Exception {
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        this.sslCache.startWatching();
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Utils.deleteFiles(this.tempDir, SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        TestUtils.waitForCondition(() -> this.verifyIncerementalAlterConfigsCalls(2), (long)TEST_MAX_WAIT_MS, (String)"Should call after sync");
    }
}

