/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.LogicalClusterMetadata;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantLifecycleManager;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.schema.TenantContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TenantLifecycleManagerTest {
    private static final Long TEST_DELETE_DELAY_MS = 0L;
    private ConfluentAdmin mockAdminClient;
    private TenantLifecycleManager lifecycleManagerWithDeleteDelay;
    private TenantLifecycleManager lifecycleManager;

    @BeforeEach
    public void setUp() throws Exception {
        Node node = new Node(0, "localhost", 9092);
        this.mockAdminClient = (ConfluentAdmin)Mockito.spy((Object)new MockAdminClient(Collections.singletonList(node), node));
        DescribeAclsResult emptyAcls = (DescribeAclsResult)Mockito.mock(DescribeAclsResult.class);
        ((DescribeAclsResult)Mockito.doReturn((Object)KafkaFuture.completedFuture(Collections.emptySet())).when((Object)emptyAcls)).values();
        ((ConfluentAdmin)Mockito.doReturn((Object)emptyAcls).when((Object)this.mockAdminClient)).describeAcls((AclBindingFilter)ArgumentMatchers.any(), (DescribeAclsOptions)ArgumentMatchers.any());
        ((ConfluentAdmin)Mockito.doReturn(null).when((Object)this.mockAdminClient)).deleteAcls((Collection)ArgumentMatchers.any(), (DeleteAclsOptions)ArgumentMatchers.any());
        this.lifecycleManager = new TenantLifecycleManager(TEST_DELETE_DELAY_MS.longValue(), this.mockAdminClient);
        this.lifecycleManagerWithDeleteDelay = new TenantLifecycleManager(ConfluentConfigs.MULTITENANT_TENANT_DELETE_DELAY_MS_DEFAULT.longValue(), this.mockAdminClient);
        this.lifecycleManagerWithDeleteDelay.updateTenantState(Utils.LC_META_ABC);
        this.lifecycleManagerWithDeleteDelay.updateTenantState(Utils.LC_META_DED);
        this.lifecycleManagerWithDeleteDelay.updateTenantState(Utils.LC_META_MEH);
        Assertions.assertEquals((int)3, (int)this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.size(), (String)"Expecting three tenants");
    }

    @AfterEach
    public void teardown() {
        this.lifecycleManager.close();
    }

    @Test
    public void testStateInitialization() {
        Assertions.assertEquals((Object)TenantLifecycleManager.State.ACTIVE, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(Utils.LC_META_ABC.logicalClusterId()), (String)"Expecting tenant LC_META_ABC to be active");
        Assertions.assertTrue((boolean)this.lifecycleManagerWithDeleteDelay.isClusterActive(Utils.LC_META_ABC.logicalClusterId()), (String)"Expecting tenant LC_META_ABC to be active");
        Assertions.assertEquals((Object)TenantLifecycleManager.State.DEACTIVATED, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(Utils.LC_META_DED.logicalClusterId()), (String)"Expecting tenant LC_META_DED to be deactivated");
        Assertions.assertFalse((boolean)this.lifecycleManagerWithDeleteDelay.isClusterActive(Utils.LC_META_DED.logicalClusterId()), (String)"Expecting tenant LC_META_DED to be inactive");
        Assertions.assertEquals((Object)TenantLifecycleManager.State.DELETE_IN_PROGRESS, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(Utils.LC_META_MEH.logicalClusterId()), (String)"Expecting tenant LC_META_MEH to be on the way to deletion");
        Assertions.assertFalse((boolean)this.lifecycleManagerWithDeleteDelay.isClusterActive(Utils.LC_META_MEH.logicalClusterId()), (String)"Expecting tenant LC_META_MEH to be inactive");
    }

    @Test
    public void testInactiveClusters() {
        List<String> clusters = Arrays.asList(Utils.LC_META_DED.logicalClusterId(), Utils.LC_META_MEH.logicalClusterId());
        Assertions.assertTrue((boolean)this.lifecycleManagerWithDeleteDelay.inactiveClusters().containsAll(clusters), (String)"LC_META_DED and LC_META_MEH should be inactive");
        clusters.forEach(id -> Assertions.assertFalse((boolean)this.lifecycleManagerWithDeleteDelay.isClusterActive(id)));
        Assertions.assertFalse((boolean)this.lifecycleManagerWithDeleteDelay.inactiveClusters().contains(Utils.LC_META_ABC.logicalClusterId()), (String)"LC_META_ABC should be active");
        Assertions.assertTrue((boolean)this.lifecycleManagerWithDeleteDelay.isClusterActive(Utils.LC_META_ABC.logicalClusterId()), (String)"LC_META_ABC should be active");
    }

    @Test
    public void testNonExistingCluster() {
        Assertions.assertFalse((boolean)this.lifecycleManagerWithDeleteDelay.isClusterActive("no-such-cluster"), (String)"Non existing clusters shouldn't fail isClusterActive, but return false");
    }

    @Test
    public void testOnlyDeleteTenantsOnce() throws ExecutionException, InterruptedException {
        TenantContext tc = new TenantContext(new MultiTenantPrincipal("", new TenantMetadata(Utils.LC_META_DED.logicalClusterId(), Utils.LC_META_DED.logicalClusterId())));
        List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic(tc.addTenantPrefix("topic"), 3, 1));
        this.mockAdminClient.createTopics(sampleTopics).all().get();
        this.lifecycleManager.updateTenantState(Utils.LC_META_DED);
        this.lifecycleManager.deleteTenants();
        this.lifecycleManager.deletionExecutor().submit(() -> {}).get();
        this.lifecycleManager.deleteTenants();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)2))).listTopics((ListTopicsOptions)ArgumentMatchers.any());
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)2))).describeAcls((AclBindingFilter)ArgumentMatchers.any(), (DescribeAclsOptions)ArgumentMatchers.any());
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)2))).deleteAcls((Collection)ArgumentMatchers.any(), (DeleteAclsOptions)ArgumentMatchers.any());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.mockAdminClient});
        this.lifecycleManager.updateTenantState(Utils.LC_META_DED);
        this.lifecycleManager.deleteTenants();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.never())).listTopics((ListTopicsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testUndelete() throws IOException {
        Assertions.assertEquals((Object)TenantLifecycleManager.State.DEACTIVATED, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(Utils.LC_META_DED.logicalClusterId()), (String)"Expecting tenant LC_META_DED to be deactivated");
        Assertions.assertFalse((boolean)this.lifecycleManagerWithDeleteDelay.isClusterActive(Utils.LC_META_DED.logicalClusterId()), (String)"Expecting tenant LC_META_DED to be deactivated");
        LogicalClusterMetadata active = this.reactivateLogicalCluster(Utils.LC_META_DED);
        this.lifecycleManagerWithDeleteDelay.updateTenantState(active);
        Assertions.assertEquals((Object)TenantLifecycleManager.State.ACTIVE, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(active.logicalClusterId()), (String)"Expecting tenant to be active");
        Assertions.assertTrue((boolean)this.lifecycleManagerWithDeleteDelay.isClusterActive(active.logicalClusterId()), (String)"Expecting tenant to be active");
    }

    @Test
    public void testOnlyDeleteTenantTopics() throws ExecutionException, InterruptedException {
        String internalTopicName = "_internal-topic";
        TenantContext tc = new TenantContext(new MultiTenantPrincipal("", new TenantMetadata(Utils.LC_META_DED.logicalClusterId(), Utils.LC_META_DED.logicalClusterId())));
        ArrayList<NewTopic> sampleTopics = new ArrayList<NewTopic>();
        sampleTopics.add(new NewTopic(tc.addTenantPrefix("topic"), 3, 1));
        sampleTopics.add(new NewTopic(internalTopicName, 3, 1));
        this.mockAdminClient.createTopics(sampleTopics).all().get();
        this.lifecycleManager.updateTenantState(Utils.LC_META_DED);
        this.lifecycleManager.deleteTenants();
        this.lifecycleManager.deletionExecutor().submit(() -> {}).get();
        this.lifecycleManager.deleteTenants();
        Set topicsRemaining = (Set)this.mockAdminClient.listTopics().names().get();
        Assertions.assertTrue((boolean)topicsRemaining.contains(internalTopicName), (String)(internalTopicName + " should still exist after deleting tenant"));
        Assertions.assertEquals((int)1, (int)topicsRemaining.size(), (String)(internalTopicName + " should be the only topic remaining"));
    }

    @Test
    public void testOnlyDeleteTenantClusterLinks() throws ExecutionException, InterruptedException {
        TenantContext tenant = new TenantContext(new MultiTenantPrincipal("", new TenantMetadata(Utils.LC_META_XYZ.logicalClusterId(), Utils.LC_META_XYZ.logicalClusterId())));
        TenantContext deletedTenant = new TenantContext(new MultiTenantPrincipal("", new TenantMetadata(Utils.LC_META_DED.logicalClusterId(), Utils.LC_META_DED.logicalClusterId())));
        ArrayList<NewClusterLink> newClusterLinks = new ArrayList<NewClusterLink>();
        CreateClusterLinksOptions option = new CreateClusterLinksOptions();
        HashSet<String> expectedLinks = new HashSet<String>();
        String aliveLinkName = tenant.addTenantPrefix("link1");
        newClusterLinks.add(new NewClusterLink(aliveLinkName, "remote-cluster1", Collections.emptyMap()));
        expectedLinks.add(aliveLinkName);
        for (int ii = 0; ii < 3; ++ii) {
            String deletedLinkName = deletedTenant.addTenantPrefix("deletedTenant-link" + ii);
            newClusterLinks.add(new NewClusterLink(deletedLinkName, "remote-cluster2", Collections.emptyMap()));
            expectedLinks.add(deletedLinkName);
        }
        this.mockAdminClient.createClusterLinks(newClusterLinks, option).all().get();
        Collection links = (Collection)this.mockAdminClient.listClusterLinks(new ListClusterLinksOptions()).result().get();
        Assertions.assertEquals((int)expectedLinks.size(), (int)links.size());
        for (ClusterLinkListing listing : links) {
            Assertions.assertTrue((boolean)expectedLinks.contains(listing.linkName()), (String)(listing.linkName() + " is not expected"));
        }
        this.lifecycleManager.updateTenantState(Utils.LC_META_XYZ);
        this.lifecycleManager.updateTenantState(Utils.LC_META_DED);
        this.lifecycleManager.deleteTenants();
        this.lifecycleManager.deletionExecutor().submit(() -> {}).get();
        this.lifecycleManager.deleteTenants();
        links = (Collection)this.mockAdminClient.listClusterLinks(new ListClusterLinksOptions()).result().get();
        Assertions.assertEquals((int)1, (int)links.size());
        for (ClusterLinkListing listing : links) {
            Assertions.assertEquals((Object)aliveLinkName, (Object)listing.linkName());
        }
    }

    @Test
    public void testClusterLinkDisabled() throws ExecutionException, InterruptedException {
        MockAdminClient mockAdmin = (MockAdminClient)this.mockAdminClient;
        mockAdmin.updateClusterLinkDisabledException(true);
        this.lifecycleManager.updateTenantState(Utils.LC_META_DED);
        Assertions.assertTrue((boolean)this.lifecycleManager.deleteInProgressClusters().contains(Utils.LC_META_DED.logicalClusterId()));
        this.lifecycleManager.deleteTenants();
        this.lifecycleManager.deletionExecutor().submit(() -> {}).get();
        this.lifecycleManager.deleteTenants();
        Assertions.assertTrue((boolean)this.lifecycleManager.fullyDeletedClusters().contains(Utils.LC_META_DED.logicalClusterId()));
    }

    @Test
    public void testUpdateMaxPartitionsNullOldMeta() throws InterruptedException, ExecutionException {
        this.testUpdateMaxPartitions(null, Utils.LC_META_ABC, false);
    }

    @Test
    public void testUpdateMaxPartitionsNonNullOldMeta() throws InterruptedException, ExecutionException {
        this.testUpdateMaxPartitions(Utils.LC_META_XYZ, Utils.LC_META_ABC, true);
    }

    @Test
    public void testUpdateMaxPartitionsNoChange() throws InterruptedException, ExecutionException {
        this.testUpdateMaxPartitions(Utils.LC_META_ABC, Utils.LC_META_ABC, false);
    }

    private void testUpdateMaxPartitions(LogicalClusterMetadata oldMeta, LogicalClusterMetadata newMeta, boolean shouldUpdate) {
        Assertions.assertTrue((boolean)this.lifecycleManager.updateMaxPartitionsIfNecessary(oldMeta, newMeta));
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry("confluent.plugins.topic.policy.max.partitions.per.tenant", newMeta.maxPartitions().toString()), AlterConfigOp.OpType.SET);
        if (shouldUpdate) {
            ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(alterConfigOp)));
        } else {
            ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.never())).incrementalAlterConfigs((Map)ArgumentMatchers.any());
        }
    }

    @Test
    public void testUpdateMaxPartitionsFails() {
        ConfluentAdmin mockAdminClient = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        TenantLifecycleManager lifecycleManager = new TenantLifecycleManager(TEST_DELETE_DELAY_MS.longValue(), mockAdminClient);
        AlterConfigsResult mockResult = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new KafkaException());
        Mockito.when((Object)mockResult.all()).thenReturn((Object)future);
        Mockito.when((Object)mockAdminClient.incrementalAlterConfigs((Map)ArgumentMatchers.any())).thenReturn((Object)mockResult);
        Assertions.assertFalse((boolean)lifecycleManager.updateMaxPartitionsIfNecessary(Utils.LC_META_XYZ, Utils.LC_META_ABC));
    }

    private LogicalClusterMetadata reactivateLogicalCluster(LogicalClusterMetadata lkc) throws IOException {
        LogicalClusterMetadata deleted = new LogicalClusterMetadata(lkc.logicalClusterId(), lkc.physicalClusterId(), lkc.logicalClusterName(), lkc.accountId(), lkc.k8sClusterId(), lkc.logicalClusterType(), lkc.storageBytes(), lkc.producerByteRate(), lkc.consumerByteRate(), null, null, Long.valueOf(lkc.brokerRequestPercentage().longValue()), lkc.networkQuotaOverhead(), new LogicalClusterMetadata.LifecycleMetadata(lkc.lifecycleMetadata().logicalClusterName(), lkc.lifecycleMetadata().physicalK8sNamespace(), lkc.lifecycleMetadata().creationDate(), null), null, lkc.organizationId(), lkc.environmentId());
        return deleted;
    }
}

