/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class TestCluster {
    private final Map<TopicPartition, List<Integer>> topicPartitions = new HashMap<TopicPartition, List<Integer>>();
    private final Map<Integer, Node> nodes = new HashMap<Integer, Node>();

    public void setPartitionLeaders(String topic, int firstPartition, int count, Integer leaderBrokerId) {
        for (int i = firstPartition; i < firstPartition + count; ++i) {
            List<Object> replicas = leaderBrokerId == null ? Collections.emptyList() : Collections.singletonList(leaderBrokerId);
            this.topicPartitions.put(new TopicPartition(topic, i), replicas);
        }
    }

    public void createPartitions(String topic, int firstPartition, List<List<Integer>> assignment) {
        for (int i = firstPartition; i < firstPartition + assignment.size(); ++i) {
            this.topicPartitions.put(new TopicPartition(topic, i), assignment.get(i - firstPartition));
        }
    }

    public void deleteTopic(String topic) {
        this.topicPartitions.keySet().removeIf(tp -> tp.topic().equals(topic));
    }

    public void addNode(int id) {
        this.addNode(id, null);
    }

    public void addNode(int id, String rack) {
        this.nodes.put(id, new Node(id, "host" + id, 9090, rack));
    }

    public void addNode(int id, String rack, String cell) {
        this.addNode(id, rack, Collections.singletonMap("confluent.cell", cell));
    }

    public void addNode(int id, String rack, Map<String, String> tags) {
        this.nodes.put(id, (Node)new ConfluentNode(id, "host" + id, 9090, rack, tags));
    }

    public boolean rackAware() {
        boolean rackAware = true;
        for (Node node : this.nodes.values()) {
            if (node.rack() != null) continue;
            rackAware = false;
            break;
        }
        return rackAware;
    }

    public Set<String> racks() {
        HashSet<String> racks = new HashSet<String>();
        for (Node node : this.nodes.values()) {
            if (node.rack() == null) continue;
            racks.add(node.rack());
        }
        return racks;
    }

    public Map<Node, Integer> partitionCountByNode(String tenant, boolean leader) {
        HashMap<Node, Integer> result = new HashMap<Node, Integer>(this.nodes.size());
        for (Node node : this.nodes.values()) {
            result.put(node, 0);
        }
        String tenantPrefix = tenant + "_";
        for (Map.Entry<TopicPartition, List<Integer>> entry : this.topicPartitions.entrySet()) {
            List<Integer> replicas;
            if (!entry.getKey().topic().startsWith(tenantPrefix) || (replicas = entry.getValue()).isEmpty()) continue;
            if (leader) {
                Node leaderNode = this.nodes.get(replicas.get(0));
                result.computeIfPresent(leaderNode, (n, count) -> count + 1);
                continue;
            }
            for (int i = 1; i < replicas.size(); ++i) {
                Node node = this.nodes.get(replicas.get(i));
                result.computeIfPresent(node, (n, count) -> count + 1);
            }
        }
        return result;
    }

    public Cluster cluster() {
        return this.cluster(false);
    }

    public Cluster cluster(boolean createOfflineNodes) {
        HashSet<PartitionInfo> partitions = new HashSet<PartitionInfo>();
        for (Map.Entry<TopicPartition, List<Integer>> entry : this.topicPartitions.entrySet()) {
            TopicPartition tp = entry.getKey();
            List<Integer> replicas = entry.getValue();
            Node[] replicaArr = new Node[replicas.size()];
            for (int i = 0; i < replicas.size(); ++i) {
                Integer nodeId = replicas.get(i);
                Node aliveNode = this.nodes.get(nodeId);
                replicaArr[i] = createOfflineNodes && aliveNode == null ? new Node(nodeId.intValue(), null, -1) : aliveNode;
            }
            Node leaderNode = replicaArr.length == 0 ? null : replicaArr[0];
            partitions.add(new PartitionInfo(tp.topic(), tp.partition(), leaderNode, replicaArr, replicaArr, new Node[0]));
        }
        return new Cluster("cluster1", this.nodes.values(), partitions, Collections.emptySet(), Collections.emptySet());
    }
}

