/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.assignor;

import io.confluent.kafka.multitenant.TestCluster;
import io.confluent.kafka.multitenant.assignor.ClusterMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.Cluster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClusterMetadataTest {
    private TestCluster testCluster;

    @BeforeEach
    public void setUp() {
        this.testCluster = new TestCluster();
    }

    private ClusterMetadata clusterMetadata(String tenant, Cluster cluster) {
        return new ClusterMetadata(tenant, cluster, Collections.emptySet());
    }

    @Test
    public void testExcludedBrokers() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        this.testCluster.addNode(3, null);
        this.testCluster.addNode(4, null);
        List<Integer> excludedBrokers = Arrays.asList(1, 2);
        List<Integer> eligibleBrokers = Arrays.asList(0, 3, 4);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster(), new HashSet<Integer>(excludedBrokers));
        for (Integer eligibleBroker : eligibleBrokers) {
            Assertions.assertTrue((boolean)clusterMetadata.isBrokerEligibleForReplicaPlacement(eligibleBroker.intValue()), (String)"Expected non-excluded broker to be eligible for replica placement");
        }
        for (Integer excludedBroker : excludedBrokers) {
            Assertions.assertFalse((boolean)clusterMetadata.isBrokerEligibleForReplicaPlacement(excludedBroker.intValue()), (String)"Expected excluded broker to NOT be eligible for replica placement");
        }
        Assertions.assertEquals(new HashSet<Integer>(eligibleBrokers), (Object)clusterMetadata.eligibleBrokers());
        Assertions.assertEquals(new HashSet<Integer>(excludedBrokers), (Object)clusterMetadata.excludedBrokerIds());
    }

    @Test
    public void testRackAwareNoRacks() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertFalse((boolean)clusterMetadata.rackAware());
    }

    @Test
    public void testCellAwareNoCells() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertFalse((boolean)clusterMetadata.cellAware(), (String)"Expected the cluster metadata to not be cell aware when no cells exist");
    }

    @Test
    public void testCellAware() {
        this.testCluster.addNode(0, null, "cell1");
        this.testCluster.addNode(1, null, "cell1");
        this.testCluster.addNode(2, null, "cell2");
        this.testCluster.addNode(3, null, "cell2");
        this.testCluster.addNode(4, null, "cell3");
        this.testCluster.addNode(5, null, "cell3");
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertTrue((boolean)clusterMetadata.cellAware(), (String)"Expected the cluster metadata to be cell aware");
        Assertions.assertTrue((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(1)), (String)"Expected brokers to be in the same cell");
        Assertions.assertFalse((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(2)), (String)"Expected brokers in different cells to NOT be in the same cell");
        Assertions.assertEquals((Object)"cell1", (Object)clusterMetadata.cellForBroker(1));
        Assertions.assertEquals((Object)"cell3", (Object)clusterMetadata.cellForBroker(5));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1)), (Object)clusterMetadata.eligibleBrokersFromCell("cell1"));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(4, 5)), (Object)clusterMetadata.eligibleBrokersFromCell("cell3"));
    }

    @Test
    public void testCellAwareExclusion() {
        this.testCluster.addNode(0, null, "cell1");
        this.testCluster.addNode(1, null, "cell1");
        this.testCluster.addNode(2, null, "cell2");
        this.testCluster.addNode(3, null, "cell2");
        this.testCluster.addNode(4, null, "cell3");
        this.testCluster.addNode(5, null, "cell3");
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", this.testCluster.cluster(), new HashSet<Integer>(Arrays.asList(0, 2, 4)));
        Assertions.assertTrue((boolean)clusterMetadata.cellAware(), (String)"Expected the cluster metadata to be cell aware");
        Assertions.assertTrue((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(1)), (String)"Expected brokers to be in the same cell");
        Assertions.assertFalse((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(2)), (String)"Expected brokers in different cells to NOT be in the same cell");
        Assertions.assertEquals((Object)"cell1", (Object)clusterMetadata.cellForBroker(0));
        Assertions.assertEquals((Object)"cell2", (Object)clusterMetadata.cellForBroker(2));
        Assertions.assertEquals(new HashSet<Integer>(Collections.singletonList(1)), (Object)clusterMetadata.eligibleBrokersFromCell("cell1"));
        Assertions.assertEquals(new HashSet<Integer>(Collections.singletonList(3)), (Object)clusterMetadata.eligibleBrokersFromCell("cell2"));
        Assertions.assertEquals(new HashSet<Integer>(Collections.singletonList(5)), (Object)clusterMetadata.eligibleBrokersFromCell("cell3"));
    }

    @Test
    public void testRackAwareOneBrokerHasRack() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, "rack1");
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertFalse((boolean)clusterMetadata.rackAware());
    }

    @Test
    public void testRackAwareAllBrokersHasRack() {
        this.testCluster.addNode(0, "rack1");
        this.testCluster.addNode(1, "rack2");
        this.testCluster.addNode(2, "rack3");
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertTrue((boolean)clusterMetadata.rackAware());
    }

    @Test
    public void testNodeReplicaCountsOfflineBrokers() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 3), this.immutableList(2, 3, 0), this.immutableList(3, 0, 1));
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        String topic2 = "tenant2_topicA";
        this.testCluster.createPartitions("tenant1_topicA", 0, assignment);
        this.testCluster.createPartitions("tenant2_topicA", 0, assignment);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster(true));
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        Assertions.assertEquals((int)2, (int)nodeReplicaCounts.leaderCount((int)3).total);
        Assertions.assertEquals((int)0, (int)nodeReplicaCounts.leaderCount((int)3).topic);
        Assertions.assertEquals((int)1, (int)nodeReplicaCounts.leaderCount((int)3).tenant);
        Assertions.assertEquals((int)4, (int)nodeReplicaCounts.followerCount((int)3).total);
        Assertions.assertEquals((int)0, (int)nodeReplicaCounts.followerCount((int)3).topic);
        Assertions.assertEquals((int)2, (int)nodeReplicaCounts.followerCount((int)3).tenant);
        Assertions.assertEquals((int)2, (int)nodeReplicaCounts.leaderCount((int)1).total);
        Assertions.assertEquals((int)0, (int)nodeReplicaCounts.leaderCount((int)2).topic);
        Assertions.assertEquals((int)1, (int)nodeReplicaCounts.leaderCount((int)0).tenant);
        Assertions.assertEquals((int)4, (int)nodeReplicaCounts.followerCount((int)0).total);
        Assertions.assertEquals((int)0, (int)nodeReplicaCounts.followerCount((int)1).topic);
        Assertions.assertEquals((int)2, (int)nodeReplicaCounts.followerCount((int)2).tenant);
    }

    @Test
    public void testNodeReplicaCountsNoTopics() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounter = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        ClusterMetadata.ReplicaCounts zeroReplicaCounts = new ClusterMetadata.ReplicaCounts(0, 0);
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.leaderCount(2));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.followerCount(0));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.followerCount(1));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.followerCount(2));
    }

    @Test
    public void testNodeReplicaCountsOneTenantTopic() {
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 0), this.immutableList(2, 0, 1));
        this.testCluster.createPartitions("tenant1_topicA", 0, assignment);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounter = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        ClusterMetadata.ReplicaCounts expectedLeaderCounts = new ClusterMetadata.ReplicaCounts(1, 1);
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(2));
        ClusterMetadata.ReplicaCounts expectedFollowerCounts = new ClusterMetadata.ReplicaCounts(2, 2);
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(0));
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(1));
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(2));
    }

    @Test
    public void testNodeReplicaCountsMultipleTenants() {
        String tenant1 = "tenant1";
        String topic1 = "tenant1_topicA";
        String topic2 = "tenant2_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 0), this.immutableList(2, 0, 1));
        this.testCluster.createPartitions("tenant1_topicA", 0, assignment);
        this.testCluster.createPartitions("tenant2_topicA", 0, assignment);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounter = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        ClusterMetadata.ReplicaCounts expectedLeaderCounts = new ClusterMetadata.ReplicaCounts(1, 2);
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(2));
        ClusterMetadata.ReplicaCounts expectedFollowerCounts = new ClusterMetadata.ReplicaCounts(2, 4);
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(0));
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(1));
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(2));
    }

    @Test
    public void testNodeReplicaCountsForOneExistingTenantTopic() {
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 0), this.immutableList(2, 0, 1), this.immutableList(0, 1, 2));
        this.testCluster.createPartitions("tenant1_topicA", 0, assignment);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.NodeReplicaCounter replicaCounter = clusterMetadata.nodeReplicaCounts(this.testCluster.cluster().partitionsForTopic("tenant1_topicA"));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2, 2), (Object)replicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1, 1), (Object)replicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1, 1), (Object)replicaCounter.leaderCount(2));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2, 2), (Object)replicaCounter.followerCount(0));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(3, 3, 3), (Object)replicaCounter.followerCount(1));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(3, 3, 3), (Object)replicaCounter.followerCount(2));
    }

    @Test
    public void testNodeReplicaCountsForExistingTenantTopicWithInvalidAssignment() {
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 0), this.immutableList(2, 0, 1));
        this.testCluster.createPartitions("tenant1_topicA", 0, assignment);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertThrows(IllegalStateException.class, () -> clusterMetadata.nodeReplicaCounts(this.testCluster.cluster().partitionsForTopic("tenant1_topicA")), (String)"Expected nodeReplicaCounts() to throw IllegalStateException");
    }

    @Test
    public void testUpdateNodeMetadataWithInvalidAssignment() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertThrows(IllegalStateException.class, () -> clusterMetadata.updateNodeMetadata(this.immutableList(this.immutableList(0, 1, 2))), (String)"Expected updateNodeMetadata() to throw IllegalStateException");
    }

    @Test
    public void testUpdateNodeMetadata() {
        String tenant = "tenant1";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 0));
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        clusterMetadata.updateNodeMetadata(assignment);
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounter = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), (Object)nodeReplicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), (Object)nodeReplicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(0, 0), (Object)nodeReplicaCounter.leaderCount(2));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), (Object)nodeReplicaCounter.followerCount(0));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), (Object)nodeReplicaCounter.followerCount(1));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2), (Object)nodeReplicaCounter.followerCount(2));
    }

    @Test
    public void testReplicaCountsComparison() {
        ClusterMetadata.ReplicaCounts counts0 = new ClusterMetadata.ReplicaCounts(1, 2, 4);
        ClusterMetadata.ReplicaCounts counts1 = new ClusterMetadata.ReplicaCounts(1, 2, 3);
        ClusterMetadata.ReplicaCounts counts2 = new ClusterMetadata.ReplicaCounts(1, 4, 3);
        ClusterMetadata.ReplicaCounts counts3 = new ClusterMetadata.ReplicaCounts(3, 2, 3);
        ClusterMetadata.ReplicaCounts counts4 = new ClusterMetadata.ReplicaCounts(4, 5, 3);
        ClusterMetadata.ReplicaCounts counts5 = new ClusterMetadata.ReplicaCounts(4, 5, 3);
        Assertions.assertTrue((counts0.compareTo(counts1) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((counts0.compareTo(counts2) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((counts4.compareTo(counts3) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((counts3.compareTo(counts2) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)counts5.compareTo(counts4));
        Assertions.assertTrue((counts5.compareTo(counts0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReplicaCountsCompareToThrowsExceptionForNullParameter() {
        ClusterMetadata.ReplicaCounts counts = new ClusterMetadata.ReplicaCounts(1, 2, 4);
        Assertions.assertThrows(NullPointerException.class, () -> counts.compareTo(null), (String)"Expected updateNodeMetadata() to throw IllegalStateException");
    }

    private List<Integer> immutableList(Integer ... numbers) {
        return Collections.unmodifiableList(Arrays.asList(numbers));
    }

    @SafeVarargs
    private final List<List<Integer>> immutableList(List<Integer> ... lists) {
        return Collections.unmodifiableList(Arrays.asList(lists));
    }
}

