/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.assignor;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.assignor.TenantPartitionAssignorBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option;

public class TenantPartitionAssignorBuilderTest {
    Cluster cluster = new Cluster("", Collections.emptyList(), Collections.emptyList(), new HashSet(), new HashSet());

    @Test
    public void testBuildAssignor() {
        MultiTenantPrincipal mtp = new MultiTenantPrincipal("tenant", new TenantMetadata("tenant1", "lkc-12345"));
        TenantPartitionAssignorBuilder builder = new TenantPartitionAssignorBuilder();
        builder.updateClusterMetadata(null);
        Optional assignorOptWithEmptyCluster = builder.maybeBuildAssignor(Optional.of(mtp));
        Assertions.assertTrue((boolean)assignorOptWithEmptyCluster.isPresent(), (String)"expected the received replica assignor to be present");
        Assertions.assertNotNull(assignorOptWithEmptyCluster.get(), (String)"expected the received replica assignor to not be null");
        builder.updateClusterMetadata(this.cluster);
        Optional assignorOpt = builder.maybeBuildAssignor(Optional.of(mtp));
        Assertions.assertTrue((boolean)assignorOpt.isPresent(), (String)"expected to receive a non-empty optional with the assignor");
        Assertions.assertNotNull(assignorOpt.get(), (String)"expected the received replica assignor to not be null");
    }

    @Test
    public void testBuildAssignorReturnsEmptyOptionalWhenNullOrNonMultiTenantPrincipalArgumentsGiven() {
        TenantPartitionAssignorBuilder builder = new TenantPartitionAssignorBuilder();
        Optional emptyPrincipalOpt = builder.maybeBuildAssignor(Optional.empty());
        Assertions.assertFalse((boolean)emptyPrincipalOpt.isPresent(), (String)"Expected an empty optional due to using an empty principal option");
        Optional kafkaPrincipalOpt = builder.maybeBuildAssignor(Optional.of(new KafkaPrincipal("principal", "user")));
        Assertions.assertFalse((boolean)kafkaPrincipalOpt.isPresent(), (String)"Expected an empty optional due to not using a multi tenant principal");
    }

    @Test
    public void testConfigureAssignor() {
        Properties brokerProps = new Properties();
        brokerProps.put(KafkaConfig.ZkConnectProp(), TestUtils.MockZkConnect());
        brokerProps.put(KafkaConfig.ListenersProp(), "PLAINTEXT://localhost:9092");
        brokerProps.put(KafkaConfig.ConfluentTopicReplicaAssignorBuilderProp(), TenantPartitionAssignorBuilder.class.getCanonicalName());
        brokerProps.put("confluent.multitenant.max.partitions.per.request", "55");
        Option builderOpt = new KafkaConfig((Map)brokerProps).topicReplicaAssignorBuilder();
        Assertions.assertTrue((boolean)builderOpt.isDefined(), (String)"Expected the assignor builder to be successfully loaded");
        Assertions.assertTrue((boolean)(builderOpt.get() instanceof TenantPartitionAssignorBuilder), (String)String.format("Expected the assignor builder to be of type %s", TenantPartitionAssignorBuilder.class.getName()));
        Assertions.assertEquals((int)55, (int)((TenantPartitionAssignorBuilder)builderOpt.get()).maxPartitionsPerCreation);
    }
}

