/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.admin.AclCommand;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="integration")
public class AdminClientIntegrationTest {
    private static final Logger log = LoggerFactory.getLogger(AdminClientIntegrationTest.class);
    private final String logicalClusterId = Utils.LC_META_XYZ.logicalClusterId();
    private final Properties adminProperties = new Properties();
    private IntegrationTestHarness testHarness;
    private OAuthUtils.JwsContainer jwsContainer;
    private final String[] allowedClusters;
    private String brokerUUID;
    private PhysicalClusterMetadata metadata;
    private final String testTopic = "abcd";
    private final List<NewTopic> sampleTopics;
    private LogicalClusterUser testUser;
    private TestInfo testInfo;
    private Path tempDir;

    public AdminClientIntegrationTest() {
        this.adminProperties.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
        this.allowedClusters = new String[]{this.logicalClusterId};
        this.testTopic = "abcd";
        this.sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
    }

    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        this.tempDir = TestUtils.tempDirectory().toPath();
        this.testInfo = testInfo;
    }

    private void setUp() throws Exception {
        MockAuditLogProvider.reset();
        this.setUp(this.allowedClusters);
    }

    private void setUp(String[] allowedClusters) throws Exception {
        this.testHarness = new IntegrationTestHarness(this.testInfo);
        boolean serviceUserId = true;
        String subject = "1";
        this.jwsContainer = OAuthUtils.setUpJws(100000, "Confluent", subject, allowedClusters);
        PhysicalCluster physicalCluster = this.testHarness.start(this.setUpMetadata(this.brokerProps()));
        int adminUserId = 100;
        LogicalCluster logicalCluster = physicalCluster.createLogicalCluster(this.logicalClusterId, 100, 1);
        this.testUser = logicalCluster.user(1);
        this.addAdminAcls();
    }

    private void addAdminAcls() {
        AclCommand.main((String[])SecurityTestUtils.addTopicAclArgs(this.testHarness.zkConnect(), this.testUser.prefixedKafkaPrincipal(), this.testUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        this.metadata.close(this.brokerUUID);
    }

    private Properties setUpMetadata(Properties brokerProps) throws IOException, InterruptedException {
        this.brokerUUID = "uuid";
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("broker.session.uuid", this.brokerUUID);
        brokerProps.put("broker.session.uuid", this.brokerUUID);
        configs.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        this.metadata = Utils.initiatePhysicalClusterMetadata(configs);
        Utils.createLogicalClusterFile(Utils.LC_META_XYZ, this.tempDir);
        TestUtils.waitForCondition(() -> this.metadata.metadata(Utils.LC_META_XYZ.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
        return brokerProps;
    }

    private Properties brokerProps() {
        Properties props = IntegrationTestHarness.defaultOAuthBrokerProps();
        props.put("listener.name.external.oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required publicKeyPath=\"" + this.jwsContainer.getPublicKeyFile().toPath() + "\";");
        return props;
    }

    private String clientJaasConfig(String jwsToken, String allowedCluster) {
        return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required token=\"" + jwsToken + "\" cluster=\"" + allowedCluster + "\";";
    }

    @Test
    public void testCorrectConfigurationAuthenticatesSuccessfully() throws Exception {
        this.setUp();
        AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties);
        client.createTopics(this.sampleTopics).all().get();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics));
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assertions.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assertions.assertFalse((boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"));
        Assertions.assertEquals((Object)Scope.kafkaClusterScope((String)Utils.LC_META_XYZ.logicalClusterId()), (Object)authenticationEvent.getScope());
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assertions.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    @Test
    public void testAllowedClusterExtensionNotInTokenThrowsException() throws Exception {
        this.setUp();
        Class<SaslAuthenticationException> expectedException = SaslAuthenticationException.class;
        try {
            AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), "wrong"), this.adminProperties);
            client.createTopics(this.sampleTopics).all().get();
            Assertions.fail((String)String.format("Expected admin command to throw a %s", expectedException));
        }
        catch (Exception e) {
            if (e.getCause().getClass() != expectedException) {
                Assertions.fail((String)String.format("Expected admin command to throw a %s but it threw a %s", expectedException, e.getCause().getClass()));
            }
            log.info("Expected exception message: {}", (Object)e.getCause().getMessage());
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=wrong"));
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("logical cluster wrong is not part of the allowed clusters"));
        Assertions.assertEquals((Object)"1", (Object)errorInfo.identifier());
        Assertions.assertEquals((Object)"wrong", errorInfo.saslExtensions().get("logicalCluster"));
    }

    @Test
    public void testAllowedClusterNotHostedOnBrokerThrowsException() throws Exception {
        this.setUp(new String[]{"other-cluster"});
        Class<SaslAuthenticationException> expectedException = SaslAuthenticationException.class;
        try {
            AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), "other-cluster"), this.adminProperties);
            client.createTopics(this.sampleTopics).all().get();
            Assertions.fail((String)String.format("Expected admin command to throw a %s", expectedException));
        }
        catch (Exception e) {
            if (e.getCause().getClass() != expectedException) {
                Assertions.fail((String)String.format("Expected admin command to throw a %s but it threw a %s", expectedException, e.getCause().getClass()));
            }
            log.info("Expected exception message: {}", (Object)e.getCause().getMessage());
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=other-cluster"));
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("cluster other-cluster is not hosted on this broker"));
        Assertions.assertEquals((Object)"1", (Object)errorInfo.identifier());
        Assertions.assertEquals((Object)"other-cluster", errorInfo.saslExtensions().get("logicalCluster"));
    }

    @Test
    public void testInvalidTokenThrowsException() throws Exception {
        this.setUp(new String[0]);
        Class<SaslAuthenticationException> expectedException = SaslAuthenticationException.class;
        try {
            this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties).createTopics(this.sampleTopics).all().get();
            Assertions.fail((String)String.format("Expected admin command to throw a %s", expectedException));
        }
        catch (Exception e) {
            if (e.getCause().getClass() != expectedException) {
                Assertions.fail((String)String.format("Expected admin command to throw a %s but it threw a %s", expectedException, e.getCause().getClass()));
            }
            log.info("Expected exception message: {}", (Object)e.getCause().getMessage());
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
    }

    @Test
    public void testIllegalStateExceptionOnBrokerMetadataThrowsException() throws Exception {
        this.setUp();
        Class<SaslAuthenticationException> expectedException = SaslAuthenticationException.class;
        try {
            this.metadata.close(this.brokerUUID);
            AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties);
            client.createTopics(this.sampleTopics).all().get();
            Assertions.fail((String)String.format("Expected admin command to throw a %s", expectedException));
        }
        catch (Exception e) {
            if (e.getCause().getClass() != expectedException) {
                Assertions.fail((String)String.format("Expected admin command to throw a %s but it threw a %s", expectedException, e.getCause().getClass()));
            }
            log.info("Expected exception message: {}", (Object)e.getCause().getMessage());
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("Could not get cluster metadata to validate the token"));
        Assertions.assertEquals((Object)"1", (Object)errorInfo.identifier());
        Assertions.assertTrue((boolean)errorInfo.clusterId().isEmpty());
    }
}

