/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MultiTenantAuthorizerSuperUserTest {
    public static Collection<Arguments> data() {
        ArrayList<Arguments> args = new ArrayList<Arguments>(10);
        List<Boolean> booleans = Arrays.asList(true, false);
        for (boolean authorizationDisabled : booleans) {
            for (boolean enableDataplaneRbacForPKC : booleans) {
                for (boolean oauthSuperUserDisable : booleans) {
                    for (boolean serviceAccount : booleans) {
                        for (boolean apiKeyAuthenticated : booleans) {
                            for (boolean healthcheckTenant : booleans) {
                                for (boolean internalUser : booleans) {
                                    for (boolean sameTenantAsAction : booleans) {
                                        args.add(Arguments.of((Object[])new Object[]{authorizationDisabled, enableDataplaneRbacForPKC, oauthSuperUserDisable, serviceAccount, apiKeyAuthenticated, healthcheckTenant, internalUser, sameTenantAsAction}));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return args;
    }

    @ParameterizedTest(name="authorizationDisabled={0}, enableDataplaneRbacForPKC={1}, oauthSuperUserDisable={2}, serviceAccount={3}, apiKeyAuthenticated={4}, healthcheckTenant={5}, internalUser={6}, sameTenantAsAction={7}")
    @MethodSource(value={"data"})
    public void testSuperUser(boolean authorizationDisabled, boolean enableDataplaneRbacForPKC, boolean oauthSuperUserDisable, boolean serviceAccount, boolean apiKeyAuthenticated, boolean healthcheckTenant, boolean internalUser, boolean sameTenantAsAction) {
        boolean expectedSuperUserDueToAuthzDisabled = authorizationDisabled;
        boolean expectedSuperUserDueToServiceAccount = false;
        if (!expectedSuperUserDueToAuthzDisabled) {
            boolean bl = expectedSuperUserDueToServiceAccount = !serviceAccount;
            if (expectedSuperUserDueToServiceAccount) {
                expectedSuperUserDueToServiceAccount = healthcheckTenant || internalUser;
                expectedSuperUserDueToServiceAccount = expectedSuperUserDueToServiceAccount || apiKeyAuthenticated && !enableDataplaneRbacForPKC;
                expectedSuperUserDueToServiceAccount = expectedSuperUserDueToServiceAccount || !apiKeyAuthenticated && !enableDataplaneRbacForPKC && !oauthSuperUserDisable;
            }
        }
        String lkc = "lkc_abcde";
        TenantMetadata tm = new TenantMetadata.Builder(lkc, "userResourceId").serviceAccount(serviceAccount).apiKeyAuthenticated(apiKeyAuthenticated).healthcheckTenant(healthcheckTenant).build();
        MultiTenantPrincipal mtp = new MultiTenantPrincipal(internalUser ? "0" : "user", "user", tm);
        String authorizeAgainstTenant = (sameTenantAsAction ? lkc : lkc + "x") + "_";
        Action action = new Action(Scope.kafkaClusterScope((String)"foo"), ResourceType.ALL, authorizeAgainstTenant, Operation.ALL);
        boolean expectedSuperUser = (expectedSuperUserDueToAuthzDisabled || expectedSuperUserDueToServiceAccount) && sameTenantAsAction;
        Assertions.assertEquals((Object)expectedSuperUser, (Object)MultiTenantAuthorizer.isSuperUser((MultiTenantPrincipal)mtp, (Action)action, (boolean)authorizationDisabled, (boolean)enableDataplaneRbacForPKC, (boolean)oauthSuperUserDisable));
    }
}

