/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.errors.SslAuthenticationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

@Tag(value="integration")
public class SslCertificateIntegrationTest {
    private static final Long TEST_CACHE_RELOAD_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final String SSL_CERTS_DIR = "mnt/sslcerts/";
    private static final String SSL_CERTS_MAY_URL = "/cert_exp_may";
    private Path tempDir;
    private IntegrationTestHarness testHarness;
    private String brokerUUID;
    private LogicalCluster logicalCluster1;
    private LogicalCluster logicalCluster2;
    protected Time time;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.tempDir = TestUtils.tempDirectory().toPath();
        MockAuditLogProvider.reset();
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempDir);
        Utils.createLogicalClusterFile(Utils.LC_META_XYZ, this.tempDir);
        Utils.syncCerts(this.tempDir, this.getClass().getResource(SSL_CERTS_MAY_URL), SSL_CERTS_DIR);
        this.testHarness = new IntegrationTestHarness(testInfo);
        PhysicalCluster physicalCluster = this.testHarness.start(this.brokerProps());
        this.logicalCluster1 = physicalCluster.createLogicalCluster("tenantA", 100, 9, 11, 12);
        this.logicalCluster2 = physicalCluster.createLogicalCluster("tenantB", 200, 9, 21, 22);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    private Properties brokerProps() throws IOException {
        this.brokerUUID = "uuid";
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerSessionUuidProp(), this.brokerUUID);
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put("multitenant.metadata.reload.delay.ms", TEST_CACHE_RELOAD_DELAY_MS);
        props.put("listeners", "INTERNAL://localhost:0, SSL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0, SSL://localhost:0");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT, SSL:SSL");
        props.put("ssl.keystore.location", this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "/pkcs.p12");
        props.put("ssl.keystore.password", "mystorepassword");
        props.put("ssl.keystore.type", "PKCS12");
        props.put("ssl.endpoint.identification.algorithm", "");
        props.put("confluent.security.event.logger.authentication.enable", "true");
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        return props;
    }

    @Test
    public void testProduceConsumeFailsOnExpiredCertificateSync() {
        Assertions.assertThrows(SslAuthenticationException.class, () -> this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster2.user(21), "testtopic", "group", 0, SecurityProtocol.SSL));
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
    }
}

