/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import com.google.common.collect.Iterables;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

@Tag(value="integration")
public class UserResourceIdAuthorizationIntegrationTest {
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final String adminUserAPIkey = "APIKEY1";
    private final String adminUserAPIkeyPassword = "pwd1";
    private final String serviceUserAPIkey = "APIKEY2";
    private final String serviceUserAPIkeyPassword = "pwd2";
    private final String serviceUserAPIkey2 = "APIKEY3";
    private final String serviceUserAPIkeyPassword2 = "pwd3";
    private IntegrationTestHarness testHarness;
    private PhysicalCluster physicalCluster;
    private final String apiKeysTopic = "_confluent-apikey";
    private final String testTopic = "abcd";
    private final String userResourceId = "u-xyz123";
    private final String userId = "2";
    private final String userId2 = "3";
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        int numBrokers = 3;
        this.testHarness = new IntegrationTestHarness(testInfo, numBrokers);
        long topicCreateTimeout = 15000L;
        long topicLoadTimeoutMs = topicCreateTimeout + TimeUnit.SECONDS.toMillis(3L);
        this.physicalCluster = this.testHarness.startWithTopic("_confluent-apikey", 1, 1, topicCreateTimeout, this.brokerProps(topicLoadTimeoutMs));
        int adminUserId = 1;
        int serviceUserId = 2;
        LogicalCluster logicalCluster = this.physicalCluster.createLogicalCluster(this.logicalClusterId, 100, adminUserId, serviceUserId);
        this.loadApiKeys("/file_auth_test_apikeys.json", "APIKEY1");
        this.loadApiKeys("/service_account_apikey.json", "APIKEY2");
        this.loadApiKeys("/service_account_apikey_2.json", "APIKEY3");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    private Properties brokerProps(long topicLoadTimeoutMs) throws IOException {
        Properties props = new Properties();
        props.put("listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT");
        props.put("inter.broker.listener.name", "INTERNAL");
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required;");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        props.put("confluent.cdc.api.keys.topic", "_confluent-apikey");
        props.put("confluent.cdc.api.keys.load.timeout.ms", String.valueOf(topicLoadTimeoutMs));
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        props.put("confluent.support.resource.ids.acl.api", "true");
        return props;
    }

    @Test
    public void testCreateAcls() throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            Object future4;
            Object future22;
            Object future3;
            try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));){
                future3 = client.createTopics(this.topicsList("topic1")).all();
                TestUtils.assertFutureError((Future)future3, TopicAuthorizationException.class);
            }
            AclBinding acl1 = this.topicAcl("2", "topic1");
            adminClient.createAcls(Collections.singleton(acl1)).all().get();
            AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            future3 = null;
            try {
                client.createTopics(this.topicsList("topic1")).all().get();
                List expectedTopics = this.topicsList("topic1").stream().map(NewTopic::name).collect(Collectors.toList());
                Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics));
            }
            catch (Throwable expectedTopics) {
                future3 = expectedTopics;
                throw expectedTopics;
            }
            finally {
                if (client != null) {
                    if (future3 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable expectedTopics) {
                            ((Throwable)future3).addSuppressed(expectedTopics);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            future3 = null;
            try {
                future22 = client.createTopics(this.topicsList("topic2")).all();
                TestUtils.assertFutureError((Future)future22, TopicAuthorizationException.class);
            }
            catch (Throwable future22) {
                future3 = future22;
                throw future22;
            }
            finally {
                if (client != null) {
                    if (future3 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable future22) {
                            ((Throwable)future3).addSuppressed(future22);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            AclBinding acl2 = this.topicAcl("2", "topic2");
            adminClient.createAcls(Collections.singleton(acl2)).all().get();
            AdminClient client2 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            future22 = null;
            try {
                client2.createTopics(this.topicsList("topic2")).all().get();
                List expectedTopics = this.topicsList("topic2").stream().map(NewTopic::name).collect(Collectors.toList());
                Assertions.assertTrue((boolean)((Set)client2.listTopics().names().get()).containsAll(expectedTopics));
            }
            catch (Throwable expectedTopics) {
                future22 = expectedTopics;
                throw expectedTopics;
            }
            finally {
                if (client2 != null) {
                    if (future22 != null) {
                        try {
                            client2.close();
                        }
                        catch (Throwable expectedTopics) {
                            ((Throwable)future22).addSuppressed(expectedTopics);
                        }
                    } else {
                        client2.close();
                    }
                }
            }
            client2 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY3", "pwd3"));
            future22 = null;
            try {
                future4 = client2.createTopics(this.topicsList("topic3")).all();
                TestUtils.assertFutureError((Future)future4, TopicAuthorizationException.class);
            }
            catch (Throwable future4) {
                future22 = future4;
                throw future4;
            }
            finally {
                if (client2 != null) {
                    if (future22 != null) {
                        try {
                            client2.close();
                        }
                        catch (Throwable future4) {
                            ((Throwable)future22).addSuppressed(future4);
                        }
                    } else {
                        client2.close();
                    }
                }
            }
            AclBinding acl3 = this.topicAcl("3", "topic3");
            adminClient.createAcls(Collections.singleton(acl3)).all().get();
            AdminClient client3 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY3", "pwd3"));
            future4 = null;
            try {
                client3.createTopics(this.topicsList("topic3")).all().get();
                List expectedTopics = this.topicsList("topic3").stream().map(NewTopic::name).collect(Collectors.toList());
                Assertions.assertTrue((boolean)((Set)client3.listTopics().names().get()).containsAll(expectedTopics));
            }
            catch (Throwable expectedTopics) {
                future4 = expectedTopics;
                throw expectedTopics;
            }
            finally {
                if (client3 != null) {
                    if (future4 != null) {
                        try {
                            client3.close();
                        }
                        catch (Throwable expectedTopics) {
                            ((Throwable)future4).addSuppressed(expectedTopics);
                        }
                    } else {
                        client3.close();
                    }
                }
            }
            client3 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            future4 = null;
            try {
                KafkaFuture future5 = client3.createTopics(this.topicsList("topic4")).all();
                TestUtils.assertFutureError((Future)future5, TopicAuthorizationException.class);
            }
            catch (Throwable throwable) {
                future4 = throwable;
                throw throwable;
            }
            finally {
                if (client3 != null) {
                    if (future4 != null) {
                        try {
                            client3.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)future4).addSuppressed(throwable);
                        }
                    } else {
                        client3.close();
                    }
                }
            }
            AclBinding acl4 = this.topicAcl("*", "topic4");
            adminClient.createAcls(Collections.singleton(acl4)).all().get();
            try (AdminClient client4 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));){
                client4.createTopics(this.topicsList("topic4")).all().get();
                List expectedTopics = this.topicsList("topic4").stream().map(NewTopic::name).collect(Collectors.toList());
                Assertions.assertTrue((boolean)((Set)client4.listTopics().names().get()).containsAll(expectedTopics));
            }
        }
    }

    @Test
    public void testDescribeAcls() throws Exception {
        AclBinding acl1 = this.topicAcl("2");
        AclBinding acl2 = this.topicAcl("3");
        ArrayList<AclBinding> aclsOldFormat = new ArrayList<AclBinding>(Arrays.asList(acl1, acl2));
        ArrayList<AclBinding> aclsNewFormat = new ArrayList<AclBinding>(Arrays.asList(this.topicAcl("u-xyz123"), acl2));
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            adminClient.createAcls(new ArrayList<AclBinding>(Arrays.asList(acl1, acl2))).all().get();
            Collection aclsAnyFilter = (Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get();
            Assertions.assertEquals((int)aclsOldFormat.size(), (int)aclsAnyFilter.size());
            Assertions.assertTrue((boolean)aclsOldFormat.containsAll(aclsAnyFilter));
            AclBindingFilter resourceIdFilter = this.topicFilter("u-xyz123");
            Assertions.assertEquals((Object)this.topicAcl("u-xyz123"), (Object)Iterables.getOnlyElement((Iterable)((Iterable)adminClient.describeAcls(resourceIdFilter).values().get())));
            AclBindingFilter userIdFilter = this.topicFilter("2");
            Assertions.assertEquals((Object)acl1, (Object)Iterables.getOnlyElement((Iterable)((Iterable)adminClient.describeAcls(userIdFilter).values().get())));
            AclBindingFilter userV2Filter = this.topicFilter("*", "UserV2");
            Collection aclsV2Filter = (Collection)adminClient.describeAcls(userV2Filter).values().get();
            Assertions.assertEquals((int)aclsNewFormat.size(), (int)aclsV2Filter.size());
            Assertions.assertTrue((boolean)aclsNewFormat.containsAll(aclsV2Filter));
        }
    }

    @Disabled
    @Test
    public void testUserResourceIdWithAdminClient() throws Exception {
        AclBinding topicAcl = this.topicAcl("u-xyz123");
        AclBindingFilter topicFilter = this.topicFilter("u-xyz123");
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            KafkaFuture future;
            Collection acls = (Collection)adminClient.describeAcls(topicFilter).values().get();
            Assertions.assertTrue((boolean)acls.isEmpty());
            try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));){
                future = client.createTopics(this.sampleTopics).all();
                TestUtils.assertFutureError((Future)future, TopicAuthorizationException.class);
            }
            adminClient.createAcls(Collections.singleton(topicAcl)).all().get();
            acls = (Collection)adminClient.describeAcls(topicFilter).values().get();
            Assertions.assertEquals((int)1, (int)acls.size());
            client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            var7_9 = null;
            try {
                client.createTopics(this.sampleTopics).all().get();
                List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
                Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics));
            }
            catch (Throwable expectedTopics) {
                var7_9 = expectedTopics;
                throw expectedTopics;
            }
            finally {
                if (client != null) {
                    if (var7_9 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable expectedTopics) {
                            var7_9.addSuppressed(expectedTopics);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            adminClient.deleteAcls(Collections.singleton(topicFilter)).all().get();
            acls = (Collection)adminClient.describeAcls(topicFilter).values().get();
            Assertions.assertTrue((boolean)acls.isEmpty());
            client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            var7_9 = null;
            try {
                future = client.describeTopics(Collections.singletonList("abcd")).allTopicNames();
                TestUtils.assertFutureError((Future)future, TopicAuthorizationException.class);
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (var7_9 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
    }

    private AclBinding topicAcl(String principalName) {
        return this.topicAcl(principalName, "abcd");
    }

    private AclBinding topicAcl(String principalName, String topicName) {
        return new AclBinding(new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL), new AccessControlEntry(new KafkaPrincipal("User", principalName).toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
    }

    private AclBindingFilter topicFilter(String principalName) {
        return this.topicFilter(principalName, "User");
    }

    private AclBindingFilter topicFilter(String principalName, String principalType) {
        return new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(new KafkaPrincipal(principalType, principalName).toString(), null, AclOperation.ANY, AclPermissionType.ANY));
    }

    private List<NewTopic> topicsList(String topicName) {
        return Collections.singletonList(new NewTopic(topicName, 3, 1));
    }

    private void loadApiKeys(String fileName, String apiKey) throws Exception {
        BufferedInputStream path;
        try {
            path = (BufferedInputStream)FileBasedPlainSaslAuthenticatorTest.class.getResource(fileName).getContent();
        }
        catch (IOException e) {
            throw new Exception("Couldn't read apikeys content");
        }
        String apiKeys = org.apache.kafka.common.utils.Utils.readFullyToString((InputStream)path);
        this.physicalCluster.kafkaCluster().produceApiKeysData("_confluent-apikey", apiKey, apiKeys, true);
    }
}

