/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.ConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.ConnectionSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.metrics.TenantMetricsTestUtils;
import java.util.Map;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectionSensorsTest {
    private TenantMetricsTestUtils utils;
    private ConnectionSensors sensors;
    private Metrics metrics;
    private MetricsBuilderContext context;

    @BeforeEach
    public void setUp() {
        String tenantName = "tenant";
        String userName = "user1";
        this.metrics = new Metrics();
        TenantMetadata metadata = new TenantMetadata.Builder(tenantName, "u-1").build();
        MultiTenantPrincipal principal = new MultiTenantPrincipal(userName, metadata);
        this.context = new TenantMetrics.TenantMetricsContext(principal);
        this.utils = new TenantMetricsTestUtils(this.metrics);
        this.sensors = new ConnectionSensorBuilder(this.metrics, principal).build();
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testRecordConnectionAndDisconnectionBringsActiveConnectionsToZero() {
        int i;
        for (i = 0; i < 5; ++i) {
            this.sensors.recordAuthenticatedConnection();
            Assertions.assertEquals((double)((double)i + 1.0), (double)((Double)this.utils.metric("active-authenticated-connection-count").metricValue()), (double)0.0);
        }
        for (i = 5; i > 0; --i) {
            this.sensors.recordAuthenticatedDisconnection();
            Assertions.assertEquals((double)((double)i - 1.0), (double)((Double)this.utils.metric("active-authenticated-connection-count").metricValue()), (double)0.0);
        }
        Map<String, KafkaMetric> metrics = this.utils.verifyTenantMetrics(this.context, "successful-authentication-rate", "successful-authentication-total");
        Assertions.assertEquals((double)5.0, (double)((Double)metrics.get("successful-authentication-total").metricValue()), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)((Double)this.utils.metric("active-authenticated-connection-count").metricValue()), (double)0.0);
    }

    @Test
    public void testRecordAuthenticatedConnectionIncrementsRateTotalAndActiveConnections() {
        this.sensors.recordAuthenticatedConnection();
        this.utils.verifyTenantMetrics(this.context, "successful-authentication-rate", "successful-authentication-total", "active-authenticated-connection-count");
    }

    @Test
    public void testRecordAuthenticatedConnectionsPerTenant() {
        TenantMetadata firstTenantMetadataU1 = new TenantMetadata.Builder("tenant1", "u-1").build();
        TenantMetadata firstTenantMetadataU2 = new TenantMetadata.Builder("tenant1", "u-2").build();
        MultiTenantPrincipal firstTenantU1 = new MultiTenantPrincipal("user1", firstTenantMetadataU1);
        MultiTenantPrincipal firstTenantU2 = new MultiTenantPrincipal("user2", firstTenantMetadataU2);
        TenantMetadata secondTenantMetadataU1 = new TenantMetadata.Builder("tenant2", "u-1").build();
        MultiTenantPrincipal secondTenantU1 = new MultiTenantPrincipal("user1", secondTenantMetadataU1);
        TenantMetrics.TenantMetricsContext firstTenantU1Context = new TenantMetrics.TenantMetricsContext(firstTenantU1);
        TenantMetrics.TenantMetricsContext firstTenantU2Context = new TenantMetrics.TenantMetricsContext(firstTenantU2);
        TenantMetrics.TenantMetricsContext secondTenantU1Context = new TenantMetrics.TenantMetricsContext(secondTenantU1);
        ConnectionSensors firstTenantU1Sensors = new ConnectionSensorBuilder(this.metrics, firstTenantU1).build();
        ConnectionSensors firstTenantU2Sensors = new ConnectionSensorBuilder(this.metrics, firstTenantU2).build();
        ConnectionSensors secondTenantU1Sensors = new ConnectionSensorBuilder(this.metrics, secondTenantU1).build();
        for (int i = 0; i < 5; ++i) {
            firstTenantU1Sensors.recordAuthenticatedConnection();
        }
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)firstTenantU1Context, TenantMetricsTestUtils.TENANT_CONNECTION_METRICS);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)firstTenantU2Context, true, TenantMetricsTestUtils.TENANT_CONNECTION_METRICS);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)secondTenantU1Context, true, TenantMetricsTestUtils.TENANT_CONNECTION_METRICS);
        firstTenantU2Sensors.recordAuthenticatedConnection();
        Map<String, KafkaMetric> firstTenantU1Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)firstTenantU1Context, TenantMetricsTestUtils.TENANT_CONNECTION_METRICS);
        Map<String, KafkaMetric> firstTenantU2Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)firstTenantU2Context, TenantMetricsTestUtils.TENANT_CONNECTION_METRICS);
        Assertions.assertEquals((double)5.0, (double)((Double)firstTenantU1Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)((Double)firstTenantU2Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)secondTenantU1Context, true, TenantMetricsTestUtils.TENANT_CONNECTION_METRICS);
        for (int i = 0; i < 3; ++i) {
            secondTenantU1Sensors.recordAuthenticatedConnection();
        }
        Map<String, KafkaMetric> secondTenantU1Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)secondTenantU1Context, TenantMetricsTestUtils.TENANT_CONNECTION_METRICS);
        Assertions.assertEquals((double)3.0, (double)((Double)secondTenantU1Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
        firstTenantU1Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)firstTenantU1Context, TenantMetricsTestUtils.TENANT_CONNECTION_METRICS);
        firstTenantU2Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)firstTenantU2Context, TenantMetricsTestUtils.TENANT_CONNECTION_METRICS);
        Assertions.assertEquals((double)5.0, (double)((Double)firstTenantU1Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)((Double)firstTenantU2Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
        for (KafkaMetric metric : firstTenantU1Metrics.values()) {
            Assertions.assertEquals((Object)firstTenantMetadataU1.userResourceId, metric.metricName().tags().get("user-resource-id"));
        }
        for (KafkaMetric metric : firstTenantU2Metrics.values()) {
            Assertions.assertEquals((Object)firstTenantMetadataU2.userResourceId, metric.metricName().tags().get("user-resource-id"));
        }
    }
}

