/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantInterceptor;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkSourceMetricsTest;
import org.junit.jupiter.api.Assertions;

public class MultiTenantClusterLinkSourceMetricsTest
extends ClusterLinkSourceMetricsTest {
    private final String tenant = "tenant";

    protected BrokerInterceptor createInterceptor(Time time) {
        HashMap<String, Object> configs = new HashMap<String, Object>(){
            {
                this.put(KafkaConfig.BrokerIdProp(), 1);
                this.put(KafkaConfig.DefaultReplicationFactorProp(), (short)1);
                this.put(KafkaConfig.NumPartitionsProp(), 1);
                this.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", false);
                this.put("confluent.multitenant.interceptor.balancer.apis.enabled", false);
                this.put("confluent.schema.validator.multitenant.enable", false);
            }
        };
        MultiTenantInterceptor interceptor = new MultiTenantInterceptor(time);
        interceptor.configure((Map)configs);
        return interceptor;
    }

    protected KafkaPrincipal createPrincipal() {
        return new MultiTenantPrincipal("user", new TenantMetadata("tenant", "tenant"));
    }

    protected String responseTopic() {
        return "tenant_topic";
    }

    protected void verifyMetrics() {
        super.verifyMetrics();
        Set metricNames = this.metrics.metrics().keySet().stream().filter(m -> m.tags().containsKey("link-id")).collect(Collectors.toSet());
        for (MetricName metricName : metricNames) {
            Assertions.assertEquals((Object)"tenant", metricName.tags().get("tenant"));
        }
        Set tenantMetrics = this.metrics.metrics().keySet().stream().filter(m -> m.group().equals("tenant-metrics")).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)tenantMetrics.isEmpty(), (String)tenantMetrics.toString());
    }
}

