/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.Assertions;

public class TenantMetricsTestUtils {
    public static final String ACTIVE_AUTH_CONNECTIONS_BY_IP_METRIC_NAME = "active-authenticated-connection-by-ip-count";
    public static final String AUTH_RATE_BY_IP_METRIC_NAME = "successful-authentication-by-ip-rate";
    public static final String AUTH_TOTAL_BY_IP_METRIC_NAME = "successful-authentication-by-ip-total";
    public static final String ACTIVE_AUTH_CONNECTIONS_COUNT_METRIC_NAME = "active-authenticated-connection-count";
    public static final String[] TENANT_CONNECTION_METRICS = new String[]{"successful-authentication-rate", "successful-authentication-total", "active-authenticated-connection-count"};
    public static final String[] IP_CONNECTION_METRICS = new String[]{"successful-authentication-by-ip-rate", "successful-authentication-by-ip-total", "active-authenticated-connection-by-ip-count"};
    private Metrics metrics;

    public TenantMetricsTestUtils(Metrics metrics) {
        this.metrics = metrics;
    }

    public Map<String, KafkaMetric> verifyTenantMetrics(MetricsBuilderContext context, String ... expectedMetrics) {
        return TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, context, expectedMetrics);
    }

    public static Map<String, KafkaMetric> verifyTenantMetrics(Metrics metrics, MetricsBuilderContext context, String ... expectedMetrics) {
        return TenantMetricsTestUtils.verifyTenantMetrics(metrics, context, false, expectedMetrics);
    }

    public static Map<String, KafkaMetric> verifyTenantMetrics(Metrics metrics, MetricsBuilderContext context, boolean assertEmpty, String ... expectedMetrics) {
        TenantMetricsTestUtils.verifySensors(metrics, context.sensorSuffix(), expectedMetrics);
        List<String> expectedMetricsList = Arrays.asList(expectedMetrics);
        return TenantMetricsTestUtils.verifyMetrics(metrics, context.metricTags(), assertEmpty, expectedMetricsList);
    }

    private static Map<String, KafkaMetric> verifyMetrics(Metrics metrics, Map<String, String> tags, boolean assertEmpty, List<String> expectedMetricsList) {
        HashMap<String, KafkaMetric> metricsByName = new HashMap<String, KafkaMetric>();
        for (Map.Entry entry : metrics.metrics().entrySet()) {
            MetricName metricName = (MetricName)entry.getKey();
            if (!expectedMetricsList.contains(metricName.name()) || !tags.equals(metricName.tags())) continue;
            KafkaMetric metric = (KafkaMetric)entry.getValue();
            metricsByName.put(metricName.name(), metric);
            double value = (Double)metric.metricValue();
            if (assertEmpty) {
                Assertions.assertEquals((double)0.0, (double)value, (double)0.0, (String)String.format("Metric (%s) was recorded: %s", metricName, value));
                continue;
            }
            Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)String.format("Metric (%s) not recorded: %s", metricName, value));
        }
        return metricsByName;
    }

    public KafkaMetric metric(String wantedMetricName) {
        return this.metric(this.metrics, wantedMetricName);
    }

    public KafkaMetric metric(Metrics metrics, String wantedMetricName) {
        for (Map.Entry entry : metrics.metrics().entrySet()) {
            MetricName metricName = (MetricName)entry.getKey();
            if (!wantedMetricName.equals(metricName.name())) continue;
            return (KafkaMetric)entry.getValue();
        }
        return null;
    }

    public void verifyActiveTenantIpConnectionsMetrics(Map<MetricsBuilderContext, Double> expectedAuthCountMetricValues) {
        expectedAuthCountMetricValues.forEach((ctx, expected) -> {
            Map<String, KafkaMetric> tenantMetrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, ctx, expected == 0.0, IP_CONNECTION_METRICS);
            Assertions.assertEquals((double)expected, (double)((Double)tenantMetrics.get(ACTIVE_AUTH_CONNECTIONS_BY_IP_METRIC_NAME).metricValue()), (double)0.0);
        });
    }

    public void verifyActiveTenantConnectionsMetrics(Map<MetricsBuilderContext, Double> expectedAuthCountMetricValues) {
        expectedAuthCountMetricValues.forEach((ctx, expected) -> {
            Map<String, KafkaMetric> tenantMetrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, ctx, expected == 0.0, TENANT_CONNECTION_METRICS);
            Assertions.assertEquals((double)expected, (double)((Double)tenantMetrics.get(ACTIVE_AUTH_CONNECTIONS_COUNT_METRIC_NAME).metricValue()), (double)0.0);
        });
    }

    public static void verifySensors(Metrics metrics, String sensorSuffix, String ... expectedMetrics) {
        for (String metricName : expectedMetrics) {
            String name = metricName.substring(0, metricName.lastIndexOf(45));
            String sensorName = name + sensorSuffix;
            Sensor sensor = metrics.getSensor(sensorName);
            Assertions.assertNotNull((Object)sensor, (String)("Sensor not found " + sensorName));
        }
    }
}

