/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import io.confluent.kafka.multitenant.quota.QuotaConfig;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuotaConfigTest {
    private static final QuotaConfig TEST_CONFIG = new QuotaConfig(Long.valueOf(102400L), Long.valueOf(204800L), Double.valueOf(500.0), null, QuotaConfig.UNLIMITED_QUOTA);

    @Test
    public void testQuotaConfig() {
        Assertions.assertTrue((boolean)TEST_CONFIG.hasQuotaLimit(ClientQuotaType.PRODUCE));
        Assertions.assertEquals((double)102400.0, (double)TEST_CONFIG.quota(ClientQuotaType.PRODUCE), (double)1.0E-4);
        Assertions.assertTrue((boolean)TEST_CONFIG.hasQuotaLimit(ClientQuotaType.FETCH));
        Assertions.assertEquals((double)204800.0, (double)TEST_CONFIG.quota(ClientQuotaType.FETCH), (double)1.0E-4);
        Assertions.assertTrue((boolean)TEST_CONFIG.hasQuotaLimit(ClientQuotaType.REQUEST));
        Assertions.assertEquals((double)500.0, (double)TEST_CONFIG.quota(ClientQuotaType.REQUEST), (double)1.0E-4);
    }

    @Test
    public void testUnlimitedQuotaConfig() {
        Assertions.assertFalse((boolean)QuotaConfig.UNLIMITED_QUOTA.hasQuotaLimit(ClientQuotaType.PRODUCE));
        Assertions.assertFalse((boolean)QuotaConfig.UNLIMITED_QUOTA.hasQuotaLimit(ClientQuotaType.FETCH));
        Assertions.assertFalse((boolean)QuotaConfig.UNLIMITED_QUOTA.hasQuotaLimit(ClientQuotaType.REQUEST));
    }

    @Test
    public void testEqualQuotaPerBrokerNoBrokers() {
        long quotaNoBrokers = 12345L;
        Assertions.assertEquals((long)12345L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.PRODUCE, 0, Long.valueOf(12345L)), (String)"Unexpected produce broker quota");
        Assertions.assertEquals((long)12345L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.FETCH, 0, Long.valueOf(12345L)), (String)"Unexpected consume broker quota");
        Assertions.assertEquals((long)12345L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.REQUEST, 0, Long.valueOf(12345L)), (String)"Unexpected request broker quota");
    }

    @Test
    public void testEqualQuotaPerBroker() {
        Assertions.assertEquals((long)10240L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.PRODUCE, 10, Long.valueOf(12345L)), (String)"Unexpected produce broker quota");
        Assertions.assertEquals((long)20480L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.FETCH, 10, Long.valueOf(12345L)), (String)"Unexpected consume broker quota");
        Assertions.assertEquals((long)50L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.REQUEST, 10, Long.valueOf(12345L)), (String)"Unexpected request broker quota");
    }

    @Test
    public void testEqualQuotaPerBrokerForUnlimitedQuotasReturnsUnlimitedQuota() {
        Assertions.assertEquals((double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.PRODUCE), (double)QuotaConfig.UNLIMITED_QUOTA.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.PRODUCE, 10, Long.valueOf(13L)).doubleValue(), (double)1.0E-4, (String)"Unexpected produce broker quota for unlimited quota");
        Assertions.assertEquals((double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.FETCH), (double)QuotaConfig.UNLIMITED_QUOTA.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.FETCH, 10, Long.valueOf(123L)).doubleValue(), (double)1.0E-4, (String)"Unexpected consume broker quota for unlimited quota");
        Assertions.assertEquals((double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.REQUEST), (double)QuotaConfig.UNLIMITED_QUOTA.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.REQUEST, 10, Long.valueOf(11L)).doubleValue(), (double)1.0E-4, (String)"Unexpected request broker quota for unlimited quota");
    }

    @Test
    public void testWithQuota() {
        double updatedProduceQuota = 51200.0;
        Assertions.assertTrue((boolean)TEST_CONFIG.hasQuotaLimit(ClientQuotaType.PRODUCE));
        Assertions.assertEquals((double)102400.0, (double)TEST_CONFIG.quota(ClientQuotaType.PRODUCE), (double)1.0E-4);
        Assertions.assertTrue((boolean)TEST_CONFIG.hasQuotaLimit(ClientQuotaType.FETCH));
        Assertions.assertEquals((double)204800.0, (double)TEST_CONFIG.quota(ClientQuotaType.FETCH), (double)1.0E-4);
        Assertions.assertTrue((boolean)TEST_CONFIG.hasQuotaLimit(ClientQuotaType.REQUEST));
        Assertions.assertEquals((double)500.0, (double)TEST_CONFIG.quota(ClientQuotaType.REQUEST), (double)1.0E-4);
        QuotaConfig testConfigWithProduceQuota = TEST_CONFIG.withQuota(ClientQuotaType.PRODUCE, 51200.0);
        Assertions.assertNotEquals((Object)TEST_CONFIG, (Object)testConfigWithProduceQuota);
        Assertions.assertTrue((boolean)testConfigWithProduceQuota.hasQuotaLimit(ClientQuotaType.PRODUCE));
        Assertions.assertEquals((double)updatedProduceQuota, (double)testConfigWithProduceQuota.quota(ClientQuotaType.PRODUCE), (double)1.0E-4);
        Assertions.assertTrue((boolean)testConfigWithProduceQuota.hasQuotaLimit(ClientQuotaType.FETCH));
        Assertions.assertEquals((double)204800.0, (double)testConfigWithProduceQuota.quota(ClientQuotaType.FETCH), (double)1.0E-4);
        Assertions.assertTrue((boolean)testConfigWithProduceQuota.hasQuotaLimit(ClientQuotaType.REQUEST));
        Assertions.assertEquals((double)500.0, (double)testConfigWithProduceQuota.quota(ClientQuotaType.REQUEST), (double)1.0E-4);
    }
}

