/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.utils;

import io.confluent.kafka.multitenant.utils.Utils;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.protobuf.cloud.events.v1.EventsMetadata;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Random;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UtilsTest {
    private static final int TEST_REPETITONS = 1000;
    private final Random random = new Random();

    @Test
    public void testTryParseEventsSequenceIdFromString() {
        this.random.longs(1000L, 1L, Long.MAX_VALUE).forEach(v -> Assertions.assertEquals((long)v, (Long)Utils.tryParseEventsSequenceIdFromString((byte[])Long.toUnsignedString(v).getBytes(StandardCharsets.UTF_8))));
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceIdFromString((byte[])Long.toUnsignedString(0L).getBytes(StandardCharsets.UTF_8)), (String)"0 is invalid");
        this.random.longs(1000L, Long.MIN_VALUE, 0L).forEach(v -> Assertions.assertNull((Object)Utils.tryParseEventsSequenceIdFromString((byte[])Long.toUnsignedString(v).getBytes(StandardCharsets.UTF_8)), (String)"valid values are l < 2^63"));
        Assertions.assertThrows(NullPointerException.class, () -> Utils.tryParseEventsSequenceIdFromString(null), (String)"Null header");
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceIdFromString((byte[])"not-a-number".getBytes(StandardCharsets.UTF_8)), (String)"Valid UTF-8, but not a number");
        byte[] invalidUtf8 = new byte[]{-16, -92, -83};
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceIdFromString((byte[])invalidUtf8), (String)"Invalid UTF-8 string");
    }

    private ConsumerRecord<String, byte[]> createRecordForSequenceTests(Header[] headersArray) {
        RecordHeaders headers = new RecordHeaders(headersArray);
        return new ConsumerRecord("dontcare", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)"dontcare", null, (Headers)headers, Optional.empty());
    }

    @Test
    public void testTryParseEventsSequenceIdFromProto() {
        this.random.longs(1000L, 1L, Long.MAX_VALUE).forEach(v -> Assertions.assertEquals((long)v, (Long)Utils.tryParseEventsSequenceIdFromProto((byte[])KafkaTestUtils.buildEventMetadataContent(v))));
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceIdFromProto((byte[])KafkaTestUtils.buildEventMetadataContent(0L)), (String)"0 in invalid value");
        this.random.longs(1000L, Long.MIN_VALUE, 0L).forEach(v -> Assertions.assertNull((Object)Utils.tryParseEventsSequenceIdFromProto((byte[])KafkaTestUtils.buildEventMetadataContent(v)), (String)"Values values are l < 2^63"));
        Assertions.assertThrows(NullPointerException.class, () -> Utils.tryParseEventsSequenceIdFromProto(null), (String)"Null header");
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceIdFromProto((byte[])new byte[0]), (String)"Empty header");
        byte[] emptyProto = EventsMetadata.newBuilder().build().toByteArray();
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceIdFromProto((byte[])emptyProto), (String)"Empty protobuf");
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceIdFromProto((byte[])new byte[]{0, 1, 2}), (String)"Not a protobuf");
    }

    @Test
    public void testTryParseEventsSequenceId() {
        ConsumerRecord<String, byte[]> noHeaders = this.createRecordForSequenceTests(new Header[0]);
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceId(noHeaders), (String)"No sequence headers should return null");
        this.random.longs(1000L, 1L, Long.MAX_VALUE).forEach(v -> {
            byte[] headerContent = Long.toUnsignedString(v).getBytes(StandardCharsets.UTF_8);
            ConsumerRecord<String, byte[]> seqIdOnlyRecord = this.createRecordForSequenceTests(new Header[]{new RecordHeader("_sequence_id", headerContent)});
            Assertions.assertEquals((long)v, (Long)Utils.tryParseEventsSequenceId(seqIdOnlyRecord));
        });
        ConsumerRecord<String, byte[]> junkSeqId = this.createRecordForSequenceTests(new Header[]{new RecordHeader("_sequence_id", new byte[]{16})});
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceId(junkSeqId), (String)"Invalid _sequence_id should return null");
        this.random.longs(1000L, 1L, Long.MAX_VALUE).forEach(v -> {
            byte[] headerContent = KafkaTestUtils.buildEventMetadataContent(v);
            ConsumerRecord<String, byte[]> protoOnlyRecord = this.createRecordForSequenceTests(new Header[]{new RecordHeader("eventsmetadata", headerContent)});
            Assertions.assertEquals((long)v, (Long)Utils.tryParseEventsSequenceId(protoOnlyRecord));
        });
        byte[] notProto = new byte[]{0, 1};
        ConsumerRecord<String, byte[]> junkProtoBuf = this.createRecordForSequenceTests(new Header[]{new RecordHeader("_sequence_id", notProto)});
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceId(junkProtoBuf), (String)"Invalid eventsmetadata should return null");
        this.random.longs(1000L, 1L, 0x7FFFFFFFFFFFFFFEL).forEach(v -> {
            Header[] headers = new Header[]{new RecordHeader("_sequence_id", Long.toUnsignedString(v + 1L).getBytes(StandardCharsets.UTF_8)), new RecordHeader("eventsmetadata", KafkaTestUtils.buildEventMetadataContent(v))};
            ConsumerRecord<String, byte[]> bothRecord = this.createRecordForSequenceTests(headers);
            Assertions.assertEquals((long)v, (Long)Utils.tryParseEventsSequenceId(bothRecord));
        });
        ConsumerRecord<String, byte[]> junkProtoBufValidString = this.createRecordForSequenceTests(new Header[]{new RecordHeader("_sequence_id", "1234".getBytes(StandardCharsets.UTF_8)), new RecordHeader("_sequence_id", notProto)});
        Assertions.assertNull((Object)Utils.tryParseEventsSequenceId(junkProtoBufValidString), (String)"Invalid eventsmetadata should return null");
    }
}

