/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer;

import io.confluent.kafka.multitenant.utils.Utils;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.UnaryOperator;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.audit.AuditEvent;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.AuthenticationEvent;
import org.apache.kafka.test.TestUtils;

public class MockAuditLogProvider
implements AuditLogProvider,
ClusterResourceListener {
    public static final String AUDIT_PROVIDER_CONFIG = "ce.broker.plugins.test.audit.provider.config";
    public static final Map<String, MockAuditLogProvider> INSTANCES = new HashMap<String, MockAuditLogProvider>();
    public final List<ConfluentAuthorizationEvent> authorizationLog = new ArrayList<ConfluentAuthorizationEvent>();
    public final List<AuthenticationEvent> authenticationLog = new ArrayList<AuthenticationEvent>();
    private final ArrayList<String> states = new ArrayList();
    private boolean fail = false;
    private UnaryOperator<AuditEvent> santizer;
    private Scope scope;

    public Set<String> reconfigurableConfigs() {
        return Collections.emptySet();
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Map<String, ?> configs) {
        String brokerSessionUuid = Utils.getBrokerSessionUuid(configs);
        Map<String, MockAuditLogProvider> map = INSTANCES;
        synchronized (map) {
            MockAuditLogProvider instance = INSTANCES.get(brokerSessionUuid);
            if (instance == null) {
                INSTANCES.put(brokerSessionUuid, this);
            } else if (this != instance) {
                throw new UnsupportedOperationException("MockAuditLogProvider instance already exists for broker session " + brokerSessionUuid);
            }
        }
        this.states.add("configured");
    }

    public CompletionStage<Void> start(Map<String, ?> interBrokerListenerConfigs) {
        this.states.add("started");
        return new CompletableFuture<Void>();
    }

    public boolean providerConfigured(Map<String, ?> configs) {
        if (!"TEST".equals(configs.get(AUDIT_PROVIDER_CONFIG))) {
            return false;
        }
        if (configs.containsKey("confluent.security.event.logger.enable")) {
            return !"false".equals(configs.get("confluent.security.event.logger.enable"));
        }
        return true;
    }

    public void setSanitizer(UnaryOperator<AuditEvent> sanitizer) {
        this.santizer = sanitizer;
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return false;
    }

    public void logEvent(AuditEvent auditEvent) {
        if (this.fail) {
            throw new RuntimeException("MockAuditLogProvider intentional failure");
        }
        if (auditEvent.type() == AuditEventType.AUTHORIZATION) {
            this.handleAuthorizationEvent((ConfluentAuthorizationEvent)auditEvent);
        } else if (auditEvent.type() == AuditEventType.AUTHENTICATION) {
            this.handleAuthenticationEvent((AuthenticationEvent)auditEvent);
        } else {
            throw new UnsupportedOperationException("Event type is not supported: " + auditEvent.type());
        }
    }

    private void handleAuthenticationEvent(AuthenticationEvent auditEvent) {
        ConfluentAuthenticationEvent authenticationEvent = auditEvent instanceof ConfluentAuthenticationEvent ? (ConfluentAuthenticationEvent)auditEvent : new ConfluentAuthenticationEvent(auditEvent, this.scope);
        if (this.santizer != null) {
            authenticationEvent = (ConfluentAuthenticationEvent)this.santizer.apply((AuditEvent)authenticationEvent);
        }
        this.authenticationLog.add((AuthenticationEvent)authenticationEvent);
    }

    private void handleAuthorizationEvent(ConfluentAuthorizationEvent authZEvent) {
        if (this.santizer != null) {
            authZEvent = (ConfluentAuthorizationEvent)this.santizer.apply((AuditEvent)authZEvent);
        }
        if (authZEvent.action().logIfAllowed() && authZEvent.authorizeResult() == AuthorizeResult.ALLOWED || authZEvent.action().logIfDenied() && authZEvent.authorizeResult() == AuthorizeResult.DENIED) {
            this.authorizationLog.add(authZEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String brokerSessionUuid) throws Exception {
        Map<String, MockAuditLogProvider> map = INSTANCES;
        synchronized (map) {
            MockAuditLogProvider instance = INSTANCES.get(brokerSessionUuid);
            if (instance == this) {
                instance.close();
                INSTANCES.remove(brokerSessionUuid);
            }
        }
    }

    public void close() {
    }

    ConfluentAuthorizationEvent lastAuthorizationEntry() {
        return this.authorizationLog.get(this.authorizationLog.size() - 1);
    }

    public AuthenticationEvent lastAuthenticationEntry() {
        return this.authenticationLog.get(this.authenticationLog.size() - 1);
    }

    void ensureStarted() throws Exception {
        TestUtils.waitForCondition(() -> this.states.equals(Arrays.asList("configured", "started")), (String)("Audit log provider not started, states=" + this.states));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MockAuditLogProvider getInstance(String brokerSessionUuid) {
        Map<String, MockAuditLogProvider> map = INSTANCES;
        synchronized (map) {
            return INSTANCES.get(brokerSessionUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Map<String, MockAuditLogProvider> map = INSTANCES;
        synchronized (map) {
            INSTANCES.clear();
        }
    }

    void setFail(boolean fail) {
        this.fail = fail;
    }

    public void onUpdate(ClusterResource clusterResource) {
        this.scope = Scope.kafkaClusterScope((String)clusterResource.clusterId());
    }
}

