/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.server.plugins.auth.AbstractFileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.server.plugins.auth.FileBasedLoginModule;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.FileBasedSaslServerFactory;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsLoader;
import io.confluent.kafka.server.plugins.auth.PlainSaslServer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.security.plain.internals.PlainServerCallbackHandler;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedPlainSaslAuthenticatorTest
extends AbstractFileBasedPlainSaslAuthenticatorTest {
    private static final Logger log = LoggerFactory.getLogger(FileBasedPlainSaslAuthenticatorTest.class);
    public static final String USER_ID_1 = "23";
    public static final String TENANT_NAME_1 = "lkc-bkey";
    public static final String CLUSTER_ID_1 = "lkc-bkey";

    @Override
    protected FileBasedPlainSaslAuthenticator createAuthenticator() {
        return new FileBasedPlainSaslAuthenticator();
    }

    @Test
    public void testHashedPasswordAuth() throws Exception {
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.empty());
        this.assertPrincipal("lkc-bkey_23", USER_ID_1, "lkc-bkey", "lkc-bkey", true, principal);
    }

    @Test
    public void testPlainPasswordAuth() throws Exception {
        for (int i = 0; i < 3; ++i) {
            MultiTenantPrincipal principal = this.saslAuth.authenticate("pkey", "no hash", Optional.empty());
            this.assertPrincipal("confluent_7", "7", "confluent", "confluent", true, principal);
        }
    }

    @Test
    public void testServiceAccountAuth() throws Exception {
        for (int i = 0; i < 3; ++i) {
            MultiTenantPrincipal principal = this.saslAuth.authenticate("skey", "service secret", Optional.empty());
            Assertions.assertEquals((Object)"test_service_11", (Object)principal.getName());
            Assertions.assertEquals((Object)"11", (Object)principal.user());
            Assertions.assertEquals((Object)"test_service", (Object)principal.tenantMetadata().tenantName);
            Assertions.assertEquals((Object)"test_service", (Object)principal.tenantMetadata().clusterId);
            Assertions.assertFalse((boolean)principal.isSuperUser(false, false));
        }
    }

    @Test
    public void testInvalidUser() throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                this.saslAuth.authenticate("no_user", "blah", Optional.empty());
                Assertions.fail((String)"Invalid user name should fail the authentication");
                continue;
            }
            catch (SaslAuthenticationException e) {
                Assertions.assertEquals((Object)"Authentication failed", (Object)e.getMessage());
                Assertions.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)e.errorInfo().auditEventStatus());
                Assertions.assertEquals((Object)"Unknown user no_user", (Object)e.errorInfo().errorMessage());
                Assertions.assertEquals((Object)"no_user", (Object)e.errorInfo().identifier());
                Assertions.assertEquals((Object)"", (Object)e.errorInfo().clusterId());
            }
        }
    }

    @Test
    public void testInvalidHashedPassword() throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                this.saslAuth.authenticate("bkey", "not right", Optional.empty());
                Assertions.fail((String)"Invalid hashed password should fail the authentication");
                continue;
            }
            catch (SaslAuthenticationException e) {
                Assertions.assertEquals((Object)"Authentication failed", (Object)e.getMessage());
                Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)e.errorInfo().auditEventStatus());
                Assertions.assertEquals((Object)"Bad password for user bkey", (Object)e.errorInfo().errorMessage());
                Assertions.assertEquals((Object)"bkey", (Object)e.errorInfo().identifier());
                Assertions.assertEquals((Object)"lkc-bkey", (Object)e.errorInfo().clusterId());
            }
        }
    }

    @Test
    public void testInvalidPlainPassword() throws Exception {
        try {
            this.saslAuth.authenticate("pkey", "not right", Optional.empty());
            Assertions.fail((String)"Invalid plain password should fail the authentication");
        }
        catch (SaslAuthenticationException e) {
            Assertions.assertEquals((Object)"Authentication failed", (Object)e.getMessage());
            Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)e.errorInfo().auditEventStatus());
            Assertions.assertEquals((Object)"Bad password for user pkey", (Object)e.errorInfo().errorMessage());
            Assertions.assertEquals((Object)"pkey", (Object)e.errorInfo().identifier());
            Assertions.assertEquals((Object)"confluent", (Object)e.errorInfo().clusterId());
        }
    }

    @Test
    public void testCheckpwPerSecond() throws Exception {
        long now;
        String configFilePath = FileBasedPlainSaslAuthenticator.configEntryOption((List)this.jaasEntries, (String)"config_path", (String)FileBasedLoginModule.class.getName());
        MultiTenantSaslSecretsLoader loader = new MultiTenantSaslSecretsLoader(1);
        Map.Entry entry = loader.load(configFilePath, 100L, 100000000L).entries().entrySet().iterator().next();
        long calls = 0L;
        long startMs = Time.SYSTEM.milliseconds();
        long endMs = startMs + 1000L;
        do {
            BCrypt.checkpw((String)((MultiTenantSaslConfigEntry)entry.getValue()).userId(), (String)((MultiTenantSaslConfigEntry)entry.getValue()).hashedSecret());
            ++calls;
        } while ((now = Time.SYSTEM.milliseconds()) < endMs);
        double duration = (double)(endMs - startMs) / 1000.0;
        log.info("testCheckpwPerSecond: performed {} operations in {} seconds.  Average sec/op = {}", new Object[]{calls, duration, duration / (double)calls});
    }

    @Test
    public void testServerFactory() throws SaslException {
        FileBasedSaslServerFactory factory = new FileBasedSaslServerFactory();
        PlainServerCallbackHandler cbh = new PlainServerCallbackHandler();
        Map emptyMap = Collections.emptyMap();
        cbh.configure(emptyMap, "PLAIN", this.jaasEntries);
        PlainSaslServer server = (PlainSaslServer)factory.createSaslServer("PLAIN", "", "", emptyMap, (CallbackHandler)cbh);
        Assertions.assertNotNull((Object)server, (String)"Server not created");
    }

    @Test
    public void testPKCClusterIdShouldAuthenticateUserInLegacyMode() throws Exception {
        this.setAuthenticatorValidationMode("allow_legacy_bootstrap");
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.of(new PathAwareSniHostName("pkc-12345.wrong.host.name")));
        this.assertPrincipal("lkc-bkey_23", USER_ID_1, "lkc-bkey", "lkc-bkey", true, principal);
    }

    @Test
    public void testIncorrectClusterIdShouldAuthenticateUserInOptionalMode() throws Exception {
        this.setAuthenticatorValidationMode("optional_validation");
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.of(new PathAwareSniHostName("wrong.host.name")));
        this.assertPrincipal("lkc-bkey_23", USER_ID_1, "lkc-bkey", "lkc-bkey", true, principal);
    }

    @Test
    public void testIncorrectClusterIdShouldFailAuthenticationInStrictMode() throws Exception {
        this.setAuthenticatorValidationMode("strict");
        try {
            this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.of(new PathAwareSniHostName("lkc-wrong-00aa.host.name")));
            Assertions.fail((String)"Incorrect cluster Id should fail the authentication.");
        }
        catch (SaslAuthenticationException e) {
            Assertions.assertEquals((Object)"Authentication failed", (Object)e.getMessage());
            Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)e.errorInfo().auditEventStatus());
            Assertions.assertEquals((Object)String.format("SNI cluster ID: %s does not match API key cluster ID %s for user name: %s", "lkc-wrong", "lkc-bkey", "bkey"), (Object)e.errorInfo().errorMessage());
            Assertions.assertEquals((Object)"bkey", (Object)e.errorInfo().identifier());
            Assertions.assertEquals((Object)"lkc-bkey", (Object)e.errorInfo().clusterId());
        }
    }

    @Test
    public void testCorrectClusterIdShouldAuthenticateUser() throws Exception {
        this.setAuthenticatorValidationMode("strict");
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.of(new PathAwareSniHostName("lkc-bkey-0aa.rufus.confluent.cloud")));
        this.assertPrincipal("lkc-bkey_23", USER_ID_1, "lkc-bkey", "lkc-bkey", true, principal);
    }

    @Test
    public void testUnrecognizedUserShouldReturnEmptyClusterId() throws SaslException {
        Assertions.assertEquals(Optional.of("lkc-bkey"), (Object)this.saslAuth.clusterId("bkey"));
        Assertions.assertEquals(Optional.empty(), (Object)this.saslAuth.clusterId("no-user"));
    }

    private void assertPrincipal(String expectedUserName, String expectedUserId, String expectedTenantName, String expectedClusterId, boolean expectedIsSuperUser, MultiTenantPrincipal actualPrincipal) {
        Assertions.assertEquals((Object)expectedUserName, (Object)actualPrincipal.getName());
        Assertions.assertEquals((Object)expectedUserId, (Object)actualPrincipal.user());
        Assertions.assertEquals((Object)expectedTenantName, (Object)actualPrincipal.tenantMetadata().tenantName);
        Assertions.assertEquals((Object)expectedClusterId, (Object)actualPrincipal.tenantMetadata().clusterId);
        Assertions.assertEquals((Object)expectedIsSuperUser, (Object)actualPrincipal.isSuperUser(false, false));
    }
}

