/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.test.TestUtils;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthUtils {
    private static final Logger log = LoggerFactory.getLogger(OAuthUtils.class);

    public static JwsContainer setUpJws(Integer expiration, String issuer, String subject, Integer[] userIds, String[] allowedClusters, String jku, boolean withKid) throws Exception {
        KeyPair keyPair = OAuthUtils.generateKeyPair();
        File publicKeyFile = TestUtils.tempFile();
        OAuthUtils.writePemFile(publicKeyFile, keyPair.getPublic());
        String uuid = UUID.randomUUID().toString();
        String jws = OAuthUtils.sign(keyPair.getPrivate(), expiration, issuer, subject, allowedClusters, withKid ? uuid : null, jku);
        HashMap<Integer, String> userTokens = new HashMap<Integer, String>();
        for (Integer userId : userIds) {
            String userJws = OAuthUtils.sign(keyPair.getPrivate(), expiration, issuer, userId + "", allowedClusters, withKid ? uuid : null, jku);
            userTokens.put(userId, userJws);
        }
        return new JwsContainer(jws, userTokens, publicKeyFile, keyPair.getPublic(), uuid);
    }

    public static JwsContainer setUpJws(Integer expiration, String issuer, String subject, Integer[] userIds, String[] allowedClusters) throws Exception {
        return OAuthUtils.setUpJws(expiration, issuer, subject, userIds, allowedClusters, null, false);
    }

    public static JwsContainer setUpJws(Integer expiration, String issuer, String subject, String[] allowedClusters) throws Exception {
        return OAuthUtils.setUpJws(expiration, issuer, subject, new Integer[0], allowedClusters, null, false);
    }

    static void writePemFile(File publicKeyFile, PublicKey publicKey) throws IOException {
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new FileWriter(publicKeyFile));
        pemWriter.writeObject((Object)publicKey);
        pemWriter.close();
    }

    static KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        return keyGen.genKeyPair();
    }

    private static String sign(PrivateKey key, Integer expiration, String issuer, String subject, String[] allowedClusters, String uuid, String jku) {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setIssuer(issuer);
            if (expiration != null) {
                NumericDate expirationTime = NumericDate.now();
                expirationTime.addSeconds((long)(expiration / 1000));
                claims.setExpirationTime(expirationTime);
            }
            claims.setGeneratedJwtId();
            claims.setIssuedAtToNow();
            claims.setNotBeforeMinutesInThePast(2.0f);
            claims.setStringListClaim("clusters", allowedClusters);
            if (subject != null) {
                claims.setSubject(subject);
            }
            claims.setClaim("monitoring", (Object)true);
            claims.setClaim("userResourceId", (Object)("u-" + subject));
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)key);
            jws.setAlgorithmHeaderValue("RS256");
            if (uuid != null) {
                jws.setKeyIdHeaderValue(uuid);
            }
            if (jku != null) {
                jws.setHeader("jku", jku);
            }
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            log.error("Error creating JWS for test");
            return null;
        }
    }

    private static String sign(PrivateKey key, Integer expiration, String issuer, String subject, String[] allowedClusters, String uuid) {
        return OAuthUtils.sign(key, expiration, issuer, subject, allowedClusters, uuid, null);
    }

    public static class JwsContainer {
        private final String jwsToken;
        private final File publicKeyFile;
        private final Map<Integer, String> userTokens;
        private PublicKey key;
        private String kid;

        public JwsContainer(String jwsToken, Map<Integer, String> userTokens, File publicKeyFile) {
            this(jwsToken, userTokens, publicKeyFile, null, null);
        }

        public JwsContainer(String jwsToken, Map<Integer, String> userTokens, File publicKeyFile, PublicKey key, String uuid) {
            this.jwsToken = jwsToken;
            this.userTokens = userTokens;
            this.publicKeyFile = publicKeyFile;
            this.key = key;
            this.kid = uuid;
        }

        public File getPublicKeyFile() {
            return this.publicKeyFile;
        }

        public String getJwsToken() {
            return this.jwsToken;
        }

        public Map<Integer, String> userTokens() {
            return this.userTokens;
        }

        public PublicKey verificationKey() {
            return this.key;
        }

        public String getKid() {
            return this.kid;
        }
    }
}

