/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.server.plugins.policy.CreateTopicPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateTopicPolicyTest {
    static final Map<String, Integer> SAMPLE_TOPICS_TO_NUM_PARTITIONS = new HashMap<String, Integer>();
    static final Map<String, String> VALID_SAMPLE_TOPIC_CONFIG;
    static final Map<String, String> INVALID_SAMPLE_TOPIC_CONFIG;
    static final Map<String, String> SCHEMA_VALIDATION_TOPIC_CONFIG;

    @Test
    public void testEnsureValidPartitionCount() {
        CreateTopicPolicy.ensureValidPartitionCount((String)"foo", (int)10, (int)1, (int)2);
        CreateTopicPolicy.ensureValidPartitionCount((String)"foo", (int)10, (int)9, (int)1);
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidPartitionCount((String)"foo", (int)10, (int)9, (int)2));
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidPartitionCount((String)"foo", (int)10, (int)0, (int)11));
    }

    @Test
    public void testFullUpdate() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            Assertions.assertEquals((int)4, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)4, (Integer)ctx.metricValue("lkc-abcde"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("lkc-fghij"));
            Assertions.assertEquals((int)0, (int)ctx.policy.numPartitions("lkc-klmno"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("lkc-klmno"));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap()));
        }
    }

    @Test
    public void testPartialUpdates() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            ctx.policy.partialUpdate("lkc-abcde_foo", -2);
            Assertions.assertEquals((int)2, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("lkc-abcde"));
            ctx.policy.partialUpdate("blah", -2);
            Assertions.assertEquals((int)2, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("lkc-abcde"));
            ctx.policy.partialUpdate("lkc-abcde_foo", -2);
            ctx.policy.partialUpdate("lkc-xyzab_", 2);
            Assertions.assertEquals((int)0, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("lkc-abcde"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("lkc-fghij"));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap()));
            ctx.policy.partialUpdate("lkc-fghij_baz", 4);
            Assertions.assertEquals((int)5, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap())));
        }
    }

    @Test
    public void testTooManyTopics() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap()));
            Assertions.assertEquals((Object)"You may not create more than the maximum number of partitions (5).", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(6), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than 1 new partitions. Adding the requested number of partitions will exceed 5 total partitions. Currently, there are 4 total topic partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(2), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testInvalidRequestMetadata() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            Assertions.assertEquals((Object)"Invalid topic name specified.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Invalid topic name specified.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_::", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Must specify number of partitions.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", null, null, null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Topic replication factor must be 3", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", Integer.valueOf(1), Short.valueOf((short)2), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Must specify number of partitions.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", null, null, Collections.emptyMap(), Collections.emptyMap())))).getMessage());
            HashMap<Integer, List<Integer>> assignments = new HashMap<Integer, List<Integer>>();
            assignments.put(0, Arrays.asList(5, 6, 7, 8));
            assignments.put(1, Arrays.asList(8, 7, 6, 5));
            Assertions.assertEquals((Object)"Topic replication factor must be 3", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", null, null, assignments, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testSettingTopicConfigs() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, VALID_SAMPLE_TOPIC_CONFIG));
            Assertions.assertEquals((Object)"Altering config property 'foobar' is disallowed.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(3), Short.valueOf((short)3), null, INVALID_SAMPLE_TOPIC_CONFIG)))).getMessage());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(3), Short.valueOf((short)3), null, SCHEMA_VALIDATION_TOPIC_CONFIG)));
        }
    }

    @Test
    public void rejectsInvalidMinInSyncReplicasConfig() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            Assertions.assertEquals((Object)"Config property 'min.insync.replicas' with value '0' must be greater or equal to 1 and less than 3, or left empty.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("min.insync.replicas", "0"))))).getMessage());
            Assertions.assertEquals((Object)"Config property 'min.insync.replicas' with value '4' must be greater or equal to 1 and less than 3, or left empty.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("min.insync.replicas", "4"))))).getMessage());
        }
    }

    @Test
    public void rejectsDeleteRetentionMsToHigh() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("delete.retention.ms", "60566400001"))));
        }
    }

    @Test
    public void rejectsSegmentBytesTooLow() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("segment.bytes", "52428799"))));
        }
    }

    @Test
    public void rejectsSegmentBytesTooHigh() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("segment.bytes", "1073741825"))));
        }
    }

    @Test
    public void rejectSegmentMsTooLow() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("segment.ms", "500000"))));
        }
    }

    @Test
    public void testNonTenantTopicsAreExempt() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("not-a-tenant-topic", Integer.valueOf(1000), Short.valueOf((short)30), null, Collections.emptyMap()));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("blah_abc", Integer.valueOf(100), Short.valueOf((short)3), null, INVALID_SAMPLE_TOPIC_CONFIG));
        }
    }

    @Test
    public void rejectsWhenTopicMetadataNotSet() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, false);){
            Assertions.assertThrows(NotControllerException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, VALID_SAMPLE_TOPIC_CONFIG)));
        }
    }

    @Test
    public void acceptSchemaValidationPropertiesWhenFeatureEnabled() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 7, true);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(2), Short.valueOf((short)3), null, SCHEMA_VALIDATION_TOPIC_CONFIG));
        }
    }

    static {
        SAMPLE_TOPICS_TO_NUM_PARTITIONS.put("lkc-abcde_foo", 2);
        SAMPLE_TOPICS_TO_NUM_PARTITIONS.put("lkc-abcde_bar", 2);
        SAMPLE_TOPICS_TO_NUM_PARTITIONS.put("baz", 2);
        SAMPLE_TOPICS_TO_NUM_PARTITIONS.put("lkc-fghij_bar", 1);
        VALID_SAMPLE_TOPIC_CONFIG = new HashMap<String, String>();
        VALID_SAMPLE_TOPIC_CONFIG.put("max.message.bytes", "10000");
        VALID_SAMPLE_TOPIC_CONFIG.put("retention.ms", Integer.toString(Integer.MAX_VALUE));
        VALID_SAMPLE_TOPIC_CONFIG.put("min.insync.replicas", "2");
        INVALID_SAMPLE_TOPIC_CONFIG = new HashMap<String, String>();
        INVALID_SAMPLE_TOPIC_CONFIG.put("max.message.bytes", "10000");
        INVALID_SAMPLE_TOPIC_CONFIG.put("foobar", "baz");
        SCHEMA_VALIDATION_TOPIC_CONFIG = new HashMap<String, String>();
        SCHEMA_VALIDATION_TOPIC_CONFIG.put("confluent.key.schema.validation", "true");
        SCHEMA_VALIDATION_TOPIC_CONFIG.put("confluent.key.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
        SCHEMA_VALIDATION_TOPIC_CONFIG.put("confluent.value.schema.validation", "false");
        SCHEMA_VALIDATION_TOPIC_CONFIG.put("confluent.value.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
    }

    static class CreateTopicPolicyTestContext
    implements AutoCloseable {
        final CreateTopicPolicy policy = new CreateTopicPolicy();
        final Metrics metrics;

        CreateTopicPolicyTestContext(int replicationFactor, int maxPartitionsPerTenant, boolean schemaValidationEnabled) {
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("confluent.plugins.topic.policy.replication.factor", String.valueOf(replicationFactor));
            configs.put("confluent.plugins.topic.policy.max.partitions.per.tenant", String.valueOf(maxPartitionsPerTenant));
            if (schemaValidationEnabled) {
                configs.put("confluent.schema.validator.multitenant.enable", "true");
            }
            this.policy.configure(configs);
            this.metrics = new Metrics();
            this.policy.registerMetrics(this.metrics);
        }

        Integer metricValue(String tenant) {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("tenant", tenant);
            MetricName name = this.metrics.metricName("partitions", "tenant-metrics", "", tags);
            KafkaMetric metric = this.metrics.metric(name);
            if (metric != null) {
                return (Integer)metric.metricValue();
            }
            return null;
        }

        @Override
        public void close() {
            this.policy.close();
            this.metrics.close();
        }
    }
}

