/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.test.utils;

import io.confluent.kafka.test.utils.ClientSecuritySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kafka.admin.AclCommand;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

public class AclCommandBuilder {
    private ClientSecuritySpec clientSecuritySpec;
    private String zookeeperConnect;
    private List<String> commandArguments;

    public AclCommandBuilder setClientSecuritySpec(ClientSecuritySpec clientSecuritySpec) {
        if (this.zookeeperConnect != null) {
            throw new IllegalArgumentException("AclCommand is already configured to connect with Zookeeper");
        }
        this.clientSecuritySpec = clientSecuritySpec;
        return this;
    }

    public AclCommandBuilder setZookeeperConnect(String zookeeperConnect) {
        if (this.clientSecuritySpec != null) {
            throw new IllegalArgumentException("AclCommand is already configured to connect with Admin");
        }
        this.zookeeperConnect = zookeeperConnect;
        return this;
    }

    public AclCommandBuilder clusterAclArgs(KafkaPrincipal principal, String op) {
        this.commandArguments = Arrays.asList("--add", "--cluster", "--operation=" + op, "--allow-principal=" + principal);
        return this;
    }

    public AclCommandBuilder topicBrokerReadAclArgs(KafkaPrincipal principal) {
        this.commandArguments = Arrays.asList("--add", "--topic=*", "--operation=Read", "--allow-principal=" + principal);
        return this;
    }

    public AclCommandBuilder produceAclArgs(KafkaPrincipal principal, String topic, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--topic=" + topic, "--producer", "--allow-principal=" + principal);
        return this;
    }

    public AclCommandBuilder consumeAclArgs(KafkaPrincipal principal, String topic, String consumerGroup, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--topic=" + topic, "--group=" + consumerGroup, "--consumer", "--allow-principal=" + principal);
        return this;
    }

    public AclCommandBuilder addConsumerGroupAclArgs(KafkaPrincipal principal, String consumerGroup, AclOperation op, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--group=" + consumerGroup, "--operation=" + SecurityUtils.operationName((AclOperation)op), "--allow-principal=" + principal);
        return this;
    }

    public AclCommandBuilder addTopicAclArgs(KafkaPrincipal principal, String topic, AclOperation op, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--topic=" + topic, "--operation=" + SecurityUtils.operationName((AclOperation)op), "--allow-principal=" + principal);
        return this;
    }

    public AclCommandBuilder addTopicDenyAclArgs(KafkaPrincipal principal, String topic, AclOperation op, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--topic=" + topic, "--operation=" + SecurityUtils.operationName((AclOperation)op), "--deny-principal=" + principal);
        return this;
    }

    public AclCommandBuilder deleteTopicAclArgs(KafkaPrincipal principal, String topic, String op) {
        this.commandArguments = Arrays.asList("--remove", "--force", "--topic=" + topic, "--operation=" + op, "--allow-principal=" + principal);
        return this;
    }

    public AclCommandBuilder addLicenseTopicAcl(KafkaPrincipal principal) {
        this.commandArguments = Arrays.asList("--add", "--topic=_confluent-command", "--operation=All", "--allow-principal=" + principal);
        return this;
    }

    public void execute() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.zookeeperConnect != null) {
            arguments.add("--authorizer-properties");
            arguments.add("zookeeper.connect=" + this.zookeeperConnect);
        } else if (this.clientSecuritySpec != null) {
            String commandConfigFilePath = this.clientSecuritySpec.writePropertiesAsTempFile();
            arguments.add("--bootstrap-server");
            arguments.add(this.clientSecuritySpec.bootstrapServers);
            arguments.add("--command-config");
            arguments.add(commandConfigFilePath);
        } else {
            throw new IllegalStateException("AclCommand has not been configured to connect with Zookeeper or Admin");
        }
        arguments.addAll(this.commandArguments);
        AclCommand.main((String[])arguments.toArray(new String[0]));
    }
}

