/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.SslCertificateSpecification;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;

public class Utils {
    static final SslCertificateSpecification SSL_CERT_SPEC_NO_TYPE = new SslCertificateSpecification(null, "mystorepassword", "pkcs.p12", Integer.valueOf(1), "fullchain.pem", "privkey.pem");
    static final SslCertificateSpecification SSL_CERT_SPEC_NO_PKCSFILE = new SslCertificateSpecification("PKCS12", "mystorepassword", null, Integer.valueOf(1), "fullchain.pem", "privkey.pem");
    static final SslCertificateSpecification SSL_CERT_SPEC_NO_PEMFILES = new SslCertificateSpecification("PKCS12", "mystorepassword", "pkcs.p12", Integer.valueOf(1), null, null);

    public static PhysicalClusterMetadata initiatePhysicalClusterMetadata(Map<String, Object> configs) throws IOException {
        return Utils.initiatePhysicalClusterMetadata(configs, ConfluentConfigs.MULTITENANT_METADATA_RELOAD_DELAY_MS_DEFAULT);
    }

    public static PhysicalClusterMetadata initiatePhysicalClusterMetadata(Map<String, Object> configs, long reloadDelay) throws IOException {
        configs.put("multitenant.metadata.reload.delay.ms", reloadDelay);
        PhysicalClusterMetadata metadata = new PhysicalClusterMetadata(new Metrics(), Time.SYSTEM);
        metadata.configure(configs);
        return metadata;
    }

    public static void createLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, true, dir, null);
    }

    public static void createInvalidLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, false, dir, null);
    }

    public static void updateLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, true, dir, null);
    }

    public static void updateInvalidLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, false, dir, null);
    }

    public static void deleteLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, true, true, dir, null);
    }

    public static void setPosixFilePermissions(KafkaLogicalClusterMetadata lcMeta, String posixFilePermissionsStr, Path dir) throws IOException {
        String lcFilename = lcMeta.logicalClusterId() + ".json";
        Path metaPath = Paths.get(dir.toString(), "..data", lcFilename);
        Files.setPosixFilePermissions(metaPath, PosixFilePermissions.fromString(posixFilePermissionsStr));
    }

    public static void createOrUpdateLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir, long lastModified) throws IOException {
        String lcFilename = lcMeta.logicalClusterId() + ".json";
        Utils.updateJsonFile(lcFilename, KafkaLogicalClusterUtils.logicalClusterJsonString((KafkaLogicalClusterMetadata)lcMeta, (boolean)true), false, dir, lastModified);
    }

    private static void updateLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, boolean remove, boolean valid, Path dir, Long lastModified) throws IOException {
        String lcFilename = lcMeta.logicalClusterId() + ".json";
        Utils.updateJsonFile(lcFilename, KafkaLogicalClusterUtils.logicalClusterJsonString((KafkaLogicalClusterMetadata)lcMeta, (boolean)valid), remove, dir, lastModified);
    }

    public static Path updateJsonFile(String jsonFilename, String jsonString, boolean remove, Path dir) throws IOException {
        return Utils.updateJsonFile(jsonFilename, jsonString, remove, dir, null);
    }

    public static Path updateJsonFile(String jsonFilename, String jsonString, boolean remove, Path dir, Long lastModified) throws IOException {
        Path dataDir;
        Path newDir = TestUtils.tempDirectory((Path)dir, null).toPath();
        Path lcFile = null;
        if (!remove) {
            lcFile = newDir.resolve(jsonFilename);
            Files.write(lcFile, jsonString.getBytes(), new OpenOption[0]);
            if (lastModified != null) {
                lcFile.toFile().setLastModified(lastModified);
            }
        }
        if (Files.exists(dataDir = dir.resolve("..data"), new LinkOption[0])) {
            Path oldDir = Files.readSymbolicLink(dataDir);
            try (Stream<Path> fileStream = Files.list(oldDir);){
                fileStream.forEach(filePath -> {
                    try {
                        if (!filePath.getFileName().toString().equals(jsonFilename)) {
                            Files.move(filePath, Paths.get(newDir.toString(), filePath.getFileName().toString()), new CopyOption[0]);
                        } else {
                            Files.delete(filePath);
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("Test failed to simulate logical cluster file creation.", ioe);
                    }
                });
            }
            Files.delete(dataDir);
            Files.delete(oldDir);
        }
        Files.createSymbolicLink(dataDir, newDir, new FileAttribute[0]);
        return lcFile;
    }

    static String sslCertSpecJsonString(SslCertificateSpecification sslSpec) {
        String json = "{\"ssl_certificate_encoding\": \"" + sslSpec.sslKeystoreType() + "\",\"ssl_keystore_filename\": \"" + sslSpec.pkcsCertFilename() + "\",\"ssl_pem_fullchain_filename\": \"" + sslSpec.sslPemFullchainFilename() + "\",\"ssl_pem_privkey_filename\": \"" + sslSpec.sslPemPrivkeyFilename() + "\"}";
        return json;
    }

    public static Path createSpecFile(Path dir, SslCertificateSpecification sslSpec) throws IOException {
        Path newDir = Files.createTempDirectory(dir, null, new FileAttribute[0]);
        Path sslSpecPath = Paths.get(newDir.toString(), "spec.json");
        String jsonString = Utils.sslCertSpecJsonString(sslSpec);
        Files.write(sslSpecPath, jsonString.getBytes(), new OpenOption[0]);
        return sslSpecPath;
    }

    public static void syncCerts(Path dir, URL url, String dirPath) throws IOException {
        String[] certFiles;
        String certs = url.getPath();
        Path tmpDataPath = Paths.get(dir.toRealPath(new LinkOption[0]).toString(), dirPath + "..data-tmp");
        Files.createDirectories(tmpDataPath, new FileAttribute[0]);
        String symlinkPath = String.valueOf(dir.toRealPath(new LinkOption[0])) + "/" + dirPath;
        String certDirPath = symlinkPath + "..data";
        String tmpCertDirPath = certDirPath + "-tmp";
        File syncCertFile = new File(certs);
        for (String certFile : certFiles = syncCertFile.list()) {
            Files.copy(Paths.get(syncCertFile.getCanonicalPath(), certFile), Paths.get(tmpCertDirPath, certFile), StandardCopyOption.REPLACE_EXISTING);
            Path symLinkFile = Paths.get(symlinkPath, certFile);
            if (Files.exists(symLinkFile, new LinkOption[0])) continue;
            Files.createSymbolicLink(symLinkFile, Paths.get(certDirPath, certFile), new FileAttribute[0]);
        }
        Path path = Paths.get(certDirPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        for (String certFile : certFiles) {
            Files.move(Paths.get(tmpCertDirPath, certFile), Paths.get(certDirPath, certFile), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void verifyInvalidECkuMetadataMetricPresent(String lkcId) throws InterruptedException {
        String name = "InvalidEckuMetadata";
        String type = "KafkaLogicalClusterMetadata";
        Map metricsMap = KafkaYammerMetrics.defaultRegistry().allMetrics();
        TestCondition condition = () -> metricsMap.entrySet().stream().filter(e -> {
            MetricName metricName = (MetricName)e.getKey();
            return metricName.getName().equals(name) && metricName.getType().equals(type) && metricName.getMBeanName().contains(String.format("%s=%s", "tenant", lkcId));
        }).filter(e -> {
            Gauge metricValue = (Gauge)e.getValue();
            return metricValue != null && (Integer)metricValue.value() >= 0;
        }).count() > 0L;
        TestUtils.waitForCondition((TestCondition)condition, (String)("Invalid ECKU metadata is not present for " + lkcId));
    }

    public static void verifyInvalidECkuMetadataMetricNotPresent(String lkcId) throws InterruptedException {
        String name = "InvalidEckuMetadata";
        String type = "KafkaLogicalClusterMetadata";
        Map metricsMap = KafkaYammerMetrics.defaultRegistry().allMetrics();
        TestCondition condition = () -> metricsMap.entrySet().stream().filter(e -> {
            MetricName metricName = (MetricName)e.getKey();
            return metricName.getName().equals(name) && metricName.getType().equals(type) && metricName.getMBeanName().contains(String.format("%s=%s", "tenant", lkcId));
        }).count() == 0L;
        TestUtils.waitForCondition((TestCondition)condition, (String)("Invalid ECKU metadata should not be present for " + lkcId));
    }
}

