/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class MultiTenantRequestInterceptorIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    @Override
    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        super.createPhysicalAndLogicalClusters(brokerProperties);
        this.awaitMetadataPropagation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testProduceAndFetchRequestInterceptors(String quorum) throws Throwable {
        this.setUp(6, Arrays.asList("0", "1", "2", "0", "1", "2"));
        this.createPhysicalAndLogicalClusters(this.nodeProps());
        AdminClient client1 = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        client1.createTopics(Collections.singletonList(new NewTopic(topic1, Optional.of(1), Optional.empty()))).all().get();
        this.testHarness.produce(this.logicalCluster1.user(11), topic1, 0, false);
        try {
            this.physicalCluster.superConfluentAdmin().alterClientQuotas(Collections.singletonList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", this.logicalCluster1.logicalClusterId())), Arrays.asList(new ClientQuotaAlteration.Op("reject_all_fetches", Double.valueOf(1.0)), new ClientQuotaAlteration.Op("reject_all_produces", Double.valueOf(1.0)))))).all().get();
        }
        catch (Exception e) {
            Assertions.fail((String)String.format("Failed to update tenant level config with exception: %s", e.getCause()), (Throwable)e);
        }
        Assertions.assertThrows(TopicAuthorizationException.class, () -> this.testHarness.produce(this.logicalCluster1.user(11), topic1, 0, false));
        try (KafkaConsumer<String, String> consumer = this.testHarness.createConsumer(this.logicalCluster1.user(11), "test-group", SecurityProtocol.SASL_PLAINTEXT);){
            consumer.subscribe(Collections.singleton(topic1));
            Assertions.assertThrows(TopicAuthorizationException.class, () -> consumer.poll(Duration.ofSeconds(5L)));
        }
        this.testHarness.produceConsume(this.logicalCluster2.user(21), this.logicalCluster2.user(22), topic2, "group2", 0);
        this.testHarness.produceConsume(this.logicalCluster3.user(31), this.logicalCluster3.user(32), topic3, "group3", 0);
        try {
            this.physicalCluster.superConfluentAdmin().alterClientQuotas(Collections.singletonList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", this.logicalCluster1.logicalClusterId())), Arrays.asList(new ClientQuotaAlteration.Op("reject_all_fetches", Double.valueOf(0.0)), new ClientQuotaAlteration.Op("reject_all_produces", Double.valueOf(0.0)))))).all().get();
        }
        catch (Exception e) {
            Assertions.fail((String)String.format("Failed to update tenant level config with exception: %s", e.getCause()), (Throwable)e);
        }
        this.testHarness.produce(this.logicalCluster1.user(11), topic1, 0, false);
        consumer = this.testHarness.createConsumer(this.logicalCluster1.user(11), "test-group", SecurityProtocol.SASL_PLAINTEXT);
        try {
            consumer.subscribe(Collections.singleton(topic1));
            consumer.poll(Duration.ofSeconds(5L));
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
    }
}

