/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.ConnectionSensors;
import io.confluent.kafka.multitenant.metrics.IpConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.metrics.TenantMetricsTestUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IpConnectionSensorsTest {
    private TenantMetricsTestUtils utils;
    private ConnectionSensors sensors;
    private Metrics metrics;
    private String ip1 = "127.0.0.1";
    private String ip2 = "127.1.2.3";
    private MetricsBuilderContext context;

    @BeforeEach
    public void setUp() throws UnknownHostException {
        String tenantName = "tenant";
        String userName = "user";
        this.metrics = new Metrics();
        MultiTenantPrincipal principal = new MultiTenantPrincipal(userName, new TenantMetadata(tenantName, "cluster-1"));
        InetAddress clientAddress = InetAddress.getByName(this.ip1);
        this.context = new TenantMetrics.TenantIpMetricsContext(principal, clientAddress);
        this.utils = new TenantMetricsTestUtils(this.metrics);
        this.sensors = new IpConnectionSensorBuilder(this.metrics, principal, clientAddress).build();
    }

    @Test
    public void testRecordConnectionAndDisconnectionBringsActiveConnectionsToZero() {
        for (int i = 0; i < 5; ++i) {
            this.sensors.recordAuthenticatedConnection();
            Assertions.assertEquals((double)((double)i + 1.0), (double)((Double)this.utils.metric("active-authenticated-connection-by-ip-count").metricValue()), (double)0.0);
        }
        Map<String, KafkaMetric> metrics = this.utils.verifyTenantMetrics(this.context, TenantMetricsTestUtils.IP_CONNECTION_METRICS);
        for (int i = 5; i > 0; --i) {
            this.sensors.recordAuthenticatedDisconnection();
            Assertions.assertEquals((double)((double)i - 1.0), (double)((Double)this.utils.metric("active-authenticated-connection-by-ip-count").metricValue()), (double)0.0);
        }
        Assertions.assertEquals((double)5.0, (double)((Double)metrics.get("successful-authentication-by-ip-total").metricValue()), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)((Double)metrics.get("active-authenticated-connection-by-ip-count").metricValue()), (double)0.0);
    }

    @Test
    public void testRecordAuthenticatedConnectionIncrementsRateTotalAndActiveConnections() {
        this.sensors.recordAuthenticatedConnection();
        this.utils.verifyTenantMetrics(this.context, TenantMetricsTestUtils.IP_CONNECTION_METRICS);
    }

    @Test
    public void testRecordedAuthPerTenantAndIp() throws UnknownHostException {
        int i;
        MultiTenantPrincipal firstTenant = new MultiTenantPrincipal("user", new TenantMetadata("tenant1", "cluster-1"));
        MultiTenantPrincipal secondTenant = new MultiTenantPrincipal("user", new TenantMetadata("tenant2", "cluster-1"));
        InetAddress clientAddress1 = InetAddress.getByName(this.ip1);
        InetAddress clientAddress2 = InetAddress.getByName(this.ip2);
        HashMap<MetricsBuilderContext, Double> expectedValues = new HashMap<MetricsBuilderContext, Double>();
        TenantMetrics.TenantIpMetricsContext firstTenantIp1Context = new TenantMetrics.TenantIpMetricsContext(firstTenant, clientAddress1);
        TenantMetrics.TenantIpMetricsContext firstTenantIp2Context = new TenantMetrics.TenantIpMetricsContext(firstTenant, clientAddress2);
        TenantMetrics.TenantIpMetricsContext secondTenantIp1Context = new TenantMetrics.TenantIpMetricsContext(secondTenant, clientAddress1);
        expectedValues.put((MetricsBuilderContext)firstTenantIp1Context, 0.0);
        expectedValues.put((MetricsBuilderContext)firstTenantIp2Context, 0.0);
        expectedValues.put((MetricsBuilderContext)secondTenantIp1Context, 0.0);
        ConnectionSensors firstTenantIp1Sensors = new IpConnectionSensorBuilder(this.metrics, firstTenant, clientAddress1).build();
        ConnectionSensors firstTenantIp2Sensors = new IpConnectionSensorBuilder(this.metrics, firstTenant, clientAddress2).build();
        ConnectionSensors secondTenantIp1Sensors = new IpConnectionSensorBuilder(this.metrics, secondTenant, clientAddress1).build();
        for (i = 0; i < 2; ++i) {
            firstTenantIp1Sensors.recordAuthenticatedConnection();
        }
        expectedValues.put((MetricsBuilderContext)firstTenantIp1Context, 2.0);
        this.verifyActiveTenantIpConnectionsMetrics(expectedValues);
        firstTenantIp2Sensors.recordAuthenticatedConnection();
        expectedValues.put((MetricsBuilderContext)firstTenantIp2Context, 1.0);
        this.verifyActiveTenantIpConnectionsMetrics(expectedValues);
        for (i = 0; i < 3; ++i) {
            secondTenantIp1Sensors.recordAuthenticatedConnection();
        }
        expectedValues.put((MetricsBuilderContext)secondTenantIp1Context, 3.0);
        this.verifyActiveTenantIpConnectionsMetrics(expectedValues);
    }

    private void verifyActiveTenantIpConnectionsMetrics(Map<MetricsBuilderContext, Double> expectedMetricValues) {
        expectedMetricValues.forEach((ctx, expected) -> {
            Map<String, KafkaMetric> tenantMetrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, ctx, expected == 0.0, TenantMetricsTestUtils.IP_CONNECTION_METRICS);
            Assertions.assertEquals((double)expected, (double)((Double)tenantMetrics.get("active-authenticated-connection-by-ip-count").metricValue()), (double)0.0);
        });
    }
}

