/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.common;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import io.confluent.security.auth.oauth.mockserver.common.SupportedAlgorithms;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSAKeyProvider {
    public static JWK getRSAKey(SupportedAlgorithms algorithm, String kid) throws Exception {
        RSAKey jwk = null;
        try {
            switch (algorithm) {
                case RS256: {
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                    keyPairGenerator.initialize(2048);
                    KeyPair keyPair = keyPairGenerator.generateKeyPair();
                    jwk = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey((RSAPrivateKey)keyPair.getPrivate()).keyUse(KeyUse.SIGNATURE).algorithm((Algorithm)JWSAlgorithm.RS256).keyID(kid).build();
                    break;
                }
                case RS384: {
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                    keyPairGenerator.initialize(2048);
                    KeyPair keyPair = keyPairGenerator.generateKeyPair();
                    jwk = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey((RSAPrivateKey)keyPair.getPrivate()).keyUse(KeyUse.SIGNATURE).algorithm((Algorithm)JWSAlgorithm.RS384).keyID(kid).build();
                    break;
                }
                case RS512: {
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                    keyPairGenerator.initialize(2048);
                    KeyPair keyPair = keyPairGenerator.generateKeyPair();
                    jwk = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey((RSAPrivateKey)keyPair.getPrivate()).keyUse(KeyUse.SIGNATURE).algorithm((Algorithm)JWSAlgorithm.RS512).keyID(kid).build();
                }
            }
            return jwk;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getCause());
        }
    }
}

