/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import io.confluent.kafka.server.plugins.policy.CreateClusterLinkPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClusterLinkCreateLinkPolicyTest {
    private CreateClusterLinkPolicy policy;
    static final Map<String, String> VALID_CONFIG = new HashMap<String, String>();

    @BeforeEach
    public void setUp() {
        this.policy = new CreateClusterLinkPolicy();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("confluent.plugins.cluster.link.policy.max.destination.links.per.tenant", "5");
        config.put("confluent.plugins.cluster.link.policy.max.source.links.per.tenant", "5");
        this.policy.configure(config);
    }

    @Test
    public void testValidateWithExceedingDestLinks() {
        this.policy.setTenantMaxDestLinks(Optional.of("tenant1"), Optional.of(2));
        this.policy.setTenantMaxDestLinks(Optional.of("tenant2"), Optional.of(3));
        this.testValidateWithExceedingLinks("DESTINATION");
    }

    @Test
    public void testValidateWithExceedingSourceLinks() {
        this.policy.setTenantMaxSourceLinks(Optional.of("tenant1"), Optional.of(2));
        this.policy.setTenantMaxSourceLinks(Optional.of("tenant2"), Optional.of(3));
        this.testValidateWithExceedingLinks("SOURCE");
    }

    @Test
    public void testValidateWithExceedingBidirectionalLinks() {
        this.policy.setTenantMaxSourceLinks(Optional.of("tenant1"), Optional.of(2));
        this.policy.setTenantMaxSourceLinks(Optional.of("tenant2"), Optional.of(3));
        this.testValidateWithExceedingLinks("BIDIRECTIONAL");
    }

    @Test
    public void testLinkAddedAndDeleted() {
        Uuid linkId = Uuid.randomUuid();
        this.policy.linkAdded(linkId, Optional.of("tenant1_"), "DESTINATION");
        this.policy.linkDeleted(linkId);
        Map<String, String> configs = VALID_CONFIG;
        Assertions.assertDoesNotThrow(() -> this.policy.validate(Optional.of("tenant1_"), "DESTINATION", configs));
    }

    @Test
    public void testValidateWithEmptyTenantPrefix() {
        Map<String, String> configs = VALID_CONFIG;
        for (int i = 0; i < 4; ++i) {
            this.policy.linkAdded(Uuid.randomUuid(), Optional.of(""), "DESTINATION");
        }
        Assertions.assertDoesNotThrow(() -> this.policy.validate(Optional.of(""), "DESTINATION", configs));
        Assertions.assertDoesNotThrow(() -> this.policy.validate(Optional.ofNullable(null), "DESTINATION", configs));
        Assertions.assertDoesNotThrow(() -> this.policy.validate(Optional.empty(), "DESTINATION", configs));
        this.policy.linkAdded(Uuid.randomUuid(), Optional.of(""), "DESTINATION");
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(Optional.of(""), "DESTINATION", configs));
        configs.put("confluent.plugins.cluster.link.policy.max.destination.links.per.tenant", "6");
        this.policy.reconfigure(configs);
        Assertions.assertDoesNotThrow(() -> this.policy.validate(Optional.of(""), "DESTINATION", configs));
        this.policy.linkAdded(Uuid.randomUuid(), Optional.of(""), "DESTINATION");
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(Optional.of(""), "DESTINATION", configs));
    }

    @Test
    public void testValidateWithInvalidLinkMode() {
        Map<String, String> configs = VALID_CONFIG;
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.policy.validate(Optional.of("tenant1_"), "INVALID_MODE", configs));
    }

    private void testValidateWithExceedingLinks(String linkMode) {
        for (int i = 0; i < 2; ++i) {
            this.policy.linkAdded(Uuid.randomUuid(), Optional.of("tenant1_"), linkMode);
            this.policy.linkAdded(Uuid.randomUuid(), Optional.of("tenant2_"), linkMode);
        }
        Map<String, String> configs = VALID_CONFIG;
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(Optional.of("tenant1_"), linkMode, configs));
        Assertions.assertDoesNotThrow(() -> this.policy.validate(Optional.of("tenant2_"), linkMode, configs));
        this.policy.linkAdded(Uuid.randomUuid(), Optional.of("tenant2_"), linkMode);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(Optional.of("tenant2_"), linkMode, configs));
    }

    static {
        VALID_CONFIG.put("bootstrap.servers", "localhost:9092");
    }
}

