/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.CallingResourceIdentityType;
import io.confluent.kafka.multitenant.CallingResourceIdentityTypeExtractor;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CallingResourceIdentityTypeExtractorTest {
    private CallingResourceIdentityTypeExtractor extractor;

    @BeforeEach
    public void setUp() {
        this.extractor = new CallingResourceIdentityTypeExtractor();
    }

    @ParameterizedTest
    @MethodSource(value={"invalidConfigurations"})
    public void testConfigureWithInvalidConfigurations(Map<String, String> configs) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.extractor.configure(configs));
    }

    @ParameterizedTest
    @MethodSource(value={"validConfigurations"})
    public void testRegexPatternMatch(Map<String, String> configs) {
        this.extractor.configure(configs);
        Assertions.assertEquals((Object)CallingResourceIdentityType.CONFLUENT_TABLEFLOW, (Object)this.extractor.extractType("cc-unified-storage-cts-enumerator-service.cc-unified-storage-cts-enumerator-test123"));
        Assertions.assertEquals((Object)CallingResourceIdentityType.DEFAULT, (Object)this.extractor.extractType(null));
        Assertions.assertEquals((Object)CallingResourceIdentityType.DEFAULT, (Object)this.extractor.extractType("default"));
        Assertions.assertEquals((Object)CallingResourceIdentityType.CONFLUENT_FLINK, (Object)this.extractor.extractType("crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-ab123/flink-region=aws.us-east-2"));
    }

    private static Stream<Map<String, String>> invalidConfigurations() {
        return Stream.of("invalid_map", "pattern1:invalid_calling_resource_identity_type,pattern2:invalid_calling_resource_identity_type", "invalid_pattern\\:CONFLUENT_TABLEFLOW").map(value -> Collections.singletonMap("confluent.calling.resource.identity.type.map", value));
    }

    private static Stream<Map<String, String>> validConfigurations() {
        return Stream.of("^cc-(unified-storage|us)-cts:CONFLUENT_TABLEFLOW,^crn://confluent.cloud/organization.*flink-region:CONFLUENT_FLINK").map(value -> Collections.singletonMap("confluent.calling.resource.identity.type.map", value));
    }
}

